/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details related to the continue step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteContinueStepDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteContinueStepDetails.Builder, RouteContinueStepDetails> {
    private static final SdkField<List<LocalizedString>> INTERSECTION_FIELD = SdkField
            .<List<LocalizedString>> builder(MarshallingType.LIST)
            .memberName("Intersection")
            .getter(getter(RouteContinueStepDetails::intersection))
            .setter(setter(Builder::intersection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalizedString> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalizedString::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERSECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LocalizedString> intersection;

    private RouteContinueStepDetails(BuilderImpl builder) {
        this.intersection = builder.intersection;
    }

    /**
     * For responses, this returns true if the service returned a value for the Intersection property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntersection() {
        return intersection != null && !(intersection instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the intersection, if applicable to the step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntersection} method.
     * </p>
     * 
     * @return Name of the intersection, if applicable to the step.
     */
    public final List<LocalizedString> intersection() {
        return intersection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIntersection() ? intersection() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteContinueStepDetails)) {
            return false;
        }
        RouteContinueStepDetails other = (RouteContinueStepDetails) obj;
        return hasIntersection() == other.hasIntersection() && Objects.equals(intersection(), other.intersection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteContinueStepDetails").add("Intersection", hasIntersection() ? intersection() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Intersection":
            return Optional.ofNullable(clazz.cast(intersection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Intersection", INTERSECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteContinueStepDetails, T> g) {
        return obj -> g.apply((RouteContinueStepDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteContinueStepDetails> {
        /**
         * <p>
         * Name of the intersection, if applicable to the step.
         * </p>
         * 
         * @param intersection
         *        Name of the intersection, if applicable to the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intersection(Collection<LocalizedString> intersection);

        /**
         * <p>
         * Name of the intersection, if applicable to the step.
         * </p>
         * 
         * @param intersection
         *        Name of the intersection, if applicable to the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intersection(LocalizedString... intersection);

        /**
         * <p>
         * Name of the intersection, if applicable to the step.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.LocalizedString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder#build()} is called immediately
         * and its result is passed to {@link #intersection(List<LocalizedString>)}.
         * 
         * @param intersection
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intersection(java.util.Collection<LocalizedString>)
         */
        Builder intersection(Consumer<LocalizedString.Builder>... intersection);
    }

    static final class BuilderImpl implements Builder {
        private List<LocalizedString> intersection = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteContinueStepDetails model) {
            intersection(model.intersection);
        }

        public final List<LocalizedString.Builder> getIntersection() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.intersection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntersection(Collection<LocalizedString.BuilderImpl> intersection) {
            this.intersection = LocalizedStringListCopier.copyFromBuilder(intersection);
        }

        @Override
        public final Builder intersection(Collection<LocalizedString> intersection) {
            this.intersection = LocalizedStringListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(LocalizedString... intersection) {
            intersection(Arrays.asList(intersection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(Consumer<LocalizedString.Builder>... intersection) {
            intersection(Stream.of(intersection).map(c -> LocalizedString.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RouteContinueStepDetails build() {
            return new RouteContinueStepDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
