/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allow Options related to the route matrix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixAllowOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixAllowOptions.Builder, RouteMatrixAllowOptions> {
    private static final SdkField<Boolean> HOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Hot")
            .getter(getter(RouteMatrixAllowOptions::hot)).setter(setter(Builder::hot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hot").build()).build();

    private static final SdkField<Boolean> HOV_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Hov")
            .getter(getter(RouteMatrixAllowOptions::hov)).setter(setter(Builder::hov))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hov").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOT_FIELD, HOV_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean hot;

    private final Boolean hov;

    private RouteMatrixAllowOptions(BuilderImpl builder) {
        this.hot = builder.hot;
        this.hov = builder.hov;
    }

    /**
     * <p>
     * Allow Hot (High Occupancy Toll) lanes while calculating the route.
     * </p>
     * <p>
     * Default value: <code>false</code>
     * </p>
     * 
     * @return Allow Hot (High Occupancy Toll) lanes while calculating the route.</p>
     *         <p>
     *         Default value: <code>false</code>
     */
    public final Boolean hot() {
        return hot;
    }

    /**
     * <p>
     * Allow Hov (High Occupancy vehicle) lanes while calculating the route.
     * </p>
     * <p>
     * Default value: <code>false</code>
     * </p>
     * 
     * @return Allow Hov (High Occupancy vehicle) lanes while calculating the route.</p>
     *         <p>
     *         Default value: <code>false</code>
     */
    public final Boolean hov() {
        return hov;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hot());
        hashCode = 31 * hashCode + Objects.hashCode(hov());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixAllowOptions)) {
            return false;
        }
        RouteMatrixAllowOptions other = (RouteMatrixAllowOptions) obj;
        return Objects.equals(hot(), other.hot()) && Objects.equals(hov(), other.hov());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixAllowOptions").add("Hot", hot()).add("Hov", hov()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hot":
            return Optional.ofNullable(clazz.cast(hot()));
        case "Hov":
            return Optional.ofNullable(clazz.cast(hov()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Hot", HOT_FIELD);
        map.put("Hov", HOV_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixAllowOptions, T> g) {
        return obj -> g.apply((RouteMatrixAllowOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixAllowOptions> {
        /**
         * <p>
         * Allow Hot (High Occupancy Toll) lanes while calculating the route.
         * </p>
         * <p>
         * Default value: <code>false</code>
         * </p>
         * 
         * @param hot
         *        Allow Hot (High Occupancy Toll) lanes while calculating the route.</p>
         *        <p>
         *        Default value: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hot(Boolean hot);

        /**
         * <p>
         * Allow Hov (High Occupancy vehicle) lanes while calculating the route.
         * </p>
         * <p>
         * Default value: <code>false</code>
         * </p>
         * 
         * @param hov
         *        Allow Hov (High Occupancy vehicle) lanes while calculating the route.</p>
         *        <p>
         *        Default value: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hov(Boolean hov);
    }

    static final class BuilderImpl implements Builder {
        private Boolean hot;

        private Boolean hov;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixAllowOptions model) {
            hot(model.hot);
            hov(model.hov);
        }

        public final Boolean getHot() {
            return hot;
        }

        public final void setHot(Boolean hot) {
            this.hot = hot;
        }

        @Override
        public final Builder hot(Boolean hot) {
            this.hot = hot;
            return this;
        }

        public final Boolean getHov() {
            return hov;
        }

        public final void setHov(Boolean hov) {
            this.hov = hov;
        }

        @Override
        public final Builder hov(Boolean hov) {
            this.hov = hov;
            return this;
        }

        @Override
        public RouteMatrixAllowOptions build() {
            return new RouteMatrixAllowOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
