/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Area to be avoided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixAvoidanceArea implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixAvoidanceArea.Builder, RouteMatrixAvoidanceArea> {
    private static final SdkField<RouteMatrixAvoidanceAreaGeometry> GEOMETRY_FIELD = SdkField
            .<RouteMatrixAvoidanceAreaGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry")
            .getter(getter(RouteMatrixAvoidanceArea::geometry)).setter(setter(Builder::geometry))
            .constructor(RouteMatrixAvoidanceAreaGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEOMETRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteMatrixAvoidanceAreaGeometry geometry;

    private RouteMatrixAvoidanceArea(BuilderImpl builder) {
        this.geometry = builder.geometry;
    }

    /**
     * <p>
     * Geometry of the area to be avoided.
     * </p>
     * 
     * @return Geometry of the area to be avoided.
     */
    public final RouteMatrixAvoidanceAreaGeometry geometry() {
        return geometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixAvoidanceArea)) {
            return false;
        }
        RouteMatrixAvoidanceArea other = (RouteMatrixAvoidanceArea) obj;
        return Objects.equals(geometry(), other.geometry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixAvoidanceArea").add("Geometry", geometry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Geometry", GEOMETRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixAvoidanceArea, T> g) {
        return obj -> g.apply((RouteMatrixAvoidanceArea) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixAvoidanceArea> {
        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * 
         * @param geometry
         *        Geometry of the area to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(RouteMatrixAvoidanceAreaGeometry geometry);

        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatrixAvoidanceAreaGeometry.Builder}
         * avoiding the need to create one manually via {@link RouteMatrixAvoidanceAreaGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixAvoidanceAreaGeometry.Builder#build()} is called
         * immediately and its result is passed to {@link #geometry(RouteMatrixAvoidanceAreaGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link RouteMatrixAvoidanceAreaGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(RouteMatrixAvoidanceAreaGeometry)
         */
        default Builder geometry(Consumer<RouteMatrixAvoidanceAreaGeometry.Builder> geometry) {
            return geometry(RouteMatrixAvoidanceAreaGeometry.builder().applyMutation(geometry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RouteMatrixAvoidanceAreaGeometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixAvoidanceArea model) {
            geometry(model.geometry);
        }

        public final RouteMatrixAvoidanceAreaGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(RouteMatrixAvoidanceAreaGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(RouteMatrixAvoidanceAreaGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        @Override
        public RouteMatrixAvoidanceArea build() {
            return new RouteMatrixAvoidanceArea(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
