/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Boundary within which the matrix is to be calculated. All data, origins and destinations outside the boundary are
 * considered invalid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixBoundary implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixBoundary.Builder, RouteMatrixBoundary> {
    private static final SdkField<RouteMatrixBoundaryGeometry> GEOMETRY_FIELD = SdkField
            .<RouteMatrixBoundaryGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry")
            .getter(getter(RouteMatrixBoundary::geometry)).setter(setter(Builder::geometry))
            .constructor(RouteMatrixBoundaryGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final SdkField<Boolean> UNBOUNDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Unbounded").getter(getter(RouteMatrixBoundary::unbounded)).setter(setter(Builder::unbounded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unbounded").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEOMETRY_FIELD,
            UNBOUNDED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteMatrixBoundaryGeometry geometry;

    private final Boolean unbounded;

    private RouteMatrixBoundary(BuilderImpl builder) {
        this.geometry = builder.geometry;
        this.unbounded = builder.unbounded;
    }

    /**
     * <p>
     * Geometry of the area to be avoided.
     * </p>
     * 
     * @return Geometry of the area to be avoided.
     */
    public final RouteMatrixBoundaryGeometry geometry() {
        return geometry;
    }

    /**
     * <p>
     * No restrictions in terms of a routing boundary, and is typically used for longer routes.
     * </p>
     * 
     * @return No restrictions in terms of a routing boundary, and is typically used for longer routes.
     */
    public final Boolean unbounded() {
        return unbounded;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        hashCode = 31 * hashCode + Objects.hashCode(unbounded());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixBoundary)) {
            return false;
        }
        RouteMatrixBoundary other = (RouteMatrixBoundary) obj;
        return Objects.equals(geometry(), other.geometry()) && Objects.equals(unbounded(), other.unbounded());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixBoundary").add("Geometry", geometry()).add("Unbounded", unbounded()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        case "Unbounded":
            return Optional.ofNullable(clazz.cast(unbounded()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Geometry", GEOMETRY_FIELD);
        map.put("Unbounded", UNBOUNDED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixBoundary, T> g) {
        return obj -> g.apply((RouteMatrixBoundary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixBoundary> {
        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * 
         * @param geometry
         *        Geometry of the area to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(RouteMatrixBoundaryGeometry geometry);

        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatrixBoundaryGeometry.Builder}
         * avoiding the need to create one manually via {@link RouteMatrixBoundaryGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixBoundaryGeometry.Builder#build()} is called
         * immediately and its result is passed to {@link #geometry(RouteMatrixBoundaryGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link RouteMatrixBoundaryGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(RouteMatrixBoundaryGeometry)
         */
        default Builder geometry(Consumer<RouteMatrixBoundaryGeometry.Builder> geometry) {
            return geometry(RouteMatrixBoundaryGeometry.builder().applyMutation(geometry).build());
        }

        /**
         * <p>
         * No restrictions in terms of a routing boundary, and is typically used for longer routes.
         * </p>
         * 
         * @param unbounded
         *        No restrictions in terms of a routing boundary, and is typically used for longer routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unbounded(Boolean unbounded);
    }

    static final class BuilderImpl implements Builder {
        private RouteMatrixBoundaryGeometry geometry;

        private Boolean unbounded;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixBoundary model) {
            geometry(model.geometry);
            unbounded(model.unbounded);
        }

        public final RouteMatrixBoundaryGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(RouteMatrixBoundaryGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(RouteMatrixBoundaryGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final Boolean getUnbounded() {
            return unbounded;
        }

        public final void setUnbounded(Boolean unbounded) {
            this.unbounded = unbounded;
        }

        @Override
        public final Builder unbounded(Boolean unbounded) {
            this.unbounded = unbounded;
            return this;
        }

        @Override
        public RouteMatrixBoundary build() {
            return new RouteMatrixBoundary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
