/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Geometry of the routing boundary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixBoundaryGeometry implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixBoundaryGeometry.Builder, RouteMatrixBoundaryGeometry> {
    private static final SdkField<RouteMatrixAutoCircle> AUTO_CIRCLE_FIELD = SdkField
            .<RouteMatrixAutoCircle> builder(MarshallingType.SDK_POJO).memberName("AutoCircle")
            .getter(getter(RouteMatrixBoundaryGeometry::autoCircle)).setter(setter(Builder::autoCircle))
            .constructor(RouteMatrixAutoCircle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCircle").build()).build();

    private static final SdkField<Circle> CIRCLE_FIELD = SdkField.<Circle> builder(MarshallingType.SDK_POJO).memberName("Circle")
            .getter(getter(RouteMatrixBoundaryGeometry::circle)).setter(setter(Builder::circle)).constructor(Circle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Circle").build()).build();

    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("BoundingBox")
            .getter(getter(RouteMatrixBoundaryGeometry::boundingBox))
            .setter(setter(Builder::boundingBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<List<Double>>>> POLYGON_FIELD = SdkField
            .<List<List<List<Double>>>> builder(MarshallingType.LIST)
            .memberName("Polygon")
            .getter(getter(RouteMatrixBoundaryGeometry::polygon))
            .setter(setter(Builder::polygon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<List<Double>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<List<Double>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<Double> builder(
                                                                                                            MarshallingType.DOUBLE)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_CIRCLE_FIELD,
            CIRCLE_FIELD, BOUNDING_BOX_FIELD, POLYGON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteMatrixAutoCircle autoCircle;

    private final Circle circle;

    private final List<Double> boundingBox;

    private final List<List<List<Double>>> polygon;

    private RouteMatrixBoundaryGeometry(BuilderImpl builder) {
        this.autoCircle = builder.autoCircle;
        this.circle = builder.circle;
        this.boundingBox = builder.boundingBox;
        this.polygon = builder.polygon;
    }

    /**
     * <p>
     * Provides the circle that was used while calculating the route.
     * </p>
     * 
     * @return Provides the circle that was used while calculating the route.
     */
    public final RouteMatrixAutoCircle autoCircle() {
        return autoCircle;
    }

    /**
     * <p>
     * Geometry defined as a circle. When request routing boundary was set as <code>AutoCircle</code>, the response
     * routing boundary will return <code>Circle</code> derived from the <code>AutoCircle</code> settings.
     * </p>
     * 
     * @return Geometry defined as a circle. When request routing boundary was set as <code>AutoCircle</code>, the
     *         response routing boundary will return <code>Circle</code> derived from the <code>AutoCircle</code>
     *         settings.
     */
    public final Circle circle() {
        return circle;
    }

    /**
     * For responses, this returns true if the service returned a value for the BoundingBox property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBoundingBox() {
        return boundingBox != null && !(boundingBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and latitude,)
     * of the southwest corner of the bounding box; the second pair represents the X and Y coordinates (longitude and
     * latitude) of the northeast corner.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBoundingBox} method.
     * </p>
     * 
     * @return Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
     *         latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y
     *         coordinates (longitude and latitude) of the northeast corner.
     */
    public final List<Double> boundingBox() {
        return boundingBox;
    }

    /**
     * For responses, this returns true if the service returned a value for the Polygon property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolygon() {
        return polygon != null && !(polygon instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Geometry defined as a polygon with only one linear ring.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolygon} method.
     * </p>
     * 
     * @return Geometry defined as a polygon with only one linear ring.
     */
    public final List<List<List<Double>>> polygon() {
        return polygon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoCircle());
        hashCode = 31 * hashCode + Objects.hashCode(circle());
        hashCode = 31 * hashCode + Objects.hashCode(hasBoundingBox() ? boundingBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPolygon() ? polygon() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixBoundaryGeometry)) {
            return false;
        }
        RouteMatrixBoundaryGeometry other = (RouteMatrixBoundaryGeometry) obj;
        return Objects.equals(autoCircle(), other.autoCircle()) && Objects.equals(circle(), other.circle())
                && hasBoundingBox() == other.hasBoundingBox() && Objects.equals(boundingBox(), other.boundingBox())
                && hasPolygon() == other.hasPolygon() && Objects.equals(polygon(), other.polygon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixBoundaryGeometry").add("AutoCircle", autoCircle())
                .add("Circle", circle() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BoundingBox", boundingBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Polygon", polygon() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoCircle":
            return Optional.ofNullable(clazz.cast(autoCircle()));
        case "Circle":
            return Optional.ofNullable(clazz.cast(circle()));
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Polygon":
            return Optional.ofNullable(clazz.cast(polygon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoCircle", AUTO_CIRCLE_FIELD);
        map.put("Circle", CIRCLE_FIELD);
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("Polygon", POLYGON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixBoundaryGeometry, T> g) {
        return obj -> g.apply((RouteMatrixBoundaryGeometry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixBoundaryGeometry> {
        /**
         * <p>
         * Provides the circle that was used while calculating the route.
         * </p>
         * 
         * @param autoCircle
         *        Provides the circle that was used while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoCircle(RouteMatrixAutoCircle autoCircle);

        /**
         * <p>
         * Provides the circle that was used while calculating the route.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatrixAutoCircle.Builder} avoiding
         * the need to create one manually via {@link RouteMatrixAutoCircle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixAutoCircle.Builder#build()} is called immediately and
         * its result is passed to {@link #autoCircle(RouteMatrixAutoCircle)}.
         * 
         * @param autoCircle
         *        a consumer that will call methods on {@link RouteMatrixAutoCircle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoCircle(RouteMatrixAutoCircle)
         */
        default Builder autoCircle(Consumer<RouteMatrixAutoCircle.Builder> autoCircle) {
            return autoCircle(RouteMatrixAutoCircle.builder().applyMutation(autoCircle).build());
        }

        /**
         * <p>
         * Geometry defined as a circle. When request routing boundary was set as <code>AutoCircle</code>, the response
         * routing boundary will return <code>Circle</code> derived from the <code>AutoCircle</code> settings.
         * </p>
         * 
         * @param circle
         *        Geometry defined as a circle. When request routing boundary was set as <code>AutoCircle</code>, the
         *        response routing boundary will return <code>Circle</code> derived from the <code>AutoCircle</code>
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder circle(Circle circle);

        /**
         * <p>
         * Geometry defined as a circle. When request routing boundary was set as <code>AutoCircle</code>, the response
         * routing boundary will return <code>Circle</code> derived from the <code>AutoCircle</code> settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link Circle.Builder} avoiding the need to
         * create one manually via {@link Circle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Circle.Builder#build()} is called immediately and its result is
         * passed to {@link #circle(Circle)}.
         * 
         * @param circle
         *        a consumer that will call methods on {@link Circle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #circle(Circle)
         */
        default Builder circle(Consumer<Circle.Builder> circle) {
            return circle(Circle.builder().applyMutation(circle).build());
        }

        /**
         * <p>
         * Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
         * latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y coordinates
         * (longitude and latitude) of the northeast corner.
         * </p>
         * 
         * @param boundingBox
         *        Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
         *        latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y
         *        coordinates (longitude and latitude) of the northeast corner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(Collection<Double> boundingBox);

        /**
         * <p>
         * Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
         * latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y coordinates
         * (longitude and latitude) of the northeast corner.
         * </p>
         * 
         * @param boundingBox
         *        Geometry defined as a bounding box. The first pair represents the X and Y coordinates (longitude and
         *        latitude,) of the southwest corner of the bounding box; the second pair represents the X and Y
         *        coordinates (longitude and latitude) of the northeast corner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(Double... boundingBox);

        /**
         * <p>
         * Geometry defined as a polygon with only one linear ring.
         * </p>
         * 
         * @param polygon
         *        Geometry defined as a polygon with only one linear ring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon);

        /**
         * <p>
         * Geometry defined as a polygon with only one linear ring.
         * </p>
         * 
         * @param polygon
         *        Geometry defined as a polygon with only one linear ring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygon(Collection<? extends Collection<Double>>... polygon);
    }

    static final class BuilderImpl implements Builder {
        private RouteMatrixAutoCircle autoCircle;

        private Circle circle;

        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();

        private List<List<List<Double>>> polygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixBoundaryGeometry model) {
            autoCircle(model.autoCircle);
            circle(model.circle);
            boundingBox(model.boundingBox);
            polygon(model.polygon);
        }

        public final RouteMatrixAutoCircle.Builder getAutoCircle() {
            return autoCircle != null ? autoCircle.toBuilder() : null;
        }

        public final void setAutoCircle(RouteMatrixAutoCircle.BuilderImpl autoCircle) {
            this.autoCircle = autoCircle != null ? autoCircle.build() : null;
        }

        @Override
        public final Builder autoCircle(RouteMatrixAutoCircle autoCircle) {
            this.autoCircle = autoCircle;
            return this;
        }

        public final Circle.Builder getCircle() {
            return circle != null ? circle.toBuilder() : null;
        }

        public final void setCircle(Circle.BuilderImpl circle) {
            this.circle = circle != null ? circle.build() : null;
        }

        @Override
        public final Builder circle(Circle circle) {
            this.circle = circle;
            return this;
        }

        public final Collection<Double> getBoundingBox() {
            if (boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double... boundingBox) {
            boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getPolygon() {
            if (polygon instanceof SdkAutoConstructList) {
                return null;
            }
            return polygon;
        }

        public final void setPolygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = RouteMatrixBoundaryGeometryPolygonListCopier.copy(polygon);
        }

        @Override
        public final Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = RouteMatrixBoundaryGeometryPolygonListCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Collection<? extends Collection<Double>>... polygon) {
            polygon(Arrays.asList(polygon));
            return this;
        }

        @Override
        public RouteMatrixBoundaryGeometry build() {
            return new RouteMatrixBoundaryGeometry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
