/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Travel mode options when the provided travel mode is <code>Car</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixCarOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixCarOptions.Builder, RouteMatrixCarOptions> {
    private static final SdkField<RouteMatrixVehicleLicensePlate> LICENSE_PLATE_FIELD = SdkField
            .<RouteMatrixVehicleLicensePlate> builder(MarshallingType.SDK_POJO).memberName("LicensePlate")
            .getter(getter(RouteMatrixCarOptions::licensePlate)).setter(setter(Builder::licensePlate))
            .constructor(RouteMatrixVehicleLicensePlate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicensePlate").build()).build();

    private static final SdkField<Double> MAX_SPEED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxSpeed").getter(getter(RouteMatrixCarOptions::maxSpeed)).setter(setter(Builder::maxSpeed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeed").build()).build();

    private static final SdkField<Integer> OCCUPANCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Occupancy").getter(getter(RouteMatrixCarOptions::occupancy)).setter(setter(Builder::occupancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Occupancy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_PLATE_FIELD,
            MAX_SPEED_FIELD, OCCUPANCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteMatrixVehicleLicensePlate licensePlate;

    private final Double maxSpeed;

    private final Integer occupancy;

    private RouteMatrixCarOptions(BuilderImpl builder) {
        this.licensePlate = builder.licensePlate;
        this.maxSpeed = builder.maxSpeed;
        this.occupancy = builder.occupancy;
    }

    /**
     * <p>
     * The vehicle License Plate.
     * </p>
     * 
     * @return The vehicle License Plate.
     */
    public final RouteMatrixVehicleLicensePlate licensePlate() {
        return licensePlate;
    }

    /**
     * <p>
     * Maximum speed
     * </p>
     * <p>
     * <b>Unit</b>: <code>KilometersPerHour</code>
     * </p>
     * 
     * @return Maximum speed</p>
     *         <p>
     *         <b>Unit</b>: <code>KilometersPerHour</code>
     */
    public final Double maxSpeed() {
        return maxSpeed;
    }

    /**
     * <p>
     * The number of occupants in the vehicle.
     * </p>
     * <p>
     * Default Value: <code>1</code>
     * </p>
     * 
     * @return The number of occupants in the vehicle.</p>
     *         <p>
     *         Default Value: <code>1</code>
     */
    public final Integer occupancy() {
        return occupancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licensePlate());
        hashCode = 31 * hashCode + Objects.hashCode(maxSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(occupancy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixCarOptions)) {
            return false;
        }
        RouteMatrixCarOptions other = (RouteMatrixCarOptions) obj;
        return Objects.equals(licensePlate(), other.licensePlate()) && Objects.equals(maxSpeed(), other.maxSpeed())
                && Objects.equals(occupancy(), other.occupancy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixCarOptions").add("LicensePlate", licensePlate()).add("MaxSpeed", maxSpeed())
                .add("Occupancy", occupancy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicensePlate":
            return Optional.ofNullable(clazz.cast(licensePlate()));
        case "MaxSpeed":
            return Optional.ofNullable(clazz.cast(maxSpeed()));
        case "Occupancy":
            return Optional.ofNullable(clazz.cast(occupancy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LicensePlate", LICENSE_PLATE_FIELD);
        map.put("MaxSpeed", MAX_SPEED_FIELD);
        map.put("Occupancy", OCCUPANCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixCarOptions, T> g) {
        return obj -> g.apply((RouteMatrixCarOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixCarOptions> {
        /**
         * <p>
         * The vehicle License Plate.
         * </p>
         * 
         * @param licensePlate
         *        The vehicle License Plate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licensePlate(RouteMatrixVehicleLicensePlate licensePlate);

        /**
         * <p>
         * The vehicle License Plate.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatrixVehicleLicensePlate.Builder}
         * avoiding the need to create one manually via {@link RouteMatrixVehicleLicensePlate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixVehicleLicensePlate.Builder#build()} is called
         * immediately and its result is passed to {@link #licensePlate(RouteMatrixVehicleLicensePlate)}.
         * 
         * @param licensePlate
         *        a consumer that will call methods on {@link RouteMatrixVehicleLicensePlate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licensePlate(RouteMatrixVehicleLicensePlate)
         */
        default Builder licensePlate(Consumer<RouteMatrixVehicleLicensePlate.Builder> licensePlate) {
            return licensePlate(RouteMatrixVehicleLicensePlate.builder().applyMutation(licensePlate).build());
        }

        /**
         * <p>
         * Maximum speed
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * 
         * @param maxSpeed
         *        Maximum speed</p>
         *        <p>
         *        <b>Unit</b>: <code>KilometersPerHour</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSpeed(Double maxSpeed);

        /**
         * <p>
         * The number of occupants in the vehicle.
         * </p>
         * <p>
         * Default Value: <code>1</code>
         * </p>
         * 
         * @param occupancy
         *        The number of occupants in the vehicle.</p>
         *        <p>
         *        Default Value: <code>1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occupancy(Integer occupancy);
    }

    static final class BuilderImpl implements Builder {
        private RouteMatrixVehicleLicensePlate licensePlate;

        private Double maxSpeed;

        private Integer occupancy;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixCarOptions model) {
            licensePlate(model.licensePlate);
            maxSpeed(model.maxSpeed);
            occupancy(model.occupancy);
        }

        public final RouteMatrixVehicleLicensePlate.Builder getLicensePlate() {
            return licensePlate != null ? licensePlate.toBuilder() : null;
        }

        public final void setLicensePlate(RouteMatrixVehicleLicensePlate.BuilderImpl licensePlate) {
            this.licensePlate = licensePlate != null ? licensePlate.build() : null;
        }

        @Override
        public final Builder licensePlate(RouteMatrixVehicleLicensePlate licensePlate) {
            this.licensePlate = licensePlate;
            return this;
        }

        public final Double getMaxSpeed() {
            return maxSpeed;
        }

        public final void setMaxSpeed(Double maxSpeed) {
            this.maxSpeed = maxSpeed;
        }

        @Override
        public final Builder maxSpeed(Double maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        public final Integer getOccupancy() {
            return occupancy;
        }

        public final void setOccupancy(Integer occupancy) {
            this.occupancy = occupancy;
        }

        @Override
        public final Builder occupancy(Integer occupancy) {
            this.occupancy = occupancy;
            return this;
        }

        @Override
        public RouteMatrixCarOptions build() {
            return new RouteMatrixCarOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
