/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Matching options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixMatchingOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixMatchingOptions.Builder, RouteMatrixMatchingOptions> {
    private static final SdkField<String> NAME_HINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameHint").getter(getter(RouteMatrixMatchingOptions::nameHint)).setter(setter(Builder::nameHint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameHint").build()).build();

    private static final SdkField<Long> ON_ROAD_THRESHOLD_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OnRoadThreshold").getter(getter(RouteMatrixMatchingOptions::onRoadThreshold))
            .setter(setter(Builder::onRoadThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnRoadThreshold").build()).build();

    private static final SdkField<Long> RADIUS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Radius")
            .getter(getter(RouteMatrixMatchingOptions::radius)).setter(setter(Builder::radius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Radius").build()).build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strategy").getter(getter(RouteMatrixMatchingOptions::strategyAsString))
            .setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_HINT_FIELD,
            ON_ROAD_THRESHOLD_FIELD, RADIUS_FIELD, STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nameHint;

    private final Long onRoadThreshold;

    private final Long radius;

    private final String strategy;

    private RouteMatrixMatchingOptions(BuilderImpl builder) {
        this.nameHint = builder.nameHint;
        this.onRoadThreshold = builder.onRoadThreshold;
        this.radius = builder.radius;
        this.strategy = builder.strategy;
    }

    /**
     * <p>
     * Attempts to match the provided position to a road similar to the provided name.
     * </p>
     * 
     * @return Attempts to match the provided position to a road similar to the provided name.
     */
    public final String nameHint() {
        return nameHint;
    }

    /**
     * <p>
     * If the distance to a highway/bridge/tunnel/sliproad is within threshold, the waypoint will be snapped to the
     * highway/bridge/tunnel/sliproad.
     * </p>
     * <p>
     * <b>Unit</b>: <code>meters</code>
     * </p>
     * 
     * @return If the distance to a highway/bridge/tunnel/sliproad is within threshold, the waypoint will be snapped to
     *         the highway/bridge/tunnel/sliproad.</p>
     *         <p>
     *         <b>Unit</b>: <code>meters</code>
     */
    public final Long onRoadThreshold() {
        return onRoadThreshold;
    }

    /**
     * <p>
     * Considers all roads within the provided radius to match the provided destination to. The roads that are
     * considered are determined by the provided Strategy.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Meters</code>
     * </p>
     * 
     * @return Considers all roads within the provided radius to match the provided destination to. The roads that are
     *         considered are determined by the provided Strategy.</p>
     *         <p>
     *         <b>Unit</b>: <code>Meters</code>
     */
    public final Long radius() {
        return radius;
    }

    /**
     * <p>
     * Strategy that defines matching of the position onto the road network. MatchAny considers all roads possible,
     * whereas MatchMostSignificantRoad matches to the most significant road.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link MatchingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return Strategy that defines matching of the position onto the road network. MatchAny considers all roads
     *         possible, whereas MatchMostSignificantRoad matches to the most significant road.
     * @see MatchingStrategy
     */
    public final MatchingStrategy strategy() {
        return MatchingStrategy.fromValue(strategy);
    }

    /**
     * <p>
     * Strategy that defines matching of the position onto the road network. MatchAny considers all roads possible,
     * whereas MatchMostSignificantRoad matches to the most significant road.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link MatchingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return Strategy that defines matching of the position onto the road network. MatchAny considers all roads
     *         possible, whereas MatchMostSignificantRoad matches to the most significant road.
     * @see MatchingStrategy
     */
    public final String strategyAsString() {
        return strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameHint());
        hashCode = 31 * hashCode + Objects.hashCode(onRoadThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(radius());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixMatchingOptions)) {
            return false;
        }
        RouteMatrixMatchingOptions other = (RouteMatrixMatchingOptions) obj;
        return Objects.equals(nameHint(), other.nameHint()) && Objects.equals(onRoadThreshold(), other.onRoadThreshold())
                && Objects.equals(radius(), other.radius()) && Objects.equals(strategyAsString(), other.strategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixMatchingOptions")
                .add("NameHint", nameHint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OnRoadThreshold", onRoadThreshold()).add("Radius", radius()).add("Strategy", strategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NameHint":
            return Optional.ofNullable(clazz.cast(nameHint()));
        case "OnRoadThreshold":
            return Optional.ofNullable(clazz.cast(onRoadThreshold()));
        case "Radius":
            return Optional.ofNullable(clazz.cast(radius()));
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NameHint", NAME_HINT_FIELD);
        map.put("OnRoadThreshold", ON_ROAD_THRESHOLD_FIELD);
        map.put("Radius", RADIUS_FIELD);
        map.put("Strategy", STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixMatchingOptions, T> g) {
        return obj -> g.apply((RouteMatrixMatchingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixMatchingOptions> {
        /**
         * <p>
         * Attempts to match the provided position to a road similar to the provided name.
         * </p>
         * 
         * @param nameHint
         *        Attempts to match the provided position to a road similar to the provided name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameHint(String nameHint);

        /**
         * <p>
         * If the distance to a highway/bridge/tunnel/sliproad is within threshold, the waypoint will be snapped to the
         * highway/bridge/tunnel/sliproad.
         * </p>
         * <p>
         * <b>Unit</b>: <code>meters</code>
         * </p>
         * 
         * @param onRoadThreshold
         *        If the distance to a highway/bridge/tunnel/sliproad is within threshold, the waypoint will be snapped
         *        to the highway/bridge/tunnel/sliproad.</p>
         *        <p>
         *        <b>Unit</b>: <code>meters</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onRoadThreshold(Long onRoadThreshold);

        /**
         * <p>
         * Considers all roads within the provided radius to match the provided destination to. The roads that are
         * considered are determined by the provided Strategy.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Meters</code>
         * </p>
         * 
         * @param radius
         *        Considers all roads within the provided radius to match the provided destination to. The roads that
         *        are considered are determined by the provided Strategy.</p>
         *        <p>
         *        <b>Unit</b>: <code>Meters</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radius(Long radius);

        /**
         * <p>
         * Strategy that defines matching of the position onto the road network. MatchAny considers all roads possible,
         * whereas MatchMostSignificantRoad matches to the most significant road.
         * </p>
         * 
         * @param strategy
         *        Strategy that defines matching of the position onto the road network. MatchAny considers all roads
         *        possible, whereas MatchMostSignificantRoad matches to the most significant road.
         * @see MatchingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchingStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * Strategy that defines matching of the position onto the road network. MatchAny considers all roads possible,
         * whereas MatchMostSignificantRoad matches to the most significant road.
         * </p>
         * 
         * @param strategy
         *        Strategy that defines matching of the position onto the road network. MatchAny considers all roads
         *        possible, whereas MatchMostSignificantRoad matches to the most significant road.
         * @see MatchingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchingStrategy
         */
        Builder strategy(MatchingStrategy strategy);
    }

    static final class BuilderImpl implements Builder {
        private String nameHint;

        private Long onRoadThreshold;

        private Long radius;

        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixMatchingOptions model) {
            nameHint(model.nameHint);
            onRoadThreshold(model.onRoadThreshold);
            radius(model.radius);
            strategy(model.strategy);
        }

        public final String getNameHint() {
            return nameHint;
        }

        public final void setNameHint(String nameHint) {
            this.nameHint = nameHint;
        }

        @Override
        public final Builder nameHint(String nameHint) {
            this.nameHint = nameHint;
            return this;
        }

        public final Long getOnRoadThreshold() {
            return onRoadThreshold;
        }

        public final void setOnRoadThreshold(Long onRoadThreshold) {
            this.onRoadThreshold = onRoadThreshold;
        }

        @Override
        public final Builder onRoadThreshold(Long onRoadThreshold) {
            this.onRoadThreshold = onRoadThreshold;
            return this;
        }

        public final Long getRadius() {
            return radius;
        }

        public final void setRadius(Long radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Long radius) {
            this.radius = radius;
            return this;
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(MatchingStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        @Override
        public RouteMatrixMatchingOptions build() {
            return new RouteMatrixMatchingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
