/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The start position for the route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixOrigin implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixOrigin.Builder, RouteMatrixOrigin> {
    private static final SdkField<RouteMatrixOriginOptions> OPTIONS_FIELD = SdkField
            .<RouteMatrixOriginOptions> builder(MarshallingType.SDK_POJO).memberName("Options")
            .getter(getter(RouteMatrixOrigin::options)).setter(setter(Builder::options))
            .constructor(RouteMatrixOriginOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(RouteMatrixOrigin::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(OPTIONS_FIELD, POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteMatrixOriginOptions options;

    private final List<Double> position;

    private RouteMatrixOrigin(BuilderImpl builder) {
        this.options = builder.options;
        this.position = builder.position;
    }

    /**
     * <p>
     * Origin related options.
     * </p>
     * 
     * @return Origin related options.
     */
    public final RouteMatrixOriginOptions options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position defined as <code>[longitude, latitude]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return Position defined as <code>[longitude, latitude]</code>.
     */
    public final List<Double> position() {
        return position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixOrigin)) {
            return false;
        }
        RouteMatrixOrigin other = (RouteMatrixOrigin) obj;
        return Objects.equals(options(), other.options()) && hasPosition() == other.hasPosition()
                && Objects.equals(position(), other.position());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixOrigin").add("Options", options())
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Options", OPTIONS_FIELD);
        map.put("Position", POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixOrigin, T> g) {
        return obj -> g.apply((RouteMatrixOrigin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixOrigin> {
        /**
         * <p>
         * Origin related options.
         * </p>
         * 
         * @param options
         *        Origin related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(RouteMatrixOriginOptions options);

        /**
         * <p>
         * Origin related options.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatrixOriginOptions.Builder}
         * avoiding the need to create one manually via {@link RouteMatrixOriginOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixOriginOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #options(RouteMatrixOriginOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link RouteMatrixOriginOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(RouteMatrixOriginOptions)
         */
        default Builder options(Consumer<RouteMatrixOriginOptions.Builder> options) {
            return options(RouteMatrixOriginOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);
    }

    static final class BuilderImpl implements Builder {
        private RouteMatrixOriginOptions options;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixOrigin model) {
            options(model.options);
            position(model.position);
        }

        public final RouteMatrixOriginOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(RouteMatrixOriginOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(RouteMatrixOriginOptions options) {
            this.options = options;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        @Override
        public RouteMatrixOrigin build() {
            return new RouteMatrixOrigin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
