/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Traffic related options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixTrafficOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixTrafficOptions.Builder, RouteMatrixTrafficOptions> {
    private static final SdkField<Long> FLOW_EVENT_THRESHOLD_OVERRIDE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("FlowEventThresholdOverride")
            .getter(getter(RouteMatrixTrafficOptions::flowEventThresholdOverride))
            .setter(setter(Builder::flowEventThresholdOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowEventThresholdOverride").build())
            .build();

    private static final SdkField<String> USAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Usage")
            .getter(getter(RouteMatrixTrafficOptions::usageAsString)).setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FLOW_EVENT_THRESHOLD_OVERRIDE_FIELD, USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long flowEventThresholdOverride;

    private final String usage;

    private RouteMatrixTrafficOptions(BuilderImpl builder) {
        this.flowEventThresholdOverride = builder.flowEventThresholdOverride;
        this.usage = builder.usage;
    }

    /**
     * <p>
     * Duration for which flow traffic is considered valid. For this period, the flow traffic is used over historical
     * traffic data. Flow traffic refers to congestion, which changes very quickly. Duration in seconds for which flow
     * traffic event would be considered valid. While flow traffic event is valid it will be used over the historical
     * traffic data.
     * </p>
     * 
     * @return Duration for which flow traffic is considered valid. For this period, the flow traffic is used over
     *         historical traffic data. Flow traffic refers to congestion, which changes very quickly. Duration in
     *         seconds for which flow traffic event would be considered valid. While flow traffic event is valid it will
     *         be used over the historical traffic data.
     */
    public final Long flowEventThresholdOverride() {
        return flowEventThresholdOverride;
    }

    /**
     * <p>
     * Determines if traffic should be used or ignored while calculating the route.
     * </p>
     * <p>
     * Default Value: <code>UseTrafficData</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usage} will return
     * {@link TrafficUsage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageAsString}.
     * </p>
     * 
     * @return Determines if traffic should be used or ignored while calculating the route.</p>
     *         <p>
     *         Default Value: <code>UseTrafficData</code>
     * @see TrafficUsage
     */
    public final TrafficUsage usage() {
        return TrafficUsage.fromValue(usage);
    }

    /**
     * <p>
     * Determines if traffic should be used or ignored while calculating the route.
     * </p>
     * <p>
     * Default Value: <code>UseTrafficData</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usage} will return
     * {@link TrafficUsage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageAsString}.
     * </p>
     * 
     * @return Determines if traffic should be used or ignored while calculating the route.</p>
     *         <p>
     *         Default Value: <code>UseTrafficData</code>
     * @see TrafficUsage
     */
    public final String usageAsString() {
        return usage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowEventThresholdOverride());
        hashCode = 31 * hashCode + Objects.hashCode(usageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixTrafficOptions)) {
            return false;
        }
        RouteMatrixTrafficOptions other = (RouteMatrixTrafficOptions) obj;
        return Objects.equals(flowEventThresholdOverride(), other.flowEventThresholdOverride())
                && Objects.equals(usageAsString(), other.usageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixTrafficOptions").add("FlowEventThresholdOverride", flowEventThresholdOverride())
                .add("Usage", usageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowEventThresholdOverride":
            return Optional.ofNullable(clazz.cast(flowEventThresholdOverride()));
        case "Usage":
            return Optional.ofNullable(clazz.cast(usageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlowEventThresholdOverride", FLOW_EVENT_THRESHOLD_OVERRIDE_FIELD);
        map.put("Usage", USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixTrafficOptions, T> g) {
        return obj -> g.apply((RouteMatrixTrafficOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixTrafficOptions> {
        /**
         * <p>
         * Duration for which flow traffic is considered valid. For this period, the flow traffic is used over
         * historical traffic data. Flow traffic refers to congestion, which changes very quickly. Duration in seconds
         * for which flow traffic event would be considered valid. While flow traffic event is valid it will be used
         * over the historical traffic data.
         * </p>
         * 
         * @param flowEventThresholdOverride
         *        Duration for which flow traffic is considered valid. For this period, the flow traffic is used over
         *        historical traffic data. Flow traffic refers to congestion, which changes very quickly. Duration in
         *        seconds for which flow traffic event would be considered valid. While flow traffic event is valid it
         *        will be used over the historical traffic data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowEventThresholdOverride(Long flowEventThresholdOverride);

        /**
         * <p>
         * Determines if traffic should be used or ignored while calculating the route.
         * </p>
         * <p>
         * Default Value: <code>UseTrafficData</code>
         * </p>
         * 
         * @param usage
         *        Determines if traffic should be used or ignored while calculating the route.</p>
         *        <p>
         *        Default Value: <code>UseTrafficData</code>
         * @see TrafficUsage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficUsage
         */
        Builder usage(String usage);

        /**
         * <p>
         * Determines if traffic should be used or ignored while calculating the route.
         * </p>
         * <p>
         * Default Value: <code>UseTrafficData</code>
         * </p>
         * 
         * @param usage
         *        Determines if traffic should be used or ignored while calculating the route.</p>
         *        <p>
         *        Default Value: <code>UseTrafficData</code>
         * @see TrafficUsage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficUsage
         */
        Builder usage(TrafficUsage usage);
    }

    static final class BuilderImpl implements Builder {
        private Long flowEventThresholdOverride;

        private String usage;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixTrafficOptions model) {
            flowEventThresholdOverride(model.flowEventThresholdOverride);
            usage(model.usage);
        }

        public final Long getFlowEventThresholdOverride() {
            return flowEventThresholdOverride;
        }

        public final void setFlowEventThresholdOverride(Long flowEventThresholdOverride) {
            this.flowEventThresholdOverride = flowEventThresholdOverride;
        }

        @Override
        public final Builder flowEventThresholdOverride(Long flowEventThresholdOverride) {
            this.flowEventThresholdOverride = flowEventThresholdOverride;
            return this;
        }

        public final String getUsage() {
            return usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public final Builder usage(TrafficUsage usage) {
            this.usage(usage == null ? null : usage.toString());
            return this;
        }

        @Override
        public RouteMatrixTrafficOptions build() {
            return new RouteMatrixTrafficOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
