/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Origin related options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteOriginOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteOriginOptions.Builder, RouteOriginOptions> {
    private static final SdkField<Long> AVOID_ACTIONS_FOR_DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AvoidActionsForDistance").getter(getter(RouteOriginOptions::avoidActionsForDistance))
            .setter(setter(Builder::avoidActionsForDistance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidActionsForDistance").build())
            .build();

    private static final SdkField<Boolean> AVOID_U_TURNS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AvoidUTurns").getter(getter(RouteOriginOptions::avoidUTurns)).setter(setter(Builder::avoidUTurns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidUTurns").build()).build();

    private static final SdkField<Double> HEADING_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Heading")
            .getter(getter(RouteOriginOptions::heading)).setter(setter(Builder::heading))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()).build();

    private static final SdkField<RouteMatchingOptions> MATCHING_FIELD = SdkField
            .<RouteMatchingOptions> builder(MarshallingType.SDK_POJO).memberName("Matching")
            .getter(getter(RouteOriginOptions::matching)).setter(setter(Builder::matching))
            .constructor(RouteMatchingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matching").build()).build();

    private static final SdkField<RouteSideOfStreetOptions> SIDE_OF_STREET_FIELD = SdkField
            .<RouteSideOfStreetOptions> builder(MarshallingType.SDK_POJO).memberName("SideOfStreet")
            .getter(getter(RouteOriginOptions::sideOfStreet)).setter(setter(Builder::sideOfStreet))
            .constructor(RouteSideOfStreetOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AVOID_ACTIONS_FOR_DISTANCE_FIELD, AVOID_U_TURNS_FIELD, HEADING_FIELD, MATCHING_FIELD, SIDE_OF_STREET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long avoidActionsForDistance;

    private final Boolean avoidUTurns;

    private final Double heading;

    private final RouteMatchingOptions matching;

    private final RouteSideOfStreetOptions sideOfStreet;

    private RouteOriginOptions(BuilderImpl builder) {
        this.avoidActionsForDistance = builder.avoidActionsForDistance;
        this.avoidUTurns = builder.avoidUTurns;
        this.heading = builder.heading;
        this.matching = builder.matching;
        this.sideOfStreet = builder.sideOfStreet;
    }

    /**
     * <p>
     * Avoids actions for the provided distance. This is typically to consider for users in moving vehicles who may not
     * have sufficient time to make an action at an origin or a destination.
     * </p>
     * 
     * @return Avoids actions for the provided distance. This is typically to consider for users in moving vehicles who
     *         may not have sufficient time to make an action at an origin or a destination.
     */
    public final Long avoidActionsForDistance() {
        return avoidActionsForDistance;
    }

    /**
     * <p>
     * Avoid U-turns for calculation on highways and motorways.
     * </p>
     * 
     * @return Avoid U-turns for calculation on highways and motorways.
     */
    public final Boolean avoidUTurns() {
        return avoidUTurns;
    }

    /**
     * <p>
     * GPS Heading at the position.
     * </p>
     * 
     * @return GPS Heading at the position.
     */
    public final Double heading() {
        return heading;
    }

    /**
     * <p>
     * Options to configure matching the provided position to the road network.
     * </p>
     * 
     * @return Options to configure matching the provided position to the road network.
     */
    public final RouteMatchingOptions matching() {
        return matching;
    }

    /**
     * <p>
     * Options to configure matching the provided position to a side of the street.
     * </p>
     * 
     * @return Options to configure matching the provided position to a side of the street.
     */
    public final RouteSideOfStreetOptions sideOfStreet() {
        return sideOfStreet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(avoidActionsForDistance());
        hashCode = 31 * hashCode + Objects.hashCode(avoidUTurns());
        hashCode = 31 * hashCode + Objects.hashCode(heading());
        hashCode = 31 * hashCode + Objects.hashCode(matching());
        hashCode = 31 * hashCode + Objects.hashCode(sideOfStreet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteOriginOptions)) {
            return false;
        }
        RouteOriginOptions other = (RouteOriginOptions) obj;
        return Objects.equals(avoidActionsForDistance(), other.avoidActionsForDistance())
                && Objects.equals(avoidUTurns(), other.avoidUTurns()) && Objects.equals(heading(), other.heading())
                && Objects.equals(matching(), other.matching()) && Objects.equals(sideOfStreet(), other.sideOfStreet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteOriginOptions").add("AvoidActionsForDistance", avoidActionsForDistance())
                .add("AvoidUTurns", avoidUTurns()).add("Heading", heading()).add("Matching", matching())
                .add("SideOfStreet", sideOfStreet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvoidActionsForDistance":
            return Optional.ofNullable(clazz.cast(avoidActionsForDistance()));
        case "AvoidUTurns":
            return Optional.ofNullable(clazz.cast(avoidUTurns()));
        case "Heading":
            return Optional.ofNullable(clazz.cast(heading()));
        case "Matching":
            return Optional.ofNullable(clazz.cast(matching()));
        case "SideOfStreet":
            return Optional.ofNullable(clazz.cast(sideOfStreet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvoidActionsForDistance", AVOID_ACTIONS_FOR_DISTANCE_FIELD);
        map.put("AvoidUTurns", AVOID_U_TURNS_FIELD);
        map.put("Heading", HEADING_FIELD);
        map.put("Matching", MATCHING_FIELD);
        map.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteOriginOptions, T> g) {
        return obj -> g.apply((RouteOriginOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteOriginOptions> {
        /**
         * <p>
         * Avoids actions for the provided distance. This is typically to consider for users in moving vehicles who may
         * not have sufficient time to make an action at an origin or a destination.
         * </p>
         * 
         * @param avoidActionsForDistance
         *        Avoids actions for the provided distance. This is typically to consider for users in moving vehicles
         *        who may not have sufficient time to make an action at an origin or a destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avoidActionsForDistance(Long avoidActionsForDistance);

        /**
         * <p>
         * Avoid U-turns for calculation on highways and motorways.
         * </p>
         * 
         * @param avoidUTurns
         *        Avoid U-turns for calculation on highways and motorways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avoidUTurns(Boolean avoidUTurns);

        /**
         * <p>
         * GPS Heading at the position.
         * </p>
         * 
         * @param heading
         *        GPS Heading at the position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heading(Double heading);

        /**
         * <p>
         * Options to configure matching the provided position to the road network.
         * </p>
         * 
         * @param matching
         *        Options to configure matching the provided position to the road network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matching(RouteMatchingOptions matching);

        /**
         * <p>
         * Options to configure matching the provided position to the road network.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatchingOptions.Builder} avoiding
         * the need to create one manually via {@link RouteMatchingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatchingOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #matching(RouteMatchingOptions)}.
         * 
         * @param matching
         *        a consumer that will call methods on {@link RouteMatchingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matching(RouteMatchingOptions)
         */
        default Builder matching(Consumer<RouteMatchingOptions.Builder> matching) {
            return matching(RouteMatchingOptions.builder().applyMutation(matching).build());
        }

        /**
         * <p>
         * Options to configure matching the provided position to a side of the street.
         * </p>
         * 
         * @param sideOfStreet
         *        Options to configure matching the provided position to a side of the street.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sideOfStreet(RouteSideOfStreetOptions sideOfStreet);

        /**
         * <p>
         * Options to configure matching the provided position to a side of the street.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteSideOfStreetOptions.Builder}
         * avoiding the need to create one manually via {@link RouteSideOfStreetOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteSideOfStreetOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #sideOfStreet(RouteSideOfStreetOptions)}.
         * 
         * @param sideOfStreet
         *        a consumer that will call methods on {@link RouteSideOfStreetOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sideOfStreet(RouteSideOfStreetOptions)
         */
        default Builder sideOfStreet(Consumer<RouteSideOfStreetOptions.Builder> sideOfStreet) {
            return sideOfStreet(RouteSideOfStreetOptions.builder().applyMutation(sideOfStreet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long avoidActionsForDistance;

        private Boolean avoidUTurns;

        private Double heading;

        private RouteMatchingOptions matching;

        private RouteSideOfStreetOptions sideOfStreet;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteOriginOptions model) {
            avoidActionsForDistance(model.avoidActionsForDistance);
            avoidUTurns(model.avoidUTurns);
            heading(model.heading);
            matching(model.matching);
            sideOfStreet(model.sideOfStreet);
        }

        public final Long getAvoidActionsForDistance() {
            return avoidActionsForDistance;
        }

        public final void setAvoidActionsForDistance(Long avoidActionsForDistance) {
            this.avoidActionsForDistance = avoidActionsForDistance;
        }

        @Override
        public final Builder avoidActionsForDistance(Long avoidActionsForDistance) {
            this.avoidActionsForDistance = avoidActionsForDistance;
            return this;
        }

        public final Boolean getAvoidUTurns() {
            return avoidUTurns;
        }

        public final void setAvoidUTurns(Boolean avoidUTurns) {
            this.avoidUTurns = avoidUTurns;
        }

        @Override
        public final Builder avoidUTurns(Boolean avoidUTurns) {
            this.avoidUTurns = avoidUTurns;
            return this;
        }

        public final Double getHeading() {
            return heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final RouteMatchingOptions.Builder getMatching() {
            return matching != null ? matching.toBuilder() : null;
        }

        public final void setMatching(RouteMatchingOptions.BuilderImpl matching) {
            this.matching = matching != null ? matching.build() : null;
        }

        @Override
        public final Builder matching(RouteMatchingOptions matching) {
            this.matching = matching;
            return this;
        }

        public final RouteSideOfStreetOptions.Builder getSideOfStreet() {
            return sideOfStreet != null ? sideOfStreet.toBuilder() : null;
        }

        public final void setSideOfStreet(RouteSideOfStreetOptions.BuilderImpl sideOfStreet) {
            this.sideOfStreet = sideOfStreet != null ? sideOfStreet.build() : null;
        }

        @Override
        public final Builder sideOfStreet(RouteSideOfStreetOptions sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        @Override
        public RouteOriginOptions build() {
            return new RouteOriginOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
