/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details corresponding to the arrival for a leg.
 * </p>
 * <p>
 * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
 * </p>
 * <p>
 * Examples:
 * </p>
 * <p>
 * <code>2020-04-22T17:57:24Z</code>
 * </p>
 * <p>
 * <code>2020-04-22T17:57:24+02:00</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutePedestrianArrival implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutePedestrianArrival.Builder, RoutePedestrianArrival> {
    private static final SdkField<RoutePedestrianPlace> PLACE_FIELD = SdkField
            .<RoutePedestrianPlace> builder(MarshallingType.SDK_POJO).memberName("Place")
            .getter(getter(RoutePedestrianArrival::place)).setter(setter(Builder::place))
            .constructor(RoutePedestrianPlace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Place").build()).build();

    private static final SdkField<String> TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Time")
            .getter(getter(RoutePedestrianArrival::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_FIELD, TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RoutePedestrianPlace place;

    private final String time;

    private RoutePedestrianArrival(BuilderImpl builder) {
        this.place = builder.place;
        this.time = builder.time;
    }

    /**
     * <p>
     * The place details.
     * </p>
     * 
     * @return The place details.
     */
    public final RoutePedestrianPlace place() {
        return place;
    }

    /**
     * <p>
     * The time.
     * </p>
     * 
     * @return The time.
     */
    public final String time() {
        return time;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(place());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutePedestrianArrival)) {
            return false;
        }
        RoutePedestrianArrival other = (RoutePedestrianArrival) obj;
        return Objects.equals(place(), other.place()) && Objects.equals(time(), other.time());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutePedestrianArrival").add("Place", place()).add("Time", time()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Place":
            return Optional.ofNullable(clazz.cast(place()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Place", PLACE_FIELD);
        map.put("Time", TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutePedestrianArrival, T> g) {
        return obj -> g.apply((RoutePedestrianArrival) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutePedestrianArrival> {
        /**
         * <p>
         * The place details.
         * </p>
         * 
         * @param place
         *        The place details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder place(RoutePedestrianPlace place);

        /**
         * <p>
         * The place details.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePedestrianPlace.Builder} avoiding
         * the need to create one manually via {@link RoutePedestrianPlace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePedestrianPlace.Builder#build()} is called immediately and
         * its result is passed to {@link #place(RoutePedestrianPlace)}.
         * 
         * @param place
         *        a consumer that will call methods on {@link RoutePedestrianPlace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #place(RoutePedestrianPlace)
         */
        default Builder place(Consumer<RoutePedestrianPlace.Builder> place) {
            return place(RoutePedestrianPlace.builder().applyMutation(place).build());
        }

        /**
         * <p>
         * The time.
         * </p>
         * 
         * @param time
         *        The time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(String time);
    }

    static final class BuilderImpl implements Builder {
        private RoutePedestrianPlace place;

        private String time;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutePedestrianArrival model) {
            place(model.place);
            time(model.time);
        }

        public final RoutePedestrianPlace.Builder getPlace() {
            return place != null ? place.toBuilder() : null;
        }

        public final void setPlace(RoutePedestrianPlace.BuilderImpl place) {
            this.place = place != null ? place.build() : null;
        }

        @Override
        public final Builder place(RoutePedestrianPlace place) {
            this.place = place;
            return this;
        }

        public final String getTime() {
            return time;
        }

        public final void setTime(String time) {
            this.time = time;
        }

        @Override
        public final Builder time(String time) {
            this.time = time;
            return this;
        }

        @Override
        public RoutePedestrianArrival build() {
            return new RoutePedestrianArrival(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
