/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about toll information along a route, including the payment sites, applicable toll rates, toll
 * systems, and the country associated with the toll collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteToll implements SdkPojo, Serializable, ToCopyableBuilder<RouteToll.Builder, RouteToll> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(RouteToll::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<List<RouteTollPaymentSite>> PAYMENT_SITES_FIELD = SdkField
            .<List<RouteTollPaymentSite>> builder(MarshallingType.LIST)
            .memberName("PaymentSites")
            .getter(getter(RouteToll::paymentSites))
            .setter(setter(Builder::paymentSites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentSites").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteTollPaymentSite> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteTollPaymentSite::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteTollRate>> RATES_FIELD = SdkField
            .<List<RouteTollRate>> builder(MarshallingType.LIST)
            .memberName("Rates")
            .getter(getter(RouteToll::rates))
            .setter(setter(Builder::rates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteTollRate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteTollRate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> SYSTEMS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Systems")
            .getter(getter(RouteToll::systems))
            .setter(setter(Builder::systems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Systems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD,
            PAYMENT_SITES_FIELD, RATES_FIELD, SYSTEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String country;

    private final List<RouteTollPaymentSite> paymentSites;

    private final List<RouteTollRate> rates;

    private final List<Integer> systems;

    private RouteToll(BuilderImpl builder) {
        this.country = builder.country;
        this.paymentSites = builder.paymentSites;
        this.rates = builder.rates;
        this.systems = builder.systems;
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the country.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the country.
     */
    public final String country() {
        return country;
    }

    /**
     * For responses, this returns true if the service returned a value for the PaymentSites property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPaymentSites() {
        return paymentSites != null && !(paymentSites instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Locations or sites where the toll fare is collected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPaymentSites} method.
     * </p>
     * 
     * @return Locations or sites where the toll fare is collected.
     */
    public final List<RouteTollPaymentSite> paymentSites() {
        return paymentSites;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rates property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRates() {
        return rates != null && !(rates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Toll rates that need to be paid to travel this leg of the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRates} method.
     * </p>
     * 
     * @return Toll rates that need to be paid to travel this leg of the route.
     */
    public final List<RouteTollRate> rates() {
        return rates;
    }

    /**
     * For responses, this returns true if the service returned a value for the Systems property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSystems() {
        return systems != null && !(systems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Toll systems are authorities that collect payments for the toll.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSystems} method.
     * </p>
     * 
     * @return Toll systems are authorities that collect payments for the toll.
     */
    public final List<Integer> systems() {
        return systems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(hasPaymentSites() ? paymentSites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRates() ? rates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSystems() ? systems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteToll)) {
            return false;
        }
        RouteToll other = (RouteToll) obj;
        return Objects.equals(country(), other.country()) && hasPaymentSites() == other.hasPaymentSites()
                && Objects.equals(paymentSites(), other.paymentSites()) && hasRates() == other.hasRates()
                && Objects.equals(rates(), other.rates()) && hasSystems() == other.hasSystems()
                && Objects.equals(systems(), other.systems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteToll").add("Country", country())
                .add("PaymentSites", hasPaymentSites() ? paymentSites() : null).add("Rates", hasRates() ? rates() : null)
                .add("Systems", hasSystems() ? systems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "PaymentSites":
            return Optional.ofNullable(clazz.cast(paymentSites()));
        case "Rates":
            return Optional.ofNullable(clazz.cast(rates()));
        case "Systems":
            return Optional.ofNullable(clazz.cast(systems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Country", COUNTRY_FIELD);
        map.put("PaymentSites", PAYMENT_SITES_FIELD);
        map.put("Rates", RATES_FIELD);
        map.put("Systems", SYSTEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteToll, T> g) {
        return obj -> g.apply((RouteToll) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteToll> {
        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country.
         * </p>
         * 
         * @param country
         *        The alpha-2 or alpha-3 character code for the country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * Locations or sites where the toll fare is collected.
         * </p>
         * 
         * @param paymentSites
         *        Locations or sites where the toll fare is collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentSites(Collection<RouteTollPaymentSite> paymentSites);

        /**
         * <p>
         * Locations or sites where the toll fare is collected.
         * </p>
         * 
         * @param paymentSites
         *        Locations or sites where the toll fare is collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentSites(RouteTollPaymentSite... paymentSites);

        /**
         * <p>
         * Locations or sites where the toll fare is collected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTollPaymentSite.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTollPaymentSite#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTollPaymentSite.Builder#build()} is called
         * immediately and its result is passed to {@link #paymentSites(List<RouteTollPaymentSite>)}.
         * 
         * @param paymentSites
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteTollPaymentSite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paymentSites(java.util.Collection<RouteTollPaymentSite>)
         */
        Builder paymentSites(Consumer<RouteTollPaymentSite.Builder>... paymentSites);

        /**
         * <p>
         * Toll rates that need to be paid to travel this leg of the route.
         * </p>
         * 
         * @param rates
         *        Toll rates that need to be paid to travel this leg of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rates(Collection<RouteTollRate> rates);

        /**
         * <p>
         * Toll rates that need to be paid to travel this leg of the route.
         * </p>
         * 
         * @param rates
         *        Toll rates that need to be paid to travel this leg of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rates(RouteTollRate... rates);

        /**
         * <p>
         * Toll rates that need to be paid to travel this leg of the route.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTollRate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.RouteTollRate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTollRate.Builder#build()} is called immediately
         * and its result is passed to {@link #rates(List<RouteTollRate>)}.
         * 
         * @param rates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteTollRate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rates(java.util.Collection<RouteTollRate>)
         */
        Builder rates(Consumer<RouteTollRate.Builder>... rates);

        /**
         * <p>
         * Toll systems are authorities that collect payments for the toll.
         * </p>
         * 
         * @param systems
         *        Toll systems are authorities that collect payments for the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systems(Collection<Integer> systems);

        /**
         * <p>
         * Toll systems are authorities that collect payments for the toll.
         * </p>
         * 
         * @param systems
         *        Toll systems are authorities that collect payments for the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systems(Integer... systems);
    }

    static final class BuilderImpl implements Builder {
        private String country;

        private List<RouteTollPaymentSite> paymentSites = DefaultSdkAutoConstructList.getInstance();

        private List<RouteTollRate> rates = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> systems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteToll model) {
            country(model.country);
            paymentSites(model.paymentSites);
            rates(model.rates);
            systems(model.systems);
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final List<RouteTollPaymentSite.Builder> getPaymentSites() {
            List<RouteTollPaymentSite.Builder> result = RouteTollPaymentSiteListCopier.copyToBuilder(this.paymentSites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPaymentSites(Collection<RouteTollPaymentSite.BuilderImpl> paymentSites) {
            this.paymentSites = RouteTollPaymentSiteListCopier.copyFromBuilder(paymentSites);
        }

        @Override
        public final Builder paymentSites(Collection<RouteTollPaymentSite> paymentSites) {
            this.paymentSites = RouteTollPaymentSiteListCopier.copy(paymentSites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentSites(RouteTollPaymentSite... paymentSites) {
            paymentSites(Arrays.asList(paymentSites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentSites(Consumer<RouteTollPaymentSite.Builder>... paymentSites) {
            paymentSites(Stream.of(paymentSites).map(c -> RouteTollPaymentSite.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RouteTollRate.Builder> getRates() {
            List<RouteTollRate.Builder> result = RouteTollRateListCopier.copyToBuilder(this.rates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRates(Collection<RouteTollRate.BuilderImpl> rates) {
            this.rates = RouteTollRateListCopier.copyFromBuilder(rates);
        }

        @Override
        public final Builder rates(Collection<RouteTollRate> rates) {
            this.rates = RouteTollRateListCopier.copy(rates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rates(RouteTollRate... rates) {
            rates(Arrays.asList(rates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rates(Consumer<RouteTollRate.Builder>... rates) {
            rates(Stream.of(rates).map(c -> RouteTollRate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Integer> getSystems() {
            if (systems instanceof SdkAutoConstructList) {
                return null;
            }
            return systems;
        }

        public final void setSystems(Collection<Integer> systems) {
            this.systems = IndexListCopier.copy(systems);
        }

        @Override
        public final Builder systems(Collection<Integer> systems) {
            this.systems = IndexListCopier.copy(systems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systems(Integer... systems) {
            systems(Arrays.asList(systems));
            return this;
        }

        @Override
        public RouteToll build() {
            return new RouteToll(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
