/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the route and toll price.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTollPriceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteTollPriceSummary.Builder, RouteTollPriceSummary> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Currency").getter(getter(RouteTollPriceSummary::currency)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()).build();

    private static final SdkField<Boolean> ESTIMATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Estimate").getter(getter(RouteTollPriceSummary::estimate)).setter(setter(Builder::estimate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Estimate").build()).build();

    private static final SdkField<Boolean> RANGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Range")
            .getter(getter(RouteTollPriceSummary::range)).setter(setter(Builder::range))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final SdkField<RouteTollPriceValueRange> RANGE_VALUE_FIELD = SdkField
            .<RouteTollPriceValueRange> builder(MarshallingType.SDK_POJO).memberName("RangeValue")
            .getter(getter(RouteTollPriceSummary::rangeValue)).setter(setter(Builder::rangeValue))
            .constructor(RouteTollPriceValueRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeValue").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(RouteTollPriceSummary::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD,
            ESTIMATE_FIELD, RANGE_FIELD, RANGE_VALUE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currency;

    private final Boolean estimate;

    private final Boolean range;

    private final RouteTollPriceValueRange rangeValue;

    private final Double value;

    private RouteTollPriceSummary(BuilderImpl builder) {
        this.currency = builder.currency;
        this.estimate = builder.estimate;
        this.range = builder.range;
        this.rangeValue = builder.rangeValue;
        this.value = builder.value;
    }

    /**
     * <p>
     * Currency code corresponding to the price. This is the same as Currency specified in the request.
     * </p>
     * 
     * @return Currency code corresponding to the price. This is the same as Currency specified in the request.
     */
    public final String currency() {
        return currency;
    }

    /**
     * <p>
     * If the price is an estimate or an exact value.
     * </p>
     * 
     * @return If the price is an estimate or an exact value.
     */
    public final Boolean estimate() {
        return estimate;
    }

    /**
     * <p>
     * If the price is a range or an exact value. If any of the toll fares making up the route is a range, the overall
     * price is also a range.
     * </p>
     * 
     * @return If the price is a range or an exact value. If any of the toll fares making up the route is a range, the
     *         overall price is also a range.
     */
    public final Boolean range() {
        return range;
    }

    /**
     * <p>
     * Price range with a minimum and maximum value, if a range.
     * </p>
     * 
     * @return Price range with a minimum and maximum value, if a range.
     */
    public final RouteTollPriceValueRange rangeValue() {
        return rangeValue;
    }

    /**
     * <p>
     * Exact price, if not a range.
     * </p>
     * 
     * @return Exact price, if not a range.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currency());
        hashCode = 31 * hashCode + Objects.hashCode(estimate());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        hashCode = 31 * hashCode + Objects.hashCode(rangeValue());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTollPriceSummary)) {
            return false;
        }
        RouteTollPriceSummary other = (RouteTollPriceSummary) obj;
        return Objects.equals(currency(), other.currency()) && Objects.equals(estimate(), other.estimate())
                && Objects.equals(range(), other.range()) && Objects.equals(rangeValue(), other.rangeValue())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTollPriceSummary").add("Currency", currency()).add("Estimate", estimate())
                .add("Range", range()).add("RangeValue", rangeValue()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Currency":
            return Optional.ofNullable(clazz.cast(currency()));
        case "Estimate":
            return Optional.ofNullable(clazz.cast(estimate()));
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        case "RangeValue":
            return Optional.ofNullable(clazz.cast(rangeValue()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Currency", CURRENCY_FIELD);
        map.put("Estimate", ESTIMATE_FIELD);
        map.put("Range", RANGE_FIELD);
        map.put("RangeValue", RANGE_VALUE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTollPriceSummary, T> g) {
        return obj -> g.apply((RouteTollPriceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTollPriceSummary> {
        /**
         * <p>
         * Currency code corresponding to the price. This is the same as Currency specified in the request.
         * </p>
         * 
         * @param currency
         *        Currency code corresponding to the price. This is the same as Currency specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currency(String currency);

        /**
         * <p>
         * If the price is an estimate or an exact value.
         * </p>
         * 
         * @param estimate
         *        If the price is an estimate or an exact value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimate(Boolean estimate);

        /**
         * <p>
         * If the price is a range or an exact value. If any of the toll fares making up the route is a range, the
         * overall price is also a range.
         * </p>
         * 
         * @param range
         *        If the price is a range or an exact value. If any of the toll fares making up the route is a range,
         *        the overall price is also a range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(Boolean range);

        /**
         * <p>
         * Price range with a minimum and maximum value, if a range.
         * </p>
         * 
         * @param rangeValue
         *        Price range with a minimum and maximum value, if a range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeValue(RouteTollPriceValueRange rangeValue);

        /**
         * <p>
         * Price range with a minimum and maximum value, if a range.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTollPriceValueRange.Builder}
         * avoiding the need to create one manually via {@link RouteTollPriceValueRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTollPriceValueRange.Builder#build()} is called immediately
         * and its result is passed to {@link #rangeValue(RouteTollPriceValueRange)}.
         * 
         * @param rangeValue
         *        a consumer that will call methods on {@link RouteTollPriceValueRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeValue(RouteTollPriceValueRange)
         */
        default Builder rangeValue(Consumer<RouteTollPriceValueRange.Builder> rangeValue) {
            return rangeValue(RouteTollPriceValueRange.builder().applyMutation(rangeValue).build());
        }

        /**
         * <p>
         * Exact price, if not a range.
         * </p>
         * 
         * @param value
         *        Exact price, if not a range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String currency;

        private Boolean estimate;

        private Boolean range;

        private RouteTollPriceValueRange rangeValue;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTollPriceSummary model) {
            currency(model.currency);
            estimate(model.estimate);
            range(model.range);
            rangeValue(model.rangeValue);
            value(model.value);
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public final Boolean getEstimate() {
            return estimate;
        }

        public final void setEstimate(Boolean estimate) {
            this.estimate = estimate;
        }

        @Override
        public final Builder estimate(Boolean estimate) {
            this.estimate = estimate;
            return this;
        }

        public final Boolean getRange() {
            return range;
        }

        public final void setRange(Boolean range) {
            this.range = range;
        }

        @Override
        public final Builder range(Boolean range) {
            this.range = range;
            return this;
        }

        public final RouteTollPriceValueRange.Builder getRangeValue() {
            return rangeValue != null ? rangeValue.toBuilder() : null;
        }

        public final void setRangeValue(RouteTollPriceValueRange.BuilderImpl rangeValue) {
            this.rangeValue = rangeValue != null ? rangeValue.build() : null;
        }

        @Override
        public final Builder rangeValue(RouteTollPriceValueRange rangeValue) {
            this.rangeValue = rangeValue;
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public RouteTollPriceSummary build() {
            return new RouteTollPriceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
