/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The toll summary for the complete route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTollSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteTollSummary.Builder, RouteTollSummary> {
    private static final SdkField<RouteTollPriceSummary> TOTAL_FIELD = SdkField
            .<RouteTollPriceSummary> builder(MarshallingType.SDK_POJO).memberName("Total")
            .getter(getter(RouteTollSummary::total)).setter(setter(Builder::total)).constructor(RouteTollPriceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteTollPriceSummary total;

    private RouteTollSummary(BuilderImpl builder) {
        this.total = builder.total;
    }

    /**
     * <p>
     * Total toll summary for the complete route. Total is the only summary available today.
     * </p>
     * 
     * @return Total toll summary for the complete route. Total is the only summary available today.
     */
    public final RouteTollPriceSummary total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTollSummary)) {
            return false;
        }
        RouteTollSummary other = (RouteTollSummary) obj;
        return Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTollSummary").add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTollSummary, T> g) {
        return obj -> g.apply((RouteTollSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTollSummary> {
        /**
         * <p>
         * Total toll summary for the complete route. Total is the only summary available today.
         * </p>
         * 
         * @param total
         *        Total toll summary for the complete route. Total is the only summary available today.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(RouteTollPriceSummary total);

        /**
         * <p>
         * Total toll summary for the complete route. Total is the only summary available today.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTollPriceSummary.Builder} avoiding
         * the need to create one manually via {@link RouteTollPriceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTollPriceSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #total(RouteTollPriceSummary)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link RouteTollPriceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(RouteTollPriceSummary)
         */
        default Builder total(Consumer<RouteTollPriceSummary.Builder> total) {
            return total(RouteTollPriceSummary.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RouteTollPriceSummary total;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTollSummary model) {
            total(model.total);
        }

        public final RouteTollPriceSummary.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        public final void setTotal(RouteTollPriceSummary.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(RouteTollPriceSummary total) {
            this.total = total;
            return this;
        }

        @Override
        public RouteTollSummary build() {
            return new RouteTollSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
