/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trailer options corresponding to the vehicle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTrailerOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteTrailerOptions.Builder, RouteTrailerOptions> {
    private static final SdkField<Integer> AXLE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AxleCount").getter(getter(RouteTrailerOptions::axleCount)).setter(setter(Builder::axleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxleCount").build()).build();

    private static final SdkField<Integer> TRAILER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TrailerCount").getter(getter(RouteTrailerOptions::trailerCount)).setter(setter(Builder::trailerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailerCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AXLE_COUNT_FIELD,
            TRAILER_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer axleCount;

    private final Integer trailerCount;

    private RouteTrailerOptions(BuilderImpl builder) {
        this.axleCount = builder.axleCount;
        this.trailerCount = builder.trailerCount;
    }

    /**
     * <p>
     * Total number of axles of the vehicle.
     * </p>
     * 
     * @return Total number of axles of the vehicle.
     */
    public final Integer axleCount() {
        return axleCount;
    }

    /**
     * <p>
     * Number of trailers attached to the vehicle.
     * </p>
     * <p>
     * Default Value: <code>0</code>
     * </p>
     * 
     * @return Number of trailers attached to the vehicle.</p>
     *         <p>
     *         Default Value: <code>0</code>
     */
    public final Integer trailerCount() {
        return trailerCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(axleCount());
        hashCode = 31 * hashCode + Objects.hashCode(trailerCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTrailerOptions)) {
            return false;
        }
        RouteTrailerOptions other = (RouteTrailerOptions) obj;
        return Objects.equals(axleCount(), other.axleCount()) && Objects.equals(trailerCount(), other.trailerCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTrailerOptions").add("AxleCount", axleCount()).add("TrailerCount", trailerCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AxleCount":
            return Optional.ofNullable(clazz.cast(axleCount()));
        case "TrailerCount":
            return Optional.ofNullable(clazz.cast(trailerCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AxleCount", AXLE_COUNT_FIELD);
        map.put("TrailerCount", TRAILER_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTrailerOptions, T> g) {
        return obj -> g.apply((RouteTrailerOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTrailerOptions> {
        /**
         * <p>
         * Total number of axles of the vehicle.
         * </p>
         * 
         * @param axleCount
         *        Total number of axles of the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder axleCount(Integer axleCount);

        /**
         * <p>
         * Number of trailers attached to the vehicle.
         * </p>
         * <p>
         * Default Value: <code>0</code>
         * </p>
         * 
         * @param trailerCount
         *        Number of trailers attached to the vehicle.</p>
         *        <p>
         *        Default Value: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailerCount(Integer trailerCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer axleCount;

        private Integer trailerCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTrailerOptions model) {
            axleCount(model.axleCount);
            trailerCount(model.trailerCount);
        }

        public final Integer getAxleCount() {
            return axleCount;
        }

        public final void setAxleCount(Integer axleCount) {
            this.axleCount = axleCount;
        }

        @Override
        public final Builder axleCount(Integer axleCount) {
            this.axleCount = axleCount;
            return this;
        }

        public final Integer getTrailerCount() {
            return trailerCount;
        }

        public final void setTrailerCount(Integer trailerCount) {
            this.trailerCount = trailerCount;
        }

        @Override
        public final Builder trailerCount(Integer trailerCount) {
            this.trailerCount = trailerCount;
            return this;
        }

        @Override
        public RouteTrailerOptions build() {
            return new RouteTrailerOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
