/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Transponders for which this toll can be applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTransponder implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteTransponder.Builder, RouteTransponder> {
    private static final SdkField<String> SYSTEM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SystemName").getter(getter(RouteTransponder::systemName)).setter(setter(Builder::systemName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String systemName;

    private RouteTransponder(BuilderImpl builder) {
        this.systemName = builder.systemName;
    }

    /**
     * <p>
     * Names of the toll system collecting the toll.
     * </p>
     * 
     * @return Names of the toll system collecting the toll.
     */
    public final String systemName() {
        return systemName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(systemName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTransponder)) {
            return false;
        }
        RouteTransponder other = (RouteTransponder) obj;
        return Objects.equals(systemName(), other.systemName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTransponder").add("SystemName", systemName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SystemName":
            return Optional.ofNullable(clazz.cast(systemName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SystemName", SYSTEM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTransponder, T> g) {
        return obj -> g.apply((RouteTransponder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTransponder> {
        /**
         * <p>
         * Names of the toll system collecting the toll.
         * </p>
         * 
         * @param systemName
         *        Names of the toll system collecting the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemName(String systemName);
    }

    static final class BuilderImpl implements Builder {
        private String systemName;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTransponder model) {
            systemName(model.systemName);
        }

        public final String getSystemName() {
            return systemName;
        }

        public final void setSystemName(String systemName) {
            this.systemName = systemName;
        }

        @Override
        public final Builder systemName(String systemName) {
            this.systemName = systemName;
            return this;
        }

        @Override
        public RouteTransponder build() {
            return new RouteTransponder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
