/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details related to the U-turn step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteUTurnStepDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteUTurnStepDetails.Builder, RouteUTurnStepDetails> {
    private static final SdkField<List<LocalizedString>> INTERSECTION_FIELD = SdkField
            .<List<LocalizedString>> builder(MarshallingType.LIST)
            .memberName("Intersection")
            .getter(getter(RouteUTurnStepDetails::intersection))
            .setter(setter(Builder::intersection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalizedString> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalizedString::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STEERING_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SteeringDirection").getter(getter(RouteUTurnStepDetails::steeringDirectionAsString))
            .setter(setter(Builder::steeringDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SteeringDirection").build()).build();

    private static final SdkField<Double> TURN_ANGLE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TurnAngle").getter(getter(RouteUTurnStepDetails::turnAngle)).setter(setter(Builder::turnAngle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnAngle").build()).build();

    private static final SdkField<String> TURN_INTENSITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TurnIntensity").getter(getter(RouteUTurnStepDetails::turnIntensityAsString))
            .setter(setter(Builder::turnIntensity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnIntensity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERSECTION_FIELD,
            STEERING_DIRECTION_FIELD, TURN_ANGLE_FIELD, TURN_INTENSITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LocalizedString> intersection;

    private final String steeringDirection;

    private final Double turnAngle;

    private final String turnIntensity;

    private RouteUTurnStepDetails(BuilderImpl builder) {
        this.intersection = builder.intersection;
        this.steeringDirection = builder.steeringDirection;
        this.turnAngle = builder.turnAngle;
        this.turnIntensity = builder.turnIntensity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Intersection property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntersection() {
        return intersection != null && !(intersection instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the intersection, if applicable to the step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntersection} method.
     * </p>
     * 
     * @return Name of the intersection, if applicable to the step.
     */
    public final List<LocalizedString> intersection() {
        return intersection;
    }

    /**
     * <p>
     * Steering direction for the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #steeringDirection}
     * will return {@link RouteSteeringDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #steeringDirectionAsString}.
     * </p>
     * 
     * @return Steering direction for the step.
     * @see RouteSteeringDirection
     */
    public final RouteSteeringDirection steeringDirection() {
        return RouteSteeringDirection.fromValue(steeringDirection);
    }

    /**
     * <p>
     * Steering direction for the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #steeringDirection}
     * will return {@link RouteSteeringDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #steeringDirectionAsString}.
     * </p>
     * 
     * @return Steering direction for the step.
     * @see RouteSteeringDirection
     */
    public final String steeringDirectionAsString() {
        return steeringDirection;
    }

    /**
     * <p>
     * Angle of the turn.
     * </p>
     * 
     * @return Angle of the turn.
     */
    public final Double turnAngle() {
        return turnAngle;
    }

    /**
     * <p>
     * Intensity of the turn.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #turnIntensity}
     * will return {@link RouteTurnIntensity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #turnIntensityAsString}.
     * </p>
     * 
     * @return Intensity of the turn.
     * @see RouteTurnIntensity
     */
    public final RouteTurnIntensity turnIntensity() {
        return RouteTurnIntensity.fromValue(turnIntensity);
    }

    /**
     * <p>
     * Intensity of the turn.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #turnIntensity}
     * will return {@link RouteTurnIntensity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #turnIntensityAsString}.
     * </p>
     * 
     * @return Intensity of the turn.
     * @see RouteTurnIntensity
     */
    public final String turnIntensityAsString() {
        return turnIntensity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIntersection() ? intersection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(steeringDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(turnAngle());
        hashCode = 31 * hashCode + Objects.hashCode(turnIntensityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteUTurnStepDetails)) {
            return false;
        }
        RouteUTurnStepDetails other = (RouteUTurnStepDetails) obj;
        return hasIntersection() == other.hasIntersection() && Objects.equals(intersection(), other.intersection())
                && Objects.equals(steeringDirectionAsString(), other.steeringDirectionAsString())
                && Objects.equals(turnAngle(), other.turnAngle())
                && Objects.equals(turnIntensityAsString(), other.turnIntensityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteUTurnStepDetails").add("Intersection", hasIntersection() ? intersection() : null)
                .add("SteeringDirection", steeringDirectionAsString()).add("TurnAngle", turnAngle())
                .add("TurnIntensity", turnIntensityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Intersection":
            return Optional.ofNullable(clazz.cast(intersection()));
        case "SteeringDirection":
            return Optional.ofNullable(clazz.cast(steeringDirectionAsString()));
        case "TurnAngle":
            return Optional.ofNullable(clazz.cast(turnAngle()));
        case "TurnIntensity":
            return Optional.ofNullable(clazz.cast(turnIntensityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Intersection", INTERSECTION_FIELD);
        map.put("SteeringDirection", STEERING_DIRECTION_FIELD);
        map.put("TurnAngle", TURN_ANGLE_FIELD);
        map.put("TurnIntensity", TURN_INTENSITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteUTurnStepDetails, T> g) {
        return obj -> g.apply((RouteUTurnStepDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteUTurnStepDetails> {
        /**
         * <p>
         * Name of the intersection, if applicable to the step.
         * </p>
         * 
         * @param intersection
         *        Name of the intersection, if applicable to the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intersection(Collection<LocalizedString> intersection);

        /**
         * <p>
         * Name of the intersection, if applicable to the step.
         * </p>
         * 
         * @param intersection
         *        Name of the intersection, if applicable to the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intersection(LocalizedString... intersection);

        /**
         * <p>
         * Name of the intersection, if applicable to the step.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.LocalizedString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder#build()} is called immediately
         * and its result is passed to {@link #intersection(List<LocalizedString>)}.
         * 
         * @param intersection
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intersection(java.util.Collection<LocalizedString>)
         */
        Builder intersection(Consumer<LocalizedString.Builder>... intersection);

        /**
         * <p>
         * Steering direction for the step.
         * </p>
         * 
         * @param steeringDirection
         *        Steering direction for the step.
         * @see RouteSteeringDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteSteeringDirection
         */
        Builder steeringDirection(String steeringDirection);

        /**
         * <p>
         * Steering direction for the step.
         * </p>
         * 
         * @param steeringDirection
         *        Steering direction for the step.
         * @see RouteSteeringDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteSteeringDirection
         */
        Builder steeringDirection(RouteSteeringDirection steeringDirection);

        /**
         * <p>
         * Angle of the turn.
         * </p>
         * 
         * @param turnAngle
         *        Angle of the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnAngle(Double turnAngle);

        /**
         * <p>
         * Intensity of the turn.
         * </p>
         * 
         * @param turnIntensity
         *        Intensity of the turn.
         * @see RouteTurnIntensity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTurnIntensity
         */
        Builder turnIntensity(String turnIntensity);

        /**
         * <p>
         * Intensity of the turn.
         * </p>
         * 
         * @param turnIntensity
         *        Intensity of the turn.
         * @see RouteTurnIntensity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTurnIntensity
         */
        Builder turnIntensity(RouteTurnIntensity turnIntensity);
    }

    static final class BuilderImpl implements Builder {
        private List<LocalizedString> intersection = DefaultSdkAutoConstructList.getInstance();

        private String steeringDirection;

        private Double turnAngle;

        private String turnIntensity;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteUTurnStepDetails model) {
            intersection(model.intersection);
            steeringDirection(model.steeringDirection);
            turnAngle(model.turnAngle);
            turnIntensity(model.turnIntensity);
        }

        public final List<LocalizedString.Builder> getIntersection() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.intersection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntersection(Collection<LocalizedString.BuilderImpl> intersection) {
            this.intersection = LocalizedStringListCopier.copyFromBuilder(intersection);
        }

        @Override
        public final Builder intersection(Collection<LocalizedString> intersection) {
            this.intersection = LocalizedStringListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(LocalizedString... intersection) {
            intersection(Arrays.asList(intersection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(Consumer<LocalizedString.Builder>... intersection) {
            intersection(Stream.of(intersection).map(c -> LocalizedString.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSteeringDirection() {
            return steeringDirection;
        }

        public final void setSteeringDirection(String steeringDirection) {
            this.steeringDirection = steeringDirection;
        }

        @Override
        public final Builder steeringDirection(String steeringDirection) {
            this.steeringDirection = steeringDirection;
            return this;
        }

        @Override
        public final Builder steeringDirection(RouteSteeringDirection steeringDirection) {
            this.steeringDirection(steeringDirection == null ? null : steeringDirection.toString());
            return this;
        }

        public final Double getTurnAngle() {
            return turnAngle;
        }

        public final void setTurnAngle(Double turnAngle) {
            this.turnAngle = turnAngle;
        }

        @Override
        public final Builder turnAngle(Double turnAngle) {
            this.turnAngle = turnAngle;
            return this;
        }

        public final String getTurnIntensity() {
            return turnIntensity;
        }

        public final void setTurnIntensity(String turnIntensity) {
            this.turnIntensity = turnIntensity;
        }

        @Override
        public final Builder turnIntensity(String turnIntensity) {
            this.turnIntensity = turnIntensity;
            return this;
        }

        @Override
        public final Builder turnIntensity(RouteTurnIntensity turnIntensity) {
            this.turnIntensity(turnIntensity == null ? null : turnIntensity.toString());
            return this;
        }

        @Override
        public RouteUTurnStepDetails build() {
            return new RouteUTurnStepDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
