/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Incidents corresponding to this leg of the route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteVehicleIncident implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteVehicleIncident.Builder, RouteVehicleIncident> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RouteVehicleIncident::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTime").getter(getter(RouteVehicleIncident::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(RouteVehicleIncident::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(RouteVehicleIncident::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RouteVehicleIncident::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            END_TIME_FIELD, SEVERITY_FIELD, START_TIME_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String endTime;

    private final String severity;

    private final String startTime;

    private final String type;

    private RouteVehicleIncident(BuilderImpl builder) {
        this.description = builder.description;
        this.endTime = builder.endTime;
        this.severity = builder.severity;
        this.startTime = builder.startTime;
        this.type = builder.type;
    }

    /**
     * <p>
     * Brief readable description of the incident.
     * </p>
     * 
     * @return Brief readable description of the incident.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * End timestamp of the incident.
     * </p>
     * 
     * @return End timestamp of the incident.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * Severity of the incident Critical - The part of the route the incident affects is unusable. Major- Major impact
     * on the leg duration, for example stop and go Minor- Minor impact on the leg duration, for example traffic jam Low
     * - Low on duration, for example slightly increased traffic
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link RouteVehicleIncidentSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #severityAsString}.
     * </p>
     * 
     * @return Severity of the incident Critical - The part of the route the incident affects is unusable. Major- Major
     *         impact on the leg duration, for example stop and go Minor- Minor impact on the leg duration, for example
     *         traffic jam Low - Low on duration, for example slightly increased traffic
     * @see RouteVehicleIncidentSeverity
     */
    public final RouteVehicleIncidentSeverity severity() {
        return RouteVehicleIncidentSeverity.fromValue(severity);
    }

    /**
     * <p>
     * Severity of the incident Critical - The part of the route the incident affects is unusable. Major- Major impact
     * on the leg duration, for example stop and go Minor- Minor impact on the leg duration, for example traffic jam Low
     * - Low on duration, for example slightly increased traffic
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link RouteVehicleIncidentSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #severityAsString}.
     * </p>
     * 
     * @return Severity of the incident Critical - The part of the route the incident affects is unusable. Major- Major
     *         impact on the leg duration, for example stop and go Minor- Minor impact on the leg duration, for example
     *         traffic jam Low - Low on duration, for example slightly increased traffic
     * @see RouteVehicleIncidentSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * Start time of the incident.
     * </p>
     * 
     * @return Start time of the incident.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * Type of the incident.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteVehicleIncidentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the incident.
     * @see RouteVehicleIncidentType
     */
    public final RouteVehicleIncidentType type() {
        return RouteVehicleIncidentType.fromValue(type);
    }

    /**
     * <p>
     * Type of the incident.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteVehicleIncidentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the incident.
     * @see RouteVehicleIncidentType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleIncident)) {
            return false;
        }
        RouteVehicleIncident other = (RouteVehicleIncident) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(severityAsString(), other.severityAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteVehicleIncident").add("Description", description()).add("EndTime", endTime())
                .add("Severity", severityAsString()).add("StartTime", startTime()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleIncident, T> g) {
        return obj -> g.apply((RouteVehicleIncident) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteVehicleIncident> {
        /**
         * <p>
         * Brief readable description of the incident.
         * </p>
         * 
         * @param description
         *        Brief readable description of the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * End timestamp of the incident.
         * </p>
         * 
         * @param endTime
         *        End timestamp of the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * Severity of the incident Critical - The part of the route the incident affects is unusable. Major- Major
         * impact on the leg duration, for example stop and go Minor- Minor impact on the leg duration, for example
         * traffic jam Low - Low on duration, for example slightly increased traffic
         * </p>
         * 
         * @param severity
         *        Severity of the incident Critical - The part of the route the incident affects is unusable. Major-
         *        Major impact on the leg duration, for example stop and go Minor- Minor impact on the leg duration, for
         *        example traffic jam Low - Low on duration, for example slightly increased traffic
         * @see RouteVehicleIncidentSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteVehicleIncidentSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * Severity of the incident Critical - The part of the route the incident affects is unusable. Major- Major
         * impact on the leg duration, for example stop and go Minor- Minor impact on the leg duration, for example
         * traffic jam Low - Low on duration, for example slightly increased traffic
         * </p>
         * 
         * @param severity
         *        Severity of the incident Critical - The part of the route the incident affects is unusable. Major-
         *        Major impact on the leg duration, for example stop and go Minor- Minor impact on the leg duration, for
         *        example traffic jam Low - Low on duration, for example slightly increased traffic
         * @see RouteVehicleIncidentSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteVehicleIncidentSeverity
         */
        Builder severity(RouteVehicleIncidentSeverity severity);

        /**
         * <p>
         * Start time of the incident.
         * </p>
         * 
         * @param startTime
         *        Start time of the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * Type of the incident.
         * </p>
         * 
         * @param type
         *        Type of the incident.
         * @see RouteVehicleIncidentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteVehicleIncidentType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the incident.
         * </p>
         * 
         * @param type
         *        Type of the incident.
         * @see RouteVehicleIncidentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteVehicleIncidentType
         */
        Builder type(RouteVehicleIncidentType type);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String endTime;

        private String severity;

        private String startTime;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleIncident model) {
            description(model.description);
            endTime(model.endTime);
            severity(model.severity);
            startTime(model.startTime);
            type(model.type);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(RouteVehicleIncidentSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteVehicleIncidentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RouteVehicleIncident build() {
            return new RouteVehicleIncident(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
