/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Steps of a leg that correspond to the travel portion of the leg.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteVehicleLegDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteVehicleLegDetails.Builder, RouteVehicleLegDetails> {
    private static final SdkField<RouteVehicleArrival> ARRIVAL_FIELD = SdkField
            .<RouteVehicleArrival> builder(MarshallingType.SDK_POJO).memberName("Arrival")
            .getter(getter(RouteVehicleLegDetails::arrival)).setter(setter(Builder::arrival))
            .constructor(RouteVehicleArrival::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arrival").build()).build();

    private static final SdkField<RouteVehicleDeparture> DEPARTURE_FIELD = SdkField
            .<RouteVehicleDeparture> builder(MarshallingType.SDK_POJO).memberName("Departure")
            .getter(getter(RouteVehicleLegDetails::departure)).setter(setter(Builder::departure))
            .constructor(RouteVehicleDeparture::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Departure").build()).build();

    private static final SdkField<List<RouteVehicleIncident>> INCIDENTS_FIELD = SdkField
            .<List<RouteVehicleIncident>> builder(MarshallingType.LIST)
            .memberName("Incidents")
            .getter(getter(RouteVehicleLegDetails::incidents))
            .setter(setter(Builder::incidents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Incidents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteVehicleIncident> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteVehicleIncident::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteVehicleNotice>> NOTICES_FIELD = SdkField
            .<List<RouteVehicleNotice>> builder(MarshallingType.LIST)
            .memberName("Notices")
            .getter(getter(RouteVehicleLegDetails::notices))
            .setter(setter(Builder::notices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteVehicleNotice> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteVehicleNotice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RoutePassThroughWaypoint>> PASS_THROUGH_WAYPOINTS_FIELD = SdkField
            .<List<RoutePassThroughWaypoint>> builder(MarshallingType.LIST)
            .memberName("PassThroughWaypoints")
            .getter(getter(RouteVehicleLegDetails::passThroughWaypoints))
            .setter(setter(Builder::passThroughWaypoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PassThroughWaypoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutePassThroughWaypoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutePassThroughWaypoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteVehicleSpan>> SPANS_FIELD = SdkField
            .<List<RouteVehicleSpan>> builder(MarshallingType.LIST)
            .memberName("Spans")
            .getter(getter(RouteVehicleLegDetails::spans))
            .setter(setter(Builder::spans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteVehicleSpan> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteVehicleSpan::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteVehicleSummary> SUMMARY_FIELD = SdkField
            .<RouteVehicleSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(RouteVehicleLegDetails::summary)).setter(setter(Builder::summary))
            .constructor(RouteVehicleSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final SdkField<List<RouteToll>> TOLLS_FIELD = SdkField
            .<List<RouteToll>> builder(MarshallingType.LIST)
            .memberName("Tolls")
            .getter(getter(RouteVehicleLegDetails::tolls))
            .setter(setter(Builder::tolls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tolls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteToll> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteToll::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteTollSystem>> TOLL_SYSTEMS_FIELD = SdkField
            .<List<RouteTollSystem>> builder(MarshallingType.LIST)
            .memberName("TollSystems")
            .getter(getter(RouteVehicleLegDetails::tollSystems))
            .setter(setter(Builder::tollSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteTollSystem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteTollSystem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteVehicleTravelStep>> TRAVEL_STEPS_FIELD = SdkField
            .<List<RouteVehicleTravelStep>> builder(MarshallingType.LIST)
            .memberName("TravelSteps")
            .getter(getter(RouteVehicleLegDetails::travelSteps))
            .setter(setter(Builder::travelSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteVehicleTravelStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteVehicleTravelStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TRUCK_ROAD_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TruckRoadTypes")
            .getter(getter(RouteVehicleLegDetails::truckRoadTypes))
            .setter(setter(Builder::truckRoadTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckRoadTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteZone>> ZONES_FIELD = SdkField
            .<List<RouteZone>> builder(MarshallingType.LIST)
            .memberName("Zones")
            .getter(getter(RouteVehicleLegDetails::zones))
            .setter(setter(Builder::zones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRIVAL_FIELD,
            DEPARTURE_FIELD, INCIDENTS_FIELD, NOTICES_FIELD, PASS_THROUGH_WAYPOINTS_FIELD, SPANS_FIELD, SUMMARY_FIELD,
            TOLLS_FIELD, TOLL_SYSTEMS_FIELD, TRAVEL_STEPS_FIELD, TRUCK_ROAD_TYPES_FIELD, ZONES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteVehicleArrival arrival;

    private final RouteVehicleDeparture departure;

    private final List<RouteVehicleIncident> incidents;

    private final List<RouteVehicleNotice> notices;

    private final List<RoutePassThroughWaypoint> passThroughWaypoints;

    private final List<RouteVehicleSpan> spans;

    private final RouteVehicleSummary summary;

    private final List<RouteToll> tolls;

    private final List<RouteTollSystem> tollSystems;

    private final List<RouteVehicleTravelStep> travelSteps;

    private final List<String> truckRoadTypes;

    private final List<RouteZone> zones;

    private RouteVehicleLegDetails(BuilderImpl builder) {
        this.arrival = builder.arrival;
        this.departure = builder.departure;
        this.incidents = builder.incidents;
        this.notices = builder.notices;
        this.passThroughWaypoints = builder.passThroughWaypoints;
        this.spans = builder.spans;
        this.summary = builder.summary;
        this.tolls = builder.tolls;
        this.tollSystems = builder.tollSystems;
        this.travelSteps = builder.travelSteps;
        this.truckRoadTypes = builder.truckRoadTypes;
        this.zones = builder.zones;
    }

    /**
     * <p>
     * Details corresponding to the arrival for the leg.
     * </p>
     * 
     * @return Details corresponding to the arrival for the leg.
     */
    public final RouteVehicleArrival arrival() {
        return arrival;
    }

    /**
     * <p>
     * Details corresponding to the departure for the leg.
     * </p>
     * 
     * @return Details corresponding to the departure for the leg.
     */
    public final RouteVehicleDeparture departure() {
        return departure;
    }

    /**
     * For responses, this returns true if the service returned a value for the Incidents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncidents() {
        return incidents != null && !(incidents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Incidents corresponding to this leg of the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncidents} method.
     * </p>
     * 
     * @return Incidents corresponding to this leg of the route.
     */
    public final List<RouteVehicleIncident> incidents() {
        return incidents;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotices() {
        return notices != null && !(notices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Notices are additional information returned that indicate issues that occurred during route calculation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotices} method.
     * </p>
     * 
     * @return Notices are additional information returned that indicate issues that occurred during route calculation.
     */
    public final List<RouteVehicleNotice> notices() {
        return notices;
    }

    /**
     * For responses, this returns true if the service returned a value for the PassThroughWaypoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPassThroughWaypoints() {
        return passThroughWaypoints != null && !(passThroughWaypoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
     * PassThrough option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPassThroughWaypoints} method.
     * </p>
     * 
     * @return Waypoints that were passed through during the leg. This includes the waypoints that were configured with
     *         the PassThrough option.
     */
    public final List<RoutePassThroughWaypoint> passThroughWaypoints() {
        return passThroughWaypoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the Spans property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSpans() {
        return spans != null && !(spans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Spans that were computed for the requested SpanAdditionalFeatures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpans} method.
     * </p>
     * 
     * @return Spans that were computed for the requested SpanAdditionalFeatures.
     */
    public final List<RouteVehicleSpan> spans() {
        return spans;
    }

    /**
     * <p>
     * Summarized details of the leg.
     * </p>
     * 
     * @return Summarized details of the leg.
     */
    public final RouteVehicleSummary summary() {
        return summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tolls property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTolls() {
        return tolls != null && !(tolls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Toll related options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTolls} method.
     * </p>
     * 
     * @return Toll related options.
     */
    public final List<RouteToll> tolls() {
        return tolls;
    }

    /**
     * For responses, this returns true if the service returned a value for the TollSystems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTollSystems() {
        return tollSystems != null && !(tollSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Toll systems are authorities that collect payments for the toll.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTollSystems} method.
     * </p>
     * 
     * @return Toll systems are authorities that collect payments for the toll.
     */
    public final List<RouteTollSystem> tollSystems() {
        return tollSystems;
    }

    /**
     * For responses, this returns true if the service returned a value for the TravelSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTravelSteps() {
        return travelSteps != null && !(travelSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Steps of a leg that must be performed before the travel portion of the leg.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTravelSteps} method.
     * </p>
     * 
     * @return Steps of a leg that must be performed before the travel portion of the leg.
     */
    public final List<RouteVehicleTravelStep> travelSteps() {
        return travelSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the TruckRoadTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTruckRoadTypes() {
        return truckRoadTypes != null && !(truckRoadTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
     * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
     * </p>
     * <note>
     * <p>
     * There are currently no other supported values as of 26th April 2024.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTruckRoadTypes} method.
     * </p>
     * 
     * @return Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
     *         <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
     *         <p>
     *         There are currently no other supported values as of 26th April 2024.
     *         </p>
     */
    public final List<String> truckRoadTypes() {
        return truckRoadTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Zones property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasZones() {
        return zones != null && !(zones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Zones corresponding to this leg of the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasZones} method.
     * </p>
     * 
     * @return Zones corresponding to this leg of the route.
     */
    public final List<RouteZone> zones() {
        return zones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arrival());
        hashCode = 31 * hashCode + Objects.hashCode(departure());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncidents() ? incidents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotices() ? notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPassThroughWaypoints() ? passThroughWaypoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSpans() ? spans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(hasTolls() ? tolls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTollSystems() ? tollSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTravelSteps() ? travelSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTruckRoadTypes() ? truckRoadTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasZones() ? zones() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleLegDetails)) {
            return false;
        }
        RouteVehicleLegDetails other = (RouteVehicleLegDetails) obj;
        return Objects.equals(arrival(), other.arrival()) && Objects.equals(departure(), other.departure())
                && hasIncidents() == other.hasIncidents() && Objects.equals(incidents(), other.incidents())
                && hasNotices() == other.hasNotices() && Objects.equals(notices(), other.notices())
                && hasPassThroughWaypoints() == other.hasPassThroughWaypoints()
                && Objects.equals(passThroughWaypoints(), other.passThroughWaypoints()) && hasSpans() == other.hasSpans()
                && Objects.equals(spans(), other.spans()) && Objects.equals(summary(), other.summary())
                && hasTolls() == other.hasTolls() && Objects.equals(tolls(), other.tolls())
                && hasTollSystems() == other.hasTollSystems() && Objects.equals(tollSystems(), other.tollSystems())
                && hasTravelSteps() == other.hasTravelSteps() && Objects.equals(travelSteps(), other.travelSteps())
                && hasTruckRoadTypes() == other.hasTruckRoadTypes() && Objects.equals(truckRoadTypes(), other.truckRoadTypes())
                && hasZones() == other.hasZones() && Objects.equals(zones(), other.zones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteVehicleLegDetails").add("Arrival", arrival()).add("Departure", departure())
                .add("Incidents", hasIncidents() ? incidents() : null).add("Notices", hasNotices() ? notices() : null)
                .add("PassThroughWaypoints", hasPassThroughWaypoints() ? passThroughWaypoints() : null)
                .add("Spans", hasSpans() ? spans() : null).add("Summary", summary()).add("Tolls", hasTolls() ? tolls() : null)
                .add("TollSystems", hasTollSystems() ? tollSystems() : null)
                .add("TravelSteps", hasTravelSteps() ? travelSteps() : null)
                .add("TruckRoadTypes", hasTruckRoadTypes() ? truckRoadTypes() : null).add("Zones", hasZones() ? zones() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arrival":
            return Optional.ofNullable(clazz.cast(arrival()));
        case "Departure":
            return Optional.ofNullable(clazz.cast(departure()));
        case "Incidents":
            return Optional.ofNullable(clazz.cast(incidents()));
        case "Notices":
            return Optional.ofNullable(clazz.cast(notices()));
        case "PassThroughWaypoints":
            return Optional.ofNullable(clazz.cast(passThroughWaypoints()));
        case "Spans":
            return Optional.ofNullable(clazz.cast(spans()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "Tolls":
            return Optional.ofNullable(clazz.cast(tolls()));
        case "TollSystems":
            return Optional.ofNullable(clazz.cast(tollSystems()));
        case "TravelSteps":
            return Optional.ofNullable(clazz.cast(travelSteps()));
        case "TruckRoadTypes":
            return Optional.ofNullable(clazz.cast(truckRoadTypes()));
        case "Zones":
            return Optional.ofNullable(clazz.cast(zones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arrival", ARRIVAL_FIELD);
        map.put("Departure", DEPARTURE_FIELD);
        map.put("Incidents", INCIDENTS_FIELD);
        map.put("Notices", NOTICES_FIELD);
        map.put("PassThroughWaypoints", PASS_THROUGH_WAYPOINTS_FIELD);
        map.put("Spans", SPANS_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        map.put("Tolls", TOLLS_FIELD);
        map.put("TollSystems", TOLL_SYSTEMS_FIELD);
        map.put("TravelSteps", TRAVEL_STEPS_FIELD);
        map.put("TruckRoadTypes", TRUCK_ROAD_TYPES_FIELD);
        map.put("Zones", ZONES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleLegDetails, T> g) {
        return obj -> g.apply((RouteVehicleLegDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteVehicleLegDetails> {
        /**
         * <p>
         * Details corresponding to the arrival for the leg.
         * </p>
         * 
         * @param arrival
         *        Details corresponding to the arrival for the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrival(RouteVehicleArrival arrival);

        /**
         * <p>
         * Details corresponding to the arrival for the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteVehicleArrival.Builder} avoiding the
         * need to create one manually via {@link RouteVehicleArrival#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteVehicleArrival.Builder#build()} is called immediately and
         * its result is passed to {@link #arrival(RouteVehicleArrival)}.
         * 
         * @param arrival
         *        a consumer that will call methods on {@link RouteVehicleArrival.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrival(RouteVehicleArrival)
         */
        default Builder arrival(Consumer<RouteVehicleArrival.Builder> arrival) {
            return arrival(RouteVehicleArrival.builder().applyMutation(arrival).build());
        }

        /**
         * <p>
         * Details corresponding to the departure for the leg.
         * </p>
         * 
         * @param departure
         *        Details corresponding to the departure for the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder departure(RouteVehicleDeparture departure);

        /**
         * <p>
         * Details corresponding to the departure for the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteVehicleDeparture.Builder} avoiding
         * the need to create one manually via {@link RouteVehicleDeparture#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteVehicleDeparture.Builder#build()} is called immediately and
         * its result is passed to {@link #departure(RouteVehicleDeparture)}.
         * 
         * @param departure
         *        a consumer that will call methods on {@link RouteVehicleDeparture.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #departure(RouteVehicleDeparture)
         */
        default Builder departure(Consumer<RouteVehicleDeparture.Builder> departure) {
            return departure(RouteVehicleDeparture.builder().applyMutation(departure).build());
        }

        /**
         * <p>
         * Incidents corresponding to this leg of the route.
         * </p>
         * 
         * @param incidents
         *        Incidents corresponding to this leg of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidents(Collection<RouteVehicleIncident> incidents);

        /**
         * <p>
         * Incidents corresponding to this leg of the route.
         * </p>
         * 
         * @param incidents
         *        Incidents corresponding to this leg of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidents(RouteVehicleIncident... incidents);

        /**
         * <p>
         * Incidents corresponding to this leg of the route.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleIncident.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleIncident#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleIncident.Builder#build()} is called
         * immediately and its result is passed to {@link #incidents(List<RouteVehicleIncident>)}.
         * 
         * @param incidents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleIncident.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incidents(java.util.Collection<RouteVehicleIncident>)
         */
        Builder incidents(Consumer<RouteVehicleIncident.Builder>... incidents);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(Collection<RouteVehicleNotice> notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(RouteVehicleNotice... notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleNotice.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleNotice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleNotice.Builder#build()} is called
         * immediately and its result is passed to {@link #notices(List<RouteVehicleNotice>)}.
         * 
         * @param notices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleNotice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notices(java.util.Collection<RouteVehicleNotice>)
         */
        Builder notices(Consumer<RouteVehicleNotice.Builder>... notices);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * 
         * @param passThroughWaypoints
         *        Waypoints that were passed through during the leg. This includes the waypoints that were configured
         *        with the PassThrough option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passThroughWaypoints(Collection<RoutePassThroughWaypoint> passThroughWaypoints);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * 
         * @param passThroughWaypoints
         *        Waypoints that were passed through during the leg. This includes the waypoints that were configured
         *        with the PassThrough option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passThroughWaypoints(RoutePassThroughWaypoint... passThroughWaypoints);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder#build()} is called
         * immediately and its result is passed to {@link #passThroughWaypoints(List<RoutePassThroughWaypoint>)}.
         * 
         * @param passThroughWaypoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passThroughWaypoints(java.util.Collection<RoutePassThroughWaypoint>)
         */
        Builder passThroughWaypoints(Consumer<RoutePassThroughWaypoint.Builder>... passThroughWaypoints);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * 
         * @param spans
         *        Spans that were computed for the requested SpanAdditionalFeatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spans(Collection<RouteVehicleSpan> spans);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * 
         * @param spans
         *        Spans that were computed for the requested SpanAdditionalFeatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spans(RouteVehicleSpan... spans);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleSpan.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleSpan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleSpan.Builder#build()} is called
         * immediately and its result is passed to {@link #spans(List<RouteVehicleSpan>)}.
         * 
         * @param spans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleSpan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spans(java.util.Collection<RouteVehicleSpan>)
         */
        Builder spans(Consumer<RouteVehicleSpan.Builder>... spans);

        /**
         * <p>
         * Summarized details of the leg.
         * </p>
         * 
         * @param summary
         *        Summarized details of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(RouteVehicleSummary summary);

        /**
         * <p>
         * Summarized details of the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteVehicleSummary.Builder} avoiding the
         * need to create one manually via {@link RouteVehicleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteVehicleSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #summary(RouteVehicleSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link RouteVehicleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(RouteVehicleSummary)
         */
        default Builder summary(Consumer<RouteVehicleSummary.Builder> summary) {
            return summary(RouteVehicleSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * Toll related options.
         * </p>
         * 
         * @param tolls
         *        Toll related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tolls(Collection<RouteToll> tolls);

        /**
         * <p>
         * Toll related options.
         * </p>
         * 
         * @param tolls
         *        Toll related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tolls(RouteToll... tolls);

        /**
         * <p>
         * Toll related options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteToll.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.RouteToll#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteToll.Builder#build()} is called immediately and
         * its result is passed to {@link #tolls(List<RouteToll>)}.
         * 
         * @param tolls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteToll.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tolls(java.util.Collection<RouteToll>)
         */
        Builder tolls(Consumer<RouteToll.Builder>... tolls);

        /**
         * <p>
         * Toll systems are authorities that collect payments for the toll.
         * </p>
         * 
         * @param tollSystems
         *        Toll systems are authorities that collect payments for the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollSystems(Collection<RouteTollSystem> tollSystems);

        /**
         * <p>
         * Toll systems are authorities that collect payments for the toll.
         * </p>
         * 
         * @param tollSystems
         *        Toll systems are authorities that collect payments for the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollSystems(RouteTollSystem... tollSystems);

        /**
         * <p>
         * Toll systems are authorities that collect payments for the toll.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTollSystem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteTollSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTollSystem.Builder#build()} is called immediately
         * and its result is passed to {@link #tollSystems(List<RouteTollSystem>)}.
         * 
         * @param tollSystems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteTollSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tollSystems(java.util.Collection<RouteTollSystem>)
         */
        Builder tollSystems(Consumer<RouteTollSystem.Builder>... tollSystems);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * 
         * @param travelSteps
         *        Steps of a leg that must be performed before the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelSteps(Collection<RouteVehicleTravelStep> travelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * 
         * @param travelSteps
         *        Steps of a leg that must be performed before the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelSteps(RouteVehicleTravelStep... travelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleTravelStep.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleTravelStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleTravelStep.Builder#build()} is called
         * immediately and its result is passed to {@link #travelSteps(List<RouteVehicleTravelStep>)}.
         * 
         * @param travelSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteVehicleTravelStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #travelSteps(java.util.Collection<RouteVehicleTravelStep>)
         */
        Builder travelSteps(Consumer<RouteVehicleTravelStep.Builder>... travelSteps);

        /**
         * <p>
         * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
         * </p>
         * <note>
         * <p>
         * There are currently no other supported values as of 26th April 2024.
         * </p>
         * </note>
         * 
         * @param truckRoadTypes
         *        Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         *        <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
         *        <p>
         *        There are currently no other supported values as of 26th April 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckRoadTypes(Collection<String> truckRoadTypes);

        /**
         * <p>
         * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
         * </p>
         * <note>
         * <p>
         * There are currently no other supported values as of 26th April 2024.
         * </p>
         * </note>
         * 
         * @param truckRoadTypes
         *        Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         *        <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
         *        <p>
         *        There are currently no other supported values as of 26th April 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckRoadTypes(String... truckRoadTypes);

        /**
         * <p>
         * Zones corresponding to this leg of the route.
         * </p>
         * 
         * @param zones
         *        Zones corresponding to this leg of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zones(Collection<RouteZone> zones);

        /**
         * <p>
         * Zones corresponding to this leg of the route.
         * </p>
         * 
         * @param zones
         *        Zones corresponding to this leg of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zones(RouteZone... zones);

        /**
         * <p>
         * Zones corresponding to this leg of the route.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteZone.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.RouteZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteZone.Builder#build()} is called immediately and
         * its result is passed to {@link #zones(List<RouteZone>)}.
         * 
         * @param zones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zones(java.util.Collection<RouteZone>)
         */
        Builder zones(Consumer<RouteZone.Builder>... zones);
    }

    static final class BuilderImpl implements Builder {
        private RouteVehicleArrival arrival;

        private RouteVehicleDeparture departure;

        private List<RouteVehicleIncident> incidents = DefaultSdkAutoConstructList.getInstance();

        private List<RouteVehicleNotice> notices = DefaultSdkAutoConstructList.getInstance();

        private List<RoutePassThroughWaypoint> passThroughWaypoints = DefaultSdkAutoConstructList.getInstance();

        private List<RouteVehicleSpan> spans = DefaultSdkAutoConstructList.getInstance();

        private RouteVehicleSummary summary;

        private List<RouteToll> tolls = DefaultSdkAutoConstructList.getInstance();

        private List<RouteTollSystem> tollSystems = DefaultSdkAutoConstructList.getInstance();

        private List<RouteVehicleTravelStep> travelSteps = DefaultSdkAutoConstructList.getInstance();

        private List<String> truckRoadTypes = DefaultSdkAutoConstructList.getInstance();

        private List<RouteZone> zones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleLegDetails model) {
            arrival(model.arrival);
            departure(model.departure);
            incidents(model.incidents);
            notices(model.notices);
            passThroughWaypoints(model.passThroughWaypoints);
            spans(model.spans);
            summary(model.summary);
            tolls(model.tolls);
            tollSystems(model.tollSystems);
            travelSteps(model.travelSteps);
            truckRoadTypes(model.truckRoadTypes);
            zones(model.zones);
        }

        public final RouteVehicleArrival.Builder getArrival() {
            return arrival != null ? arrival.toBuilder() : null;
        }

        public final void setArrival(RouteVehicleArrival.BuilderImpl arrival) {
            this.arrival = arrival != null ? arrival.build() : null;
        }

        @Override
        public final Builder arrival(RouteVehicleArrival arrival) {
            this.arrival = arrival;
            return this;
        }

        public final RouteVehicleDeparture.Builder getDeparture() {
            return departure != null ? departure.toBuilder() : null;
        }

        public final void setDeparture(RouteVehicleDeparture.BuilderImpl departure) {
            this.departure = departure != null ? departure.build() : null;
        }

        @Override
        public final Builder departure(RouteVehicleDeparture departure) {
            this.departure = departure;
            return this;
        }

        public final List<RouteVehicleIncident.Builder> getIncidents() {
            List<RouteVehicleIncident.Builder> result = RouteVehicleIncidentListCopier.copyToBuilder(this.incidents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidents(Collection<RouteVehicleIncident.BuilderImpl> incidents) {
            this.incidents = RouteVehicleIncidentListCopier.copyFromBuilder(incidents);
        }

        @Override
        public final Builder incidents(Collection<RouteVehicleIncident> incidents) {
            this.incidents = RouteVehicleIncidentListCopier.copy(incidents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidents(RouteVehicleIncident... incidents) {
            incidents(Arrays.asList(incidents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidents(Consumer<RouteVehicleIncident.Builder>... incidents) {
            incidents(Stream.of(incidents).map(c -> RouteVehicleIncident.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RouteVehicleNotice.Builder> getNotices() {
            List<RouteVehicleNotice.Builder> result = RouteVehicleNoticeListCopier.copyToBuilder(this.notices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotices(Collection<RouteVehicleNotice.BuilderImpl> notices) {
            this.notices = RouteVehicleNoticeListCopier.copyFromBuilder(notices);
        }

        @Override
        public final Builder notices(Collection<RouteVehicleNotice> notices) {
            this.notices = RouteVehicleNoticeListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(RouteVehicleNotice... notices) {
            notices(Arrays.asList(notices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Consumer<RouteVehicleNotice.Builder>... notices) {
            notices(Stream.of(notices).map(c -> RouteVehicleNotice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RoutePassThroughWaypoint.Builder> getPassThroughWaypoints() {
            List<RoutePassThroughWaypoint.Builder> result = RoutePassThroughWaypointListCopier
                    .copyToBuilder(this.passThroughWaypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPassThroughWaypoints(Collection<RoutePassThroughWaypoint.BuilderImpl> passThroughWaypoints) {
            this.passThroughWaypoints = RoutePassThroughWaypointListCopier.copyFromBuilder(passThroughWaypoints);
        }

        @Override
        public final Builder passThroughWaypoints(Collection<RoutePassThroughWaypoint> passThroughWaypoints) {
            this.passThroughWaypoints = RoutePassThroughWaypointListCopier.copy(passThroughWaypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passThroughWaypoints(RoutePassThroughWaypoint... passThroughWaypoints) {
            passThroughWaypoints(Arrays.asList(passThroughWaypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passThroughWaypoints(Consumer<RoutePassThroughWaypoint.Builder>... passThroughWaypoints) {
            passThroughWaypoints(Stream.of(passThroughWaypoints)
                    .map(c -> RoutePassThroughWaypoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteVehicleSpan.Builder> getSpans() {
            List<RouteVehicleSpan.Builder> result = RouteVehicleSpanListCopier.copyToBuilder(this.spans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpans(Collection<RouteVehicleSpan.BuilderImpl> spans) {
            this.spans = RouteVehicleSpanListCopier.copyFromBuilder(spans);
        }

        @Override
        public final Builder spans(Collection<RouteVehicleSpan> spans) {
            this.spans = RouteVehicleSpanListCopier.copy(spans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(RouteVehicleSpan... spans) {
            spans(Arrays.asList(spans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(Consumer<RouteVehicleSpan.Builder>... spans) {
            spans(Stream.of(spans).map(c -> RouteVehicleSpan.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouteVehicleSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(RouteVehicleSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(RouteVehicleSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<RouteToll.Builder> getTolls() {
            List<RouteToll.Builder> result = RouteTollListCopier.copyToBuilder(this.tolls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTolls(Collection<RouteToll.BuilderImpl> tolls) {
            this.tolls = RouteTollListCopier.copyFromBuilder(tolls);
        }

        @Override
        public final Builder tolls(Collection<RouteToll> tolls) {
            this.tolls = RouteTollListCopier.copy(tolls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tolls(RouteToll... tolls) {
            tolls(Arrays.asList(tolls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tolls(Consumer<RouteToll.Builder>... tolls) {
            tolls(Stream.of(tolls).map(c -> RouteToll.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteTollSystem.Builder> getTollSystems() {
            List<RouteTollSystem.Builder> result = RouteTollSystemListCopier.copyToBuilder(this.tollSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTollSystems(Collection<RouteTollSystem.BuilderImpl> tollSystems) {
            this.tollSystems = RouteTollSystemListCopier.copyFromBuilder(tollSystems);
        }

        @Override
        public final Builder tollSystems(Collection<RouteTollSystem> tollSystems) {
            this.tollSystems = RouteTollSystemListCopier.copy(tollSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tollSystems(RouteTollSystem... tollSystems) {
            tollSystems(Arrays.asList(tollSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tollSystems(Consumer<RouteTollSystem.Builder>... tollSystems) {
            tollSystems(Stream.of(tollSystems).map(c -> RouteTollSystem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RouteVehicleTravelStep.Builder> getTravelSteps() {
            List<RouteVehicleTravelStep.Builder> result = RouteVehicleTravelStepListCopier.copyToBuilder(this.travelSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTravelSteps(Collection<RouteVehicleTravelStep.BuilderImpl> travelSteps) {
            this.travelSteps = RouteVehicleTravelStepListCopier.copyFromBuilder(travelSteps);
        }

        @Override
        public final Builder travelSteps(Collection<RouteVehicleTravelStep> travelSteps) {
            this.travelSteps = RouteVehicleTravelStepListCopier.copy(travelSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelSteps(RouteVehicleTravelStep... travelSteps) {
            travelSteps(Arrays.asList(travelSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelSteps(Consumer<RouteVehicleTravelStep.Builder>... travelSteps) {
            travelSteps(Stream.of(travelSteps).map(c -> RouteVehicleTravelStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTruckRoadTypes() {
            if (truckRoadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return truckRoadTypes;
        }

        public final void setTruckRoadTypes(Collection<String> truckRoadTypes) {
            this.truckRoadTypes = TruckRoadTypeListCopier.copy(truckRoadTypes);
        }

        @Override
        public final Builder truckRoadTypes(Collection<String> truckRoadTypes) {
            this.truckRoadTypes = TruckRoadTypeListCopier.copy(truckRoadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckRoadTypes(String... truckRoadTypes) {
            truckRoadTypes(Arrays.asList(truckRoadTypes));
            return this;
        }

        public final List<RouteZone.Builder> getZones() {
            List<RouteZone.Builder> result = RouteZoneListCopier.copyToBuilder(this.zones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setZones(Collection<RouteZone.BuilderImpl> zones) {
            this.zones = RouteZoneListCopier.copyFromBuilder(zones);
        }

        @Override
        public final Builder zones(Collection<RouteZone> zones) {
            this.zones = RouteZoneListCopier.copy(zones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zones(RouteZone... zones) {
            zones(Arrays.asList(zones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zones(Consumer<RouteZone.Builder>... zones) {
            zones(Stream.of(zones).map(c -> RouteZone.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RouteVehicleLegDetails build() {
            return new RouteVehicleLegDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
