/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional details of the notice.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteVehicleNoticeDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteVehicleNoticeDetail.Builder, RouteVehicleNoticeDetail> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(RouteVehicleNoticeDetail::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<RouteViolatedConstraints> VIOLATED_CONSTRAINTS_FIELD = SdkField
            .<RouteViolatedConstraints> builder(MarshallingType.SDK_POJO).memberName("ViolatedConstraints")
            .getter(getter(RouteVehicleNoticeDetail::violatedConstraints)).setter(setter(Builder::violatedConstraints))
            .constructor(RouteViolatedConstraints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatedConstraints").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            VIOLATED_CONSTRAINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final RouteViolatedConstraints violatedConstraints;

    private RouteVehicleNoticeDetail(BuilderImpl builder) {
        this.title = builder.title;
        this.violatedConstraints = builder.violatedConstraints;
    }

    /**
     * <p>
     * The notice title.
     * </p>
     * 
     * @return The notice title.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Any violated constraints.
     * </p>
     * 
     * @return Any violated constraints.
     */
    public final RouteViolatedConstraints violatedConstraints() {
        return violatedConstraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(violatedConstraints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleNoticeDetail)) {
            return false;
        }
        RouteVehicleNoticeDetail other = (RouteVehicleNoticeDetail) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(violatedConstraints(), other.violatedConstraints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteVehicleNoticeDetail").add("Title", title())
                .add("ViolatedConstraints", violatedConstraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "ViolatedConstraints":
            return Optional.ofNullable(clazz.cast(violatedConstraints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("ViolatedConstraints", VIOLATED_CONSTRAINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleNoticeDetail, T> g) {
        return obj -> g.apply((RouteVehicleNoticeDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteVehicleNoticeDetail> {
        /**
         * <p>
         * The notice title.
         * </p>
         * 
         * @param title
         *        The notice title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Any violated constraints.
         * </p>
         * 
         * @param violatedConstraints
         *        Any violated constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatedConstraints(RouteViolatedConstraints violatedConstraints);

        /**
         * <p>
         * Any violated constraints.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteViolatedConstraints.Builder}
         * avoiding the need to create one manually via {@link RouteViolatedConstraints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteViolatedConstraints.Builder#build()} is called immediately
         * and its result is passed to {@link #violatedConstraints(RouteViolatedConstraints)}.
         * 
         * @param violatedConstraints
         *        a consumer that will call methods on {@link RouteViolatedConstraints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violatedConstraints(RouteViolatedConstraints)
         */
        default Builder violatedConstraints(Consumer<RouteViolatedConstraints.Builder> violatedConstraints) {
            return violatedConstraints(RouteViolatedConstraints.builder().applyMutation(violatedConstraints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private RouteViolatedConstraints violatedConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleNoticeDetail model) {
            title(model.title);
            violatedConstraints(model.violatedConstraints);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final RouteViolatedConstraints.Builder getViolatedConstraints() {
            return violatedConstraints != null ? violatedConstraints.toBuilder() : null;
        }

        public final void setViolatedConstraints(RouteViolatedConstraints.BuilderImpl violatedConstraints) {
            this.violatedConstraints = violatedConstraints != null ? violatedConstraints.build() : null;
        }

        @Override
        public final Builder violatedConstraints(RouteViolatedConstraints violatedConstraints) {
            this.violatedConstraints = violatedConstraints;
            return this;
        }

        @Override
        public RouteVehicleNoticeDetail build() {
            return new RouteVehicleNoticeDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
