/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Span computed for the requested SpanAdditionalFeatures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteVehicleSpan implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteVehicleSpan.Builder, RouteVehicleSpan> {
    private static final SdkField<Long> BEST_CASE_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BestCaseDuration").getter(getter(RouteVehicleSpan::bestCaseDuration))
            .setter(setter(Builder::bestCaseDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCaseDuration").build()).build();

    private static final SdkField<List<String>> CAR_ACCESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CarAccess")
            .getter(getter(RouteVehicleSpan::carAccessAsStrings))
            .setter(setter(Builder::carAccessWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarAccess").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(RouteVehicleSpan::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<Long> DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Distance")
            .getter(getter(RouteVehicleSpan::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(RouteVehicleSpan::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<RouteSpanDynamicSpeedDetails> DYNAMIC_SPEED_FIELD = SdkField
            .<RouteSpanDynamicSpeedDetails> builder(MarshallingType.SDK_POJO).memberName("DynamicSpeed")
            .getter(getter(RouteVehicleSpan::dynamicSpeed)).setter(setter(Builder::dynamicSpeed))
            .constructor(RouteSpanDynamicSpeedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicSpeed").build()).build();

    private static final SdkField<Integer> FUNCTIONAL_CLASSIFICATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FunctionalClassification").getter(getter(RouteVehicleSpan::functionalClassification))
            .setter(setter(Builder::functionalClassification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionalClassification").build())
            .build();

    private static final SdkField<String> GATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Gate")
            .getter(getter(RouteVehicleSpan::gateAsString)).setter(setter(Builder::gate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gate").build()).build();

    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GeometryOffset").getter(getter(RouteVehicleSpan::geometryOffset))
            .setter(setter(Builder::geometryOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()).build();

    private static final SdkField<List<Integer>> INCIDENTS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Incidents")
            .getter(getter(RouteVehicleSpan::incidents))
            .setter(setter(Builder::incidents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Incidents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LocalizedString>> NAMES_FIELD = SdkField
            .<List<LocalizedString>> builder(MarshallingType.LIST)
            .memberName("Names")
            .getter(getter(RouteVehicleSpan::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalizedString> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalizedString::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> NOTICES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Notices")
            .getter(getter(RouteVehicleSpan::notices))
            .setter(setter(Builder::notices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RAILWAY_CROSSING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RailwayCrossing").getter(getter(RouteVehicleSpan::railwayCrossingAsString))
            .setter(setter(Builder::railwayCrossing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RailwayCrossing").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(RouteVehicleSpan::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<List<String>> ROAD_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RoadAttributes")
            .getter(getter(RouteVehicleSpan::roadAttributesAsStrings))
            .setter(setter(Builder::roadAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoadAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteNumber>> ROUTE_NUMBERS_FIELD = SdkField
            .<List<RouteNumber>> builder(MarshallingType.LIST)
            .memberName("RouteNumbers")
            .getter(getter(RouteVehicleSpan::routeNumbers))
            .setter(setter(Builder::routeNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteNumber> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteNumber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SCOOTER_ACCESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScooterAccess")
            .getter(getter(RouteVehicleSpan::scooterAccessAsStrings))
            .setter(setter(Builder::scooterAccessWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScooterAccess").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteSpanSpeedLimitDetails> SPEED_LIMIT_FIELD = SdkField
            .<RouteSpanSpeedLimitDetails> builder(MarshallingType.SDK_POJO).memberName("SpeedLimit")
            .getter(getter(RouteVehicleSpan::speedLimit)).setter(setter(Builder::speedLimit))
            .constructor(RouteSpanSpeedLimitDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeedLimit").build()).build();

    private static final SdkField<List<Integer>> TOLL_SYSTEMS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("TollSystems")
            .getter(getter(RouteVehicleSpan::tollSystems))
            .setter(setter(Builder::tollSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TRUCK_ACCESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TruckAccess")
            .getter(getter(RouteVehicleSpan::truckAccessAsStrings))
            .setter(setter(Builder::truckAccessWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckAccess").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> TRUCK_ROAD_TYPES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("TruckRoadTypes")
            .getter(getter(RouteVehicleSpan::truckRoadTypes))
            .setter(setter(Builder::truckRoadTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckRoadTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TYPICAL_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TypicalDuration").getter(getter(RouteVehicleSpan::typicalDuration))
            .setter(setter(Builder::typicalDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypicalDuration").build()).build();

    private static final SdkField<List<Integer>> ZONES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Zones")
            .getter(getter(RouteVehicleSpan::zones))
            .setter(setter(Builder::zones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEST_CASE_DURATION_FIELD,
            CAR_ACCESS_FIELD, COUNTRY_FIELD, DISTANCE_FIELD, DURATION_FIELD, DYNAMIC_SPEED_FIELD,
            FUNCTIONAL_CLASSIFICATION_FIELD, GATE_FIELD, GEOMETRY_OFFSET_FIELD, INCIDENTS_FIELD, NAMES_FIELD, NOTICES_FIELD,
            RAILWAY_CROSSING_FIELD, REGION_FIELD, ROAD_ATTRIBUTES_FIELD, ROUTE_NUMBERS_FIELD, SCOOTER_ACCESS_FIELD,
            SPEED_LIMIT_FIELD, TOLL_SYSTEMS_FIELD, TRUCK_ACCESS_FIELD, TRUCK_ROAD_TYPES_FIELD, TYPICAL_DURATION_FIELD,
            ZONES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long bestCaseDuration;

    private final List<String> carAccess;

    private final String country;

    private final Long distance;

    private final Long duration;

    private final RouteSpanDynamicSpeedDetails dynamicSpeed;

    private final Integer functionalClassification;

    private final String gate;

    private final Integer geometryOffset;

    private final List<Integer> incidents;

    private final List<LocalizedString> names;

    private final List<Integer> notices;

    private final String railwayCrossing;

    private final String region;

    private final List<String> roadAttributes;

    private final List<RouteNumber> routeNumbers;

    private final List<String> scooterAccess;

    private final RouteSpanSpeedLimitDetails speedLimit;

    private final List<Integer> tollSystems;

    private final List<String> truckAccess;

    private final List<Integer> truckRoadTypes;

    private final Long typicalDuration;

    private final List<Integer> zones;

    private RouteVehicleSpan(BuilderImpl builder) {
        this.bestCaseDuration = builder.bestCaseDuration;
        this.carAccess = builder.carAccess;
        this.country = builder.country;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.dynamicSpeed = builder.dynamicSpeed;
        this.functionalClassification = builder.functionalClassification;
        this.gate = builder.gate;
        this.geometryOffset = builder.geometryOffset;
        this.incidents = builder.incidents;
        this.names = builder.names;
        this.notices = builder.notices;
        this.railwayCrossing = builder.railwayCrossing;
        this.region = builder.region;
        this.roadAttributes = builder.roadAttributes;
        this.routeNumbers = builder.routeNumbers;
        this.scooterAccess = builder.scooterAccess;
        this.speedLimit = builder.speedLimit;
        this.tollSystems = builder.tollSystems;
        this.truckAccess = builder.truckAccess;
        this.truckRoadTypes = builder.truckRoadTypes;
        this.typicalDuration = builder.typicalDuration;
        this.zones = builder.zones;
    }

    /**
     * <p>
     * Duration of the computed span without traffic congestion.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the computed span without traffic congestion.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long bestCaseDuration() {
        return bestCaseDuration;
    }

    /**
     * <p>
     * Access attributes for a car corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCarAccess} method.
     * </p>
     * 
     * @return Access attributes for a car corresponding to the span.
     */
    public final List<RouteSpanCarAccessAttribute> carAccess() {
        return RouteSpanCarAccessAttributeListCopier.copyStringToEnum(carAccess);
    }

    /**
     * For responses, this returns true if the service returned a value for the CarAccess property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCarAccess() {
        return carAccess != null && !(carAccess instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Access attributes for a car corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCarAccess} method.
     * </p>
     * 
     * @return Access attributes for a car corresponding to the span.
     */
    public final List<String> carAccessAsStrings() {
        return carAccess;
    }

    /**
     * <p>
     * 3 letter Country code corresponding to the Span.
     * </p>
     * 
     * @return 3 letter Country code corresponding to the Span.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * Distance of the computed span. This feature doesn't split a span, but is always computed on a span split by other
     * properties.
     * </p>
     * 
     * @return Distance of the computed span. This feature doesn't split a span, but is always computed on a span split
     *         by other properties.
     */
    public final Long distance() {
        return distance;
    }

    /**
     * <p>
     * Duration of the computed span. This feature doesn't split a span, but is always computed on a span split by other
     * properties.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the computed span. This feature doesn't split a span, but is always computed on a span split
     *         by other properties.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * Dynamic speed details corresponding to the span.
     * </p>
     * <p>
     * <b>Unit</b>: <code>KilometersPerHour</code>
     * </p>
     * 
     * @return Dynamic speed details corresponding to the span.</p>
     *         <p>
     *         <b>Unit</b>: <code>KilometersPerHour</code>
     */
    public final RouteSpanDynamicSpeedDetails dynamicSpeed() {
        return dynamicSpeed;
    }

    /**
     * <p>
     * Functional classification of the road segment corresponding to the span.
     * </p>
     * 
     * @return Functional classification of the road segment corresponding to the span.
     */
    public final Integer functionalClassification() {
        return functionalClassification;
    }

    /**
     * <p>
     * Attributes corresponding to a gate. The gate is present at the end of the returned span.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gate} will return
     * {@link RouteSpanGateAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gateAsString}.
     * </p>
     * 
     * @return Attributes corresponding to a gate. The gate is present at the end of the returned span.
     * @see RouteSpanGateAttribute
     */
    public final RouteSpanGateAttribute gate() {
        return RouteSpanGateAttribute.fromValue(gate);
    }

    /**
     * <p>
     * Attributes corresponding to a gate. The gate is present at the end of the returned span.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gate} will return
     * {@link RouteSpanGateAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gateAsString}.
     * </p>
     * 
     * @return Attributes corresponding to a gate. The gate is present at the end of the returned span.
     * @see RouteSpanGateAttribute
     */
    public final String gateAsString() {
        return gate;
    }

    /**
     * <p>
     * Offset in the leg geometry corresponding to the start of this span.
     * </p>
     * 
     * @return Offset in the leg geometry corresponding to the start of this span.
     */
    public final Integer geometryOffset() {
        return geometryOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Incidents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncidents() {
        return incidents != null && !(incidents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Incidents corresponding to the span. These index into the Incidents in the parent Leg.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncidents} method.
     * </p>
     * 
     * @return Incidents corresponding to the span. These index into the Incidents in the parent Leg.
     */
    public final List<Integer> incidents() {
        return incidents;
    }

    /**
     * For responses, this returns true if the service returned a value for the Names property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides an array of names of the vehicle span in available languages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNames} method.
     * </p>
     * 
     * @return Provides an array of names of the vehicle span in available languages.
     */
    public final List<LocalizedString> names() {
        return names;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotices() {
        return notices != null && !(notices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Notices are additional information returned that indicate issues that occurred during route calculation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotices} method.
     * </p>
     * 
     * @return Notices are additional information returned that indicate issues that occurred during route calculation.
     */
    public final List<Integer> notices() {
        return notices;
    }

    /**
     * <p>
     * Attributes corresponding to a railway crossing. The gate is present at the end of the returned span.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #railwayCrossing}
     * will return {@link RouteSpanRailwayCrossingAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #railwayCrossingAsString}.
     * </p>
     * 
     * @return Attributes corresponding to a railway crossing. The gate is present at the end of the returned span.
     * @see RouteSpanRailwayCrossingAttribute
     */
    public final RouteSpanRailwayCrossingAttribute railwayCrossing() {
        return RouteSpanRailwayCrossingAttribute.fromValue(railwayCrossing);
    }

    /**
     * <p>
     * Attributes corresponding to a railway crossing. The gate is present at the end of the returned span.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #railwayCrossing}
     * will return {@link RouteSpanRailwayCrossingAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #railwayCrossingAsString}.
     * </p>
     * 
     * @return Attributes corresponding to a railway crossing. The gate is present at the end of the returned span.
     * @see RouteSpanRailwayCrossingAttribute
     */
    public final String railwayCrossingAsString() {
        return railwayCrossing;
    }

    /**
     * <p>
     * 2-3 letter Region code corresponding to the Span. This is either a province or a state.
     * </p>
     * 
     * @return 2-3 letter Region code corresponding to the Span. This is either a province or a state.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Attributes for the road segment corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoadAttributes} method.
     * </p>
     * 
     * @return Attributes for the road segment corresponding to the span.
     */
    public final List<RouteSpanRoadAttribute> roadAttributes() {
        return RouteSpanRoadAttributeListCopier.copyStringToEnum(roadAttributes);
    }

    /**
     * For responses, this returns true if the service returned a value for the RoadAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoadAttributes() {
        return roadAttributes != null && !(roadAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes for the road segment corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoadAttributes} method.
     * </p>
     * 
     * @return Attributes for the road segment corresponding to the span.
     */
    public final List<String> roadAttributesAsStrings() {
        return roadAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteNumbers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteNumbers() {
        return routeNumbers != null && !(routeNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Designated route name or number corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteNumbers} method.
     * </p>
     * 
     * @return Designated route name or number corresponding to the span.
     */
    public final List<RouteNumber> routeNumbers() {
        return routeNumbers;
    }

    /**
     * <p>
     * Access attributes for a scooter corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScooterAccess} method.
     * </p>
     * 
     * @return Access attributes for a scooter corresponding to the span.
     */
    public final List<RouteSpanScooterAccessAttribute> scooterAccess() {
        return RouteSpanScooterAccessAttributeListCopier.copyStringToEnum(scooterAccess);
    }

    /**
     * For responses, this returns true if the service returned a value for the ScooterAccess property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScooterAccess() {
        return scooterAccess != null && !(scooterAccess instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Access attributes for a scooter corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScooterAccess} method.
     * </p>
     * 
     * @return Access attributes for a scooter corresponding to the span.
     */
    public final List<String> scooterAccessAsStrings() {
        return scooterAccess;
    }

    /**
     * <p>
     * Speed limit details corresponding to the span.
     * </p>
     * <p>
     * <b>Unit</b>: <code>KilometersPerHour</code>
     * </p>
     * 
     * @return Speed limit details corresponding to the span.</p>
     *         <p>
     *         <b>Unit</b>: <code>KilometersPerHour</code>
     */
    public final RouteSpanSpeedLimitDetails speedLimit() {
        return speedLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the TollSystems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTollSystems() {
        return tollSystems != null && !(tollSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Toll systems are authorities that collect payments for the toll.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTollSystems} method.
     * </p>
     * 
     * @return Toll systems are authorities that collect payments for the toll.
     */
    public final List<Integer> tollSystems() {
        return tollSystems;
    }

    /**
     * <p>
     * Access attributes for a truck corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTruckAccess} method.
     * </p>
     * 
     * @return Access attributes for a truck corresponding to the span.
     */
    public final List<RouteSpanTruckAccessAttribute> truckAccess() {
        return RouteSpanTruckAccessAttributeListCopier.copyStringToEnum(truckAccess);
    }

    /**
     * For responses, this returns true if the service returned a value for the TruckAccess property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTruckAccess() {
        return truckAccess != null && !(truckAccess instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Access attributes for a truck corresponding to the span.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTruckAccess} method.
     * </p>
     * 
     * @return Access attributes for a truck corresponding to the span.
     */
    public final List<String> truckAccessAsStrings() {
        return truckAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the TruckRoadTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTruckRoadTypes() {
        return truckRoadTypes != null && !(truckRoadTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
     * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
     * </p>
     * <note>
     * <p>
     * There are currently no other supported values as of 26th April 2024.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTruckRoadTypes} method.
     * </p>
     * 
     * @return Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
     *         <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
     *         <p>
     *         There are currently no other supported values as of 26th April 2024.
     *         </p>
     */
    public final List<Integer> truckRoadTypes() {
        return truckRoadTypes;
    }

    /**
     * <p>
     * Duration of the computed span under typical traffic congestion.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the computed span under typical traffic congestion. </p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long typicalDuration() {
        return typicalDuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Zones property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasZones() {
        return zones != null && !(zones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Zones corresponding to this leg of the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasZones} method.
     * </p>
     * 
     * @return Zones corresponding to this leg of the route.
     */
    public final List<Integer> zones() {
        return zones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bestCaseDuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCarAccess() ? carAccessAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(functionalClassification());
        hashCode = 31 * hashCode + Objects.hashCode(gateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncidents() ? incidents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNames() ? names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotices() ? notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(railwayCrossingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoadAttributes() ? roadAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteNumbers() ? routeNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScooterAccess() ? scooterAccessAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(speedLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasTollSystems() ? tollSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTruckAccess() ? truckAccessAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTruckRoadTypes() ? truckRoadTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typicalDuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasZones() ? zones() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleSpan)) {
            return false;
        }
        RouteVehicleSpan other = (RouteVehicleSpan) obj;
        return Objects.equals(bestCaseDuration(), other.bestCaseDuration()) && hasCarAccess() == other.hasCarAccess()
                && Objects.equals(carAccessAsStrings(), other.carAccessAsStrings()) && Objects.equals(country(), other.country())
                && Objects.equals(distance(), other.distance()) && Objects.equals(duration(), other.duration())
                && Objects.equals(dynamicSpeed(), other.dynamicSpeed())
                && Objects.equals(functionalClassification(), other.functionalClassification())
                && Objects.equals(gateAsString(), other.gateAsString())
                && Objects.equals(geometryOffset(), other.geometryOffset()) && hasIncidents() == other.hasIncidents()
                && Objects.equals(incidents(), other.incidents()) && hasNames() == other.hasNames()
                && Objects.equals(names(), other.names()) && hasNotices() == other.hasNotices()
                && Objects.equals(notices(), other.notices())
                && Objects.equals(railwayCrossingAsString(), other.railwayCrossingAsString())
                && Objects.equals(region(), other.region()) && hasRoadAttributes() == other.hasRoadAttributes()
                && Objects.equals(roadAttributesAsStrings(), other.roadAttributesAsStrings())
                && hasRouteNumbers() == other.hasRouteNumbers() && Objects.equals(routeNumbers(), other.routeNumbers())
                && hasScooterAccess() == other.hasScooterAccess()
                && Objects.equals(scooterAccessAsStrings(), other.scooterAccessAsStrings())
                && Objects.equals(speedLimit(), other.speedLimit()) && hasTollSystems() == other.hasTollSystems()
                && Objects.equals(tollSystems(), other.tollSystems()) && hasTruckAccess() == other.hasTruckAccess()
                && Objects.equals(truckAccessAsStrings(), other.truckAccessAsStrings())
                && hasTruckRoadTypes() == other.hasTruckRoadTypes() && Objects.equals(truckRoadTypes(), other.truckRoadTypes())
                && Objects.equals(typicalDuration(), other.typicalDuration()) && hasZones() == other.hasZones()
                && Objects.equals(zones(), other.zones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteVehicleSpan").add("BestCaseDuration", bestCaseDuration())
                .add("CarAccess", hasCarAccess() ? carAccessAsStrings() : null).add("Country", country())
                .add("Distance", distance()).add("Duration", duration()).add("DynamicSpeed", dynamicSpeed())
                .add("FunctionalClassification", functionalClassification()).add("Gate", gateAsString())
                .add("GeometryOffset", geometryOffset()).add("Incidents", hasIncidents() ? incidents() : null)
                .add("Names", hasNames() ? names() : null).add("Notices", hasNotices() ? notices() : null)
                .add("RailwayCrossing", railwayCrossingAsString()).add("Region", region())
                .add("RoadAttributes", hasRoadAttributes() ? roadAttributesAsStrings() : null)
                .add("RouteNumbers", hasRouteNumbers() ? routeNumbers() : null)
                .add("ScooterAccess", hasScooterAccess() ? scooterAccessAsStrings() : null).add("SpeedLimit", speedLimit())
                .add("TollSystems", hasTollSystems() ? tollSystems() : null)
                .add("TruckAccess", hasTruckAccess() ? truckAccessAsStrings() : null)
                .add("TruckRoadTypes", hasTruckRoadTypes() ? truckRoadTypes() : null).add("TypicalDuration", typicalDuration())
                .add("Zones", hasZones() ? zones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BestCaseDuration":
            return Optional.ofNullable(clazz.cast(bestCaseDuration()));
        case "CarAccess":
            return Optional.ofNullable(clazz.cast(carAccessAsStrings()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "DynamicSpeed":
            return Optional.ofNullable(clazz.cast(dynamicSpeed()));
        case "FunctionalClassification":
            return Optional.ofNullable(clazz.cast(functionalClassification()));
        case "Gate":
            return Optional.ofNullable(clazz.cast(gateAsString()));
        case "GeometryOffset":
            return Optional.ofNullable(clazz.cast(geometryOffset()));
        case "Incidents":
            return Optional.ofNullable(clazz.cast(incidents()));
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "Notices":
            return Optional.ofNullable(clazz.cast(notices()));
        case "RailwayCrossing":
            return Optional.ofNullable(clazz.cast(railwayCrossingAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "RoadAttributes":
            return Optional.ofNullable(clazz.cast(roadAttributesAsStrings()));
        case "RouteNumbers":
            return Optional.ofNullable(clazz.cast(routeNumbers()));
        case "ScooterAccess":
            return Optional.ofNullable(clazz.cast(scooterAccessAsStrings()));
        case "SpeedLimit":
            return Optional.ofNullable(clazz.cast(speedLimit()));
        case "TollSystems":
            return Optional.ofNullable(clazz.cast(tollSystems()));
        case "TruckAccess":
            return Optional.ofNullable(clazz.cast(truckAccessAsStrings()));
        case "TruckRoadTypes":
            return Optional.ofNullable(clazz.cast(truckRoadTypes()));
        case "TypicalDuration":
            return Optional.ofNullable(clazz.cast(typicalDuration()));
        case "Zones":
            return Optional.ofNullable(clazz.cast(zones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BestCaseDuration", BEST_CASE_DURATION_FIELD);
        map.put("CarAccess", CAR_ACCESS_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("DynamicSpeed", DYNAMIC_SPEED_FIELD);
        map.put("FunctionalClassification", FUNCTIONAL_CLASSIFICATION_FIELD);
        map.put("Gate", GATE_FIELD);
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Incidents", INCIDENTS_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("Notices", NOTICES_FIELD);
        map.put("RailwayCrossing", RAILWAY_CROSSING_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("RoadAttributes", ROAD_ATTRIBUTES_FIELD);
        map.put("RouteNumbers", ROUTE_NUMBERS_FIELD);
        map.put("ScooterAccess", SCOOTER_ACCESS_FIELD);
        map.put("SpeedLimit", SPEED_LIMIT_FIELD);
        map.put("TollSystems", TOLL_SYSTEMS_FIELD);
        map.put("TruckAccess", TRUCK_ACCESS_FIELD);
        map.put("TruckRoadTypes", TRUCK_ROAD_TYPES_FIELD);
        map.put("TypicalDuration", TYPICAL_DURATION_FIELD);
        map.put("Zones", ZONES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleSpan, T> g) {
        return obj -> g.apply((RouteVehicleSpan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteVehicleSpan> {
        /**
         * <p>
         * Duration of the computed span without traffic congestion.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param bestCaseDuration
         *        Duration of the computed span without traffic congestion.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestCaseDuration(Long bestCaseDuration);

        /**
         * <p>
         * Access attributes for a car corresponding to the span.
         * </p>
         * 
         * @param carAccess
         *        Access attributes for a car corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carAccessWithStrings(Collection<String> carAccess);

        /**
         * <p>
         * Access attributes for a car corresponding to the span.
         * </p>
         * 
         * @param carAccess
         *        Access attributes for a car corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carAccessWithStrings(String... carAccess);

        /**
         * <p>
         * Access attributes for a car corresponding to the span.
         * </p>
         * 
         * @param carAccess
         *        Access attributes for a car corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carAccess(Collection<RouteSpanCarAccessAttribute> carAccess);

        /**
         * <p>
         * Access attributes for a car corresponding to the span.
         * </p>
         * 
         * @param carAccess
         *        Access attributes for a car corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carAccess(RouteSpanCarAccessAttribute... carAccess);

        /**
         * <p>
         * 3 letter Country code corresponding to the Span.
         * </p>
         * 
         * @param country
         *        3 letter Country code corresponding to the Span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * Distance of the computed span. This feature doesn't split a span, but is always computed on a span split by
         * other properties.
         * </p>
         * 
         * @param distance
         *        Distance of the computed span. This feature doesn't split a span, but is always computed on a span
         *        split by other properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Long distance);

        /**
         * <p>
         * Duration of the computed span. This feature doesn't split a span, but is always computed on a span split by
         * other properties.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param duration
         *        Duration of the computed span. This feature doesn't split a span, but is always computed on a span
         *        split by other properties.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * Dynamic speed details corresponding to the span.
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * 
         * @param dynamicSpeed
         *        Dynamic speed details corresponding to the span.</p>
         *        <p>
         *        <b>Unit</b>: <code>KilometersPerHour</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicSpeed(RouteSpanDynamicSpeedDetails dynamicSpeed);

        /**
         * <p>
         * Dynamic speed details corresponding to the span.
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteSpanDynamicSpeedDetails.Builder}
         * avoiding the need to create one manually via {@link RouteSpanDynamicSpeedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteSpanDynamicSpeedDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #dynamicSpeed(RouteSpanDynamicSpeedDetails)}.
         * 
         * @param dynamicSpeed
         *        a consumer that will call methods on {@link RouteSpanDynamicSpeedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamicSpeed(RouteSpanDynamicSpeedDetails)
         */
        default Builder dynamicSpeed(Consumer<RouteSpanDynamicSpeedDetails.Builder> dynamicSpeed) {
            return dynamicSpeed(RouteSpanDynamicSpeedDetails.builder().applyMutation(dynamicSpeed).build());
        }

        /**
         * <p>
         * Functional classification of the road segment corresponding to the span.
         * </p>
         * 
         * @param functionalClassification
         *        Functional classification of the road segment corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionalClassification(Integer functionalClassification);

        /**
         * <p>
         * Attributes corresponding to a gate. The gate is present at the end of the returned span.
         * </p>
         * 
         * @param gate
         *        Attributes corresponding to a gate. The gate is present at the end of the returned span.
         * @see RouteSpanGateAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteSpanGateAttribute
         */
        Builder gate(String gate);

        /**
         * <p>
         * Attributes corresponding to a gate. The gate is present at the end of the returned span.
         * </p>
         * 
         * @param gate
         *        Attributes corresponding to a gate. The gate is present at the end of the returned span.
         * @see RouteSpanGateAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteSpanGateAttribute
         */
        Builder gate(RouteSpanGateAttribute gate);

        /**
         * <p>
         * Offset in the leg geometry corresponding to the start of this span.
         * </p>
         * 
         * @param geometryOffset
         *        Offset in the leg geometry corresponding to the start of this span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometryOffset(Integer geometryOffset);

        /**
         * <p>
         * Incidents corresponding to the span. These index into the Incidents in the parent Leg.
         * </p>
         * 
         * @param incidents
         *        Incidents corresponding to the span. These index into the Incidents in the parent Leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidents(Collection<Integer> incidents);

        /**
         * <p>
         * Incidents corresponding to the span. These index into the Incidents in the parent Leg.
         * </p>
         * 
         * @param incidents
         *        Incidents corresponding to the span. These index into the Incidents in the parent Leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidents(Integer... incidents);

        /**
         * <p>
         * Provides an array of names of the vehicle span in available languages.
         * </p>
         * 
         * @param names
         *        Provides an array of names of the vehicle span in available languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<LocalizedString> names);

        /**
         * <p>
         * Provides an array of names of the vehicle span in available languages.
         * </p>
         * 
         * @param names
         *        Provides an array of names of the vehicle span in available languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(LocalizedString... names);

        /**
         * <p>
         * Provides an array of names of the vehicle span in available languages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.LocalizedString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder#build()} is called immediately
         * and its result is passed to {@link #names(List<LocalizedString>)}.
         * 
         * @param names
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #names(java.util.Collection<LocalizedString>)
         */
        Builder names(Consumer<LocalizedString.Builder>... names);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(Collection<Integer> notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(Integer... notices);

        /**
         * <p>
         * Attributes corresponding to a railway crossing. The gate is present at the end of the returned span.
         * </p>
         * 
         * @param railwayCrossing
         *        Attributes corresponding to a railway crossing. The gate is present at the end of the returned span.
         * @see RouteSpanRailwayCrossingAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteSpanRailwayCrossingAttribute
         */
        Builder railwayCrossing(String railwayCrossing);

        /**
         * <p>
         * Attributes corresponding to a railway crossing. The gate is present at the end of the returned span.
         * </p>
         * 
         * @param railwayCrossing
         *        Attributes corresponding to a railway crossing. The gate is present at the end of the returned span.
         * @see RouteSpanRailwayCrossingAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteSpanRailwayCrossingAttribute
         */
        Builder railwayCrossing(RouteSpanRailwayCrossingAttribute railwayCrossing);

        /**
         * <p>
         * 2-3 letter Region code corresponding to the Span. This is either a province or a state.
         * </p>
         * 
         * @param region
         *        2-3 letter Region code corresponding to the Span. This is either a province or a state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Attributes for the road segment corresponding to the span.
         * </p>
         * 
         * @param roadAttributes
         *        Attributes for the road segment corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roadAttributesWithStrings(Collection<String> roadAttributes);

        /**
         * <p>
         * Attributes for the road segment corresponding to the span.
         * </p>
         * 
         * @param roadAttributes
         *        Attributes for the road segment corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roadAttributesWithStrings(String... roadAttributes);

        /**
         * <p>
         * Attributes for the road segment corresponding to the span.
         * </p>
         * 
         * @param roadAttributes
         *        Attributes for the road segment corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roadAttributes(Collection<RouteSpanRoadAttribute> roadAttributes);

        /**
         * <p>
         * Attributes for the road segment corresponding to the span.
         * </p>
         * 
         * @param roadAttributes
         *        Attributes for the road segment corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roadAttributes(RouteSpanRoadAttribute... roadAttributes);

        /**
         * <p>
         * Designated route name or number corresponding to the span.
         * </p>
         * 
         * @param routeNumbers
         *        Designated route name or number corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeNumbers(Collection<RouteNumber> routeNumbers);

        /**
         * <p>
         * Designated route name or number corresponding to the span.
         * </p>
         * 
         * @param routeNumbers
         *        Designated route name or number corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeNumbers(RouteNumber... routeNumbers);

        /**
         * <p>
         * Designated route name or number corresponding to the span.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteNumber.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.RouteNumber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteNumber.Builder#build()} is called immediately and
         * its result is passed to {@link #routeNumbers(List<RouteNumber>)}.
         * 
         * @param routeNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeNumbers(java.util.Collection<RouteNumber>)
         */
        Builder routeNumbers(Consumer<RouteNumber.Builder>... routeNumbers);

        /**
         * <p>
         * Access attributes for a scooter corresponding to the span.
         * </p>
         * 
         * @param scooterAccess
         *        Access attributes for a scooter corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scooterAccessWithStrings(Collection<String> scooterAccess);

        /**
         * <p>
         * Access attributes for a scooter corresponding to the span.
         * </p>
         * 
         * @param scooterAccess
         *        Access attributes for a scooter corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scooterAccessWithStrings(String... scooterAccess);

        /**
         * <p>
         * Access attributes for a scooter corresponding to the span.
         * </p>
         * 
         * @param scooterAccess
         *        Access attributes for a scooter corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scooterAccess(Collection<RouteSpanScooterAccessAttribute> scooterAccess);

        /**
         * <p>
         * Access attributes for a scooter corresponding to the span.
         * </p>
         * 
         * @param scooterAccess
         *        Access attributes for a scooter corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scooterAccess(RouteSpanScooterAccessAttribute... scooterAccess);

        /**
         * <p>
         * Speed limit details corresponding to the span.
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * 
         * @param speedLimit
         *        Speed limit details corresponding to the span.</p>
         *        <p>
         *        <b>Unit</b>: <code>KilometersPerHour</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speedLimit(RouteSpanSpeedLimitDetails speedLimit);

        /**
         * <p>
         * Speed limit details corresponding to the span.
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteSpanSpeedLimitDetails.Builder}
         * avoiding the need to create one manually via {@link RouteSpanSpeedLimitDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteSpanSpeedLimitDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #speedLimit(RouteSpanSpeedLimitDetails)}.
         * 
         * @param speedLimit
         *        a consumer that will call methods on {@link RouteSpanSpeedLimitDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #speedLimit(RouteSpanSpeedLimitDetails)
         */
        default Builder speedLimit(Consumer<RouteSpanSpeedLimitDetails.Builder> speedLimit) {
            return speedLimit(RouteSpanSpeedLimitDetails.builder().applyMutation(speedLimit).build());
        }

        /**
         * <p>
         * Toll systems are authorities that collect payments for the toll.
         * </p>
         * 
         * @param tollSystems
         *        Toll systems are authorities that collect payments for the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollSystems(Collection<Integer> tollSystems);

        /**
         * <p>
         * Toll systems are authorities that collect payments for the toll.
         * </p>
         * 
         * @param tollSystems
         *        Toll systems are authorities that collect payments for the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollSystems(Integer... tollSystems);

        /**
         * <p>
         * Access attributes for a truck corresponding to the span.
         * </p>
         * 
         * @param truckAccess
         *        Access attributes for a truck corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckAccessWithStrings(Collection<String> truckAccess);

        /**
         * <p>
         * Access attributes for a truck corresponding to the span.
         * </p>
         * 
         * @param truckAccess
         *        Access attributes for a truck corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckAccessWithStrings(String... truckAccess);

        /**
         * <p>
         * Access attributes for a truck corresponding to the span.
         * </p>
         * 
         * @param truckAccess
         *        Access attributes for a truck corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckAccess(Collection<RouteSpanTruckAccessAttribute> truckAccess);

        /**
         * <p>
         * Access attributes for a truck corresponding to the span.
         * </p>
         * 
         * @param truckAccess
         *        Access attributes for a truck corresponding to the span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckAccess(RouteSpanTruckAccessAttribute... truckAccess);

        /**
         * <p>
         * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
         * </p>
         * <note>
         * <p>
         * There are currently no other supported values as of 26th April 2024.
         * </p>
         * </note>
         * 
         * @param truckRoadTypes
         *        Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         *        <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
         *        <p>
         *        There are currently no other supported values as of 26th April 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckRoadTypes(Collection<Integer> truckRoadTypes);

        /**
         * <p>
         * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
         * </p>
         * <note>
         * <p>
         * There are currently no other supported values as of 26th April 2024.
         * </p>
         * </note>
         * 
         * @param truckRoadTypes
         *        Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         *        <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
         *        <p>
         *        There are currently no other supported values as of 26th April 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckRoadTypes(Integer... truckRoadTypes);

        /**
         * <p>
         * Duration of the computed span under typical traffic congestion.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param typicalDuration
         *        Duration of the computed span under typical traffic congestion. </p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typicalDuration(Long typicalDuration);

        /**
         * <p>
         * Zones corresponding to this leg of the route.
         * </p>
         * 
         * @param zones
         *        Zones corresponding to this leg of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zones(Collection<Integer> zones);

        /**
         * <p>
         * Zones corresponding to this leg of the route.
         * </p>
         * 
         * @param zones
         *        Zones corresponding to this leg of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zones(Integer... zones);
    }

    static final class BuilderImpl implements Builder {
        private Long bestCaseDuration;

        private List<String> carAccess = DefaultSdkAutoConstructList.getInstance();

        private String country;

        private Long distance;

        private Long duration;

        private RouteSpanDynamicSpeedDetails dynamicSpeed;

        private Integer functionalClassification;

        private String gate;

        private Integer geometryOffset;

        private List<Integer> incidents = DefaultSdkAutoConstructList.getInstance();

        private List<LocalizedString> names = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> notices = DefaultSdkAutoConstructList.getInstance();

        private String railwayCrossing;

        private String region;

        private List<String> roadAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<RouteNumber> routeNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<String> scooterAccess = DefaultSdkAutoConstructList.getInstance();

        private RouteSpanSpeedLimitDetails speedLimit;

        private List<Integer> tollSystems = DefaultSdkAutoConstructList.getInstance();

        private List<String> truckAccess = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> truckRoadTypes = DefaultSdkAutoConstructList.getInstance();

        private Long typicalDuration;

        private List<Integer> zones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleSpan model) {
            bestCaseDuration(model.bestCaseDuration);
            carAccessWithStrings(model.carAccess);
            country(model.country);
            distance(model.distance);
            duration(model.duration);
            dynamicSpeed(model.dynamicSpeed);
            functionalClassification(model.functionalClassification);
            gate(model.gate);
            geometryOffset(model.geometryOffset);
            incidents(model.incidents);
            names(model.names);
            notices(model.notices);
            railwayCrossing(model.railwayCrossing);
            region(model.region);
            roadAttributesWithStrings(model.roadAttributes);
            routeNumbers(model.routeNumbers);
            scooterAccessWithStrings(model.scooterAccess);
            speedLimit(model.speedLimit);
            tollSystems(model.tollSystems);
            truckAccessWithStrings(model.truckAccess);
            truckRoadTypes(model.truckRoadTypes);
            typicalDuration(model.typicalDuration);
            zones(model.zones);
        }

        public final Long getBestCaseDuration() {
            return bestCaseDuration;
        }

        public final void setBestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
        }

        @Override
        public final Builder bestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
            return this;
        }

        public final Collection<String> getCarAccess() {
            if (carAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return carAccess;
        }

        public final void setCarAccess(Collection<String> carAccess) {
            this.carAccess = RouteSpanCarAccessAttributeListCopier.copy(carAccess);
        }

        @Override
        public final Builder carAccessWithStrings(Collection<String> carAccess) {
            this.carAccess = RouteSpanCarAccessAttributeListCopier.copy(carAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder carAccessWithStrings(String... carAccess) {
            carAccessWithStrings(Arrays.asList(carAccess));
            return this;
        }

        @Override
        public final Builder carAccess(Collection<RouteSpanCarAccessAttribute> carAccess) {
            this.carAccess = RouteSpanCarAccessAttributeListCopier.copyEnumToString(carAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder carAccess(RouteSpanCarAccessAttribute... carAccess) {
            carAccess(Arrays.asList(carAccess));
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final Long getDistance() {
            return distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final RouteSpanDynamicSpeedDetails.Builder getDynamicSpeed() {
            return dynamicSpeed != null ? dynamicSpeed.toBuilder() : null;
        }

        public final void setDynamicSpeed(RouteSpanDynamicSpeedDetails.BuilderImpl dynamicSpeed) {
            this.dynamicSpeed = dynamicSpeed != null ? dynamicSpeed.build() : null;
        }

        @Override
        public final Builder dynamicSpeed(RouteSpanDynamicSpeedDetails dynamicSpeed) {
            this.dynamicSpeed = dynamicSpeed;
            return this;
        }

        public final Integer getFunctionalClassification() {
            return functionalClassification;
        }

        public final void setFunctionalClassification(Integer functionalClassification) {
            this.functionalClassification = functionalClassification;
        }

        @Override
        public final Builder functionalClassification(Integer functionalClassification) {
            this.functionalClassification = functionalClassification;
            return this;
        }

        public final String getGate() {
            return gate;
        }

        public final void setGate(String gate) {
            this.gate = gate;
        }

        @Override
        public final Builder gate(String gate) {
            this.gate = gate;
            return this;
        }

        @Override
        public final Builder gate(RouteSpanGateAttribute gate) {
            this.gate(gate == null ? null : gate.toString());
            return this;
        }

        public final Integer getGeometryOffset() {
            return geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final Collection<Integer> getIncidents() {
            if (incidents instanceof SdkAutoConstructList) {
                return null;
            }
            return incidents;
        }

        public final void setIncidents(Collection<Integer> incidents) {
            this.incidents = IndexListCopier.copy(incidents);
        }

        @Override
        public final Builder incidents(Collection<Integer> incidents) {
            this.incidents = IndexListCopier.copy(incidents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidents(Integer... incidents) {
            incidents(Arrays.asList(incidents));
            return this;
        }

        public final List<LocalizedString.Builder> getNames() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.names);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNames(Collection<LocalizedString.BuilderImpl> names) {
            this.names = LocalizedStringListCopier.copyFromBuilder(names);
        }

        @Override
        public final Builder names(Collection<LocalizedString> names) {
            this.names = LocalizedStringListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(LocalizedString... names) {
            names(Arrays.asList(names));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(Consumer<LocalizedString.Builder>... names) {
            names(Stream.of(names).map(c -> LocalizedString.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Integer> getNotices() {
            if (notices instanceof SdkAutoConstructList) {
                return null;
            }
            return notices;
        }

        public final void setNotices(Collection<Integer> notices) {
            this.notices = IndexListCopier.copy(notices);
        }

        @Override
        public final Builder notices(Collection<Integer> notices) {
            this.notices = IndexListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Integer... notices) {
            notices(Arrays.asList(notices));
            return this;
        }

        public final String getRailwayCrossing() {
            return railwayCrossing;
        }

        public final void setRailwayCrossing(String railwayCrossing) {
            this.railwayCrossing = railwayCrossing;
        }

        @Override
        public final Builder railwayCrossing(String railwayCrossing) {
            this.railwayCrossing = railwayCrossing;
            return this;
        }

        @Override
        public final Builder railwayCrossing(RouteSpanRailwayCrossingAttribute railwayCrossing) {
            this.railwayCrossing(railwayCrossing == null ? null : railwayCrossing.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getRoadAttributes() {
            if (roadAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return roadAttributes;
        }

        public final void setRoadAttributes(Collection<String> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copy(roadAttributes);
        }

        @Override
        public final Builder roadAttributesWithStrings(Collection<String> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copy(roadAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadAttributesWithStrings(String... roadAttributes) {
            roadAttributesWithStrings(Arrays.asList(roadAttributes));
            return this;
        }

        @Override
        public final Builder roadAttributes(Collection<RouteSpanRoadAttribute> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copyEnumToString(roadAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadAttributes(RouteSpanRoadAttribute... roadAttributes) {
            roadAttributes(Arrays.asList(roadAttributes));
            return this;
        }

        public final List<RouteNumber.Builder> getRouteNumbers() {
            List<RouteNumber.Builder> result = RouteNumberListCopier.copyToBuilder(this.routeNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteNumbers(Collection<RouteNumber.BuilderImpl> routeNumbers) {
            this.routeNumbers = RouteNumberListCopier.copyFromBuilder(routeNumbers);
        }

        @Override
        public final Builder routeNumbers(Collection<RouteNumber> routeNumbers) {
            this.routeNumbers = RouteNumberListCopier.copy(routeNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumbers(RouteNumber... routeNumbers) {
            routeNumbers(Arrays.asList(routeNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumbers(Consumer<RouteNumber.Builder>... routeNumbers) {
            routeNumbers(Stream.of(routeNumbers).map(c -> RouteNumber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getScooterAccess() {
            if (scooterAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return scooterAccess;
        }

        public final void setScooterAccess(Collection<String> scooterAccess) {
            this.scooterAccess = RouteSpanScooterAccessAttributeListCopier.copy(scooterAccess);
        }

        @Override
        public final Builder scooterAccessWithStrings(Collection<String> scooterAccess) {
            this.scooterAccess = RouteSpanScooterAccessAttributeListCopier.copy(scooterAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scooterAccessWithStrings(String... scooterAccess) {
            scooterAccessWithStrings(Arrays.asList(scooterAccess));
            return this;
        }

        @Override
        public final Builder scooterAccess(Collection<RouteSpanScooterAccessAttribute> scooterAccess) {
            this.scooterAccess = RouteSpanScooterAccessAttributeListCopier.copyEnumToString(scooterAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scooterAccess(RouteSpanScooterAccessAttribute... scooterAccess) {
            scooterAccess(Arrays.asList(scooterAccess));
            return this;
        }

        public final RouteSpanSpeedLimitDetails.Builder getSpeedLimit() {
            return speedLimit != null ? speedLimit.toBuilder() : null;
        }

        public final void setSpeedLimit(RouteSpanSpeedLimitDetails.BuilderImpl speedLimit) {
            this.speedLimit = speedLimit != null ? speedLimit.build() : null;
        }

        @Override
        public final Builder speedLimit(RouteSpanSpeedLimitDetails speedLimit) {
            this.speedLimit = speedLimit;
            return this;
        }

        public final Collection<Integer> getTollSystems() {
            if (tollSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return tollSystems;
        }

        public final void setTollSystems(Collection<Integer> tollSystems) {
            this.tollSystems = IndexListCopier.copy(tollSystems);
        }

        @Override
        public final Builder tollSystems(Collection<Integer> tollSystems) {
            this.tollSystems = IndexListCopier.copy(tollSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tollSystems(Integer... tollSystems) {
            tollSystems(Arrays.asList(tollSystems));
            return this;
        }

        public final Collection<String> getTruckAccess() {
            if (truckAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return truckAccess;
        }

        public final void setTruckAccess(Collection<String> truckAccess) {
            this.truckAccess = RouteSpanTruckAccessAttributeListCopier.copy(truckAccess);
        }

        @Override
        public final Builder truckAccessWithStrings(Collection<String> truckAccess) {
            this.truckAccess = RouteSpanTruckAccessAttributeListCopier.copy(truckAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckAccessWithStrings(String... truckAccess) {
            truckAccessWithStrings(Arrays.asList(truckAccess));
            return this;
        }

        @Override
        public final Builder truckAccess(Collection<RouteSpanTruckAccessAttribute> truckAccess) {
            this.truckAccess = RouteSpanTruckAccessAttributeListCopier.copyEnumToString(truckAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckAccess(RouteSpanTruckAccessAttribute... truckAccess) {
            truckAccess(Arrays.asList(truckAccess));
            return this;
        }

        public final Collection<Integer> getTruckRoadTypes() {
            if (truckRoadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return truckRoadTypes;
        }

        public final void setTruckRoadTypes(Collection<Integer> truckRoadTypes) {
            this.truckRoadTypes = IndexListCopier.copy(truckRoadTypes);
        }

        @Override
        public final Builder truckRoadTypes(Collection<Integer> truckRoadTypes) {
            this.truckRoadTypes = IndexListCopier.copy(truckRoadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckRoadTypes(Integer... truckRoadTypes) {
            truckRoadTypes(Arrays.asList(truckRoadTypes));
            return this;
        }

        public final Long getTypicalDuration() {
            return typicalDuration;
        }

        public final void setTypicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
        }

        @Override
        public final Builder typicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
            return this;
        }

        public final Collection<Integer> getZones() {
            if (zones instanceof SdkAutoConstructList) {
                return null;
            }
            return zones;
        }

        public final void setZones(Collection<Integer> zones) {
            this.zones = IndexListCopier.copy(zones);
        }

        @Override
        public final Builder zones(Collection<Integer> zones) {
            this.zones = IndexListCopier.copy(zones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zones(Integer... zones) {
            zones(Arrays.asList(zones));
            return this;
        }

        @Override
        public RouteVehicleSpan build() {
            return new RouteVehicleSpan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
