/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Steps of a leg that correspond to the travel portion of the leg.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteVehicleTravelStep implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteVehicleTravelStep.Builder, RouteVehicleTravelStep> {
    private static final SdkField<RouteContinueHighwayStepDetails> CONTINUE_HIGHWAY_STEP_DETAILS_FIELD = SdkField
            .<RouteContinueHighwayStepDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ContinueHighwayStepDetails")
            .getter(getter(RouteVehicleTravelStep::continueHighwayStepDetails))
            .setter(setter(Builder::continueHighwayStepDetails))
            .constructor(RouteContinueHighwayStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinueHighwayStepDetails").build())
            .build();

    private static final SdkField<RouteContinueStepDetails> CONTINUE_STEP_DETAILS_FIELD = SdkField
            .<RouteContinueStepDetails> builder(MarshallingType.SDK_POJO).memberName("ContinueStepDetails")
            .getter(getter(RouteVehicleTravelStep::continueStepDetails)).setter(setter(Builder::continueStepDetails))
            .constructor(RouteContinueStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinueStepDetails").build())
            .build();

    private static final SdkField<RouteRoad> CURRENT_ROAD_FIELD = SdkField.<RouteRoad> builder(MarshallingType.SDK_POJO)
            .memberName("CurrentRoad").getter(getter(RouteVehicleTravelStep::currentRoad)).setter(setter(Builder::currentRoad))
            .constructor(RouteRoad::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRoad").build()).build();

    private static final SdkField<Long> DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Distance")
            .getter(getter(RouteVehicleTravelStep::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(RouteVehicleTravelStep::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<RouteEnterHighwayStepDetails> ENTER_HIGHWAY_STEP_DETAILS_FIELD = SdkField
            .<RouteEnterHighwayStepDetails> builder(MarshallingType.SDK_POJO).memberName("EnterHighwayStepDetails")
            .getter(getter(RouteVehicleTravelStep::enterHighwayStepDetails)).setter(setter(Builder::enterHighwayStepDetails))
            .constructor(RouteEnterHighwayStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnterHighwayStepDetails").build())
            .build();

    private static final SdkField<List<LocalizedString>> EXIT_NUMBER_FIELD = SdkField
            .<List<LocalizedString>> builder(MarshallingType.LIST)
            .memberName("ExitNumber")
            .getter(getter(RouteVehicleTravelStep::exitNumber))
            .setter(setter(Builder::exitNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExitNumber").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalizedString> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalizedString::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteExitStepDetails> EXIT_STEP_DETAILS_FIELD = SdkField
            .<RouteExitStepDetails> builder(MarshallingType.SDK_POJO).memberName("ExitStepDetails")
            .getter(getter(RouteVehicleTravelStep::exitStepDetails)).setter(setter(Builder::exitStepDetails))
            .constructor(RouteExitStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExitStepDetails").build()).build();

    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GeometryOffset").getter(getter(RouteVehicleTravelStep::geometryOffset))
            .setter(setter(Builder::geometryOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()).build();

    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Instruction").getter(getter(RouteVehicleTravelStep::instruction)).setter(setter(Builder::instruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instruction").build()).build();

    private static final SdkField<RouteKeepStepDetails> KEEP_STEP_DETAILS_FIELD = SdkField
            .<RouteKeepStepDetails> builder(MarshallingType.SDK_POJO).memberName("KeepStepDetails")
            .getter(getter(RouteVehicleTravelStep::keepStepDetails)).setter(setter(Builder::keepStepDetails))
            .constructor(RouteKeepStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeepStepDetails").build()).build();

    private static final SdkField<RouteRoad> NEXT_ROAD_FIELD = SdkField.<RouteRoad> builder(MarshallingType.SDK_POJO)
            .memberName("NextRoad").getter(getter(RouteVehicleTravelStep::nextRoad)).setter(setter(Builder::nextRoad))
            .constructor(RouteRoad::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRoad").build()).build();

    private static final SdkField<RouteRampStepDetails> RAMP_STEP_DETAILS_FIELD = SdkField
            .<RouteRampStepDetails> builder(MarshallingType.SDK_POJO).memberName("RampStepDetails")
            .getter(getter(RouteVehicleTravelStep::rampStepDetails)).setter(setter(Builder::rampStepDetails))
            .constructor(RouteRampStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RampStepDetails").build()).build();

    private static final SdkField<RouteRoundaboutEnterStepDetails> ROUNDABOUT_ENTER_STEP_DETAILS_FIELD = SdkField
            .<RouteRoundaboutEnterStepDetails> builder(MarshallingType.SDK_POJO)
            .memberName("RoundaboutEnterStepDetails")
            .getter(getter(RouteVehicleTravelStep::roundaboutEnterStepDetails))
            .setter(setter(Builder::roundaboutEnterStepDetails))
            .constructor(RouteRoundaboutEnterStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoundaboutEnterStepDetails").build())
            .build();

    private static final SdkField<RouteRoundaboutExitStepDetails> ROUNDABOUT_EXIT_STEP_DETAILS_FIELD = SdkField
            .<RouteRoundaboutExitStepDetails> builder(MarshallingType.SDK_POJO).memberName("RoundaboutExitStepDetails")
            .getter(getter(RouteVehicleTravelStep::roundaboutExitStepDetails)).setter(setter(Builder::roundaboutExitStepDetails))
            .constructor(RouteRoundaboutExitStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoundaboutExitStepDetails").build())
            .build();

    private static final SdkField<RouteRoundaboutPassStepDetails> ROUNDABOUT_PASS_STEP_DETAILS_FIELD = SdkField
            .<RouteRoundaboutPassStepDetails> builder(MarshallingType.SDK_POJO).memberName("RoundaboutPassStepDetails")
            .getter(getter(RouteVehicleTravelStep::roundaboutPassStepDetails)).setter(setter(Builder::roundaboutPassStepDetails))
            .constructor(RouteRoundaboutPassStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoundaboutPassStepDetails").build())
            .build();

    private static final SdkField<RouteSignpost> SIGNPOST_FIELD = SdkField.<RouteSignpost> builder(MarshallingType.SDK_POJO)
            .memberName("Signpost").getter(getter(RouteVehicleTravelStep::signpost)).setter(setter(Builder::signpost))
            .constructor(RouteSignpost::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signpost").build()).build();

    private static final SdkField<RouteTurnStepDetails> TURN_STEP_DETAILS_FIELD = SdkField
            .<RouteTurnStepDetails> builder(MarshallingType.SDK_POJO).memberName("TurnStepDetails")
            .getter(getter(RouteVehicleTravelStep::turnStepDetails)).setter(setter(Builder::turnStepDetails))
            .constructor(RouteTurnStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnStepDetails").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RouteVehicleTravelStep::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<RouteUTurnStepDetails> U_TURN_STEP_DETAILS_FIELD = SdkField
            .<RouteUTurnStepDetails> builder(MarshallingType.SDK_POJO).memberName("UTurnStepDetails")
            .getter(getter(RouteVehicleTravelStep::uTurnStepDetails)).setter(setter(Builder::uTurnStepDetails))
            .constructor(RouteUTurnStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UTurnStepDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTINUE_HIGHWAY_STEP_DETAILS_FIELD, CONTINUE_STEP_DETAILS_FIELD, CURRENT_ROAD_FIELD, DISTANCE_FIELD, DURATION_FIELD,
            ENTER_HIGHWAY_STEP_DETAILS_FIELD, EXIT_NUMBER_FIELD, EXIT_STEP_DETAILS_FIELD, GEOMETRY_OFFSET_FIELD,
            INSTRUCTION_FIELD, KEEP_STEP_DETAILS_FIELD, NEXT_ROAD_FIELD, RAMP_STEP_DETAILS_FIELD,
            ROUNDABOUT_ENTER_STEP_DETAILS_FIELD, ROUNDABOUT_EXIT_STEP_DETAILS_FIELD, ROUNDABOUT_PASS_STEP_DETAILS_FIELD,
            SIGNPOST_FIELD, TURN_STEP_DETAILS_FIELD, TYPE_FIELD, U_TURN_STEP_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteContinueHighwayStepDetails continueHighwayStepDetails;

    private final RouteContinueStepDetails continueStepDetails;

    private final RouteRoad currentRoad;

    private final Long distance;

    private final Long duration;

    private final RouteEnterHighwayStepDetails enterHighwayStepDetails;

    private final List<LocalizedString> exitNumber;

    private final RouteExitStepDetails exitStepDetails;

    private final Integer geometryOffset;

    private final String instruction;

    private final RouteKeepStepDetails keepStepDetails;

    private final RouteRoad nextRoad;

    private final RouteRampStepDetails rampStepDetails;

    private final RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails;

    private final RouteRoundaboutExitStepDetails roundaboutExitStepDetails;

    private final RouteRoundaboutPassStepDetails roundaboutPassStepDetails;

    private final RouteSignpost signpost;

    private final RouteTurnStepDetails turnStepDetails;

    private final String type;

    private final RouteUTurnStepDetails uTurnStepDetails;

    private RouteVehicleTravelStep(BuilderImpl builder) {
        this.continueHighwayStepDetails = builder.continueHighwayStepDetails;
        this.continueStepDetails = builder.continueStepDetails;
        this.currentRoad = builder.currentRoad;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.enterHighwayStepDetails = builder.enterHighwayStepDetails;
        this.exitNumber = builder.exitNumber;
        this.exitStepDetails = builder.exitStepDetails;
        this.geometryOffset = builder.geometryOffset;
        this.instruction = builder.instruction;
        this.keepStepDetails = builder.keepStepDetails;
        this.nextRoad = builder.nextRoad;
        this.rampStepDetails = builder.rampStepDetails;
        this.roundaboutEnterStepDetails = builder.roundaboutEnterStepDetails;
        this.roundaboutExitStepDetails = builder.roundaboutExitStepDetails;
        this.roundaboutPassStepDetails = builder.roundaboutPassStepDetails;
        this.signpost = builder.signpost;
        this.turnStepDetails = builder.turnStepDetails;
        this.type = builder.type;
        this.uTurnStepDetails = builder.uTurnStepDetails;
    }

    /**
     * <p>
     * Details that are specific to a Continue Highway step.
     * </p>
     * 
     * @return Details that are specific to a Continue Highway step.
     */
    public final RouteContinueHighwayStepDetails continueHighwayStepDetails() {
        return continueHighwayStepDetails;
    }

    /**
     * <p>
     * Details that are specific to a Continue step.
     * </p>
     * 
     * @return Details that are specific to a Continue step.
     */
    public final RouteContinueStepDetails continueStepDetails() {
        return continueStepDetails;
    }

    /**
     * <p>
     * Details of the current road.
     * </p>
     * 
     * @return Details of the current road.
     */
    public final RouteRoad currentRoad() {
        return currentRoad;
    }

    /**
     * <p>
     * Distance of the step.
     * </p>
     * 
     * @return Distance of the step.
     */
    public final Long distance() {
        return distance;
    }

    /**
     * <p>
     * Duration of the step.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the step.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * Details that are specific to a Enter Highway step.
     * </p>
     * 
     * @return Details that are specific to a Enter Highway step.
     */
    public final RouteEnterHighwayStepDetails enterHighwayStepDetails() {
        return enterHighwayStepDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExitNumber property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExitNumber() {
        return exitNumber != null && !(exitNumber instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Exit number of the road exit, if applicable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExitNumber} method.
     * </p>
     * 
     * @return Exit number of the road exit, if applicable.
     */
    public final List<LocalizedString> exitNumber() {
        return exitNumber;
    }

    /**
     * <p>
     * Details that are specific to a Roundabout Exit step.
     * </p>
     * 
     * @return Details that are specific to a Roundabout Exit step.
     */
    public final RouteExitStepDetails exitStepDetails() {
        return exitStepDetails;
    }

    /**
     * <p>
     * Offset in the leg geometry corresponding to the start of this step.
     * </p>
     * 
     * @return Offset in the leg geometry corresponding to the start of this step.
     */
    public final Integer geometryOffset() {
        return geometryOffset;
    }

    /**
     * <p>
     * Brief description of the step in the requested language.
     * </p>
     * <note>
     * <p>
     * Only available when the TravelStepType is Default.
     * </p>
     * </note>
     * 
     * @return Brief description of the step in the requested language.</p> <note>
     *         <p>
     *         Only available when the TravelStepType is Default.
     *         </p>
     */
    public final String instruction() {
        return instruction;
    }

    /**
     * <p>
     * Details that are specific to a Keep step.
     * </p>
     * 
     * @return Details that are specific to a Keep step.
     */
    public final RouteKeepStepDetails keepStepDetails() {
        return keepStepDetails;
    }

    /**
     * <p>
     * Details of the next road. See RouteRoad for details of sub-attributes.
     * </p>
     * 
     * @return Details of the next road. See RouteRoad for details of sub-attributes.
     */
    public final RouteRoad nextRoad() {
        return nextRoad;
    }

    /**
     * <p>
     * Details that are specific to a Ramp step.
     * </p>
     * 
     * @return Details that are specific to a Ramp step.
     */
    public final RouteRampStepDetails rampStepDetails() {
        return rampStepDetails;
    }

    /**
     * <p>
     * Details that are specific to a Roundabout Enter step.
     * </p>
     * 
     * @return Details that are specific to a Roundabout Enter step.
     */
    public final RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails() {
        return roundaboutEnterStepDetails;
    }

    /**
     * <p>
     * Details that are specific to a Roundabout Exit step.
     * </p>
     * 
     * @return Details that are specific to a Roundabout Exit step.
     */
    public final RouteRoundaboutExitStepDetails roundaboutExitStepDetails() {
        return roundaboutExitStepDetails;
    }

    /**
     * <p>
     * Details that are specific to a Roundabout Pass step.
     * </p>
     * 
     * @return Details that are specific to a Roundabout Pass step.
     */
    public final RouteRoundaboutPassStepDetails roundaboutPassStepDetails() {
        return roundaboutPassStepDetails;
    }

    /**
     * <p>
     * Sign post information of the action, applicable only for TurnByTurn steps. See RouteSignpost for details of
     * sub-attributes.
     * </p>
     * 
     * @return Sign post information of the action, applicable only for TurnByTurn steps. See RouteSignpost for details
     *         of sub-attributes.
     */
    public final RouteSignpost signpost() {
        return signpost;
    }

    /**
     * <p>
     * Details that are specific to a Turn step.
     * </p>
     * 
     * @return Details that are specific to a Turn step.
     */
    public final RouteTurnStepDetails turnStepDetails() {
        return turnStepDetails;
    }

    /**
     * <p>
     * Type of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteVehicleTravelStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the step.
     * @see RouteVehicleTravelStepType
     */
    public final RouteVehicleTravelStepType type() {
        return RouteVehicleTravelStepType.fromValue(type);
    }

    /**
     * <p>
     * Type of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteVehicleTravelStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the step.
     * @see RouteVehicleTravelStepType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details that are specific to a Turn step.
     * </p>
     * 
     * @return Details that are specific to a Turn step.
     */
    public final RouteUTurnStepDetails uTurnStepDetails() {
        return uTurnStepDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continueHighwayStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(continueStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(currentRoad());
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(enterHighwayStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasExitNumber() ? exitNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(exitStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(keepStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nextRoad());
        hashCode = 31 * hashCode + Objects.hashCode(rampStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(roundaboutEnterStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(roundaboutExitStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(roundaboutPassStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(signpost());
        hashCode = 31 * hashCode + Objects.hashCode(turnStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uTurnStepDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleTravelStep)) {
            return false;
        }
        RouteVehicleTravelStep other = (RouteVehicleTravelStep) obj;
        return Objects.equals(continueHighwayStepDetails(), other.continueHighwayStepDetails())
                && Objects.equals(continueStepDetails(), other.continueStepDetails())
                && Objects.equals(currentRoad(), other.currentRoad()) && Objects.equals(distance(), other.distance())
                && Objects.equals(duration(), other.duration())
                && Objects.equals(enterHighwayStepDetails(), other.enterHighwayStepDetails())
                && hasExitNumber() == other.hasExitNumber() && Objects.equals(exitNumber(), other.exitNumber())
                && Objects.equals(exitStepDetails(), other.exitStepDetails())
                && Objects.equals(geometryOffset(), other.geometryOffset()) && Objects.equals(instruction(), other.instruction())
                && Objects.equals(keepStepDetails(), other.keepStepDetails()) && Objects.equals(nextRoad(), other.nextRoad())
                && Objects.equals(rampStepDetails(), other.rampStepDetails())
                && Objects.equals(roundaboutEnterStepDetails(), other.roundaboutEnterStepDetails())
                && Objects.equals(roundaboutExitStepDetails(), other.roundaboutExitStepDetails())
                && Objects.equals(roundaboutPassStepDetails(), other.roundaboutPassStepDetails())
                && Objects.equals(signpost(), other.signpost()) && Objects.equals(turnStepDetails(), other.turnStepDetails())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(uTurnStepDetails(), other.uTurnStepDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteVehicleTravelStep").add("ContinueHighwayStepDetails", continueHighwayStepDetails())
                .add("ContinueStepDetails", continueStepDetails()).add("CurrentRoad", currentRoad()).add("Distance", distance())
                .add("Duration", duration()).add("EnterHighwayStepDetails", enterHighwayStepDetails())
                .add("ExitNumber", hasExitNumber() ? exitNumber() : null).add("ExitStepDetails", exitStepDetails())
                .add("GeometryOffset", geometryOffset()).add("Instruction", instruction())
                .add("KeepStepDetails", keepStepDetails()).add("NextRoad", nextRoad()).add("RampStepDetails", rampStepDetails())
                .add("RoundaboutEnterStepDetails", roundaboutEnterStepDetails())
                .add("RoundaboutExitStepDetails", roundaboutExitStepDetails())
                .add("RoundaboutPassStepDetails", roundaboutPassStepDetails()).add("Signpost", signpost())
                .add("TurnStepDetails", turnStepDetails()).add("Type", typeAsString())
                .add("UTurnStepDetails", uTurnStepDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinueHighwayStepDetails":
            return Optional.ofNullable(clazz.cast(continueHighwayStepDetails()));
        case "ContinueStepDetails":
            return Optional.ofNullable(clazz.cast(continueStepDetails()));
        case "CurrentRoad":
            return Optional.ofNullable(clazz.cast(currentRoad()));
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "EnterHighwayStepDetails":
            return Optional.ofNullable(clazz.cast(enterHighwayStepDetails()));
        case "ExitNumber":
            return Optional.ofNullable(clazz.cast(exitNumber()));
        case "ExitStepDetails":
            return Optional.ofNullable(clazz.cast(exitStepDetails()));
        case "GeometryOffset":
            return Optional.ofNullable(clazz.cast(geometryOffset()));
        case "Instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "KeepStepDetails":
            return Optional.ofNullable(clazz.cast(keepStepDetails()));
        case "NextRoad":
            return Optional.ofNullable(clazz.cast(nextRoad()));
        case "RampStepDetails":
            return Optional.ofNullable(clazz.cast(rampStepDetails()));
        case "RoundaboutEnterStepDetails":
            return Optional.ofNullable(clazz.cast(roundaboutEnterStepDetails()));
        case "RoundaboutExitStepDetails":
            return Optional.ofNullable(clazz.cast(roundaboutExitStepDetails()));
        case "RoundaboutPassStepDetails":
            return Optional.ofNullable(clazz.cast(roundaboutPassStepDetails()));
        case "Signpost":
            return Optional.ofNullable(clazz.cast(signpost()));
        case "TurnStepDetails":
            return Optional.ofNullable(clazz.cast(turnStepDetails()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "UTurnStepDetails":
            return Optional.ofNullable(clazz.cast(uTurnStepDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContinueHighwayStepDetails", CONTINUE_HIGHWAY_STEP_DETAILS_FIELD);
        map.put("ContinueStepDetails", CONTINUE_STEP_DETAILS_FIELD);
        map.put("CurrentRoad", CURRENT_ROAD_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("EnterHighwayStepDetails", ENTER_HIGHWAY_STEP_DETAILS_FIELD);
        map.put("ExitNumber", EXIT_NUMBER_FIELD);
        map.put("ExitStepDetails", EXIT_STEP_DETAILS_FIELD);
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Instruction", INSTRUCTION_FIELD);
        map.put("KeepStepDetails", KEEP_STEP_DETAILS_FIELD);
        map.put("NextRoad", NEXT_ROAD_FIELD);
        map.put("RampStepDetails", RAMP_STEP_DETAILS_FIELD);
        map.put("RoundaboutEnterStepDetails", ROUNDABOUT_ENTER_STEP_DETAILS_FIELD);
        map.put("RoundaboutExitStepDetails", ROUNDABOUT_EXIT_STEP_DETAILS_FIELD);
        map.put("RoundaboutPassStepDetails", ROUNDABOUT_PASS_STEP_DETAILS_FIELD);
        map.put("Signpost", SIGNPOST_FIELD);
        map.put("TurnStepDetails", TURN_STEP_DETAILS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("UTurnStepDetails", U_TURN_STEP_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleTravelStep, T> g) {
        return obj -> g.apply((RouteVehicleTravelStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteVehicleTravelStep> {
        /**
         * <p>
         * Details that are specific to a Continue Highway step.
         * </p>
         * 
         * @param continueHighwayStepDetails
         *        Details that are specific to a Continue Highway step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continueHighwayStepDetails(RouteContinueHighwayStepDetails continueHighwayStepDetails);

        /**
         * <p>
         * Details that are specific to a Continue Highway step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteContinueHighwayStepDetails.Builder}
         * avoiding the need to create one manually via {@link RouteContinueHighwayStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteContinueHighwayStepDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #continueHighwayStepDetails(RouteContinueHighwayStepDetails)}.
         * 
         * @param continueHighwayStepDetails
         *        a consumer that will call methods on {@link RouteContinueHighwayStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continueHighwayStepDetails(RouteContinueHighwayStepDetails)
         */
        default Builder continueHighwayStepDetails(Consumer<RouteContinueHighwayStepDetails.Builder> continueHighwayStepDetails) {
            return continueHighwayStepDetails(RouteContinueHighwayStepDetails.builder().applyMutation(continueHighwayStepDetails)
                    .build());
        }

        /**
         * <p>
         * Details that are specific to a Continue step.
         * </p>
         * 
         * @param continueStepDetails
         *        Details that are specific to a Continue step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continueStepDetails(RouteContinueStepDetails continueStepDetails);

        /**
         * <p>
         * Details that are specific to a Continue step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteContinueStepDetails.Builder}
         * avoiding the need to create one manually via {@link RouteContinueStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteContinueStepDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #continueStepDetails(RouteContinueStepDetails)}.
         * 
         * @param continueStepDetails
         *        a consumer that will call methods on {@link RouteContinueStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continueStepDetails(RouteContinueStepDetails)
         */
        default Builder continueStepDetails(Consumer<RouteContinueStepDetails.Builder> continueStepDetails) {
            return continueStepDetails(RouteContinueStepDetails.builder().applyMutation(continueStepDetails).build());
        }

        /**
         * <p>
         * Details of the current road.
         * </p>
         * 
         * @param currentRoad
         *        Details of the current road.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRoad(RouteRoad currentRoad);

        /**
         * <p>
         * Details of the current road.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteRoad.Builder} avoiding the need to
         * create one manually via {@link RouteRoad#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteRoad.Builder#build()} is called immediately and its result
         * is passed to {@link #currentRoad(RouteRoad)}.
         * 
         * @param currentRoad
         *        a consumer that will call methods on {@link RouteRoad.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentRoad(RouteRoad)
         */
        default Builder currentRoad(Consumer<RouteRoad.Builder> currentRoad) {
            return currentRoad(RouteRoad.builder().applyMutation(currentRoad).build());
        }

        /**
         * <p>
         * Distance of the step.
         * </p>
         * 
         * @param distance
         *        Distance of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Long distance);

        /**
         * <p>
         * Duration of the step.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param duration
         *        Duration of the step.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * Details that are specific to a Enter Highway step.
         * </p>
         * 
         * @param enterHighwayStepDetails
         *        Details that are specific to a Enter Highway step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enterHighwayStepDetails(RouteEnterHighwayStepDetails enterHighwayStepDetails);

        /**
         * <p>
         * Details that are specific to a Enter Highway step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteEnterHighwayStepDetails.Builder}
         * avoiding the need to create one manually via {@link RouteEnterHighwayStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteEnterHighwayStepDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #enterHighwayStepDetails(RouteEnterHighwayStepDetails)}.
         * 
         * @param enterHighwayStepDetails
         *        a consumer that will call methods on {@link RouteEnterHighwayStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enterHighwayStepDetails(RouteEnterHighwayStepDetails)
         */
        default Builder enterHighwayStepDetails(Consumer<RouteEnterHighwayStepDetails.Builder> enterHighwayStepDetails) {
            return enterHighwayStepDetails(RouteEnterHighwayStepDetails.builder().applyMutation(enterHighwayStepDetails).build());
        }

        /**
         * <p>
         * Exit number of the road exit, if applicable.
         * </p>
         * 
         * @param exitNumber
         *        Exit number of the road exit, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitNumber(Collection<LocalizedString> exitNumber);

        /**
         * <p>
         * Exit number of the road exit, if applicable.
         * </p>
         * 
         * @param exitNumber
         *        Exit number of the road exit, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitNumber(LocalizedString... exitNumber);

        /**
         * <p>
         * Exit number of the road exit, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.LocalizedString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder#build()} is called immediately
         * and its result is passed to {@link #exitNumber(List<LocalizedString>)}.
         * 
         * @param exitNumber
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exitNumber(java.util.Collection<LocalizedString>)
         */
        Builder exitNumber(Consumer<LocalizedString.Builder>... exitNumber);

        /**
         * <p>
         * Details that are specific to a Roundabout Exit step.
         * </p>
         * 
         * @param exitStepDetails
         *        Details that are specific to a Roundabout Exit step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitStepDetails(RouteExitStepDetails exitStepDetails);

        /**
         * <p>
         * Details that are specific to a Roundabout Exit step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteExitStepDetails.Builder} avoiding
         * the need to create one manually via {@link RouteExitStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteExitStepDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #exitStepDetails(RouteExitStepDetails)}.
         * 
         * @param exitStepDetails
         *        a consumer that will call methods on {@link RouteExitStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exitStepDetails(RouteExitStepDetails)
         */
        default Builder exitStepDetails(Consumer<RouteExitStepDetails.Builder> exitStepDetails) {
            return exitStepDetails(RouteExitStepDetails.builder().applyMutation(exitStepDetails).build());
        }

        /**
         * <p>
         * Offset in the leg geometry corresponding to the start of this step.
         * </p>
         * 
         * @param geometryOffset
         *        Offset in the leg geometry corresponding to the start of this step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometryOffset(Integer geometryOffset);

        /**
         * <p>
         * Brief description of the step in the requested language.
         * </p>
         * <note>
         * <p>
         * Only available when the TravelStepType is Default.
         * </p>
         * </note>
         * 
         * @param instruction
         *        Brief description of the step in the requested language.</p> <note>
         *        <p>
         *        Only available when the TravelStepType is Default.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(String instruction);

        /**
         * <p>
         * Details that are specific to a Keep step.
         * </p>
         * 
         * @param keepStepDetails
         *        Details that are specific to a Keep step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keepStepDetails(RouteKeepStepDetails keepStepDetails);

        /**
         * <p>
         * Details that are specific to a Keep step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteKeepStepDetails.Builder} avoiding
         * the need to create one manually via {@link RouteKeepStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteKeepStepDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #keepStepDetails(RouteKeepStepDetails)}.
         * 
         * @param keepStepDetails
         *        a consumer that will call methods on {@link RouteKeepStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keepStepDetails(RouteKeepStepDetails)
         */
        default Builder keepStepDetails(Consumer<RouteKeepStepDetails.Builder> keepStepDetails) {
            return keepStepDetails(RouteKeepStepDetails.builder().applyMutation(keepStepDetails).build());
        }

        /**
         * <p>
         * Details of the next road. See RouteRoad for details of sub-attributes.
         * </p>
         * 
         * @param nextRoad
         *        Details of the next road. See RouteRoad for details of sub-attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRoad(RouteRoad nextRoad);

        /**
         * <p>
         * Details of the next road. See RouteRoad for details of sub-attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteRoad.Builder} avoiding the need to
         * create one manually via {@link RouteRoad#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteRoad.Builder#build()} is called immediately and its result
         * is passed to {@link #nextRoad(RouteRoad)}.
         * 
         * @param nextRoad
         *        a consumer that will call methods on {@link RouteRoad.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextRoad(RouteRoad)
         */
        default Builder nextRoad(Consumer<RouteRoad.Builder> nextRoad) {
            return nextRoad(RouteRoad.builder().applyMutation(nextRoad).build());
        }

        /**
         * <p>
         * Details that are specific to a Ramp step.
         * </p>
         * 
         * @param rampStepDetails
         *        Details that are specific to a Ramp step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rampStepDetails(RouteRampStepDetails rampStepDetails);

        /**
         * <p>
         * Details that are specific to a Ramp step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteRampStepDetails.Builder} avoiding
         * the need to create one manually via {@link RouteRampStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteRampStepDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #rampStepDetails(RouteRampStepDetails)}.
         * 
         * @param rampStepDetails
         *        a consumer that will call methods on {@link RouteRampStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rampStepDetails(RouteRampStepDetails)
         */
        default Builder rampStepDetails(Consumer<RouteRampStepDetails.Builder> rampStepDetails) {
            return rampStepDetails(RouteRampStepDetails.builder().applyMutation(rampStepDetails).build());
        }

        /**
         * <p>
         * Details that are specific to a Roundabout Enter step.
         * </p>
         * 
         * @param roundaboutEnterStepDetails
         *        Details that are specific to a Roundabout Enter step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails);

        /**
         * <p>
         * Details that are specific to a Roundabout Enter step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteRoundaboutEnterStepDetails.Builder}
         * avoiding the need to create one manually via {@link RouteRoundaboutEnterStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteRoundaboutEnterStepDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #roundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails)}.
         * 
         * @param roundaboutEnterStepDetails
         *        a consumer that will call methods on {@link RouteRoundaboutEnterStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails)
         */
        default Builder roundaboutEnterStepDetails(Consumer<RouteRoundaboutEnterStepDetails.Builder> roundaboutEnterStepDetails) {
            return roundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails.builder().applyMutation(roundaboutEnterStepDetails)
                    .build());
        }

        /**
         * <p>
         * Details that are specific to a Roundabout Exit step.
         * </p>
         * 
         * @param roundaboutExitStepDetails
         *        Details that are specific to a Roundabout Exit step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roundaboutExitStepDetails(RouteRoundaboutExitStepDetails roundaboutExitStepDetails);

        /**
         * <p>
         * Details that are specific to a Roundabout Exit step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteRoundaboutExitStepDetails.Builder}
         * avoiding the need to create one manually via {@link RouteRoundaboutExitStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteRoundaboutExitStepDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #roundaboutExitStepDetails(RouteRoundaboutExitStepDetails)}.
         * 
         * @param roundaboutExitStepDetails
         *        a consumer that will call methods on {@link RouteRoundaboutExitStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roundaboutExitStepDetails(RouteRoundaboutExitStepDetails)
         */
        default Builder roundaboutExitStepDetails(Consumer<RouteRoundaboutExitStepDetails.Builder> roundaboutExitStepDetails) {
            return roundaboutExitStepDetails(RouteRoundaboutExitStepDetails.builder().applyMutation(roundaboutExitStepDetails)
                    .build());
        }

        /**
         * <p>
         * Details that are specific to a Roundabout Pass step.
         * </p>
         * 
         * @param roundaboutPassStepDetails
         *        Details that are specific to a Roundabout Pass step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roundaboutPassStepDetails(RouteRoundaboutPassStepDetails roundaboutPassStepDetails);

        /**
         * <p>
         * Details that are specific to a Roundabout Pass step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteRoundaboutPassStepDetails.Builder}
         * avoiding the need to create one manually via {@link RouteRoundaboutPassStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteRoundaboutPassStepDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #roundaboutPassStepDetails(RouteRoundaboutPassStepDetails)}.
         * 
         * @param roundaboutPassStepDetails
         *        a consumer that will call methods on {@link RouteRoundaboutPassStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roundaboutPassStepDetails(RouteRoundaboutPassStepDetails)
         */
        default Builder roundaboutPassStepDetails(Consumer<RouteRoundaboutPassStepDetails.Builder> roundaboutPassStepDetails) {
            return roundaboutPassStepDetails(RouteRoundaboutPassStepDetails.builder().applyMutation(roundaboutPassStepDetails)
                    .build());
        }

        /**
         * <p>
         * Sign post information of the action, applicable only for TurnByTurn steps. See RouteSignpost for details of
         * sub-attributes.
         * </p>
         * 
         * @param signpost
         *        Sign post information of the action, applicable only for TurnByTurn steps. See RouteSignpost for
         *        details of sub-attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signpost(RouteSignpost signpost);

        /**
         * <p>
         * Sign post information of the action, applicable only for TurnByTurn steps. See RouteSignpost for details of
         * sub-attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteSignpost.Builder} avoiding the need
         * to create one manually via {@link RouteSignpost#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteSignpost.Builder#build()} is called immediately and its
         * result is passed to {@link #signpost(RouteSignpost)}.
         * 
         * @param signpost
         *        a consumer that will call methods on {@link RouteSignpost.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signpost(RouteSignpost)
         */
        default Builder signpost(Consumer<RouteSignpost.Builder> signpost) {
            return signpost(RouteSignpost.builder().applyMutation(signpost).build());
        }

        /**
         * <p>
         * Details that are specific to a Turn step.
         * </p>
         * 
         * @param turnStepDetails
         *        Details that are specific to a Turn step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnStepDetails(RouteTurnStepDetails turnStepDetails);

        /**
         * <p>
         * Details that are specific to a Turn step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTurnStepDetails.Builder} avoiding
         * the need to create one manually via {@link RouteTurnStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTurnStepDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #turnStepDetails(RouteTurnStepDetails)}.
         * 
         * @param turnStepDetails
         *        a consumer that will call methods on {@link RouteTurnStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #turnStepDetails(RouteTurnStepDetails)
         */
        default Builder turnStepDetails(Consumer<RouteTurnStepDetails.Builder> turnStepDetails) {
            return turnStepDetails(RouteTurnStepDetails.builder().applyMutation(turnStepDetails).build());
        }

        /**
         * <p>
         * Type of the step.
         * </p>
         * 
         * @param type
         *        Type of the step.
         * @see RouteVehicleTravelStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteVehicleTravelStepType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the step.
         * </p>
         * 
         * @param type
         *        Type of the step.
         * @see RouteVehicleTravelStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteVehicleTravelStepType
         */
        Builder type(RouteVehicleTravelStepType type);

        /**
         * <p>
         * Details that are specific to a Turn step.
         * </p>
         * 
         * @param uTurnStepDetails
         *        Details that are specific to a Turn step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uTurnStepDetails(RouteUTurnStepDetails uTurnStepDetails);

        /**
         * <p>
         * Details that are specific to a Turn step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteUTurnStepDetails.Builder} avoiding
         * the need to create one manually via {@link RouteUTurnStepDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteUTurnStepDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #uTurnStepDetails(RouteUTurnStepDetails)}.
         * 
         * @param uTurnStepDetails
         *        a consumer that will call methods on {@link RouteUTurnStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uTurnStepDetails(RouteUTurnStepDetails)
         */
        default Builder uTurnStepDetails(Consumer<RouteUTurnStepDetails.Builder> uTurnStepDetails) {
            return uTurnStepDetails(RouteUTurnStepDetails.builder().applyMutation(uTurnStepDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RouteContinueHighwayStepDetails continueHighwayStepDetails;

        private RouteContinueStepDetails continueStepDetails;

        private RouteRoad currentRoad;

        private Long distance;

        private Long duration;

        private RouteEnterHighwayStepDetails enterHighwayStepDetails;

        private List<LocalizedString> exitNumber = DefaultSdkAutoConstructList.getInstance();

        private RouteExitStepDetails exitStepDetails;

        private Integer geometryOffset;

        private String instruction;

        private RouteKeepStepDetails keepStepDetails;

        private RouteRoad nextRoad;

        private RouteRampStepDetails rampStepDetails;

        private RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails;

        private RouteRoundaboutExitStepDetails roundaboutExitStepDetails;

        private RouteRoundaboutPassStepDetails roundaboutPassStepDetails;

        private RouteSignpost signpost;

        private RouteTurnStepDetails turnStepDetails;

        private String type;

        private RouteUTurnStepDetails uTurnStepDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleTravelStep model) {
            continueHighwayStepDetails(model.continueHighwayStepDetails);
            continueStepDetails(model.continueStepDetails);
            currentRoad(model.currentRoad);
            distance(model.distance);
            duration(model.duration);
            enterHighwayStepDetails(model.enterHighwayStepDetails);
            exitNumber(model.exitNumber);
            exitStepDetails(model.exitStepDetails);
            geometryOffset(model.geometryOffset);
            instruction(model.instruction);
            keepStepDetails(model.keepStepDetails);
            nextRoad(model.nextRoad);
            rampStepDetails(model.rampStepDetails);
            roundaboutEnterStepDetails(model.roundaboutEnterStepDetails);
            roundaboutExitStepDetails(model.roundaboutExitStepDetails);
            roundaboutPassStepDetails(model.roundaboutPassStepDetails);
            signpost(model.signpost);
            turnStepDetails(model.turnStepDetails);
            type(model.type);
            uTurnStepDetails(model.uTurnStepDetails);
        }

        public final RouteContinueHighwayStepDetails.Builder getContinueHighwayStepDetails() {
            return continueHighwayStepDetails != null ? continueHighwayStepDetails.toBuilder() : null;
        }

        public final void setContinueHighwayStepDetails(RouteContinueHighwayStepDetails.BuilderImpl continueHighwayStepDetails) {
            this.continueHighwayStepDetails = continueHighwayStepDetails != null ? continueHighwayStepDetails.build() : null;
        }

        @Override
        public final Builder continueHighwayStepDetails(RouteContinueHighwayStepDetails continueHighwayStepDetails) {
            this.continueHighwayStepDetails = continueHighwayStepDetails;
            return this;
        }

        public final RouteContinueStepDetails.Builder getContinueStepDetails() {
            return continueStepDetails != null ? continueStepDetails.toBuilder() : null;
        }

        public final void setContinueStepDetails(RouteContinueStepDetails.BuilderImpl continueStepDetails) {
            this.continueStepDetails = continueStepDetails != null ? continueStepDetails.build() : null;
        }

        @Override
        public final Builder continueStepDetails(RouteContinueStepDetails continueStepDetails) {
            this.continueStepDetails = continueStepDetails;
            return this;
        }

        public final RouteRoad.Builder getCurrentRoad() {
            return currentRoad != null ? currentRoad.toBuilder() : null;
        }

        public final void setCurrentRoad(RouteRoad.BuilderImpl currentRoad) {
            this.currentRoad = currentRoad != null ? currentRoad.build() : null;
        }

        @Override
        public final Builder currentRoad(RouteRoad currentRoad) {
            this.currentRoad = currentRoad;
            return this;
        }

        public final Long getDistance() {
            return distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final RouteEnterHighwayStepDetails.Builder getEnterHighwayStepDetails() {
            return enterHighwayStepDetails != null ? enterHighwayStepDetails.toBuilder() : null;
        }

        public final void setEnterHighwayStepDetails(RouteEnterHighwayStepDetails.BuilderImpl enterHighwayStepDetails) {
            this.enterHighwayStepDetails = enterHighwayStepDetails != null ? enterHighwayStepDetails.build() : null;
        }

        @Override
        public final Builder enterHighwayStepDetails(RouteEnterHighwayStepDetails enterHighwayStepDetails) {
            this.enterHighwayStepDetails = enterHighwayStepDetails;
            return this;
        }

        public final List<LocalizedString.Builder> getExitNumber() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.exitNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExitNumber(Collection<LocalizedString.BuilderImpl> exitNumber) {
            this.exitNumber = LocalizedStringListCopier.copyFromBuilder(exitNumber);
        }

        @Override
        public final Builder exitNumber(Collection<LocalizedString> exitNumber) {
            this.exitNumber = LocalizedStringListCopier.copy(exitNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exitNumber(LocalizedString... exitNumber) {
            exitNumber(Arrays.asList(exitNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exitNumber(Consumer<LocalizedString.Builder>... exitNumber) {
            exitNumber(Stream.of(exitNumber).map(c -> LocalizedString.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RouteExitStepDetails.Builder getExitStepDetails() {
            return exitStepDetails != null ? exitStepDetails.toBuilder() : null;
        }

        public final void setExitStepDetails(RouteExitStepDetails.BuilderImpl exitStepDetails) {
            this.exitStepDetails = exitStepDetails != null ? exitStepDetails.build() : null;
        }

        @Override
        public final Builder exitStepDetails(RouteExitStepDetails exitStepDetails) {
            this.exitStepDetails = exitStepDetails;
            return this;
        }

        public final Integer getGeometryOffset() {
            return geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final String getInstruction() {
            return instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final RouteKeepStepDetails.Builder getKeepStepDetails() {
            return keepStepDetails != null ? keepStepDetails.toBuilder() : null;
        }

        public final void setKeepStepDetails(RouteKeepStepDetails.BuilderImpl keepStepDetails) {
            this.keepStepDetails = keepStepDetails != null ? keepStepDetails.build() : null;
        }

        @Override
        public final Builder keepStepDetails(RouteKeepStepDetails keepStepDetails) {
            this.keepStepDetails = keepStepDetails;
            return this;
        }

        public final RouteRoad.Builder getNextRoad() {
            return nextRoad != null ? nextRoad.toBuilder() : null;
        }

        public final void setNextRoad(RouteRoad.BuilderImpl nextRoad) {
            this.nextRoad = nextRoad != null ? nextRoad.build() : null;
        }

        @Override
        public final Builder nextRoad(RouteRoad nextRoad) {
            this.nextRoad = nextRoad;
            return this;
        }

        public final RouteRampStepDetails.Builder getRampStepDetails() {
            return rampStepDetails != null ? rampStepDetails.toBuilder() : null;
        }

        public final void setRampStepDetails(RouteRampStepDetails.BuilderImpl rampStepDetails) {
            this.rampStepDetails = rampStepDetails != null ? rampStepDetails.build() : null;
        }

        @Override
        public final Builder rampStepDetails(RouteRampStepDetails rampStepDetails) {
            this.rampStepDetails = rampStepDetails;
            return this;
        }

        public final RouteRoundaboutEnterStepDetails.Builder getRoundaboutEnterStepDetails() {
            return roundaboutEnterStepDetails != null ? roundaboutEnterStepDetails.toBuilder() : null;
        }

        public final void setRoundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails.BuilderImpl roundaboutEnterStepDetails) {
            this.roundaboutEnterStepDetails = roundaboutEnterStepDetails != null ? roundaboutEnterStepDetails.build() : null;
        }

        @Override
        public final Builder roundaboutEnterStepDetails(RouteRoundaboutEnterStepDetails roundaboutEnterStepDetails) {
            this.roundaboutEnterStepDetails = roundaboutEnterStepDetails;
            return this;
        }

        public final RouteRoundaboutExitStepDetails.Builder getRoundaboutExitStepDetails() {
            return roundaboutExitStepDetails != null ? roundaboutExitStepDetails.toBuilder() : null;
        }

        public final void setRoundaboutExitStepDetails(RouteRoundaboutExitStepDetails.BuilderImpl roundaboutExitStepDetails) {
            this.roundaboutExitStepDetails = roundaboutExitStepDetails != null ? roundaboutExitStepDetails.build() : null;
        }

        @Override
        public final Builder roundaboutExitStepDetails(RouteRoundaboutExitStepDetails roundaboutExitStepDetails) {
            this.roundaboutExitStepDetails = roundaboutExitStepDetails;
            return this;
        }

        public final RouteRoundaboutPassStepDetails.Builder getRoundaboutPassStepDetails() {
            return roundaboutPassStepDetails != null ? roundaboutPassStepDetails.toBuilder() : null;
        }

        public final void setRoundaboutPassStepDetails(RouteRoundaboutPassStepDetails.BuilderImpl roundaboutPassStepDetails) {
            this.roundaboutPassStepDetails = roundaboutPassStepDetails != null ? roundaboutPassStepDetails.build() : null;
        }

        @Override
        public final Builder roundaboutPassStepDetails(RouteRoundaboutPassStepDetails roundaboutPassStepDetails) {
            this.roundaboutPassStepDetails = roundaboutPassStepDetails;
            return this;
        }

        public final RouteSignpost.Builder getSignpost() {
            return signpost != null ? signpost.toBuilder() : null;
        }

        public final void setSignpost(RouteSignpost.BuilderImpl signpost) {
            this.signpost = signpost != null ? signpost.build() : null;
        }

        @Override
        public final Builder signpost(RouteSignpost signpost) {
            this.signpost = signpost;
            return this;
        }

        public final RouteTurnStepDetails.Builder getTurnStepDetails() {
            return turnStepDetails != null ? turnStepDetails.toBuilder() : null;
        }

        public final void setTurnStepDetails(RouteTurnStepDetails.BuilderImpl turnStepDetails) {
            this.turnStepDetails = turnStepDetails != null ? turnStepDetails.build() : null;
        }

        @Override
        public final Builder turnStepDetails(RouteTurnStepDetails turnStepDetails) {
            this.turnStepDetails = turnStepDetails;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteVehicleTravelStepType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final RouteUTurnStepDetails.Builder getUTurnStepDetails() {
            return uTurnStepDetails != null ? uTurnStepDetails.toBuilder() : null;
        }

        public final void setUTurnStepDetails(RouteUTurnStepDetails.BuilderImpl uTurnStepDetails) {
            this.uTurnStepDetails = uTurnStepDetails != null ? uTurnStepDetails.build() : null;
        }

        @Override
        public final Builder uTurnStepDetails(RouteUTurnStepDetails uTurnStepDetails) {
            this.uTurnStepDetails = uTurnStepDetails;
            return this;
        }

        @Override
        public RouteVehicleTravelStep build() {
            return new RouteVehicleTravelStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
