/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapToRoadsResponse extends GeoRoutesResponse implements
        ToCopyableBuilder<SnapToRoadsResponse.Builder, SnapToRoadsResponse> {
    private static final SdkField<List<RoadSnapNotice>> NOTICES_FIELD = SdkField
            .<List<RoadSnapNotice>> builder(MarshallingType.LIST)
            .memberName("Notices")
            .getter(getter(SnapToRoadsResponse::notices))
            .setter(setter(Builder::notices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoadSnapNotice> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoadSnapNotice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(SnapToRoadsResponse::pricingBucket))
            .setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<RoadSnapSnappedGeometry> SNAPPED_GEOMETRY_FIELD = SdkField
            .<RoadSnapSnappedGeometry> builder(MarshallingType.SDK_POJO).memberName("SnappedGeometry")
            .getter(getter(SnapToRoadsResponse::snappedGeometry)).setter(setter(Builder::snappedGeometry))
            .constructor(RoadSnapSnappedGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedGeometry").build()).build();

    private static final SdkField<String> SNAPPED_GEOMETRY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnappedGeometryFormat").getter(getter(SnapToRoadsResponse::snappedGeometryFormatAsString))
            .setter(setter(Builder::snappedGeometryFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedGeometryFormat").build())
            .build();

    private static final SdkField<List<RoadSnapSnappedTracePoint>> SNAPPED_TRACE_POINTS_FIELD = SdkField
            .<List<RoadSnapSnappedTracePoint>> builder(MarshallingType.LIST)
            .memberName("SnappedTracePoints")
            .getter(getter(SnapToRoadsResponse::snappedTracePoints))
            .setter(setter(Builder::snappedTracePoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedTracePoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoadSnapSnappedTracePoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoadSnapSnappedTracePoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTICES_FIELD,
            PRICING_BUCKET_FIELD, SNAPPED_GEOMETRY_FIELD, SNAPPED_GEOMETRY_FORMAT_FIELD, SNAPPED_TRACE_POINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RoadSnapNotice> notices;

    private final String pricingBucket;

    private final RoadSnapSnappedGeometry snappedGeometry;

    private final String snappedGeometryFormat;

    private final List<RoadSnapSnappedTracePoint> snappedTracePoints;

    private SnapToRoadsResponse(BuilderImpl builder) {
        super(builder);
        this.notices = builder.notices;
        this.pricingBucket = builder.pricingBucket;
        this.snappedGeometry = builder.snappedGeometry;
        this.snappedGeometryFormat = builder.snappedGeometryFormat;
        this.snappedTracePoints = builder.snappedTracePoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotices() {
        return notices != null && !(notices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Notices are additional information returned that indicate issues that occurred during route calculation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotices} method.
     * </p>
     * 
     * @return Notices are additional information returned that indicate issues that occurred during route calculation.
     */
    public final List<RoadSnapNotice> notices() {
        return notices;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * <p>
     * The interpolated geometry for the snapped route onto the road network.
     * </p>
     * 
     * @return The interpolated geometry for the snapped route onto the road network.
     */
    public final RoadSnapSnappedGeometry snappedGeometry() {
        return snappedGeometry;
    }

    /**
     * <p>
     * Specifies the format of the geometry returned for each leg of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snappedGeometryFormat} will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #snappedGeometryFormatAsString}.
     * </p>
     * 
     * @return Specifies the format of the geometry returned for each leg of the route.
     * @see GeometryFormat
     */
    public final GeometryFormat snappedGeometryFormat() {
        return GeometryFormat.fromValue(snappedGeometryFormat);
    }

    /**
     * <p>
     * Specifies the format of the geometry returned for each leg of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snappedGeometryFormat} will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #snappedGeometryFormatAsString}.
     * </p>
     * 
     * @return Specifies the format of the geometry returned for each leg of the route.
     * @see GeometryFormat
     */
    public final String snappedGeometryFormatAsString() {
        return snappedGeometryFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnappedTracePoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnappedTracePoints() {
        return snappedTracePoints != null && !(snappedTracePoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The trace points snapped onto the road network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnappedTracePoints} method.
     * </p>
     * 
     * @return The trace points snapped onto the road network.
     */
    public final List<RoadSnapSnappedTracePoint> snappedTracePoints() {
        return snappedTracePoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNotices() ? notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(snappedGeometry());
        hashCode = 31 * hashCode + Objects.hashCode(snappedGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnappedTracePoints() ? snappedTracePoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapToRoadsResponse)) {
            return false;
        }
        SnapToRoadsResponse other = (SnapToRoadsResponse) obj;
        return hasNotices() == other.hasNotices() && Objects.equals(notices(), other.notices())
                && Objects.equals(pricingBucket(), other.pricingBucket())
                && Objects.equals(snappedGeometry(), other.snappedGeometry())
                && Objects.equals(snappedGeometryFormatAsString(), other.snappedGeometryFormatAsString())
                && hasSnappedTracePoints() == other.hasSnappedTracePoints()
                && Objects.equals(snappedTracePoints(), other.snappedTracePoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapToRoadsResponse").add("Notices", hasNotices() ? notices() : null)
                .add("PricingBucket", pricingBucket()).add("SnappedGeometry", snappedGeometry())
                .add("SnappedGeometryFormat", snappedGeometryFormatAsString())
                .add("SnappedTracePoints", hasSnappedTracePoints() ? snappedTracePoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Notices":
            return Optional.ofNullable(clazz.cast(notices()));
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "SnappedGeometry":
            return Optional.ofNullable(clazz.cast(snappedGeometry()));
        case "SnappedGeometryFormat":
            return Optional.ofNullable(clazz.cast(snappedGeometryFormatAsString()));
        case "SnappedTracePoints":
            return Optional.ofNullable(clazz.cast(snappedTracePoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Notices", NOTICES_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("SnappedGeometry", SNAPPED_GEOMETRY_FIELD);
        map.put("SnappedGeometryFormat", SNAPPED_GEOMETRY_FORMAT_FIELD);
        map.put("SnappedTracePoints", SNAPPED_TRACE_POINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapToRoadsResponse, T> g) {
        return obj -> g.apply((SnapToRoadsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GeoRoutesResponse.Builder, SdkPojo, CopyableBuilder<Builder, SnapToRoadsResponse> {
        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(Collection<RoadSnapNotice> notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(RoadSnapNotice... notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoadSnapNotice.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.RoadSnapNotice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoadSnapNotice.Builder#build()} is called immediately
         * and its result is passed to {@link #notices(List<RoadSnapNotice>)}.
         * 
         * @param notices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoadSnapNotice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notices(java.util.Collection<RoadSnapNotice>)
         */
        Builder notices(Consumer<RoadSnapNotice.Builder>... notices);

        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * The interpolated geometry for the snapped route onto the road network.
         * </p>
         * 
         * @param snappedGeometry
         *        The interpolated geometry for the snapped route onto the road network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedGeometry(RoadSnapSnappedGeometry snappedGeometry);

        /**
         * <p>
         * The interpolated geometry for the snapped route onto the road network.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoadSnapSnappedGeometry.Builder} avoiding
         * the need to create one manually via {@link RoadSnapSnappedGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoadSnapSnappedGeometry.Builder#build()} is called immediately
         * and its result is passed to {@link #snappedGeometry(RoadSnapSnappedGeometry)}.
         * 
         * @param snappedGeometry
         *        a consumer that will call methods on {@link RoadSnapSnappedGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snappedGeometry(RoadSnapSnappedGeometry)
         */
        default Builder snappedGeometry(Consumer<RoadSnapSnappedGeometry.Builder> snappedGeometry) {
            return snappedGeometry(RoadSnapSnappedGeometry.builder().applyMutation(snappedGeometry).build());
        }

        /**
         * <p>
         * Specifies the format of the geometry returned for each leg of the route.
         * </p>
         * 
         * @param snappedGeometryFormat
         *        Specifies the format of the geometry returned for each leg of the route.
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder snappedGeometryFormat(String snappedGeometryFormat);

        /**
         * <p>
         * Specifies the format of the geometry returned for each leg of the route.
         * </p>
         * 
         * @param snappedGeometryFormat
         *        Specifies the format of the geometry returned for each leg of the route.
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder snappedGeometryFormat(GeometryFormat snappedGeometryFormat);

        /**
         * <p>
         * The trace points snapped onto the road network.
         * </p>
         * 
         * @param snappedTracePoints
         *        The trace points snapped onto the road network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedTracePoints(Collection<RoadSnapSnappedTracePoint> snappedTracePoints);

        /**
         * <p>
         * The trace points snapped onto the road network.
         * </p>
         * 
         * @param snappedTracePoints
         *        The trace points snapped onto the road network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedTracePoints(RoadSnapSnappedTracePoint... snappedTracePoints);

        /**
         * <p>
         * The trace points snapped onto the road network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoadSnapSnappedTracePoint.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RoadSnapSnappedTracePoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoadSnapSnappedTracePoint.Builder#build()} is called
         * immediately and its result is passed to {@link #snappedTracePoints(List<RoadSnapSnappedTracePoint>)}.
         * 
         * @param snappedTracePoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoadSnapSnappedTracePoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snappedTracePoints(java.util.Collection<RoadSnapSnappedTracePoint>)
         */
        Builder snappedTracePoints(Consumer<RoadSnapSnappedTracePoint.Builder>... snappedTracePoints);
    }

    static final class BuilderImpl extends GeoRoutesResponse.BuilderImpl implements Builder {
        private List<RoadSnapNotice> notices = DefaultSdkAutoConstructList.getInstance();

        private String pricingBucket;

        private RoadSnapSnappedGeometry snappedGeometry;

        private String snappedGeometryFormat;

        private List<RoadSnapSnappedTracePoint> snappedTracePoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapToRoadsResponse model) {
            super(model);
            notices(model.notices);
            pricingBucket(model.pricingBucket);
            snappedGeometry(model.snappedGeometry);
            snappedGeometryFormat(model.snappedGeometryFormat);
            snappedTracePoints(model.snappedTracePoints);
        }

        public final List<RoadSnapNotice.Builder> getNotices() {
            List<RoadSnapNotice.Builder> result = RoadSnapNoticeListCopier.copyToBuilder(this.notices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotices(Collection<RoadSnapNotice.BuilderImpl> notices) {
            this.notices = RoadSnapNoticeListCopier.copyFromBuilder(notices);
        }

        @Override
        public final Builder notices(Collection<RoadSnapNotice> notices) {
            this.notices = RoadSnapNoticeListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(RoadSnapNotice... notices) {
            notices(Arrays.asList(notices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Consumer<RoadSnapNotice.Builder>... notices) {
            notices(Stream.of(notices).map(c -> RoadSnapNotice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final RoadSnapSnappedGeometry.Builder getSnappedGeometry() {
            return snappedGeometry != null ? snappedGeometry.toBuilder() : null;
        }

        public final void setSnappedGeometry(RoadSnapSnappedGeometry.BuilderImpl snappedGeometry) {
            this.snappedGeometry = snappedGeometry != null ? snappedGeometry.build() : null;
        }

        @Override
        public final Builder snappedGeometry(RoadSnapSnappedGeometry snappedGeometry) {
            this.snappedGeometry = snappedGeometry;
            return this;
        }

        public final String getSnappedGeometryFormat() {
            return snappedGeometryFormat;
        }

        public final void setSnappedGeometryFormat(String snappedGeometryFormat) {
            this.snappedGeometryFormat = snappedGeometryFormat;
        }

        @Override
        public final Builder snappedGeometryFormat(String snappedGeometryFormat) {
            this.snappedGeometryFormat = snappedGeometryFormat;
            return this;
        }

        @Override
        public final Builder snappedGeometryFormat(GeometryFormat snappedGeometryFormat) {
            this.snappedGeometryFormat(snappedGeometryFormat == null ? null : snappedGeometryFormat.toString());
            return this;
        }

        public final List<RoadSnapSnappedTracePoint.Builder> getSnappedTracePoints() {
            List<RoadSnapSnappedTracePoint.Builder> result = RoadSnapSnappedTracePointListCopier
                    .copyToBuilder(this.snappedTracePoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnappedTracePoints(Collection<RoadSnapSnappedTracePoint.BuilderImpl> snappedTracePoints) {
            this.snappedTracePoints = RoadSnapSnappedTracePointListCopier.copyFromBuilder(snappedTracePoints);
        }

        @Override
        public final Builder snappedTracePoints(Collection<RoadSnapSnappedTracePoint> snappedTracePoints) {
            this.snappedTracePoints = RoadSnapSnappedTracePointListCopier.copy(snappedTracePoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedTracePoints(RoadSnapSnappedTracePoint... snappedTracePoints) {
            snappedTracePoints(Arrays.asList(snappedTracePoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedTracePoints(Consumer<RoadSnapSnappedTracePoint.Builder>... snappedTracePoints) {
            snappedTracePoints(Stream.of(snappedTracePoints)
                    .map(c -> RoadSnapSnappedTracePoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapToRoadsResponse build() {
            return new SnapToRoadsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
