/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The area to be avoided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationAvoidanceArea implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationAvoidanceArea.Builder, WaypointOptimizationAvoidanceArea> {
    private static final SdkField<WaypointOptimizationAvoidanceAreaGeometry> GEOMETRY_FIELD = SdkField
            .<WaypointOptimizationAvoidanceAreaGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry")
            .getter(getter(WaypointOptimizationAvoidanceArea::geometry)).setter(setter(Builder::geometry))
            .constructor(WaypointOptimizationAvoidanceAreaGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEOMETRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WaypointOptimizationAvoidanceAreaGeometry geometry;

    private WaypointOptimizationAvoidanceArea(BuilderImpl builder) {
        this.geometry = builder.geometry;
    }

    /**
     * <p>
     * Geometry of the area to be avoided.
     * </p>
     * 
     * @return Geometry of the area to be avoided.
     */
    public final WaypointOptimizationAvoidanceAreaGeometry geometry() {
        return geometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationAvoidanceArea)) {
            return false;
        }
        WaypointOptimizationAvoidanceArea other = (WaypointOptimizationAvoidanceArea) obj;
        return Objects.equals(geometry(), other.geometry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationAvoidanceArea").add("Geometry", geometry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Geometry", GEOMETRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationAvoidanceArea, T> g) {
        return obj -> g.apply((WaypointOptimizationAvoidanceArea) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationAvoidanceArea> {
        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * 
         * @param geometry
         *        Geometry of the area to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(WaypointOptimizationAvoidanceAreaGeometry geometry);

        /**
         * <p>
         * Geometry of the area to be avoided.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationAvoidanceAreaGeometry.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationAvoidanceAreaGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationAvoidanceAreaGeometry.Builder#build()} is
         * called immediately and its result is passed to {@link #geometry(WaypointOptimizationAvoidanceAreaGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link WaypointOptimizationAvoidanceAreaGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(WaypointOptimizationAvoidanceAreaGeometry)
         */
        default Builder geometry(Consumer<WaypointOptimizationAvoidanceAreaGeometry.Builder> geometry) {
            return geometry(WaypointOptimizationAvoidanceAreaGeometry.builder().applyMutation(geometry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WaypointOptimizationAvoidanceAreaGeometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationAvoidanceArea model) {
            geometry(model.geometry);
        }

        public final WaypointOptimizationAvoidanceAreaGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(WaypointOptimizationAvoidanceAreaGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(WaypointOptimizationAvoidanceAreaGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        @Override
        public WaypointOptimizationAvoidanceArea build() {
            return new WaypointOptimizationAvoidanceArea(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
