/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies options for areas to avoid. This is a best-effort avoidance setting, meaning the router will try to honor
 * the avoidance preferences but may still include restricted areas if no feasible alternative route exists. If
 * avoidance options are not followed, the response will indicate that the avoidance criteria were violated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationAvoidanceOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationAvoidanceOptions.Builder, WaypointOptimizationAvoidanceOptions> {
    private static final SdkField<List<WaypointOptimizationAvoidanceArea>> AREAS_FIELD = SdkField
            .<List<WaypointOptimizationAvoidanceArea>> builder(MarshallingType.LIST)
            .memberName("Areas")
            .getter(getter(WaypointOptimizationAvoidanceOptions::areas))
            .setter(setter(Builder::areas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Areas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WaypointOptimizationAvoidanceArea> builder(MarshallingType.SDK_POJO)
                                            .constructor(WaypointOptimizationAvoidanceArea::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CAR_SHUTTLE_TRAINS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CarShuttleTrains").getter(getter(WaypointOptimizationAvoidanceOptions::carShuttleTrains))
            .setter(setter(Builder::carShuttleTrains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarShuttleTrains").build()).build();

    private static final SdkField<Boolean> CONTROLLED_ACCESS_HIGHWAYS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ControlledAccessHighways")
            .getter(getter(WaypointOptimizationAvoidanceOptions::controlledAccessHighways))
            .setter(setter(Builder::controlledAccessHighways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlledAccessHighways").build())
            .build();

    private static final SdkField<Boolean> DIRT_ROADS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DirtRoads").getter(getter(WaypointOptimizationAvoidanceOptions::dirtRoads))
            .setter(setter(Builder::dirtRoads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirtRoads").build()).build();

    private static final SdkField<Boolean> FERRIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Ferries").getter(getter(WaypointOptimizationAvoidanceOptions::ferries)).setter(setter(Builder::ferries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ferries").build()).build();

    private static final SdkField<Boolean> TOLL_ROADS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TollRoads").getter(getter(WaypointOptimizationAvoidanceOptions::tollRoads))
            .setter(setter(Builder::tollRoads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollRoads").build()).build();

    private static final SdkField<Boolean> TUNNELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Tunnels").getter(getter(WaypointOptimizationAvoidanceOptions::tunnels)).setter(setter(Builder::tunnels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tunnels").build()).build();

    private static final SdkField<Boolean> U_TURNS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UTurns").getter(getter(WaypointOptimizationAvoidanceOptions::uTurns)).setter(setter(Builder::uTurns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UTurns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREAS_FIELD,
            CAR_SHUTTLE_TRAINS_FIELD, CONTROLLED_ACCESS_HIGHWAYS_FIELD, DIRT_ROADS_FIELD, FERRIES_FIELD, TOLL_ROADS_FIELD,
            TUNNELS_FIELD, U_TURNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<WaypointOptimizationAvoidanceArea> areas;

    private final Boolean carShuttleTrains;

    private final Boolean controlledAccessHighways;

    private final Boolean dirtRoads;

    private final Boolean ferries;

    private final Boolean tollRoads;

    private final Boolean tunnels;

    private final Boolean uTurns;

    private WaypointOptimizationAvoidanceOptions(BuilderImpl builder) {
        this.areas = builder.areas;
        this.carShuttleTrains = builder.carShuttleTrains;
        this.controlledAccessHighways = builder.controlledAccessHighways;
        this.dirtRoads = builder.dirtRoads;
        this.ferries = builder.ferries;
        this.tollRoads = builder.tollRoads;
        this.tunnels = builder.tunnels;
        this.uTurns = builder.uTurns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Areas property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAreas() {
        return areas != null && !(areas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Areas to be avoided.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAreas} method.
     * </p>
     * 
     * @return Areas to be avoided.
     */
    public final List<WaypointOptimizationAvoidanceArea> areas() {
        return areas;
    }

    /**
     * <p>
     * Avoidance options for cars-shuttles-trains.
     * </p>
     * 
     * @return Avoidance options for cars-shuttles-trains.
     */
    public final Boolean carShuttleTrains() {
        return carShuttleTrains;
    }

    /**
     * <p>
     * Avoid controlled access highways while calculating the route.
     * </p>
     * 
     * @return Avoid controlled access highways while calculating the route.
     */
    public final Boolean controlledAccessHighways() {
        return controlledAccessHighways;
    }

    /**
     * <p>
     * Avoid dirt roads while calculating the route.
     * </p>
     * 
     * @return Avoid dirt roads while calculating the route.
     */
    public final Boolean dirtRoads() {
        return dirtRoads;
    }

    /**
     * <p>
     * Avoidance options for ferries.
     * </p>
     * 
     * @return Avoidance options for ferries.
     */
    public final Boolean ferries() {
        return ferries;
    }

    /**
     * <p>
     * Avoids roads where the specified toll transponders are the only mode of payment.
     * </p>
     * 
     * @return Avoids roads where the specified toll transponders are the only mode of payment.
     */
    public final Boolean tollRoads() {
        return tollRoads;
    }

    /**
     * <p>
     * Avoid tunnels while calculating the route.
     * </p>
     * 
     * @return Avoid tunnels while calculating the route.
     */
    public final Boolean tunnels() {
        return tunnels;
    }

    /**
     * <p>
     * Avoid U-turns for calculation on highways and motorways.
     * </p>
     * 
     * @return Avoid U-turns for calculation on highways and motorways.
     */
    public final Boolean uTurns() {
        return uTurns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAreas() ? areas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(carShuttleTrains());
        hashCode = 31 * hashCode + Objects.hashCode(controlledAccessHighways());
        hashCode = 31 * hashCode + Objects.hashCode(dirtRoads());
        hashCode = 31 * hashCode + Objects.hashCode(ferries());
        hashCode = 31 * hashCode + Objects.hashCode(tollRoads());
        hashCode = 31 * hashCode + Objects.hashCode(tunnels());
        hashCode = 31 * hashCode + Objects.hashCode(uTurns());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationAvoidanceOptions)) {
            return false;
        }
        WaypointOptimizationAvoidanceOptions other = (WaypointOptimizationAvoidanceOptions) obj;
        return hasAreas() == other.hasAreas() && Objects.equals(areas(), other.areas())
                && Objects.equals(carShuttleTrains(), other.carShuttleTrains())
                && Objects.equals(controlledAccessHighways(), other.controlledAccessHighways())
                && Objects.equals(dirtRoads(), other.dirtRoads()) && Objects.equals(ferries(), other.ferries())
                && Objects.equals(tollRoads(), other.tollRoads()) && Objects.equals(tunnels(), other.tunnels())
                && Objects.equals(uTurns(), other.uTurns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationAvoidanceOptions").add("Areas", hasAreas() ? areas() : null)
                .add("CarShuttleTrains", carShuttleTrains()).add("ControlledAccessHighways", controlledAccessHighways())
                .add("DirtRoads", dirtRoads()).add("Ferries", ferries()).add("TollRoads", tollRoads()).add("Tunnels", tunnels())
                .add("UTurns", uTurns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Areas":
            return Optional.ofNullable(clazz.cast(areas()));
        case "CarShuttleTrains":
            return Optional.ofNullable(clazz.cast(carShuttleTrains()));
        case "ControlledAccessHighways":
            return Optional.ofNullable(clazz.cast(controlledAccessHighways()));
        case "DirtRoads":
            return Optional.ofNullable(clazz.cast(dirtRoads()));
        case "Ferries":
            return Optional.ofNullable(clazz.cast(ferries()));
        case "TollRoads":
            return Optional.ofNullable(clazz.cast(tollRoads()));
        case "Tunnels":
            return Optional.ofNullable(clazz.cast(tunnels()));
        case "UTurns":
            return Optional.ofNullable(clazz.cast(uTurns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Areas", AREAS_FIELD);
        map.put("CarShuttleTrains", CAR_SHUTTLE_TRAINS_FIELD);
        map.put("ControlledAccessHighways", CONTROLLED_ACCESS_HIGHWAYS_FIELD);
        map.put("DirtRoads", DIRT_ROADS_FIELD);
        map.put("Ferries", FERRIES_FIELD);
        map.put("TollRoads", TOLL_ROADS_FIELD);
        map.put("Tunnels", TUNNELS_FIELD);
        map.put("UTurns", U_TURNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationAvoidanceOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationAvoidanceOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationAvoidanceOptions> {
        /**
         * <p>
         * Areas to be avoided.
         * </p>
         * 
         * @param areas
         *        Areas to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areas(Collection<WaypointOptimizationAvoidanceArea> areas);

        /**
         * <p>
         * Areas to be avoided.
         * </p>
         * 
         * @param areas
         *        Areas to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areas(WaypointOptimizationAvoidanceArea... areas);

        /**
         * <p>
         * Areas to be avoided.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAvoidanceArea.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAvoidanceArea#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAvoidanceArea.Builder#build()} is
         * called immediately and its result is passed to {@link #areas(List<WaypointOptimizationAvoidanceArea>)}.
         * 
         * @param areas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAvoidanceArea.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #areas(java.util.Collection<WaypointOptimizationAvoidanceArea>)
         */
        Builder areas(Consumer<WaypointOptimizationAvoidanceArea.Builder>... areas);

        /**
         * <p>
         * Avoidance options for cars-shuttles-trains.
         * </p>
         * 
         * @param carShuttleTrains
         *        Avoidance options for cars-shuttles-trains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carShuttleTrains(Boolean carShuttleTrains);

        /**
         * <p>
         * Avoid controlled access highways while calculating the route.
         * </p>
         * 
         * @param controlledAccessHighways
         *        Avoid controlled access highways while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlledAccessHighways(Boolean controlledAccessHighways);

        /**
         * <p>
         * Avoid dirt roads while calculating the route.
         * </p>
         * 
         * @param dirtRoads
         *        Avoid dirt roads while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dirtRoads(Boolean dirtRoads);

        /**
         * <p>
         * Avoidance options for ferries.
         * </p>
         * 
         * @param ferries
         *        Avoidance options for ferries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ferries(Boolean ferries);

        /**
         * <p>
         * Avoids roads where the specified toll transponders are the only mode of payment.
         * </p>
         * 
         * @param tollRoads
         *        Avoids roads where the specified toll transponders are the only mode of payment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollRoads(Boolean tollRoads);

        /**
         * <p>
         * Avoid tunnels while calculating the route.
         * </p>
         * 
         * @param tunnels
         *        Avoid tunnels while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnels(Boolean tunnels);

        /**
         * <p>
         * Avoid U-turns for calculation on highways and motorways.
         * </p>
         * 
         * @param uTurns
         *        Avoid U-turns for calculation on highways and motorways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uTurns(Boolean uTurns);
    }

    static final class BuilderImpl implements Builder {
        private List<WaypointOptimizationAvoidanceArea> areas = DefaultSdkAutoConstructList.getInstance();

        private Boolean carShuttleTrains;

        private Boolean controlledAccessHighways;

        private Boolean dirtRoads;

        private Boolean ferries;

        private Boolean tollRoads;

        private Boolean tunnels;

        private Boolean uTurns;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationAvoidanceOptions model) {
            areas(model.areas);
            carShuttleTrains(model.carShuttleTrains);
            controlledAccessHighways(model.controlledAccessHighways);
            dirtRoads(model.dirtRoads);
            ferries(model.ferries);
            tollRoads(model.tollRoads);
            tunnels(model.tunnels);
            uTurns(model.uTurns);
        }

        public final List<WaypointOptimizationAvoidanceArea.Builder> getAreas() {
            List<WaypointOptimizationAvoidanceArea.Builder> result = WaypointOptimizationAvoidanceOptionsAreasListCopier
                    .copyToBuilder(this.areas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAreas(Collection<WaypointOptimizationAvoidanceArea.BuilderImpl> areas) {
            this.areas = WaypointOptimizationAvoidanceOptionsAreasListCopier.copyFromBuilder(areas);
        }

        @Override
        public final Builder areas(Collection<WaypointOptimizationAvoidanceArea> areas) {
            this.areas = WaypointOptimizationAvoidanceOptionsAreasListCopier.copy(areas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder areas(WaypointOptimizationAvoidanceArea... areas) {
            areas(Arrays.asList(areas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder areas(Consumer<WaypointOptimizationAvoidanceArea.Builder>... areas) {
            areas(Stream.of(areas).map(c -> WaypointOptimizationAvoidanceArea.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCarShuttleTrains() {
            return carShuttleTrains;
        }

        public final void setCarShuttleTrains(Boolean carShuttleTrains) {
            this.carShuttleTrains = carShuttleTrains;
        }

        @Override
        public final Builder carShuttleTrains(Boolean carShuttleTrains) {
            this.carShuttleTrains = carShuttleTrains;
            return this;
        }

        public final Boolean getControlledAccessHighways() {
            return controlledAccessHighways;
        }

        public final void setControlledAccessHighways(Boolean controlledAccessHighways) {
            this.controlledAccessHighways = controlledAccessHighways;
        }

        @Override
        public final Builder controlledAccessHighways(Boolean controlledAccessHighways) {
            this.controlledAccessHighways = controlledAccessHighways;
            return this;
        }

        public final Boolean getDirtRoads() {
            return dirtRoads;
        }

        public final void setDirtRoads(Boolean dirtRoads) {
            this.dirtRoads = dirtRoads;
        }

        @Override
        public final Builder dirtRoads(Boolean dirtRoads) {
            this.dirtRoads = dirtRoads;
            return this;
        }

        public final Boolean getFerries() {
            return ferries;
        }

        public final void setFerries(Boolean ferries) {
            this.ferries = ferries;
        }

        @Override
        public final Builder ferries(Boolean ferries) {
            this.ferries = ferries;
            return this;
        }

        public final Boolean getTollRoads() {
            return tollRoads;
        }

        public final void setTollRoads(Boolean tollRoads) {
            this.tollRoads = tollRoads;
        }

        @Override
        public final Builder tollRoads(Boolean tollRoads) {
            this.tollRoads = tollRoads;
            return this;
        }

        public final Boolean getTunnels() {
            return tunnels;
        }

        public final void setTunnels(Boolean tunnels) {
            this.tunnels = tunnels;
        }

        @Override
        public final Builder tunnels(Boolean tunnels) {
            this.tunnels = tunnels;
            return this;
        }

        public final Boolean getUTurns() {
            return uTurns;
        }

        public final void setUTurns(Boolean uTurns) {
            this.uTurns = uTurns;
        }

        @Override
        public final Builder uTurns(Boolean uTurns) {
            this.uTurns = uTurns;
            return this;
        }

        @Override
        public WaypointOptimizationAvoidanceOptions build() {
            return new WaypointOptimizationAvoidanceOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
