/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Driving distance related options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationDrivingDistanceOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationDrivingDistanceOptions.Builder, WaypointOptimizationDrivingDistanceOptions> {
    private static final SdkField<Long> DRIVING_DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DrivingDistance").getter(getter(WaypointOptimizationDrivingDistanceOptions::drivingDistance))
            .setter(setter(Builder::drivingDistance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrivingDistance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRIVING_DISTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long drivingDistance;

    private WaypointOptimizationDrivingDistanceOptions(BuilderImpl builder) {
        this.drivingDistance = builder.drivingDistance;
    }

    /**
     * <p>
     * DrivingDistance assigns all the waypoints that are within driving distance of each other into a single cluster.
     * </p>
     * 
     * @return DrivingDistance assigns all the waypoints that are within driving distance of each other into a single
     *         cluster.
     */
    public final Long drivingDistance() {
        return drivingDistance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(drivingDistance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationDrivingDistanceOptions)) {
            return false;
        }
        WaypointOptimizationDrivingDistanceOptions other = (WaypointOptimizationDrivingDistanceOptions) obj;
        return Objects.equals(drivingDistance(), other.drivingDistance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationDrivingDistanceOptions").add("DrivingDistance", drivingDistance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DrivingDistance":
            return Optional.ofNullable(clazz.cast(drivingDistance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DrivingDistance", DRIVING_DISTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationDrivingDistanceOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationDrivingDistanceOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationDrivingDistanceOptions> {
        /**
         * <p>
         * DrivingDistance assigns all the waypoints that are within driving distance of each other into a single
         * cluster.
         * </p>
         * 
         * @param drivingDistance
         *        DrivingDistance assigns all the waypoints that are within driving distance of each other into a single
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder drivingDistance(Long drivingDistance);
    }

    static final class BuilderImpl implements Builder {
        private Long drivingDistance;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationDrivingDistanceOptions model) {
            drivingDistance(model.drivingDistance);
        }

        public final Long getDrivingDistance() {
            return drivingDistance;
        }

        public final void setDrivingDistance(Long drivingDistance) {
            this.drivingDistance = drivingDistance;
        }

        @Override
        public final Builder drivingDistance(Long drivingDistance) {
            this.drivingDistance = drivingDistance;
            return this;
        }

        @Override
        public WaypointOptimizationDrivingDistanceOptions build() {
            return new WaypointOptimizationDrivingDistanceOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
