/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Driver work-rest schedules defined by a short and long cycle. A rest needs to be taken after the short work duration.
 * The short cycle can be repeated until you hit the long work duration, at which point the long rest duration should be
 * taken before restarting.
 * </p>
 * <p>
 * <b>Unit</b>: <code>seconds</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationRestCycleDurations implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationRestCycleDurations.Builder, WaypointOptimizationRestCycleDurations> {
    private static final SdkField<Long> REST_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RestDuration").getter(getter(WaypointOptimizationRestCycleDurations::restDuration))
            .setter(setter(Builder::restDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestDuration").build()).build();

    private static final SdkField<Long> WORK_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WorkDuration").getter(getter(WaypointOptimizationRestCycleDurations::workDuration))
            .setter(setter(Builder::workDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_DURATION_FIELD,
            WORK_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long restDuration;

    private final Long workDuration;

    private WaypointOptimizationRestCycleDurations(BuilderImpl builder) {
        this.restDuration = builder.restDuration;
        this.workDuration = builder.workDuration;
    }

    /**
     * <p>
     * Resting phase of the cycle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Resting phase of the cycle.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long restDuration() {
        return restDuration;
    }

    /**
     * <p>
     * Working phase of the cycle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Working phase of the cycle.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long workDuration() {
        return workDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restDuration());
        hashCode = 31 * hashCode + Objects.hashCode(workDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationRestCycleDurations)) {
            return false;
        }
        WaypointOptimizationRestCycleDurations other = (WaypointOptimizationRestCycleDurations) obj;
        return Objects.equals(restDuration(), other.restDuration()) && Objects.equals(workDuration(), other.workDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationRestCycleDurations").add("RestDuration", restDuration())
                .add("WorkDuration", workDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestDuration":
            return Optional.ofNullable(clazz.cast(restDuration()));
        case "WorkDuration":
            return Optional.ofNullable(clazz.cast(workDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestDuration", REST_DURATION_FIELD);
        map.put("WorkDuration", WORK_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationRestCycleDurations, T> g) {
        return obj -> g.apply((WaypointOptimizationRestCycleDurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationRestCycleDurations> {
        /**
         * <p>
         * Resting phase of the cycle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param restDuration
         *        Resting phase of the cycle.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restDuration(Long restDuration);

        /**
         * <p>
         * Working phase of the cycle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param workDuration
         *        Working phase of the cycle.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workDuration(Long workDuration);
    }

    static final class BuilderImpl implements Builder {
        private Long restDuration;

        private Long workDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationRestCycleDurations model) {
            restDuration(model.restDuration);
            workDuration(model.workDuration);
        }

        public final Long getRestDuration() {
            return restDuration;
        }

        public final void setRestDuration(Long restDuration) {
            this.restDuration = restDuration;
        }

        @Override
        public final Builder restDuration(Long restDuration) {
            this.restDuration = restDuration;
            return this;
        }

        public final Long getWorkDuration() {
            return workDuration;
        }

        public final void setWorkDuration(Long workDuration) {
            this.workDuration = workDuration;
        }

        @Override
        public final Builder workDuration(Long workDuration) {
            this.workDuration = workDuration;
            return this;
        }

        @Override
        public WaypointOptimizationRestCycleDurations build() {
            return new WaypointOptimizationRestCycleDurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
