/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Time breakdown for the sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationTimeBreakdown implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationTimeBreakdown.Builder, WaypointOptimizationTimeBreakdown> {
    private static final SdkField<Long> REST_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RestDuration").getter(getter(WaypointOptimizationTimeBreakdown::restDuration))
            .setter(setter(Builder::restDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestDuration").build()).build();

    private static final SdkField<Long> SERVICE_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ServiceDuration").getter(getter(WaypointOptimizationTimeBreakdown::serviceDuration))
            .setter(setter(Builder::serviceDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDuration").build()).build();

    private static final SdkField<Long> TRAVEL_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TravelDuration").getter(getter(WaypointOptimizationTimeBreakdown::travelDuration))
            .setter(setter(Builder::travelDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelDuration").build()).build();

    private static final SdkField<Long> WAIT_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WaitDuration").getter(getter(WaypointOptimizationTimeBreakdown::waitDuration))
            .setter(setter(Builder::waitDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_DURATION_FIELD,
            SERVICE_DURATION_FIELD, TRAVEL_DURATION_FIELD, WAIT_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long restDuration;

    private final Long serviceDuration;

    private final Long travelDuration;

    private final Long waitDuration;

    private WaypointOptimizationTimeBreakdown(BuilderImpl builder) {
        this.restDuration = builder.restDuration;
        this.serviceDuration = builder.serviceDuration;
        this.travelDuration = builder.travelDuration;
        this.waitDuration = builder.waitDuration;
    }

    /**
     * <p>
     * Resting phase of the cycle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Resting phase of the cycle.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long restDuration() {
        return restDuration;
    }

    /**
     * <p>
     * Service time spent at the destination. At an appointment, the service time should be the appointment duration.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Service time spent at the destination. At an appointment, the service time should be the appointment
     *         duration.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long serviceDuration() {
        return serviceDuration;
    }

    /**
     * <p>
     * Traveling phase of the cycle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Traveling phase of the cycle.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long travelDuration() {
        return travelDuration;
    }

    /**
     * <p>
     * Waiting phase of the cycle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Waiting phase of the cycle.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long waitDuration() {
        return waitDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restDuration());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDuration());
        hashCode = 31 * hashCode + Objects.hashCode(travelDuration());
        hashCode = 31 * hashCode + Objects.hashCode(waitDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationTimeBreakdown)) {
            return false;
        }
        WaypointOptimizationTimeBreakdown other = (WaypointOptimizationTimeBreakdown) obj;
        return Objects.equals(restDuration(), other.restDuration()) && Objects.equals(serviceDuration(), other.serviceDuration())
                && Objects.equals(travelDuration(), other.travelDuration())
                && Objects.equals(waitDuration(), other.waitDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationTimeBreakdown").add("RestDuration", restDuration())
                .add("ServiceDuration", serviceDuration()).add("TravelDuration", travelDuration())
                .add("WaitDuration", waitDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestDuration":
            return Optional.ofNullable(clazz.cast(restDuration()));
        case "ServiceDuration":
            return Optional.ofNullable(clazz.cast(serviceDuration()));
        case "TravelDuration":
            return Optional.ofNullable(clazz.cast(travelDuration()));
        case "WaitDuration":
            return Optional.ofNullable(clazz.cast(waitDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestDuration", REST_DURATION_FIELD);
        map.put("ServiceDuration", SERVICE_DURATION_FIELD);
        map.put("TravelDuration", TRAVEL_DURATION_FIELD);
        map.put("WaitDuration", WAIT_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationTimeBreakdown, T> g) {
        return obj -> g.apply((WaypointOptimizationTimeBreakdown) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationTimeBreakdown> {
        /**
         * <p>
         * Resting phase of the cycle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param restDuration
         *        Resting phase of the cycle.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restDuration(Long restDuration);

        /**
         * <p>
         * Service time spent at the destination. At an appointment, the service time should be the appointment
         * duration.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param serviceDuration
         *        Service time spent at the destination. At an appointment, the service time should be the appointment
         *        duration.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDuration(Long serviceDuration);

        /**
         * <p>
         * Traveling phase of the cycle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param travelDuration
         *        Traveling phase of the cycle.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelDuration(Long travelDuration);

        /**
         * <p>
         * Waiting phase of the cycle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param waitDuration
         *        Waiting phase of the cycle.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitDuration(Long waitDuration);
    }

    static final class BuilderImpl implements Builder {
        private Long restDuration;

        private Long serviceDuration;

        private Long travelDuration;

        private Long waitDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationTimeBreakdown model) {
            restDuration(model.restDuration);
            serviceDuration(model.serviceDuration);
            travelDuration(model.travelDuration);
            waitDuration(model.waitDuration);
        }

        public final Long getRestDuration() {
            return restDuration;
        }

        public final void setRestDuration(Long restDuration) {
            this.restDuration = restDuration;
        }

        @Override
        public final Builder restDuration(Long restDuration) {
            this.restDuration = restDuration;
            return this;
        }

        public final Long getServiceDuration() {
            return serviceDuration;
        }

        public final void setServiceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
        }

        @Override
        public final Builder serviceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
            return this;
        }

        public final Long getTravelDuration() {
            return travelDuration;
        }

        public final void setTravelDuration(Long travelDuration) {
            this.travelDuration = travelDuration;
        }

        @Override
        public final Builder travelDuration(Long travelDuration) {
            this.travelDuration = travelDuration;
            return this;
        }

        public final Long getWaitDuration() {
            return waitDuration;
        }

        public final void setWaitDuration(Long waitDuration) {
            this.waitDuration = waitDuration;
        }

        @Override
        public final Builder waitDuration(Long waitDuration) {
            this.waitDuration = waitDuration;
            return this;
        }

        @Override
        public WaypointOptimizationTimeBreakdown build() {
            return new WaypointOptimizationTimeBreakdown(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
