/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Travel mode related options for the provided travel mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationTravelModeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationTravelModeOptions.Builder, WaypointOptimizationTravelModeOptions> {
    private static final SdkField<WaypointOptimizationPedestrianOptions> PEDESTRIAN_FIELD = SdkField
            .<WaypointOptimizationPedestrianOptions> builder(MarshallingType.SDK_POJO).memberName("Pedestrian")
            .getter(getter(WaypointOptimizationTravelModeOptions::pedestrian)).setter(setter(Builder::pedestrian))
            .constructor(WaypointOptimizationPedestrianOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pedestrian").build()).build();

    private static final SdkField<WaypointOptimizationTruckOptions> TRUCK_FIELD = SdkField
            .<WaypointOptimizationTruckOptions> builder(MarshallingType.SDK_POJO).memberName("Truck")
            .getter(getter(WaypointOptimizationTravelModeOptions::truck)).setter(setter(Builder::truck))
            .constructor(WaypointOptimizationTruckOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PEDESTRIAN_FIELD, TRUCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WaypointOptimizationPedestrianOptions pedestrian;

    private final WaypointOptimizationTruckOptions truck;

    private WaypointOptimizationTravelModeOptions(BuilderImpl builder) {
        this.pedestrian = builder.pedestrian;
        this.truck = builder.truck;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Pedestrian"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Pedestrian"
     */
    public final WaypointOptimizationPedestrianOptions pedestrian() {
        return pedestrian;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Truck"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Truck"
     */
    public final WaypointOptimizationTruckOptions truck() {
        return truck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pedestrian());
        hashCode = 31 * hashCode + Objects.hashCode(truck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationTravelModeOptions)) {
            return false;
        }
        WaypointOptimizationTravelModeOptions other = (WaypointOptimizationTravelModeOptions) obj;
        return Objects.equals(pedestrian(), other.pedestrian()) && Objects.equals(truck(), other.truck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationTravelModeOptions").add("Pedestrian", pedestrian()).add("Truck", truck())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pedestrian":
            return Optional.ofNullable(clazz.cast(pedestrian()));
        case "Truck":
            return Optional.ofNullable(clazz.cast(truck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Pedestrian", PEDESTRIAN_FIELD);
        map.put("Truck", TRUCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationTravelModeOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationTravelModeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationTravelModeOptions> {
        /**
         * <p>
         * Travel mode options when the provided travel mode is "Pedestrian"
         * </p>
         * 
         * @param pedestrian
         *        Travel mode options when the provided travel mode is "Pedestrian"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pedestrian(WaypointOptimizationPedestrianOptions pedestrian);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Pedestrian"
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationPedestrianOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationPedestrianOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationPedestrianOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #pedestrian(WaypointOptimizationPedestrianOptions)}.
         * 
         * @param pedestrian
         *        a consumer that will call methods on {@link WaypointOptimizationPedestrianOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pedestrian(WaypointOptimizationPedestrianOptions)
         */
        default Builder pedestrian(Consumer<WaypointOptimizationPedestrianOptions.Builder> pedestrian) {
            return pedestrian(WaypointOptimizationPedestrianOptions.builder().applyMutation(pedestrian).build());
        }

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck"
         * </p>
         * 
         * @param truck
         *        Travel mode options when the provided travel mode is "Truck"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truck(WaypointOptimizationTruckOptions truck);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck"
         * </p>
         * This is a convenience method that creates an instance of the {@link WaypointOptimizationTruckOptions.Builder}
         * avoiding the need to create one manually via {@link WaypointOptimizationTruckOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationTruckOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #truck(WaypointOptimizationTruckOptions)}.
         * 
         * @param truck
         *        a consumer that will call methods on {@link WaypointOptimizationTruckOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #truck(WaypointOptimizationTruckOptions)
         */
        default Builder truck(Consumer<WaypointOptimizationTruckOptions.Builder> truck) {
            return truck(WaypointOptimizationTruckOptions.builder().applyMutation(truck).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WaypointOptimizationPedestrianOptions pedestrian;

        private WaypointOptimizationTruckOptions truck;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationTravelModeOptions model) {
            pedestrian(model.pedestrian);
            truck(model.truck);
        }

        public final WaypointOptimizationPedestrianOptions.Builder getPedestrian() {
            return pedestrian != null ? pedestrian.toBuilder() : null;
        }

        public final void setPedestrian(WaypointOptimizationPedestrianOptions.BuilderImpl pedestrian) {
            this.pedestrian = pedestrian != null ? pedestrian.build() : null;
        }

        @Override
        public final Builder pedestrian(WaypointOptimizationPedestrianOptions pedestrian) {
            this.pedestrian = pedestrian;
            return this;
        }

        public final WaypointOptimizationTruckOptions.Builder getTruck() {
            return truck != null ? truck.toBuilder() : null;
        }

        public final void setTruck(WaypointOptimizationTruckOptions.BuilderImpl truck) {
            this.truck = truck != null ? truck.build() : null;
        }

        @Override
        public final Builder truck(WaypointOptimizationTruckOptions truck) {
            this.truck = truck;
            return this;
        }

        @Override
        public WaypointOptimizationTravelModeOptions build() {
            return new WaypointOptimizationTravelModeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
