/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Waypoint between the Origin and Destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaypointOptimizationWaypoint implements SdkPojo, Serializable,
        ToCopyableBuilder<WaypointOptimizationWaypoint.Builder, WaypointOptimizationWaypoint> {
    private static final SdkField<WaypointOptimizationAccessHours> ACCESS_HOURS_FIELD = SdkField
            .<WaypointOptimizationAccessHours> builder(MarshallingType.SDK_POJO).memberName("AccessHours")
            .getter(getter(WaypointOptimizationWaypoint::accessHours)).setter(setter(Builder::accessHours))
            .constructor(WaypointOptimizationAccessHours::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessHours").build()).build();

    private static final SdkField<String> APPOINTMENT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppointmentTime").getter(getter(WaypointOptimizationWaypoint::appointmentTime))
            .setter(setter(Builder::appointmentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppointmentTime").build()).build();

    private static final SdkField<List<Integer>> BEFORE_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Before")
            .getter(getter(WaypointOptimizationWaypoint::before))
            .setter(setter(Builder::before))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Before").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> HEADING_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Heading")
            .getter(getter(WaypointOptimizationWaypoint::heading)).setter(setter(Builder::heading))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(WaypointOptimizationWaypoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(WaypointOptimizationWaypoint::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> SERVICE_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ServiceDuration").getter(getter(WaypointOptimizationWaypoint::serviceDuration))
            .setter(setter(Builder::serviceDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDuration").build()).build();

    private static final SdkField<WaypointOptimizationSideOfStreetOptions> SIDE_OF_STREET_FIELD = SdkField
            .<WaypointOptimizationSideOfStreetOptions> builder(MarshallingType.SDK_POJO).memberName("SideOfStreet")
            .getter(getter(WaypointOptimizationWaypoint::sideOfStreet)).setter(setter(Builder::sideOfStreet))
            .constructor(WaypointOptimizationSideOfStreetOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_HOURS_FIELD,
            APPOINTMENT_TIME_FIELD, BEFORE_FIELD, HEADING_FIELD, ID_FIELD, POSITION_FIELD, SERVICE_DURATION_FIELD,
            SIDE_OF_STREET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WaypointOptimizationAccessHours accessHours;

    private final String appointmentTime;

    private final List<Integer> before;

    private final Double heading;

    private final String id;

    private final List<Double> position;

    private final Long serviceDuration;

    private final WaypointOptimizationSideOfStreetOptions sideOfStreet;

    private WaypointOptimizationWaypoint(BuilderImpl builder) {
        this.accessHours = builder.accessHours;
        this.appointmentTime = builder.appointmentTime;
        this.before = builder.before;
        this.heading = builder.heading;
        this.id = builder.id;
        this.position = builder.position;
        this.serviceDuration = builder.serviceDuration;
        this.sideOfStreet = builder.sideOfStreet;
    }

    /**
     * <p>
     * Access hours corresponding to when a waypoint can be visited.
     * </p>
     * 
     * @return Access hours corresponding to when a waypoint can be visited.
     */
    public final WaypointOptimizationAccessHours accessHours() {
        return accessHours;
    }

    /**
     * <p>
     * Appointment time at the waypoint.
     * </p>
     * 
     * @return Appointment time at the waypoint.
     */
    public final String appointmentTime() {
        return appointmentTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Before property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBefore() {
        return before != null && !(before instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Constraint defining what waypoints are to be visited after this waypoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBefore} method.
     * </p>
     * 
     * @return Constraint defining what waypoints are to be visited after this waypoint.
     */
    public final List<Integer> before() {
        return before;
    }

    /**
     * <p>
     * GPS Heading at the position.
     * </p>
     * 
     * @return GPS Heading at the position.
     */
    public final Double heading() {
        return heading;
    }

    /**
     * <p>
     * The waypoint Id.
     * </p>
     * 
     * @return The waypoint Id.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position defined as <code>[longitude, latitude]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return Position defined as <code>[longitude, latitude]</code>.
     */
    public final List<Double> position() {
        return position;
    }

    /**
     * <p>
     * Service time spent at the waypoint. At an appointment, the service time should be the appointment duration.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Service time spent at the waypoint. At an appointment, the service time should be the appointment
     *         duration.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long serviceDuration() {
        return serviceDuration;
    }

    /**
     * <p>
     * Options to configure matching the provided position to a side of the street.
     * </p>
     * 
     * @return Options to configure matching the provided position to a side of the street.
     */
    public final WaypointOptimizationSideOfStreetOptions sideOfStreet() {
        return sideOfStreet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessHours());
        hashCode = 31 * hashCode + Objects.hashCode(appointmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasBefore() ? before() : null);
        hashCode = 31 * hashCode + Objects.hashCode(heading());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceDuration());
        hashCode = 31 * hashCode + Objects.hashCode(sideOfStreet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationWaypoint)) {
            return false;
        }
        WaypointOptimizationWaypoint other = (WaypointOptimizationWaypoint) obj;
        return Objects.equals(accessHours(), other.accessHours()) && Objects.equals(appointmentTime(), other.appointmentTime())
                && hasBefore() == other.hasBefore() && Objects.equals(before(), other.before())
                && Objects.equals(heading(), other.heading()) && Objects.equals(id(), other.id())
                && hasPosition() == other.hasPosition() && Objects.equals(position(), other.position())
                && Objects.equals(serviceDuration(), other.serviceDuration())
                && Objects.equals(sideOfStreet(), other.sideOfStreet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaypointOptimizationWaypoint").add("AccessHours", accessHours())
                .add("AppointmentTime", appointmentTime()).add("Before", hasBefore() ? before() : null).add("Heading", heading())
                .add("Id", id()).add("Position", position() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ServiceDuration", serviceDuration()).add("SideOfStreet", sideOfStreet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessHours":
            return Optional.ofNullable(clazz.cast(accessHours()));
        case "AppointmentTime":
            return Optional.ofNullable(clazz.cast(appointmentTime()));
        case "Before":
            return Optional.ofNullable(clazz.cast(before()));
        case "Heading":
            return Optional.ofNullable(clazz.cast(heading()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "ServiceDuration":
            return Optional.ofNullable(clazz.cast(serviceDuration()));
        case "SideOfStreet":
            return Optional.ofNullable(clazz.cast(sideOfStreet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessHours", ACCESS_HOURS_FIELD);
        map.put("AppointmentTime", APPOINTMENT_TIME_FIELD);
        map.put("Before", BEFORE_FIELD);
        map.put("Heading", HEADING_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("ServiceDuration", SERVICE_DURATION_FIELD);
        map.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationWaypoint, T> g) {
        return obj -> g.apply((WaypointOptimizationWaypoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaypointOptimizationWaypoint> {
        /**
         * <p>
         * Access hours corresponding to when a waypoint can be visited.
         * </p>
         * 
         * @param accessHours
         *        Access hours corresponding to when a waypoint can be visited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessHours(WaypointOptimizationAccessHours accessHours);

        /**
         * <p>
         * Access hours corresponding to when a waypoint can be visited.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaypointOptimizationAccessHours.Builder}
         * avoiding the need to create one manually via {@link WaypointOptimizationAccessHours#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationAccessHours.Builder#build()} is called
         * immediately and its result is passed to {@link #accessHours(WaypointOptimizationAccessHours)}.
         * 
         * @param accessHours
         *        a consumer that will call methods on {@link WaypointOptimizationAccessHours.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessHours(WaypointOptimizationAccessHours)
         */
        default Builder accessHours(Consumer<WaypointOptimizationAccessHours.Builder> accessHours) {
            return accessHours(WaypointOptimizationAccessHours.builder().applyMutation(accessHours).build());
        }

        /**
         * <p>
         * Appointment time at the waypoint.
         * </p>
         * 
         * @param appointmentTime
         *        Appointment time at the waypoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appointmentTime(String appointmentTime);

        /**
         * <p>
         * Constraint defining what waypoints are to be visited after this waypoint.
         * </p>
         * 
         * @param before
         *        Constraint defining what waypoints are to be visited after this waypoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder before(Collection<Integer> before);

        /**
         * <p>
         * Constraint defining what waypoints are to be visited after this waypoint.
         * </p>
         * 
         * @param before
         *        Constraint defining what waypoints are to be visited after this waypoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder before(Integer... before);

        /**
         * <p>
         * GPS Heading at the position.
         * </p>
         * 
         * @param heading
         *        GPS Heading at the position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heading(Double heading);

        /**
         * <p>
         * The waypoint Id.
         * </p>
         * 
         * @param id
         *        The waypoint Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        /**
         * <p>
         * Service time spent at the waypoint. At an appointment, the service time should be the appointment duration.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param serviceDuration
         *        Service time spent at the waypoint. At an appointment, the service time should be the appointment
         *        duration.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDuration(Long serviceDuration);

        /**
         * <p>
         * Options to configure matching the provided position to a side of the street.
         * </p>
         * 
         * @param sideOfStreet
         *        Options to configure matching the provided position to a side of the street.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sideOfStreet(WaypointOptimizationSideOfStreetOptions sideOfStreet);

        /**
         * <p>
         * Options to configure matching the provided position to a side of the street.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationSideOfStreetOptions.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationSideOfStreetOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationSideOfStreetOptions.Builder#build()} is
         * called immediately and its result is passed to {@link #sideOfStreet(WaypointOptimizationSideOfStreetOptions)}.
         * 
         * @param sideOfStreet
         *        a consumer that will call methods on {@link WaypointOptimizationSideOfStreetOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sideOfStreet(WaypointOptimizationSideOfStreetOptions)
         */
        default Builder sideOfStreet(Consumer<WaypointOptimizationSideOfStreetOptions.Builder> sideOfStreet) {
            return sideOfStreet(WaypointOptimizationSideOfStreetOptions.builder().applyMutation(sideOfStreet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WaypointOptimizationAccessHours accessHours;

        private String appointmentTime;

        private List<Integer> before = DefaultSdkAutoConstructList.getInstance();

        private Double heading;

        private String id;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private Long serviceDuration;

        private WaypointOptimizationSideOfStreetOptions sideOfStreet;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationWaypoint model) {
            accessHours(model.accessHours);
            appointmentTime(model.appointmentTime);
            before(model.before);
            heading(model.heading);
            id(model.id);
            position(model.position);
            serviceDuration(model.serviceDuration);
            sideOfStreet(model.sideOfStreet);
        }

        public final WaypointOptimizationAccessHours.Builder getAccessHours() {
            return accessHours != null ? accessHours.toBuilder() : null;
        }

        public final void setAccessHours(WaypointOptimizationAccessHours.BuilderImpl accessHours) {
            this.accessHours = accessHours != null ? accessHours.build() : null;
        }

        @Override
        public final Builder accessHours(WaypointOptimizationAccessHours accessHours) {
            this.accessHours = accessHours;
            return this;
        }

        public final String getAppointmentTime() {
            return appointmentTime;
        }

        public final void setAppointmentTime(String appointmentTime) {
            this.appointmentTime = appointmentTime;
        }

        @Override
        public final Builder appointmentTime(String appointmentTime) {
            this.appointmentTime = appointmentTime;
            return this;
        }

        public final Collection<Integer> getBefore() {
            if (before instanceof SdkAutoConstructList) {
                return null;
            }
            return before;
        }

        public final void setBefore(Collection<Integer> before) {
            this.before = BeforeWaypointsListCopier.copy(before);
        }

        @Override
        public final Builder before(Collection<Integer> before) {
            this.before = BeforeWaypointsListCopier.copy(before);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder before(Integer... before) {
            before(Arrays.asList(before));
            return this;
        }

        public final Double getHeading() {
            return heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final Long getServiceDuration() {
            return serviceDuration;
        }

        public final void setServiceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
        }

        @Override
        public final Builder serviceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
            return this;
        }

        public final WaypointOptimizationSideOfStreetOptions.Builder getSideOfStreet() {
            return sideOfStreet != null ? sideOfStreet.toBuilder() : null;
        }

        public final void setSideOfStreet(WaypointOptimizationSideOfStreetOptions.BuilderImpl sideOfStreet) {
            this.sideOfStreet = sideOfStreet != null ? sideOfStreet.build() : null;
        }

        @Override
        public final Builder sideOfStreet(WaypointOptimizationSideOfStreetOptions sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        @Override
        public WaypointOptimizationWaypoint build() {
            return new WaypointOptimizationWaypoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
