/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidr;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListByoipCidrsResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListByoipCidrsResponse> {
    private static final SdkField<List<ByoipCidr>> BYOIP_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ByoipCidrs").getter(ListByoipCidrsResponse.getter(ListByoipCidrsResponse::byoipCidrs)).setter(ListByoipCidrsResponse.setter(Builder::byoipCidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByoipCidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ByoipCidr::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListByoipCidrsResponse.getter(ListByoipCidrsResponse::nextToken)).setter(ListByoipCidrsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYOIP_CIDRS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ByoipCidr> byoipCidrs;
    private final String nextToken;

    private ListByoipCidrsResponse(BuilderImpl builder) {
        super(builder);
        this.byoipCidrs = builder.byoipCidrs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasByoipCidrs() {
        return this.byoipCidrs != null && !(this.byoipCidrs instanceof SdkAutoConstructList);
    }

    public final List<ByoipCidr> byoipCidrs() {
        return this.byoipCidrs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasByoipCidrs() ? this.byoipCidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListByoipCidrsResponse)) {
            return false;
        }
        ListByoipCidrsResponse other = (ListByoipCidrsResponse)((Object)obj);
        return this.hasByoipCidrs() == other.hasByoipCidrs() && Objects.equals(this.byoipCidrs(), other.byoipCidrs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListByoipCidrsResponse").add("ByoipCidrs", this.hasByoipCidrs() ? this.byoipCidrs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByoipCidrs": {
                return Optional.ofNullable(clazz.cast(this.byoipCidrs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListByoipCidrsResponse, T> g) {
        return obj -> g.apply((ListByoipCidrsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<ByoipCidr> byoipCidrs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListByoipCidrsResponse model) {
            super(model);
            this.byoipCidrs(model.byoipCidrs);
            this.nextToken(model.nextToken);
        }

        public final List<ByoipCidr.Builder> getByoipCidrs() {
            List<ByoipCidr.Builder> result = ByoipCidrsCopier.copyToBuilder(this.byoipCidrs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setByoipCidrs(Collection<ByoipCidr.BuilderImpl> byoipCidrs) {
            this.byoipCidrs = ByoipCidrsCopier.copyFromBuilder(byoipCidrs);
        }

        @Override
        public final Builder byoipCidrs(Collection<ByoipCidr> byoipCidrs) {
            this.byoipCidrs = ByoipCidrsCopier.copy(byoipCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byoipCidrs(ByoipCidr ... byoipCidrs) {
            this.byoipCidrs(Arrays.asList(byoipCidrs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byoipCidrs(Consumer<ByoipCidr.Builder> ... byoipCidrs) {
            this.byoipCidrs(Stream.of(byoipCidrs).map(c -> (ByoipCidr)((ByoipCidr.Builder)ByoipCidr.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListByoipCidrsResponse build() {
            return new ListByoipCidrsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListByoipCidrsResponse> {
        public Builder byoipCidrs(Collection<ByoipCidr> var1);

        public Builder byoipCidrs(ByoipCidr ... var1);

        public Builder byoipCidrs(Consumer<ByoipCidr.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

