/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.InboundIntegration;
import software.amazon.awssdk.services.glue.model.InboundIntegrationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInboundIntegrationsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, DescribeInboundIntegrationsResponse> {
    private static final SdkField<List<InboundIntegration>> INBOUND_INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InboundIntegrations").getter(DescribeInboundIntegrationsResponse.getter(DescribeInboundIntegrationsResponse::inboundIntegrations)).setter(DescribeInboundIntegrationsResponse.setter(Builder::inboundIntegrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundIntegrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InboundIntegration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeInboundIntegrationsResponse.getter(DescribeInboundIntegrationsResponse::marker)).setter(DescribeInboundIntegrationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOUND_INTEGRATIONS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeInboundIntegrationsResponse.memberNameToFieldInitializer();
    private final List<InboundIntegration> inboundIntegrations;
    private final String marker;

    private DescribeInboundIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.inboundIntegrations = builder.inboundIntegrations;
        this.marker = builder.marker;
    }

    public final boolean hasInboundIntegrations() {
        return this.inboundIntegrations != null && !(this.inboundIntegrations instanceof SdkAutoConstructList);
    }

    public final List<InboundIntegration> inboundIntegrations() {
        return this.inboundIntegrations;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInboundIntegrations() ? this.inboundIntegrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInboundIntegrationsResponse)) {
            return false;
        }
        DescribeInboundIntegrationsResponse other = (DescribeInboundIntegrationsResponse)((Object)obj);
        return this.hasInboundIntegrations() == other.hasInboundIntegrations() && Objects.equals(this.inboundIntegrations(), other.inboundIntegrations()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInboundIntegrationsResponse").add("InboundIntegrations", this.hasInboundIntegrations() ? this.inboundIntegrations() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InboundIntegrations": {
                return Optional.ofNullable(clazz.cast(this.inboundIntegrations()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InboundIntegrations", INBOUND_INTEGRATIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInboundIntegrationsResponse, T> g) {
        return obj -> g.apply((DescribeInboundIntegrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<InboundIntegration> inboundIntegrations = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInboundIntegrationsResponse model) {
            super(model);
            this.inboundIntegrations(model.inboundIntegrations);
            this.marker(model.marker);
        }

        public final List<InboundIntegration.Builder> getInboundIntegrations() {
            List<InboundIntegration.Builder> result = InboundIntegrationsListCopier.copyToBuilder(this.inboundIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInboundIntegrations(Collection<InboundIntegration.BuilderImpl> inboundIntegrations) {
            this.inboundIntegrations = InboundIntegrationsListCopier.copyFromBuilder(inboundIntegrations);
        }

        @Override
        public final Builder inboundIntegrations(Collection<InboundIntegration> inboundIntegrations) {
            this.inboundIntegrations = InboundIntegrationsListCopier.copy(inboundIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundIntegrations(InboundIntegration ... inboundIntegrations) {
            this.inboundIntegrations(Arrays.asList(inboundIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundIntegrations(Consumer<InboundIntegration.Builder> ... inboundIntegrations) {
            this.inboundIntegrations(Stream.of(inboundIntegrations).map(c -> (InboundIntegration)((InboundIntegration.Builder)InboundIntegration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeInboundIntegrationsResponse build() {
            return new DescribeInboundIntegrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInboundIntegrationsResponse> {
        public Builder inboundIntegrations(Collection<InboundIntegration> var1);

        public Builder inboundIntegrations(InboundIntegration ... var1);

        public Builder inboundIntegrations(Consumer<InboundIntegration.Builder> ... var1);

        public Builder marker(String var1);
    }
}

