/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.HighestSeverityThreatDetails;
import software.amazon.awssdk.services.guardduty.model.ScannedItemCount;
import software.amazon.awssdk.services.guardduty.model.ThreatDetectedByName;
import software.amazon.awssdk.services.guardduty.model.ThreatsDetectedItemCount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanDetections
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanDetections> {
    private static final SdkField<ScannedItemCount> SCANNED_ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScannedItemCount").getter(ScanDetections.getter(ScanDetections::scannedItemCount)).setter(ScanDetections.setter(Builder::scannedItemCount)).constructor(ScannedItemCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scannedItemCount").build()}).build();
    private static final SdkField<ThreatsDetectedItemCount> THREATS_DETECTED_ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThreatsDetectedItemCount").getter(ScanDetections.getter(ScanDetections::threatsDetectedItemCount)).setter(ScanDetections.setter(Builder::threatsDetectedItemCount)).constructor(ThreatsDetectedItemCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatsDetectedItemCount").build()}).build();
    private static final SdkField<HighestSeverityThreatDetails> HIGHEST_SEVERITY_THREAT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HighestSeverityThreatDetails").getter(ScanDetections.getter(ScanDetections::highestSeverityThreatDetails)).setter(ScanDetections.setter(Builder::highestSeverityThreatDetails)).constructor(HighestSeverityThreatDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highestSeverityThreatDetails").build()}).build();
    private static final SdkField<ThreatDetectedByName> THREAT_DETECTED_BY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThreatDetectedByName").getter(ScanDetections.getter(ScanDetections::threatDetectedByName)).setter(ScanDetections.setter(Builder::threatDetectedByName)).constructor(ThreatDetectedByName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatDetectedByName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCANNED_ITEM_COUNT_FIELD, THREATS_DETECTED_ITEM_COUNT_FIELD, HIGHEST_SEVERITY_THREAT_DETAILS_FIELD, THREAT_DETECTED_BY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanDetections.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ScannedItemCount scannedItemCount;
    private final ThreatsDetectedItemCount threatsDetectedItemCount;
    private final HighestSeverityThreatDetails highestSeverityThreatDetails;
    private final ThreatDetectedByName threatDetectedByName;

    private ScanDetections(BuilderImpl builder) {
        this.scannedItemCount = builder.scannedItemCount;
        this.threatsDetectedItemCount = builder.threatsDetectedItemCount;
        this.highestSeverityThreatDetails = builder.highestSeverityThreatDetails;
        this.threatDetectedByName = builder.threatDetectedByName;
    }

    public final ScannedItemCount scannedItemCount() {
        return this.scannedItemCount;
    }

    public final ThreatsDetectedItemCount threatsDetectedItemCount() {
        return this.threatsDetectedItemCount;
    }

    public final HighestSeverityThreatDetails highestSeverityThreatDetails() {
        return this.highestSeverityThreatDetails;
    }

    public final ThreatDetectedByName threatDetectedByName() {
        return this.threatDetectedByName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scannedItemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.threatsDetectedItemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.highestSeverityThreatDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.threatDetectedByName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanDetections)) {
            return false;
        }
        ScanDetections other = (ScanDetections)obj;
        return Objects.equals(this.scannedItemCount(), other.scannedItemCount()) && Objects.equals(this.threatsDetectedItemCount(), other.threatsDetectedItemCount()) && Objects.equals(this.highestSeverityThreatDetails(), other.highestSeverityThreatDetails()) && Objects.equals(this.threatDetectedByName(), other.threatDetectedByName());
    }

    public final String toString() {
        return ToString.builder((String)"ScanDetections").add("ScannedItemCount", (Object)this.scannedItemCount()).add("ThreatsDetectedItemCount", (Object)this.threatsDetectedItemCount()).add("HighestSeverityThreatDetails", (Object)this.highestSeverityThreatDetails()).add("ThreatDetectedByName", (Object)this.threatDetectedByName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScannedItemCount": {
                return Optional.ofNullable(clazz.cast(this.scannedItemCount()));
            }
            case "ThreatsDetectedItemCount": {
                return Optional.ofNullable(clazz.cast(this.threatsDetectedItemCount()));
            }
            case "HighestSeverityThreatDetails": {
                return Optional.ofNullable(clazz.cast(this.highestSeverityThreatDetails()));
            }
            case "ThreatDetectedByName": {
                return Optional.ofNullable(clazz.cast(this.threatDetectedByName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scannedItemCount", SCANNED_ITEM_COUNT_FIELD);
        map.put("threatsDetectedItemCount", THREATS_DETECTED_ITEM_COUNT_FIELD);
        map.put("highestSeverityThreatDetails", HIGHEST_SEVERITY_THREAT_DETAILS_FIELD);
        map.put("threatDetectedByName", THREAT_DETECTED_BY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanDetections, T> g) {
        return obj -> g.apply((ScanDetections)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ScannedItemCount scannedItemCount;
        private ThreatsDetectedItemCount threatsDetectedItemCount;
        private HighestSeverityThreatDetails highestSeverityThreatDetails;
        private ThreatDetectedByName threatDetectedByName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanDetections model) {
            this.scannedItemCount(model.scannedItemCount);
            this.threatsDetectedItemCount(model.threatsDetectedItemCount);
            this.highestSeverityThreatDetails(model.highestSeverityThreatDetails);
            this.threatDetectedByName(model.threatDetectedByName);
        }

        public final ScannedItemCount.Builder getScannedItemCount() {
            return this.scannedItemCount != null ? this.scannedItemCount.toBuilder() : null;
        }

        public final void setScannedItemCount(ScannedItemCount.BuilderImpl scannedItemCount) {
            this.scannedItemCount = scannedItemCount != null ? scannedItemCount.build() : null;
        }

        @Override
        public final Builder scannedItemCount(ScannedItemCount scannedItemCount) {
            this.scannedItemCount = scannedItemCount;
            return this;
        }

        public final ThreatsDetectedItemCount.Builder getThreatsDetectedItemCount() {
            return this.threatsDetectedItemCount != null ? this.threatsDetectedItemCount.toBuilder() : null;
        }

        public final void setThreatsDetectedItemCount(ThreatsDetectedItemCount.BuilderImpl threatsDetectedItemCount) {
            this.threatsDetectedItemCount = threatsDetectedItemCount != null ? threatsDetectedItemCount.build() : null;
        }

        @Override
        public final Builder threatsDetectedItemCount(ThreatsDetectedItemCount threatsDetectedItemCount) {
            this.threatsDetectedItemCount = threatsDetectedItemCount;
            return this;
        }

        public final HighestSeverityThreatDetails.Builder getHighestSeverityThreatDetails() {
            return this.highestSeverityThreatDetails != null ? this.highestSeverityThreatDetails.toBuilder() : null;
        }

        public final void setHighestSeverityThreatDetails(HighestSeverityThreatDetails.BuilderImpl highestSeverityThreatDetails) {
            this.highestSeverityThreatDetails = highestSeverityThreatDetails != null ? highestSeverityThreatDetails.build() : null;
        }

        @Override
        public final Builder highestSeverityThreatDetails(HighestSeverityThreatDetails highestSeverityThreatDetails) {
            this.highestSeverityThreatDetails = highestSeverityThreatDetails;
            return this;
        }

        public final ThreatDetectedByName.Builder getThreatDetectedByName() {
            return this.threatDetectedByName != null ? this.threatDetectedByName.toBuilder() : null;
        }

        public final void setThreatDetectedByName(ThreatDetectedByName.BuilderImpl threatDetectedByName) {
            this.threatDetectedByName = threatDetectedByName != null ? threatDetectedByName.build() : null;
        }

        @Override
        public final Builder threatDetectedByName(ThreatDetectedByName threatDetectedByName) {
            this.threatDetectedByName = threatDetectedByName;
            return this;
        }

        public ScanDetections build() {
            return new ScanDetections(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanDetections> {
        public Builder scannedItemCount(ScannedItemCount var1);

        default public Builder scannedItemCount(Consumer<ScannedItemCount.Builder> scannedItemCount) {
            return this.scannedItemCount((ScannedItemCount)((ScannedItemCount.Builder)ScannedItemCount.builder().applyMutation(scannedItemCount)).build());
        }

        public Builder threatsDetectedItemCount(ThreatsDetectedItemCount var1);

        default public Builder threatsDetectedItemCount(Consumer<ThreatsDetectedItemCount.Builder> threatsDetectedItemCount) {
            return this.threatsDetectedItemCount((ThreatsDetectedItemCount)((ThreatsDetectedItemCount.Builder)ThreatsDetectedItemCount.builder().applyMutation(threatsDetectedItemCount)).build());
        }

        public Builder highestSeverityThreatDetails(HighestSeverityThreatDetails var1);

        default public Builder highestSeverityThreatDetails(Consumer<HighestSeverityThreatDetails.Builder> highestSeverityThreatDetails) {
            return this.highestSeverityThreatDetails((HighestSeverityThreatDetails)((HighestSeverityThreatDetails.Builder)HighestSeverityThreatDetails.builder().applyMutation(highestSeverityThreatDetails)).build());
        }

        public Builder threatDetectedByName(ThreatDetectedByName var1);

        default public Builder threatDetectedByName(Consumer<ThreatDetectedByName.Builder> threatDetectedByName) {
            return this.threatDetectedByName((ThreatDetectedByName)((ThreatDetectedByName.Builder)ThreatDetectedByName.builder().applyMutation(threatDetectedByName)).build());
        }
    }
}

