/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ThreatNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThreatIntelligenceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThreatIntelligenceDetail> {
    private static final SdkField<String> THREAT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThreatListName").getter(ThreatIntelligenceDetail.getter(ThreatIntelligenceDetail::threatListName)).setter(ThreatIntelligenceDetail.setter(Builder::threatListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatListName").build()}).build();
    private static final SdkField<List<String>> THREAT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThreatNames").getter(ThreatIntelligenceDetail.getter(ThreatIntelligenceDetail::threatNames)).setter(ThreatIntelligenceDetail.setter(Builder::threatNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> THREAT_FILE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThreatFileSha256").getter(ThreatIntelligenceDetail.getter(ThreatIntelligenceDetail::threatFileSha256)).setter(ThreatIntelligenceDetail.setter(Builder::threatFileSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatFileSha256").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREAT_LIST_NAME_FIELD, THREAT_NAMES_FIELD, THREAT_FILE_SHA256_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ThreatIntelligenceDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String threatListName;
    private final List<String> threatNames;
    private final String threatFileSha256;

    private ThreatIntelligenceDetail(BuilderImpl builder) {
        this.threatListName = builder.threatListName;
        this.threatNames = builder.threatNames;
        this.threatFileSha256 = builder.threatFileSha256;
    }

    public final String threatListName() {
        return this.threatListName;
    }

    public final boolean hasThreatNames() {
        return this.threatNames != null && !(this.threatNames instanceof SdkAutoConstructList);
    }

    public final List<String> threatNames() {
        return this.threatNames;
    }

    public final String threatFileSha256() {
        return this.threatFileSha256;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.threatListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatNames() ? this.threatNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.threatFileSha256());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreatIntelligenceDetail)) {
            return false;
        }
        ThreatIntelligenceDetail other = (ThreatIntelligenceDetail)obj;
        return Objects.equals(this.threatListName(), other.threatListName()) && this.hasThreatNames() == other.hasThreatNames() && Objects.equals(this.threatNames(), other.threatNames()) && Objects.equals(this.threatFileSha256(), other.threatFileSha256());
    }

    public final String toString() {
        return ToString.builder((String)"ThreatIntelligenceDetail").add("ThreatListName", (Object)this.threatListName()).add("ThreatNames", this.hasThreatNames() ? this.threatNames() : null).add("ThreatFileSha256", (Object)this.threatFileSha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThreatListName": {
                return Optional.ofNullable(clazz.cast(this.threatListName()));
            }
            case "ThreatNames": {
                return Optional.ofNullable(clazz.cast(this.threatNames()));
            }
            case "ThreatFileSha256": {
                return Optional.ofNullable(clazz.cast(this.threatFileSha256()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("threatListName", THREAT_LIST_NAME_FIELD);
        map.put("threatNames", THREAT_NAMES_FIELD);
        map.put("threatFileSha256", THREAT_FILE_SHA256_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThreatIntelligenceDetail, T> g) {
        return obj -> g.apply((ThreatIntelligenceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String threatListName;
        private List<String> threatNames = DefaultSdkAutoConstructList.getInstance();
        private String threatFileSha256;

        private BuilderImpl() {
        }

        private BuilderImpl(ThreatIntelligenceDetail model) {
            this.threatListName(model.threatListName);
            this.threatNames(model.threatNames);
            this.threatFileSha256(model.threatFileSha256);
        }

        public final String getThreatListName() {
            return this.threatListName;
        }

        public final void setThreatListName(String threatListName) {
            this.threatListName = threatListName;
        }

        @Override
        public final Builder threatListName(String threatListName) {
            this.threatListName = threatListName;
            return this;
        }

        public final Collection<String> getThreatNames() {
            if (this.threatNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.threatNames;
        }

        public final void setThreatNames(Collection<String> threatNames) {
            this.threatNames = ThreatNamesCopier.copy(threatNames);
        }

        @Override
        public final Builder threatNames(Collection<String> threatNames) {
            this.threatNames = ThreatNamesCopier.copy(threatNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatNames(String ... threatNames) {
            this.threatNames(Arrays.asList(threatNames));
            return this;
        }

        public final String getThreatFileSha256() {
            return this.threatFileSha256;
        }

        public final void setThreatFileSha256(String threatFileSha256) {
            this.threatFileSha256 = threatFileSha256;
        }

        @Override
        public final Builder threatFileSha256(String threatFileSha256) {
            this.threatFileSha256 = threatFileSha256;
            return this;
        }

        public ThreatIntelligenceDetail build() {
            return new ThreatIntelligenceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThreatIntelligenceDetail> {
        public Builder threatListName(String var1);

        public Builder threatNames(Collection<String> var1);

        public Builder threatNames(String ... var1);

        public Builder threatFileSha256(String var1);
    }
}

