/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAffectedEntitiesForOrganizationRequest extends HealthRequest implements
        ToCopyableBuilder<DescribeAffectedEntitiesForOrganizationRequest.Builder, DescribeAffectedEntitiesForOrganizationRequest> {
    private static final SdkField<List<EventAccountFilter>> ORGANIZATION_ENTITY_FILTERS_FIELD = SdkField
            .<List<EventAccountFilter>> builder(MarshallingType.LIST)
            .memberName("organizationEntityFilters")
            .getter(getter(DescribeAffectedEntitiesForOrganizationRequest::organizationEntityFilters))
            .setter(setter(Builder::organizationEntityFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEntityFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventAccountFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventAccountFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(DescribeAffectedEntitiesForOrganizationRequest::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeAffectedEntitiesForOrganizationRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeAffectedEntitiesForOrganizationRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<EntityAccountFilter>> ORGANIZATION_ENTITY_ACCOUNT_FILTERS_FIELD = SdkField
            .<List<EntityAccountFilter>> builder(MarshallingType.LIST)
            .memberName("organizationEntityAccountFilters")
            .getter(getter(DescribeAffectedEntitiesForOrganizationRequest::organizationEntityAccountFilters))
            .setter(setter(Builder::organizationEntityAccountFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEntityAccountFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityAccountFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityAccountFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_ENTITY_FILTERS_FIELD, LOCALE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD,
            ORGANIZATION_ENTITY_ACCOUNT_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EventAccountFilter> organizationEntityFilters;

    private final String locale;

    private final String nextToken;

    private final Integer maxResults;

    private final List<EntityAccountFilter> organizationEntityAccountFilters;

    private DescribeAffectedEntitiesForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.organizationEntityFilters = builder.organizationEntityFilters;
        this.locale = builder.locale;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.organizationEntityAccountFilters = builder.organizationEntityAccountFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationEntityFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     *
     * @deprecated This property is deprecated, use organizationEntityAccountFilters instead.
     */
    @Deprecated
    public final boolean hasOrganizationEntityFilters() {
        return organizationEntityFilters != null && !(organizationEntityFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationEntityFilters} method.
     * </p>
     * 
     * @return A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
     * @deprecated This property is deprecated, use organizationEntityAccountFilters instead.
     */
    @Deprecated
    public final List<EventAccountFilter> organizationEntityFilters() {
        return organizationEntityFilters;
    }

    /**
     * <p>
     * The locale (language) to return information in. English (en) is the default and the only supported value at this
     * time.
     * </p>
     * 
     * @return The locale (language) to return information in. English (en) is the default and the only supported value
     *         at this time.
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return in one batch, between 10 and 100, inclusive.
     * </p>
     * 
     * @return The maximum number of items to return in one batch, between 10 and 100, inclusive.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationEntityAccountFilters
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasOrganizationEntityAccountFilters() {
        return organizationEntityAccountFilters != null && !(organizationEntityAccountFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON set of elements including the <code>awsAccountId</code>, <code>eventArn</code> and a set of
     * <code>statusCodes</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationEntityAccountFilters}
     * method.
     * </p>
     * 
     * @return A JSON set of elements including the <code>awsAccountId</code>, <code>eventArn</code> and a set of
     *         <code>statusCodes</code>.
     */
    public final List<EntityAccountFilter> organizationEntityAccountFilters() {
        return organizationEntityAccountFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationEntityFilters() ? organizationEntityFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasOrganizationEntityAccountFilters() ? organizationEntityAccountFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedEntitiesForOrganizationRequest)) {
            return false;
        }
        DescribeAffectedEntitiesForOrganizationRequest other = (DescribeAffectedEntitiesForOrganizationRequest) obj;
        return hasOrganizationEntityFilters() == other.hasOrganizationEntityFilters()
                && Objects.equals(organizationEntityFilters(), other.organizationEntityFilters())
                && Objects.equals(locale(), other.locale()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && hasOrganizationEntityAccountFilters() == other.hasOrganizationEntityAccountFilters()
                && Objects.equals(organizationEntityAccountFilters(), other.organizationEntityAccountFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeAffectedEntitiesForOrganizationRequest")
                .add("OrganizationEntityFilters", hasOrganizationEntityFilters() ? organizationEntityFilters() : null)
                .add("Locale", locale())
                .add("NextToken", nextToken())
                .add("MaxResults", maxResults())
                .add("OrganizationEntityAccountFilters",
                        hasOrganizationEntityAccountFilters() ? organizationEntityAccountFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "organizationEntityFilters":
            return Optional.ofNullable(clazz.cast(organizationEntityFilters()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "organizationEntityAccountFilters":
            return Optional.ofNullable(clazz.cast(organizationEntityAccountFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("organizationEntityFilters", ORGANIZATION_ENTITY_FILTERS_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("organizationEntityAccountFilters", ORGANIZATION_ENTITY_ACCOUNT_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedEntitiesForOrganizationRequest, T> g) {
        return obj -> g.apply((DescribeAffectedEntitiesForOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationRequest> {
        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * 
         * @param organizationEntityFilters
         *        A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This property is deprecated, use organizationEntityAccountFilters instead.
         */
        @Deprecated
        Builder organizationEntityFilters(Collection<EventAccountFilter> organizationEntityFilters);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * 
         * @param organizationEntityFilters
         *        A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This property is deprecated, use organizationEntityAccountFilters instead.
         */
        @Deprecated
        Builder organizationEntityFilters(EventAccountFilter... organizationEntityFilters);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.EventAccountFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.health.model.EventAccountFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.EventAccountFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #organizationEntityFilters(List<EventAccountFilter>)}.
         * 
         * @param organizationEntityFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.EventAccountFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationEntityFilters(java.util.Collection<EventAccountFilter>)
         * @deprecated This property is deprecated, use organizationEntityAccountFilters instead.
         */
        @Deprecated
        Builder organizationEntityFilters(Consumer<EventAccountFilter.Builder>... organizationEntityFilters);

        /**
         * <p>
         * The locale (language) to return information in. English (en) is the default and the only supported value at
         * this time.
         * </p>
         * 
         * @param locale
         *        The locale (language) to return information in. English (en) is the default and the only supported
         *        value at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return in one batch, between 10 and 100, inclusive.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in one batch, between 10 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code>, <code>eventArn</code> and a set of
         * <code>statusCodes</code>.
         * </p>
         * 
         * @param organizationEntityAccountFilters
         *        A JSON set of elements including the <code>awsAccountId</code>, <code>eventArn</code> and a set of
         *        <code>statusCodes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEntityAccountFilters(Collection<EntityAccountFilter> organizationEntityAccountFilters);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code>, <code>eventArn</code> and a set of
         * <code>statusCodes</code>.
         * </p>
         * 
         * @param organizationEntityAccountFilters
         *        A JSON set of elements including the <code>awsAccountId</code>, <code>eventArn</code> and a set of
         *        <code>statusCodes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEntityAccountFilters(EntityAccountFilter... organizationEntityAccountFilters);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code>, <code>eventArn</code> and a set of
         * <code>statusCodes</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.EntityAccountFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.health.model.EntityAccountFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.EntityAccountFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #organizationEntityAccountFilters(List<EntityAccountFilter>)}.
         * 
         * @param organizationEntityAccountFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.EntityAccountFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationEntityAccountFilters(java.util.Collection<EntityAccountFilter>)
         */
        Builder organizationEntityAccountFilters(Consumer<EntityAccountFilter.Builder>... organizationEntityAccountFilters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthRequest.BuilderImpl implements Builder {
        private List<EventAccountFilter> organizationEntityFilters = DefaultSdkAutoConstructList.getInstance();

        private String locale;

        private String nextToken;

        private Integer maxResults;

        private List<EntityAccountFilter> organizationEntityAccountFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedEntitiesForOrganizationRequest model) {
            super(model);
            organizationEntityFilters(model.organizationEntityFilters);
            locale(model.locale);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            organizationEntityAccountFilters(model.organizationEntityAccountFilters);
        }

        @Deprecated
        public final List<EventAccountFilter.Builder> getOrganizationEntityFilters() {
            List<EventAccountFilter.Builder> result = OrganizationEntityFiltersListCopier
                    .copyToBuilder(this.organizationEntityFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setOrganizationEntityFilters(Collection<EventAccountFilter.BuilderImpl> organizationEntityFilters) {
            this.organizationEntityFilters = OrganizationEntityFiltersListCopier.copyFromBuilder(organizationEntityFilters);
        }

        @Override
        @Deprecated
        public final Builder organizationEntityFilters(Collection<EventAccountFilter> organizationEntityFilters) {
            this.organizationEntityFilters = OrganizationEntityFiltersListCopier.copy(organizationEntityFilters);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder organizationEntityFilters(EventAccountFilter... organizationEntityFilters) {
            organizationEntityFilters(Arrays.asList(organizationEntityFilters));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder organizationEntityFilters(Consumer<EventAccountFilter.Builder>... organizationEntityFilters) {
            organizationEntityFilters(Stream.of(organizationEntityFilters)
                    .map(c -> EventAccountFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<EntityAccountFilter.Builder> getOrganizationEntityAccountFilters() {
            List<EntityAccountFilter.Builder> result = OrganizationEntityAccountFiltersListCopier
                    .copyToBuilder(this.organizationEntityAccountFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationEntityAccountFilters(
                Collection<EntityAccountFilter.BuilderImpl> organizationEntityAccountFilters) {
            this.organizationEntityAccountFilters = OrganizationEntityAccountFiltersListCopier
                    .copyFromBuilder(organizationEntityAccountFilters);
        }

        @Override
        public final Builder organizationEntityAccountFilters(Collection<EntityAccountFilter> organizationEntityAccountFilters) {
            this.organizationEntityAccountFilters = OrganizationEntityAccountFiltersListCopier
                    .copy(organizationEntityAccountFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityAccountFilters(EntityAccountFilter... organizationEntityAccountFilters) {
            organizationEntityAccountFilters(Arrays.asList(organizationEntityAccountFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityAccountFilters(
                Consumer<EntityAccountFilter.Builder>... organizationEntityAccountFilters) {
            organizationEntityAccountFilters(Stream.of(organizationEntityAccountFilters)
                    .map(c -> EntityAccountFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAffectedEntitiesForOrganizationRequest build() {
            return new DescribeAffectedEntitiesForOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
