/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class _entityStatusesCopier {
    static Map<String, Integer> copy(Map<String, Integer> entityStatusesParam) {
        Map<String, Integer> map;
        if (entityStatusesParam == null || entityStatusesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Integer> modifiableMap = new LinkedHashMap<>(entityStatusesParam.size());
            entityStatusesParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Integer> copyEnumToString(Map<EntityStatusCode, Integer> entityStatusesParam) {
        Map<String, Integer> map;
        if (entityStatusesParam == null || entityStatusesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Integer> modifiableMap = new LinkedHashMap<>(entityStatusesParam.size());
            entityStatusesParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<EntityStatusCode, Integer> copyStringToEnum(Map<String, Integer> entityStatusesParam) {
        Map<EntityStatusCode, Integer> map;
        if (entityStatusesParam == null || entityStatusesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<EntityStatusCode, Integer> modifiableMap = new LinkedHashMap<>(entityStatusesParam.size());
            entityStatusesParam.forEach((key, value) -> {
                EntityStatusCode result = EntityStatusCode.fromValue(key);
                if (result != EntityStatusCode.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
