/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.invoicing.model.BatchGetInvoiceProfileRequest;
import software.amazon.awssdk.services.invoicing.model.BatchGetInvoiceProfileResponse;
import software.amazon.awssdk.services.invoicing.model.CreateInvoiceUnitRequest;
import software.amazon.awssdk.services.invoicing.model.CreateInvoiceUnitResponse;
import software.amazon.awssdk.services.invoicing.model.DeleteInvoiceUnitRequest;
import software.amazon.awssdk.services.invoicing.model.DeleteInvoiceUnitResponse;
import software.amazon.awssdk.services.invoicing.model.GetInvoiceUnitRequest;
import software.amazon.awssdk.services.invoicing.model.GetInvoiceUnitResponse;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse;
import software.amazon.awssdk.services.invoicing.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.invoicing.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.invoicing.model.TagResourceRequest;
import software.amazon.awssdk.services.invoicing.model.TagResourceResponse;
import software.amazon.awssdk.services.invoicing.model.UntagResourceRequest;
import software.amazon.awssdk.services.invoicing.model.UntagResourceResponse;
import software.amazon.awssdk.services.invoicing.model.UpdateInvoiceUnitRequest;
import software.amazon.awssdk.services.invoicing.model.UpdateInvoiceUnitResponse;
import software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsPublisher;

/**
 * Service client for accessing AWS Invoicing asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * <b>Amazon Web Services Invoice Configuration</b>
 * </p>
 * <p>
 * You can use Amazon Web Services Invoice Configuration APIs to programmatically create, update, delete, get, and list
 * invoice units. You can also programmatically fetch the information of the invoice receiver. For example, business
 * legal name, address, and invoicing contacts.
 * </p>
 * <p>
 * You can use Amazon Web Services Invoice Configuration to receive separate Amazon Web Services invoices based your
 * organizational needs. By using Amazon Web Services Invoice Configuration, you can configure invoice units that are
 * groups of Amazon Web Services accounts that represent your business entities, and receive separate invoices for each
 * business entity. You can also assign a unique member or payer account as the invoice receiver for each invoice unit.
 * As you create new accounts within your Organizations using Amazon Web Services Invoice Configuration APIs, you can
 * automate the creation of new invoice units and subsequently automate the addition of new accounts to your invoice
 * units.
 * </p>
 * <p>
 * Service endpoint
 * </p>
 * <p>
 * You can use the following endpoints for Amazon Web Services Invoice Configuration:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>https://invoicing.us-east-1.api.aws</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface InvoicingAsyncClient extends AwsClient {
    String SERVICE_NAME = "invoicing";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "invoicing";

    /**
     * <p>
     * This gets the invoice profile associated with a set of accounts. The accounts must be linked accounts under the
     * requester management account organization.
     * </p>
     *
     * @param batchGetInvoiceProfileRequest
     * @return A Java Future containing the result of the BatchGetInvoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.BatchGetInvoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/BatchGetInvoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetInvoiceProfileResponse> batchGetInvoiceProfile(
            BatchGetInvoiceProfileRequest batchGetInvoiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This gets the invoice profile associated with a set of accounts. The accounts must be linked accounts under the
     * requester management account organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetInvoiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetInvoiceProfileRequest#builder()}
     * </p>
     *
     * @param batchGetInvoiceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.BatchGetInvoiceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetInvoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.BatchGetInvoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/BatchGetInvoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetInvoiceProfileResponse> batchGetInvoiceProfile(
            Consumer<BatchGetInvoiceProfileRequest.Builder> batchGetInvoiceProfileRequest) {
        return batchGetInvoiceProfile(BatchGetInvoiceProfileRequest.builder().applyMutation(batchGetInvoiceProfileRequest)
                .build());
    }

    /**
     * <p>
     * This creates a new invoice unit with the provided definition.
     * </p>
     *
     * @param createInvoiceUnitRequest
     * @return A Java Future containing the result of the CreateInvoiceUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.CreateInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/CreateInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInvoiceUnitResponse> createInvoiceUnit(CreateInvoiceUnitRequest createInvoiceUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This creates a new invoice unit with the provided definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvoiceUnitRequest.Builder} avoiding the need
     * to create one manually via {@link CreateInvoiceUnitRequest#builder()}
     * </p>
     *
     * @param createInvoiceUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.CreateInvoiceUnitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInvoiceUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.CreateInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/CreateInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInvoiceUnitResponse> createInvoiceUnit(
            Consumer<CreateInvoiceUnitRequest.Builder> createInvoiceUnitRequest) {
        return createInvoiceUnit(CreateInvoiceUnitRequest.builder().applyMutation(createInvoiceUnitRequest).build());
    }

    /**
     * <p>
     * This deletes an invoice unit with the provided invoice unit ARN.
     * </p>
     *
     * @param deleteInvoiceUnitRequest
     * @return A Java Future containing the result of the DeleteInvoiceUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.DeleteInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/DeleteInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInvoiceUnitResponse> deleteInvoiceUnit(DeleteInvoiceUnitRequest deleteInvoiceUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This deletes an invoice unit with the provided invoice unit ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvoiceUnitRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvoiceUnitRequest#builder()}
     * </p>
     *
     * @param deleteInvoiceUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.DeleteInvoiceUnitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInvoiceUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.DeleteInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/DeleteInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInvoiceUnitResponse> deleteInvoiceUnit(
            Consumer<DeleteInvoiceUnitRequest.Builder> deleteInvoiceUnitRequest) {
        return deleteInvoiceUnit(DeleteInvoiceUnitRequest.builder().applyMutation(deleteInvoiceUnitRequest).build());
    }

    /**
     * <p>
     * This retrieves the invoice unit definition.
     * </p>
     *
     * @param getInvoiceUnitRequest
     * @return A Java Future containing the result of the GetInvoiceUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.GetInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/GetInvoiceUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInvoiceUnitResponse> getInvoiceUnit(GetInvoiceUnitRequest getInvoiceUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This retrieves the invoice unit definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvoiceUnitRequest.Builder} avoiding the need to
     * create one manually via {@link GetInvoiceUnitRequest#builder()}
     * </p>
     *
     * @param getInvoiceUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.GetInvoiceUnitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInvoiceUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.GetInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/GetInvoiceUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInvoiceUnitResponse> getInvoiceUnit(Consumer<GetInvoiceUnitRequest.Builder> getInvoiceUnitRequest) {
        return getInvoiceUnit(GetInvoiceUnitRequest.builder().applyMutation(getInvoiceUnitRequest).build());
    }

    /**
     * <p>
     * This fetches a list of all invoice unit definitions for a given account, as of the provided <code>AsOf</code>
     * date.
     * </p>
     *
     * @param listInvoiceUnitsRequest
     * @return A Java Future containing the result of the ListInvoiceUnits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.ListInvoiceUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvoiceUnitsResponse> listInvoiceUnits(ListInvoiceUnitsRequest listInvoiceUnitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This fetches a list of all invoice unit definitions for a given account, as of the provided <code>AsOf</code>
     * date.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvoiceUnitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvoiceUnitsRequest#builder()}
     * </p>
     *
     * @param listInvoiceUnitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInvoiceUnits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.ListInvoiceUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvoiceUnitsResponse> listInvoiceUnits(
            Consumer<ListInvoiceUnitsRequest.Builder> listInvoiceUnitsRequest) {
        return listInvoiceUnits(ListInvoiceUnitsRequest.builder().applyMutation(listInvoiceUnitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvoiceUnits(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsPublisher publisher = client.listInvoiceUnitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsPublisher publisher = client.listInvoiceUnitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvoiceUnits(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest)} operation.</b>
     * </p>
     *
     * @param listInvoiceUnitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.ListInvoiceUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvoiceUnitsPublisher listInvoiceUnitsPaginator(ListInvoiceUnitsRequest listInvoiceUnitsRequest) {
        return new ListInvoiceUnitsPublisher(this, listInvoiceUnitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvoiceUnits(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsPublisher publisher = client.listInvoiceUnitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsPublisher publisher = client.listInvoiceUnitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvoiceUnits(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvoiceUnitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvoiceUnitsRequest#builder()}
     * </p>
     *
     * @param listInvoiceUnitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.ListInvoiceUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvoiceUnitsPublisher listInvoiceUnitsPaginator(Consumer<ListInvoiceUnitsRequest.Builder> listInvoiceUnitsRequest) {
        return listInvoiceUnitsPaginator(ListInvoiceUnitsRequest.builder().applyMutation(listInvoiceUnitsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ServiceQuotaExceededException The request was rejected because it attempted to create resources
     *         beyond the current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ServiceQuotaExceededException The request was rejected because it attempted to create resources
     *         beyond the current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * You can update the invoice unit configuration at any time, and Amazon Web Services will use the latest
     * configuration at the end of the month.
     * </p>
     *
     * @param updateInvoiceUnitRequest
     * @return A Java Future containing the result of the UpdateInvoiceUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.UpdateInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/UpdateInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateInvoiceUnitResponse> updateInvoiceUnit(UpdateInvoiceUnitRequest updateInvoiceUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can update the invoice unit configuration at any time, and Amazon Web Services will use the latest
     * configuration at the end of the month.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInvoiceUnitRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateInvoiceUnitRequest#builder()}
     * </p>
     *
     * @param updateInvoiceUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.UpdateInvoiceUnitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateInvoiceUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The processing request failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InvoicingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InvoicingAsyncClient.UpdateInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/UpdateInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateInvoiceUnitResponse> updateInvoiceUnit(
            Consumer<UpdateInvoiceUnitRequest.Builder> updateInvoiceUnitRequest) {
        return updateInvoiceUnit(UpdateInvoiceUnitRequest.builder().applyMutation(updateInvoiceUnitRequest).build());
    }

    @Override
    default InvoicingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link InvoicingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static InvoicingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link InvoicingAsyncClient}.
     */
    static InvoicingAsyncClientBuilder builder() {
        return new DefaultInvoicingAsyncClientBuilder();
    }
}
