/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetInvoiceProfileResponse extends InvoicingResponse implements
        ToCopyableBuilder<BatchGetInvoiceProfileResponse.Builder, BatchGetInvoiceProfileResponse> {
    private static final SdkField<List<InvoiceProfile>> PROFILES_FIELD = SdkField
            .<List<InvoiceProfile>> builder(MarshallingType.LIST)
            .memberName("Profiles")
            .getter(getter(BatchGetInvoiceProfileResponse::profiles))
            .setter(setter(Builder::profiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvoiceProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvoiceProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InvoiceProfile> profiles;

    private BatchGetInvoiceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profiles = builder.profiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Profiles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of invoice profiles corresponding to the requested accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return A list of invoice profiles corresponding to the requested accounts.
     */
    public final List<InvoiceProfile> profiles() {
        return profiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profiles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetInvoiceProfileResponse)) {
            return false;
        }
        BatchGetInvoiceProfileResponse other = (BatchGetInvoiceProfileResponse) obj;
        return hasProfiles() == other.hasProfiles() && Objects.equals(profiles(), other.profiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetInvoiceProfileResponse").add("Profiles", hasProfiles() ? profiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Profiles":
            return Optional.ofNullable(clazz.cast(profiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Profiles", PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetInvoiceProfileResponse, T> g) {
        return obj -> g.apply((BatchGetInvoiceProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InvoicingResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetInvoiceProfileResponse> {
        /**
         * <p>
         * A list of invoice profiles corresponding to the requested accounts.
         * </p>
         * 
         * @param profiles
         *        A list of invoice profiles corresponding to the requested accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Collection<InvoiceProfile> profiles);

        /**
         * <p>
         * A list of invoice profiles corresponding to the requested accounts.
         * </p>
         * 
         * @param profiles
         *        A list of invoice profiles corresponding to the requested accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(InvoiceProfile... profiles);

        /**
         * <p>
         * A list of invoice profiles corresponding to the requested accounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.InvoiceProfile.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.invoicing.model.InvoiceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.InvoiceProfile.Builder#build()} is called immediately
         * and its result is passed to {@link #profiles(List<InvoiceProfile>)}.
         * 
         * @param profiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.InvoiceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profiles(java.util.Collection<InvoiceProfile>)
         */
        Builder profiles(Consumer<InvoiceProfile.Builder>... profiles);
    }

    static final class BuilderImpl extends InvoicingResponse.BuilderImpl implements Builder {
        private List<InvoiceProfile> profiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetInvoiceProfileResponse model) {
            super(model);
            profiles(model.profiles);
        }

        public final List<InvoiceProfile.Builder> getProfiles() {
            List<InvoiceProfile.Builder> result = ProfileListCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<InvoiceProfile.BuilderImpl> profiles) {
            this.profiles = ProfileListCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<InvoiceProfile> profiles) {
            this.profiles = ProfileListCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(InvoiceProfile... profiles) {
            profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<InvoiceProfile.Builder>... profiles) {
            profiles(Stream.of(profiles).map(c -> InvoiceProfile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetInvoiceProfileResponse build() {
            return new BatchGetInvoiceProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
