/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains high-level information about the invoice receiver.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvoiceProfile implements SdkPojo, Serializable, ToCopyableBuilder<InvoiceProfile.Builder, InvoiceProfile> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(InvoiceProfile::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> RECEIVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReceiverName").getter(getter(InvoiceProfile::receiverName)).setter(setter(Builder::receiverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverName").build()).build();

    private static final SdkField<ReceiverAddress> RECEIVER_ADDRESS_FIELD = SdkField
            .<ReceiverAddress> builder(MarshallingType.SDK_POJO).memberName("ReceiverAddress")
            .getter(getter(InvoiceProfile::receiverAddress)).setter(setter(Builder::receiverAddress))
            .constructor(ReceiverAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverAddress").build()).build();

    private static final SdkField<String> RECEIVER_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReceiverEmail").getter(getter(InvoiceProfile::receiverEmail)).setter(setter(Builder::receiverEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverEmail").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issuer")
            .getter(getter(InvoiceProfile::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> TAX_REGISTRATION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaxRegistrationNumber").getter(getter(InvoiceProfile::taxRegistrationNumber))
            .setter(setter(Builder::taxRegistrationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxRegistrationNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            RECEIVER_NAME_FIELD, RECEIVER_ADDRESS_FIELD, RECEIVER_EMAIL_FIELD, ISSUER_FIELD, TAX_REGISTRATION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String receiverName;

    private final ReceiverAddress receiverAddress;

    private final String receiverEmail;

    private final String issuer;

    private final String taxRegistrationNumber;

    private InvoiceProfile(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.receiverName = builder.receiverName;
        this.receiverAddress = builder.receiverAddress;
        this.receiverEmail = builder.receiverEmail;
        this.issuer = builder.issuer;
        this.taxRegistrationNumber = builder.taxRegistrationNumber;
    }

    /**
     * <p>
     * The account ID the invoice profile is generated for.
     * </p>
     * 
     * @return The account ID the invoice profile is generated for.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the person receiving the invoice profile.
     * </p>
     * 
     * @return The name of the person receiving the invoice profile.
     */
    public final String receiverName() {
        return receiverName;
    }

    /**
     * <p>
     * The address of the receiver that will be printed on the invoice.
     * </p>
     * 
     * @return The address of the receiver that will be printed on the invoice.
     */
    public final ReceiverAddress receiverAddress() {
        return receiverAddress;
    }

    /**
     * <p>
     * The email address for the invoice profile receiver.
     * </p>
     * 
     * @return The email address for the invoice profile receiver.
     */
    public final String receiverEmail() {
        return receiverEmail;
    }

    /**
     * <p>
     * This specifies the issuing entity of the invoice.
     * </p>
     * 
     * @return This specifies the issuing entity of the invoice.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * Your Tax Registration Number (TRN) information.
     * </p>
     * 
     * @return Your Tax Registration Number (TRN) information.
     */
    public final String taxRegistrationNumber() {
        return taxRegistrationNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(receiverName());
        hashCode = 31 * hashCode + Objects.hashCode(receiverAddress());
        hashCode = 31 * hashCode + Objects.hashCode(receiverEmail());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(taxRegistrationNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceProfile)) {
            return false;
        }
        InvoiceProfile other = (InvoiceProfile) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(receiverName(), other.receiverName())
                && Objects.equals(receiverAddress(), other.receiverAddress())
                && Objects.equals(receiverEmail(), other.receiverEmail()) && Objects.equals(issuer(), other.issuer())
                && Objects.equals(taxRegistrationNumber(), other.taxRegistrationNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvoiceProfile").add("AccountId", accountId()).add("ReceiverName", receiverName())
                .add("ReceiverAddress", receiverAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReceiverEmail", receiverEmail() == null ? null : "*** Sensitive Data Redacted ***").add("Issuer", issuer())
                .add("TaxRegistrationNumber", taxRegistrationNumber() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ReceiverName":
            return Optional.ofNullable(clazz.cast(receiverName()));
        case "ReceiverAddress":
            return Optional.ofNullable(clazz.cast(receiverAddress()));
        case "ReceiverEmail":
            return Optional.ofNullable(clazz.cast(receiverEmail()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "TaxRegistrationNumber":
            return Optional.ofNullable(clazz.cast(taxRegistrationNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ReceiverName", RECEIVER_NAME_FIELD);
        map.put("ReceiverAddress", RECEIVER_ADDRESS_FIELD);
        map.put("ReceiverEmail", RECEIVER_EMAIL_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("TaxRegistrationNumber", TAX_REGISTRATION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceProfile, T> g) {
        return obj -> g.apply((InvoiceProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvoiceProfile> {
        /**
         * <p>
         * The account ID the invoice profile is generated for.
         * </p>
         * 
         * @param accountId
         *        The account ID the invoice profile is generated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the person receiving the invoice profile.
         * </p>
         * 
         * @param receiverName
         *        The name of the person receiving the invoice profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverName(String receiverName);

        /**
         * <p>
         * The address of the receiver that will be printed on the invoice.
         * </p>
         * 
         * @param receiverAddress
         *        The address of the receiver that will be printed on the invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverAddress(ReceiverAddress receiverAddress);

        /**
         * <p>
         * The address of the receiver that will be printed on the invoice.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReceiverAddress.Builder} avoiding the
         * need to create one manually via {@link ReceiverAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReceiverAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #receiverAddress(ReceiverAddress)}.
         * 
         * @param receiverAddress
         *        a consumer that will call methods on {@link ReceiverAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #receiverAddress(ReceiverAddress)
         */
        default Builder receiverAddress(Consumer<ReceiverAddress.Builder> receiverAddress) {
            return receiverAddress(ReceiverAddress.builder().applyMutation(receiverAddress).build());
        }

        /**
         * <p>
         * The email address for the invoice profile receiver.
         * </p>
         * 
         * @param receiverEmail
         *        The email address for the invoice profile receiver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverEmail(String receiverEmail);

        /**
         * <p>
         * This specifies the issuing entity of the invoice.
         * </p>
         * 
         * @param issuer
         *        This specifies the issuing entity of the invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * Your Tax Registration Number (TRN) information.
         * </p>
         * 
         * @param taxRegistrationNumber
         *        Your Tax Registration Number (TRN) information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistrationNumber(String taxRegistrationNumber);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String receiverName;

        private ReceiverAddress receiverAddress;

        private String receiverEmail;

        private String issuer;

        private String taxRegistrationNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceProfile model) {
            accountId(model.accountId);
            receiverName(model.receiverName);
            receiverAddress(model.receiverAddress);
            receiverEmail(model.receiverEmail);
            issuer(model.issuer);
            taxRegistrationNumber(model.taxRegistrationNumber);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getReceiverName() {
            return receiverName;
        }

        public final void setReceiverName(String receiverName) {
            this.receiverName = receiverName;
        }

        @Override
        public final Builder receiverName(String receiverName) {
            this.receiverName = receiverName;
            return this;
        }

        public final ReceiverAddress.Builder getReceiverAddress() {
            return receiverAddress != null ? receiverAddress.toBuilder() : null;
        }

        public final void setReceiverAddress(ReceiverAddress.BuilderImpl receiverAddress) {
            this.receiverAddress = receiverAddress != null ? receiverAddress.build() : null;
        }

        @Override
        public final Builder receiverAddress(ReceiverAddress receiverAddress) {
            this.receiverAddress = receiverAddress;
            return this;
        }

        public final String getReceiverEmail() {
            return receiverEmail;
        }

        public final void setReceiverEmail(String receiverEmail) {
            this.receiverEmail = receiverEmail;
        }

        @Override
        public final Builder receiverEmail(String receiverEmail) {
            this.receiverEmail = receiverEmail;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getTaxRegistrationNumber() {
            return taxRegistrationNumber;
        }

        public final void setTaxRegistrationNumber(String taxRegistrationNumber) {
            this.taxRegistrationNumber = taxRegistrationNumber;
        }

        @Override
        public final Builder taxRegistrationNumber(String taxRegistrationNumber) {
            this.taxRegistrationNumber = taxRegistrationNumber;
            return this;
        }

        @Override
        public InvoiceProfile build() {
            return new InvoiceProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
