/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.AlarmModelVersionStatus;
import software.amazon.awssdk.services.iotevents.model.IotEventsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAlarmModelResponse
extends IotEventsResponse
implements ToCopyableBuilder<Builder, UpdateAlarmModelResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(UpdateAlarmModelResponse.getter(UpdateAlarmModelResponse::creationTime)).setter(UpdateAlarmModelResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> ALARM_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelArn").getter(UpdateAlarmModelResponse.getter(UpdateAlarmModelResponse::alarmModelArn)).setter(UpdateAlarmModelResponse.setter(Builder::alarmModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelArn").build()}).build();
    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelVersion").getter(UpdateAlarmModelResponse.getter(UpdateAlarmModelResponse::alarmModelVersion)).setter(UpdateAlarmModelResponse.setter(Builder::alarmModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(UpdateAlarmModelResponse.getter(UpdateAlarmModelResponse::lastUpdateTime)).setter(UpdateAlarmModelResponse.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateAlarmModelResponse.getter(UpdateAlarmModelResponse::statusAsString)).setter(UpdateAlarmModelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, ALARM_MODEL_ARN_FIELD, ALARM_MODEL_VERSION_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAlarmModelResponse.memberNameToFieldInitializer();
    private final Instant creationTime;
    private final String alarmModelArn;
    private final String alarmModelVersion;
    private final Instant lastUpdateTime;
    private final String status;

    private UpdateAlarmModelResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.alarmModelArn = builder.alarmModelArn;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String alarmModelArn() {
        return this.alarmModelArn;
    }

    public final String alarmModelVersion() {
        return this.alarmModelVersion;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final AlarmModelVersionStatus status() {
        return AlarmModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAlarmModelResponse)) {
            return false;
        }
        UpdateAlarmModelResponse other = (UpdateAlarmModelResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.alarmModelArn(), other.alarmModelArn()) && Objects.equals(this.alarmModelVersion(), other.alarmModelVersion()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAlarmModelResponse").add("CreationTime", (Object)this.creationTime()).add("AlarmModelArn", (Object)this.alarmModelArn()).add("AlarmModelVersion", (Object)this.alarmModelVersion()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "alarmModelArn": {
                return Optional.ofNullable(clazz.cast(this.alarmModelArn()));
            }
            case "alarmModelVersion": {
                return Optional.ofNullable(clazz.cast(this.alarmModelVersion()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("alarmModelArn", ALARM_MODEL_ARN_FIELD);
        map.put("alarmModelVersion", ALARM_MODEL_VERSION_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAlarmModelResponse, T> g) {
        return obj -> g.apply((UpdateAlarmModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String alarmModelArn;
        private String alarmModelVersion;
        private Instant lastUpdateTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAlarmModelResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.alarmModelArn(model.alarmModelArn);
            this.alarmModelVersion(model.alarmModelVersion);
            this.lastUpdateTime(model.lastUpdateTime);
            this.status(model.status);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlarmModelArn() {
            return this.alarmModelArn;
        }

        public final void setAlarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
        }

        @Override
        public final Builder alarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
            return this;
        }

        public final String getAlarmModelVersion() {
            return this.alarmModelVersion;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        @Override
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AlarmModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateAlarmModelResponse build() {
            return new UpdateAlarmModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAlarmModelResponse> {
        public Builder creationTime(Instant var1);

        public Builder alarmModelArn(String var1);

        public Builder alarmModelVersion(String var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(AlarmModelVersionStatus var1);
    }
}

