/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.VpcConnectionState;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcConnectionResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, DescribeVpcConnectionResponse> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectionArn").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::vpcConnectionArn)).setter(DescribeVpcConnectionResponse.setter(Builder::vpcConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()}).build();
    private static final SdkField<String> TARGET_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetClusterArn").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::targetClusterArn)).setter(DescribeVpcConnectionResponse.setter(Builder::targetClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::stateAsString)).setter(DescribeVpcConnectionResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Authentication").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::authentication)).setter(DescribeVpcConnectionResponse.setter(Builder::authentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::vpcId)).setter(DescribeVpcConnectionResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::subnets)).setter(DescribeVpcConnectionResponse.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::securityGroups)).setter(DescribeVpcConnectionResponse.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::creationTime)).setter(DescribeVpcConnectionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeVpcConnectionResponse.getter(DescribeVpcConnectionResponse::tags)).setter(DescribeVpcConnectionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD, TARGET_CLUSTER_ARN_FIELD, STATE_FIELD, AUTHENTICATION_FIELD, VPC_ID_FIELD, SUBNETS_FIELD, SECURITY_GROUPS_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("vpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
            this.put("targetClusterArn", TARGET_CLUSTER_ARN_FIELD);
            this.put("state", STATE_FIELD);
            this.put("authentication", AUTHENTICATION_FIELD);
            this.put("vpcId", VPC_ID_FIELD);
            this.put("subnets", SUBNETS_FIELD);
            this.put("securityGroups", SECURITY_GROUPS_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String vpcConnectionArn;
    private final String targetClusterArn;
    private final String state;
    private final String authentication;
    private final String vpcId;
    private final List<String> subnets;
    private final List<String> securityGroups;
    private final Instant creationTime;
    private final Map<String, String> tags;

    private DescribeVpcConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.targetClusterArn = builder.targetClusterArn;
        this.state = builder.state;
        this.authentication = builder.authentication;
        this.vpcId = builder.vpcId;
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    public final String vpcConnectionArn() {
        return this.vpcConnectionArn;
    }

    public final String targetClusterArn() {
        return this.targetClusterArn;
    }

    public final VpcConnectionState state() {
        return VpcConnectionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String authentication() {
        return this.authentication;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcConnectionResponse)) {
            return false;
        }
        DescribeVpcConnectionResponse other = (DescribeVpcConnectionResponse)((Object)obj);
        return Objects.equals(this.vpcConnectionArn(), other.vpcConnectionArn()) && Objects.equals(this.targetClusterArn(), other.targetClusterArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcConnectionResponse").add("VpcConnectionArn", (Object)this.vpcConnectionArn()).add("TargetClusterArn", (Object)this.targetClusterArn()).add("State", (Object)this.stateAsString()).add("Authentication", (Object)this.authentication()).add("VpcId", (Object)this.vpcId()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionArn()));
            }
            case "TargetClusterArn": {
                return Optional.ofNullable(clazz.cast(this.targetClusterArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcConnectionResponse, T> g) {
        return obj -> g.apply((DescribeVpcConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String vpcConnectionArn;
        private String targetClusterArn;
        private String state;
        private String authentication;
        private String vpcId;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcConnectionResponse model) {
            super(model);
            this.vpcConnectionArn(model.vpcConnectionArn);
            this.targetClusterArn(model.targetClusterArn);
            this.state(model.state);
            this.authentication(model.authentication);
            this.vpcId(model.vpcId);
            this.subnets(model.subnets);
            this.securityGroups(model.securityGroups);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
        }

        public final String getVpcConnectionArn() {
            return this.vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getTargetClusterArn() {
            return this.targetClusterArn;
        }

        public final void setTargetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
        }

        @Override
        public final Builder targetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAuthentication() {
            return this.authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = ___listOf__stringCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = ___listOf__stringCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeVpcConnectionResponse build() {
            return new DescribeVpcConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcConnectionResponse> {
        public Builder vpcConnectionArn(String var1);

        public Builder targetClusterArn(String var1);

        public Builder state(String var1);

        public Builder state(VpcConnectionState var1);

        public Builder authentication(String var1);

        public Builder vpcId(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder creationTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

