/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.VpcConnectionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientVpcConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientVpcConnection> {
    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Authentication").getter(ClientVpcConnection.getter(ClientVpcConnection::authentication)).setter(ClientVpcConnection.setter(Builder::authentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ClientVpcConnection.getter(ClientVpcConnection::creationTime)).setter(ClientVpcConnection.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ClientVpcConnection.getter(ClientVpcConnection::stateAsString)).setter(ClientVpcConnection.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectionArn").getter(ClientVpcConnection.getter(ClientVpcConnection::vpcConnectionArn)).setter(ClientVpcConnection.setter(Builder::vpcConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(ClientVpcConnection.getter(ClientVpcConnection::owner)).setter(ClientVpcConnection.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD, CREATION_TIME_FIELD, STATE_FIELD, VPC_CONNECTION_ARN_FIELD, OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClientVpcConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authentication;
    private final Instant creationTime;
    private final String state;
    private final String vpcConnectionArn;
    private final String owner;

    private ClientVpcConnection(BuilderImpl builder) {
        this.authentication = builder.authentication;
        this.creationTime = builder.creationTime;
        this.state = builder.state;
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.owner = builder.owner;
    }

    public final String authentication() {
        return this.authentication;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final VpcConnectionState state() {
        return VpcConnectionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String vpcConnectionArn() {
        return this.vpcConnectionArn;
    }

    public final String owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpcConnection)) {
            return false;
        }
        ClientVpcConnection other = (ClientVpcConnection)obj;
        return Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.vpcConnectionArn(), other.vpcConnectionArn()) && Objects.equals(this.owner(), other.owner());
    }

    public final String toString() {
        return ToString.builder((String)"ClientVpcConnection").add("Authentication", (Object)this.authentication()).add("CreationTime", (Object)this.creationTime()).add("State", (Object)this.stateAsString()).add("VpcConnectionArn", (Object)this.vpcConnectionArn()).add("Owner", (Object)this.owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "VpcConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionArn()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authentication", AUTHENTICATION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("state", STATE_FIELD);
        map.put("vpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
        map.put("owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientVpcConnection, T> g) {
        return obj -> g.apply((ClientVpcConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authentication;
        private Instant creationTime;
        private String state;
        private String vpcConnectionArn;
        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpcConnection model) {
            this.authentication(model.authentication);
            this.creationTime(model.creationTime);
            this.state(model.state);
            this.vpcConnectionArn(model.vpcConnectionArn);
            this.owner(model.owner);
        }

        public final String getAuthentication() {
            return this.authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getVpcConnectionArn() {
            return this.vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public ClientVpcConnection build() {
            return new ClientVpcConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientVpcConnection> {
        public Builder authentication(String var1);

        public Builder creationTime(Instant var1);

        public Builder state(String var1);

        public Builder state(VpcConnectionState var1);

        public Builder vpcConnectionArn(String var1);

        public Builder owner(String var1);
    }
}

