/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.NodeInfo;
import software.amazon.awssdk.services.kafka.model.___listOfNodeInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNodesResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, ListNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNodesResponse.getter(ListNodesResponse::nextToken)).setter(ListNodesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<NodeInfo>> NODE_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeInfoList").getter(ListNodesResponse.getter(ListNodesResponse::nodeInfoList)).setter(ListNodesResponse.setter(Builder::nodeInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NODE_INFO_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNodesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<NodeInfo> nodeInfoList;

    private ListNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.nodeInfoList = builder.nodeInfoList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNodeInfoList() {
        return this.nodeInfoList != null && !(this.nodeInfoList instanceof SdkAutoConstructList);
    }

    public final List<NodeInfo> nodeInfoList() {
        return this.nodeInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeInfoList() ? this.nodeInfoList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodesResponse)) {
            return false;
        }
        ListNodesResponse other = (ListNodesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNodeInfoList() == other.hasNodeInfoList() && Objects.equals(this.nodeInfoList(), other.nodeInfoList());
    }

    public final String toString() {
        return ToString.builder((String)"ListNodesResponse").add("NextToken", (Object)this.nextToken()).add("NodeInfoList", this.hasNodeInfoList() ? this.nodeInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NodeInfoList": {
                return Optional.ofNullable(clazz.cast(this.nodeInfoList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("nodeInfoList", NODE_INFO_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNodesResponse, T> g) {
        return obj -> g.apply((ListNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NodeInfo> nodeInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.nodeInfoList(model.nodeInfoList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NodeInfo.Builder> getNodeInfoList() {
            List<NodeInfo.Builder> result = ___listOfNodeInfoCopier.copyToBuilder(this.nodeInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInfoList(Collection<NodeInfo.BuilderImpl> nodeInfoList) {
            this.nodeInfoList = ___listOfNodeInfoCopier.copyFromBuilder(nodeInfoList);
        }

        @Override
        public final Builder nodeInfoList(Collection<NodeInfo> nodeInfoList) {
            this.nodeInfoList = ___listOfNodeInfoCopier.copy(nodeInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInfoList(NodeInfo ... nodeInfoList) {
            this.nodeInfoList(Arrays.asList(nodeInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInfoList(Consumer<NodeInfo.Builder> ... nodeInfoList) {
            this.nodeInfoList(Stream.of(nodeInfoList).map(c -> (NodeInfo)((NodeInfo.Builder)NodeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNodesResponse build() {
            return new ListNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNodesResponse> {
        public Builder nextToken(String var1);

        public Builder nodeInfoList(Collection<NodeInfo> var1);

        public Builder nodeInfoList(NodeInfo ... var1);

        public Builder nodeInfoList(Consumer<NodeInfo.Builder> ... var1);
    }
}

