/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafkaconnect.model.CapacityDescription;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorState;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterDescription;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaConnectResponse;
import software.amazon.awssdk.services.kafkaconnect.model.LogDeliveryDescription;
import software.amazon.awssdk.services.kafkaconnect.model.PluginDescription;
import software.amazon.awssdk.services.kafkaconnect.model.StateDescription;
import software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationDescription;
import software.amazon.awssdk.services.kafkaconnect.model.___listOfPluginDescriptionCopier;
import software.amazon.awssdk.services.kafkaconnect.model.___sensitive__mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorResponse
extends KafkaConnectResponse
implements ToCopyableBuilder<Builder, DescribeConnectorResponse> {
    private static final SdkField<CapacityDescription> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacity").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::capacity)).setter(DescribeConnectorResponse.setter(Builder::capacity)).constructor(CapacityDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()}).build();
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorArn").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::connectorArn)).setter(DescribeConnectorResponse.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()}).build();
    private static final SdkField<Map<String, String>> CONNECTOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("connectorConfiguration").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::connectorConfiguration)).setter(DescribeConnectorResponse.setter(Builder::connectorConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorDescription").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::connectorDescription)).setter(DescribeConnectorResponse.setter(Builder::connectorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorDescription").build()}).build();
    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorName").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::connectorName)).setter(DescribeConnectorResponse.setter(Builder::connectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()}).build();
    private static final SdkField<String> CONNECTOR_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorState").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::connectorStateAsString)).setter(DescribeConnectorResponse.setter(Builder::connectorState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorState").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::creationTime)).setter(DescribeConnectorResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentVersion").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::currentVersion)).setter(DescribeConnectorResponse.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<KafkaClusterDescription> KAFKA_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kafkaCluster").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::kafkaCluster)).setter(DescribeConnectorResponse.setter(Builder::kafkaCluster)).constructor(KafkaClusterDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaCluster").build()}).build();
    private static final SdkField<KafkaClusterClientAuthenticationDescription> KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kafkaClusterClientAuthentication").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::kafkaClusterClientAuthentication)).setter(DescribeConnectorResponse.setter(Builder::kafkaClusterClientAuthentication)).constructor(KafkaClusterClientAuthenticationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterClientAuthentication").build()}).build();
    private static final SdkField<KafkaClusterEncryptionInTransitDescription> KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kafkaClusterEncryptionInTransit").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::kafkaClusterEncryptionInTransit)).setter(DescribeConnectorResponse.setter(Builder::kafkaClusterEncryptionInTransit)).constructor(KafkaClusterEncryptionInTransitDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterEncryptionInTransit").build()}).build();
    private static final SdkField<String> KAFKA_CONNECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kafkaConnectVersion").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::kafkaConnectVersion)).setter(DescribeConnectorResponse.setter(Builder::kafkaConnectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaConnectVersion").build()}).build();
    private static final SdkField<LogDeliveryDescription> LOG_DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logDelivery").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::logDelivery)).setter(DescribeConnectorResponse.setter(Builder::logDelivery)).constructor(LogDeliveryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDelivery").build()}).build();
    private static final SdkField<List<PluginDescription>> PLUGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("plugins").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::plugins)).setter(DescribeConnectorResponse.setter(Builder::plugins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plugins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PluginDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceExecutionRoleArn").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::serviceExecutionRoleArn)).setter(DescribeConnectorResponse.setter(Builder::serviceExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceExecutionRoleArn").build()}).build();
    private static final SdkField<StateDescription> STATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stateDescription").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::stateDescription)).setter(DescribeConnectorResponse.setter(Builder::stateDescription)).constructor(StateDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDescription").build()}).build();
    private static final SdkField<WorkerConfigurationDescription> WORKER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workerConfiguration").getter(DescribeConnectorResponse.getter(DescribeConnectorResponse::workerConfiguration)).setter(DescribeConnectorResponse.setter(Builder::workerConfiguration)).constructor(WorkerConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD, CONNECTOR_ARN_FIELD, CONNECTOR_CONFIGURATION_FIELD, CONNECTOR_DESCRIPTION_FIELD, CONNECTOR_NAME_FIELD, CONNECTOR_STATE_FIELD, CREATION_TIME_FIELD, CURRENT_VERSION_FIELD, KAFKA_CLUSTER_FIELD, KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD, KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD, KAFKA_CONNECT_VERSION_FIELD, LOG_DELIVERY_FIELD, PLUGINS_FIELD, SERVICE_EXECUTION_ROLE_ARN_FIELD, STATE_DESCRIPTION_FIELD, WORKER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("capacity", CAPACITY_FIELD);
            this.put("connectorArn", CONNECTOR_ARN_FIELD);
            this.put("connectorConfiguration", CONNECTOR_CONFIGURATION_FIELD);
            this.put("connectorDescription", CONNECTOR_DESCRIPTION_FIELD);
            this.put("connectorName", CONNECTOR_NAME_FIELD);
            this.put("connectorState", CONNECTOR_STATE_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("currentVersion", CURRENT_VERSION_FIELD);
            this.put("kafkaCluster", KAFKA_CLUSTER_FIELD);
            this.put("kafkaClusterClientAuthentication", KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD);
            this.put("kafkaClusterEncryptionInTransit", KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD);
            this.put("kafkaConnectVersion", KAFKA_CONNECT_VERSION_FIELD);
            this.put("logDelivery", LOG_DELIVERY_FIELD);
            this.put("plugins", PLUGINS_FIELD);
            this.put("serviceExecutionRoleArn", SERVICE_EXECUTION_ROLE_ARN_FIELD);
            this.put("stateDescription", STATE_DESCRIPTION_FIELD);
            this.put("workerConfiguration", WORKER_CONFIGURATION_FIELD);
        }
    });
    private final CapacityDescription capacity;
    private final String connectorArn;
    private final Map<String, String> connectorConfiguration;
    private final String connectorDescription;
    private final String connectorName;
    private final String connectorState;
    private final Instant creationTime;
    private final String currentVersion;
    private final KafkaClusterDescription kafkaCluster;
    private final KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication;
    private final KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit;
    private final String kafkaConnectVersion;
    private final LogDeliveryDescription logDelivery;
    private final List<PluginDescription> plugins;
    private final String serviceExecutionRoleArn;
    private final StateDescription stateDescription;
    private final WorkerConfigurationDescription workerConfiguration;

    private DescribeConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
        this.connectorArn = builder.connectorArn;
        this.connectorConfiguration = builder.connectorConfiguration;
        this.connectorDescription = builder.connectorDescription;
        this.connectorName = builder.connectorName;
        this.connectorState = builder.connectorState;
        this.creationTime = builder.creationTime;
        this.currentVersion = builder.currentVersion;
        this.kafkaCluster = builder.kafkaCluster;
        this.kafkaClusterClientAuthentication = builder.kafkaClusterClientAuthentication;
        this.kafkaClusterEncryptionInTransit = builder.kafkaClusterEncryptionInTransit;
        this.kafkaConnectVersion = builder.kafkaConnectVersion;
        this.logDelivery = builder.logDelivery;
        this.plugins = builder.plugins;
        this.serviceExecutionRoleArn = builder.serviceExecutionRoleArn;
        this.stateDescription = builder.stateDescription;
        this.workerConfiguration = builder.workerConfiguration;
    }

    public final CapacityDescription capacity() {
        return this.capacity;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final boolean hasConnectorConfiguration() {
        return this.connectorConfiguration != null && !(this.connectorConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectorConfiguration() {
        return this.connectorConfiguration;
    }

    public final String connectorDescription() {
        return this.connectorDescription;
    }

    public final String connectorName() {
        return this.connectorName;
    }

    public final ConnectorState connectorState() {
        return ConnectorState.fromValue(this.connectorState);
    }

    public final String connectorStateAsString() {
        return this.connectorState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final KafkaClusterDescription kafkaCluster() {
        return this.kafkaCluster;
    }

    public final KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication() {
        return this.kafkaClusterClientAuthentication;
    }

    public final KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit() {
        return this.kafkaClusterEncryptionInTransit;
    }

    public final String kafkaConnectVersion() {
        return this.kafkaConnectVersion;
    }

    public final LogDeliveryDescription logDelivery() {
        return this.logDelivery;
    }

    public final boolean hasPlugins() {
        return this.plugins != null && !(this.plugins instanceof SdkAutoConstructList);
    }

    public final List<PluginDescription> plugins() {
        return this.plugins;
    }

    public final String serviceExecutionRoleArn() {
        return this.serviceExecutionRoleArn;
    }

    public final StateDescription stateDescription() {
        return this.stateDescription;
    }

    public final WorkerConfigurationDescription workerConfiguration() {
        return this.workerConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorConfiguration() ? this.connectorConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaClusterClientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaClusterEncryptionInTransit());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaConnectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlugins() ? this.plugins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorResponse)) {
            return false;
        }
        DescribeConnectorResponse other = (DescribeConnectorResponse)((Object)obj);
        return Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.connectorArn(), other.connectorArn()) && this.hasConnectorConfiguration() == other.hasConnectorConfiguration() && Objects.equals(this.connectorConfiguration(), other.connectorConfiguration()) && Objects.equals(this.connectorDescription(), other.connectorDescription()) && Objects.equals(this.connectorName(), other.connectorName()) && Objects.equals(this.connectorStateAsString(), other.connectorStateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.kafkaCluster(), other.kafkaCluster()) && Objects.equals(this.kafkaClusterClientAuthentication(), other.kafkaClusterClientAuthentication()) && Objects.equals(this.kafkaClusterEncryptionInTransit(), other.kafkaClusterEncryptionInTransit()) && Objects.equals(this.kafkaConnectVersion(), other.kafkaConnectVersion()) && Objects.equals(this.logDelivery(), other.logDelivery()) && this.hasPlugins() == other.hasPlugins() && Objects.equals(this.plugins(), other.plugins()) && Objects.equals(this.serviceExecutionRoleArn(), other.serviceExecutionRoleArn()) && Objects.equals(this.stateDescription(), other.stateDescription()) && Objects.equals(this.workerConfiguration(), other.workerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectorResponse").add("Capacity", (Object)this.capacity()).add("ConnectorArn", (Object)this.connectorArn()).add("ConnectorConfiguration", (Object)(this.connectorConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectorDescription", (Object)this.connectorDescription()).add("ConnectorName", (Object)this.connectorName()).add("ConnectorState", (Object)this.connectorStateAsString()).add("CreationTime", (Object)this.creationTime()).add("CurrentVersion", (Object)this.currentVersion()).add("KafkaCluster", (Object)this.kafkaCluster()).add("KafkaClusterClientAuthentication", (Object)this.kafkaClusterClientAuthentication()).add("KafkaClusterEncryptionInTransit", (Object)this.kafkaClusterEncryptionInTransit()).add("KafkaConnectVersion", (Object)this.kafkaConnectVersion()).add("LogDelivery", (Object)this.logDelivery()).add("Plugins", this.hasPlugins() ? this.plugins() : null).add("ServiceExecutionRoleArn", (Object)this.serviceExecutionRoleArn()).add("StateDescription", (Object)this.stateDescription()).add("WorkerConfiguration", (Object)this.workerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "connectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "connectorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.connectorConfiguration()));
            }
            case "connectorDescription": {
                return Optional.ofNullable(clazz.cast(this.connectorDescription()));
            }
            case "connectorName": {
                return Optional.ofNullable(clazz.cast(this.connectorName()));
            }
            case "connectorState": {
                return Optional.ofNullable(clazz.cast(this.connectorStateAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "currentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "kafkaCluster": {
                return Optional.ofNullable(clazz.cast(this.kafkaCluster()));
            }
            case "kafkaClusterClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.kafkaClusterClientAuthentication()));
            }
            case "kafkaClusterEncryptionInTransit": {
                return Optional.ofNullable(clazz.cast(this.kafkaClusterEncryptionInTransit()));
            }
            case "kafkaConnectVersion": {
                return Optional.ofNullable(clazz.cast(this.kafkaConnectVersion()));
            }
            case "logDelivery": {
                return Optional.ofNullable(clazz.cast(this.logDelivery()));
            }
            case "plugins": {
                return Optional.ofNullable(clazz.cast(this.plugins()));
            }
            case "serviceExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRoleArn()));
            }
            case "stateDescription": {
                return Optional.ofNullable(clazz.cast(this.stateDescription()));
            }
            case "workerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.workerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorResponse, T> g) {
        return obj -> g.apply((DescribeConnectorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaConnectResponse.BuilderImpl
    implements Builder {
        private CapacityDescription capacity;
        private String connectorArn;
        private Map<String, String> connectorConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String connectorDescription;
        private String connectorName;
        private String connectorState;
        private Instant creationTime;
        private String currentVersion;
        private KafkaClusterDescription kafkaCluster;
        private KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication;
        private KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit;
        private String kafkaConnectVersion;
        private LogDeliveryDescription logDelivery;
        private List<PluginDescription> plugins = DefaultSdkAutoConstructList.getInstance();
        private String serviceExecutionRoleArn;
        private StateDescription stateDescription;
        private WorkerConfigurationDescription workerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorResponse model) {
            super(model);
            this.capacity(model.capacity);
            this.connectorArn(model.connectorArn);
            this.connectorConfiguration(model.connectorConfiguration);
            this.connectorDescription(model.connectorDescription);
            this.connectorName(model.connectorName);
            this.connectorState(model.connectorState);
            this.creationTime(model.creationTime);
            this.currentVersion(model.currentVersion);
            this.kafkaCluster(model.kafkaCluster);
            this.kafkaClusterClientAuthentication(model.kafkaClusterClientAuthentication);
            this.kafkaClusterEncryptionInTransit(model.kafkaClusterEncryptionInTransit);
            this.kafkaConnectVersion(model.kafkaConnectVersion);
            this.logDelivery(model.logDelivery);
            this.plugins(model.plugins);
            this.serviceExecutionRoleArn(model.serviceExecutionRoleArn);
            this.stateDescription(model.stateDescription);
            this.workerConfiguration(model.workerConfiguration);
        }

        public final CapacityDescription.Builder getCapacity() {
            return this.capacity != null ? this.capacity.toBuilder() : null;
        }

        public final void setCapacity(CapacityDescription.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(CapacityDescription capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final Map<String, String> getConnectorConfiguration() {
            if (this.connectorConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectorConfiguration;
        }

        public final void setConnectorConfiguration(Map<String, String> connectorConfiguration) {
            this.connectorConfiguration = ___sensitive__mapOf__stringCopier.copy(connectorConfiguration);
        }

        @Override
        public final Builder connectorConfiguration(Map<String, String> connectorConfiguration) {
            this.connectorConfiguration = ___sensitive__mapOf__stringCopier.copy(connectorConfiguration);
            return this;
        }

        public final String getConnectorDescription() {
            return this.connectorDescription;
        }

        public final void setConnectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
        }

        @Override
        public final Builder connectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        public final String getConnectorName() {
            return this.connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectorState() {
            return this.connectorState;
        }

        public final void setConnectorState(String connectorState) {
            this.connectorState = connectorState;
        }

        @Override
        public final Builder connectorState(String connectorState) {
            this.connectorState = connectorState;
            return this;
        }

        @Override
        public final Builder connectorState(ConnectorState connectorState) {
            this.connectorState(connectorState == null ? null : connectorState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final KafkaClusterDescription.Builder getKafkaCluster() {
            return this.kafkaCluster != null ? this.kafkaCluster.toBuilder() : null;
        }

        public final void setKafkaCluster(KafkaClusterDescription.BuilderImpl kafkaCluster) {
            this.kafkaCluster = kafkaCluster != null ? kafkaCluster.build() : null;
        }

        @Override
        public final Builder kafkaCluster(KafkaClusterDescription kafkaCluster) {
            this.kafkaCluster = kafkaCluster;
            return this;
        }

        public final KafkaClusterClientAuthenticationDescription.Builder getKafkaClusterClientAuthentication() {
            return this.kafkaClusterClientAuthentication != null ? this.kafkaClusterClientAuthentication.toBuilder() : null;
        }

        public final void setKafkaClusterClientAuthentication(KafkaClusterClientAuthenticationDescription.BuilderImpl kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication != null ? kafkaClusterClientAuthentication.build() : null;
        }

        @Override
        public final Builder kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication;
            return this;
        }

        public final KafkaClusterEncryptionInTransitDescription.Builder getKafkaClusterEncryptionInTransit() {
            return this.kafkaClusterEncryptionInTransit != null ? this.kafkaClusterEncryptionInTransit.toBuilder() : null;
        }

        public final void setKafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitDescription.BuilderImpl kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit != null ? kafkaClusterEncryptionInTransit.build() : null;
        }

        @Override
        public final Builder kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit;
            return this;
        }

        public final String getKafkaConnectVersion() {
            return this.kafkaConnectVersion;
        }

        public final void setKafkaConnectVersion(String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
        }

        @Override
        public final Builder kafkaConnectVersion(String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
            return this;
        }

        public final LogDeliveryDescription.Builder getLogDelivery() {
            return this.logDelivery != null ? this.logDelivery.toBuilder() : null;
        }

        public final void setLogDelivery(LogDeliveryDescription.BuilderImpl logDelivery) {
            this.logDelivery = logDelivery != null ? logDelivery.build() : null;
        }

        @Override
        public final Builder logDelivery(LogDeliveryDescription logDelivery) {
            this.logDelivery = logDelivery;
            return this;
        }

        public final List<PluginDescription.Builder> getPlugins() {
            List<PluginDescription.Builder> result = ___listOfPluginDescriptionCopier.copyToBuilder(this.plugins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlugins(Collection<PluginDescription.BuilderImpl> plugins) {
            this.plugins = ___listOfPluginDescriptionCopier.copyFromBuilder(plugins);
        }

        @Override
        public final Builder plugins(Collection<PluginDescription> plugins) {
            this.plugins = ___listOfPluginDescriptionCopier.copy(plugins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(PluginDescription ... plugins) {
            this.plugins(Arrays.asList(plugins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(Consumer<PluginDescription.Builder> ... plugins) {
            this.plugins(Stream.of(plugins).map(c -> (PluginDescription)((PluginDescription.Builder)PluginDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceExecutionRoleArn() {
            return this.serviceExecutionRoleArn;
        }

        public final void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
        }

        @Override
        public final Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public final StateDescription.Builder getStateDescription() {
            return this.stateDescription != null ? this.stateDescription.toBuilder() : null;
        }

        public final void setStateDescription(StateDescription.BuilderImpl stateDescription) {
            this.stateDescription = stateDescription != null ? stateDescription.build() : null;
        }

        @Override
        public final Builder stateDescription(StateDescription stateDescription) {
            this.stateDescription = stateDescription;
            return this;
        }

        public final WorkerConfigurationDescription.Builder getWorkerConfiguration() {
            return this.workerConfiguration != null ? this.workerConfiguration.toBuilder() : null;
        }

        public final void setWorkerConfiguration(WorkerConfigurationDescription.BuilderImpl workerConfiguration) {
            this.workerConfiguration = workerConfiguration != null ? workerConfiguration.build() : null;
        }

        @Override
        public final Builder workerConfiguration(WorkerConfigurationDescription workerConfiguration) {
            this.workerConfiguration = workerConfiguration;
            return this;
        }

        @Override
        public DescribeConnectorResponse build() {
            return new DescribeConnectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorResponse> {
        public Builder capacity(CapacityDescription var1);

        default public Builder capacity(Consumer<CapacityDescription.Builder> capacity) {
            return this.capacity((CapacityDescription)((CapacityDescription.Builder)CapacityDescription.builder().applyMutation(capacity)).build());
        }

        public Builder connectorArn(String var1);

        public Builder connectorConfiguration(Map<String, String> var1);

        public Builder connectorDescription(String var1);

        public Builder connectorName(String var1);

        public Builder connectorState(String var1);

        public Builder connectorState(ConnectorState var1);

        public Builder creationTime(Instant var1);

        public Builder currentVersion(String var1);

        public Builder kafkaCluster(KafkaClusterDescription var1);

        default public Builder kafkaCluster(Consumer<KafkaClusterDescription.Builder> kafkaCluster) {
            return this.kafkaCluster((KafkaClusterDescription)((KafkaClusterDescription.Builder)KafkaClusterDescription.builder().applyMutation(kafkaCluster)).build());
        }

        public Builder kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationDescription var1);

        default public Builder kafkaClusterClientAuthentication(Consumer<KafkaClusterClientAuthenticationDescription.Builder> kafkaClusterClientAuthentication) {
            return this.kafkaClusterClientAuthentication((KafkaClusterClientAuthenticationDescription)((KafkaClusterClientAuthenticationDescription.Builder)KafkaClusterClientAuthenticationDescription.builder().applyMutation(kafkaClusterClientAuthentication)).build());
        }

        public Builder kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitDescription var1);

        default public Builder kafkaClusterEncryptionInTransit(Consumer<KafkaClusterEncryptionInTransitDescription.Builder> kafkaClusterEncryptionInTransit) {
            return this.kafkaClusterEncryptionInTransit((KafkaClusterEncryptionInTransitDescription)((KafkaClusterEncryptionInTransitDescription.Builder)KafkaClusterEncryptionInTransitDescription.builder().applyMutation(kafkaClusterEncryptionInTransit)).build());
        }

        public Builder kafkaConnectVersion(String var1);

        public Builder logDelivery(LogDeliveryDescription var1);

        default public Builder logDelivery(Consumer<LogDeliveryDescription.Builder> logDelivery) {
            return this.logDelivery((LogDeliveryDescription)((LogDeliveryDescription.Builder)LogDeliveryDescription.builder().applyMutation(logDelivery)).build());
        }

        public Builder plugins(Collection<PluginDescription> var1);

        public Builder plugins(PluginDescription ... var1);

        public Builder plugins(Consumer<PluginDescription.Builder> ... var1);

        public Builder serviceExecutionRoleArn(String var1);

        public Builder stateDescription(StateDescription var1);

        default public Builder stateDescription(Consumer<StateDescription.Builder> stateDescription) {
            return this.stateDescription((StateDescription)((StateDescription.Builder)StateDescription.builder().applyMutation(stateDescription)).build());
        }

        public Builder workerConfiguration(WorkerConfigurationDescription var1);

        default public Builder workerConfiguration(Consumer<WorkerConfigurationDescription.Builder> workerConfiguration) {
            return this.workerConfiguration((WorkerConfigurationDescription)((WorkerConfigurationDescription.Builder)WorkerConfigurationDescription.builder().applyMutation(workerConfiguration)).build());
        }
    }
}

