/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The updates to the auto scaling parameters for the connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingUpdate.Builder, AutoScalingUpdate> {
    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxWorkerCount").getter(getter(AutoScalingUpdate::maxWorkerCount))
            .setter(setter(Builder::maxWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()).build();

    private static final SdkField<Integer> MCU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("mcuCount").getter(getter(AutoScalingUpdate::mcuCount)).setter(setter(Builder::mcuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mcuCount").build()).build();

    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minWorkerCount").getter(getter(AutoScalingUpdate::minWorkerCount))
            .setter(setter(Builder::minWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()).build();

    private static final SdkField<ScaleInPolicyUpdate> SCALE_IN_POLICY_FIELD = SdkField
            .<ScaleInPolicyUpdate> builder(MarshallingType.SDK_POJO).memberName("scaleInPolicy")
            .getter(getter(AutoScalingUpdate::scaleInPolicy)).setter(setter(Builder::scaleInPolicy))
            .constructor(ScaleInPolicyUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInPolicy").build()).build();

    private static final SdkField<ScaleOutPolicyUpdate> SCALE_OUT_POLICY_FIELD = SdkField
            .<ScaleOutPolicyUpdate> builder(MarshallingType.SDK_POJO).memberName("scaleOutPolicy")
            .getter(getter(AutoScalingUpdate::scaleOutPolicy)).setter(setter(Builder::scaleOutPolicy))
            .constructor(ScaleOutPolicyUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleOutPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_WORKER_COUNT_FIELD,
            MCU_COUNT_FIELD, MIN_WORKER_COUNT_FIELD, SCALE_IN_POLICY_FIELD, SCALE_OUT_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxWorkerCount;

    private final Integer mcuCount;

    private final Integer minWorkerCount;

    private final ScaleInPolicyUpdate scaleInPolicy;

    private final ScaleOutPolicyUpdate scaleOutPolicy;

    private AutoScalingUpdate(BuilderImpl builder) {
        this.maxWorkerCount = builder.maxWorkerCount;
        this.mcuCount = builder.mcuCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.scaleInPolicy = builder.scaleInPolicy;
        this.scaleOutPolicy = builder.scaleOutPolicy;
    }

    /**
     * <p>
     * The target maximum number of workers allocated to the connector.
     * </p>
     * 
     * @return The target maximum number of workers allocated to the connector.
     */
    public final Integer maxWorkerCount() {
        return maxWorkerCount;
    }

    /**
     * <p>
     * The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are
     * 1,2,4,8.
     * </p>
     * 
     * @return The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values
     *         are 1,2,4,8.
     */
    public final Integer mcuCount() {
        return mcuCount;
    }

    /**
     * <p>
     * The target minimum number of workers allocated to the connector.
     * </p>
     * 
     * @return The target minimum number of workers allocated to the connector.
     */
    public final Integer minWorkerCount() {
        return minWorkerCount;
    }

    /**
     * <p>
     * The target sacle-in policy for the connector.
     * </p>
     * 
     * @return The target sacle-in policy for the connector.
     */
    public final ScaleInPolicyUpdate scaleInPolicy() {
        return scaleInPolicy;
    }

    /**
     * <p>
     * The target sacle-out policy for the connector.
     * </p>
     * 
     * @return The target sacle-out policy for the connector.
     */
    public final ScaleOutPolicyUpdate scaleOutPolicy() {
        return scaleOutPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(mcuCount());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingUpdate)) {
            return false;
        }
        AutoScalingUpdate other = (AutoScalingUpdate) obj;
        return Objects.equals(maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(mcuCount(), other.mcuCount())
                && Objects.equals(minWorkerCount(), other.minWorkerCount())
                && Objects.equals(scaleInPolicy(), other.scaleInPolicy())
                && Objects.equals(scaleOutPolicy(), other.scaleOutPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingUpdate").add("MaxWorkerCount", maxWorkerCount()).add("McuCount", mcuCount())
                .add("MinWorkerCount", minWorkerCount()).add("ScaleInPolicy", scaleInPolicy())
                .add("ScaleOutPolicy", scaleOutPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxWorkerCount":
            return Optional.ofNullable(clazz.cast(maxWorkerCount()));
        case "mcuCount":
            return Optional.ofNullable(clazz.cast(mcuCount()));
        case "minWorkerCount":
            return Optional.ofNullable(clazz.cast(minWorkerCount()));
        case "scaleInPolicy":
            return Optional.ofNullable(clazz.cast(scaleInPolicy()));
        case "scaleOutPolicy":
            return Optional.ofNullable(clazz.cast(scaleOutPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxWorkerCount", MAX_WORKER_COUNT_FIELD);
        map.put("mcuCount", MCU_COUNT_FIELD);
        map.put("minWorkerCount", MIN_WORKER_COUNT_FIELD);
        map.put("scaleInPolicy", SCALE_IN_POLICY_FIELD);
        map.put("scaleOutPolicy", SCALE_OUT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingUpdate, T> g) {
        return obj -> g.apply((AutoScalingUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingUpdate> {
        /**
         * <p>
         * The target maximum number of workers allocated to the connector.
         * </p>
         * 
         * @param maxWorkerCount
         *        The target maximum number of workers allocated to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkerCount(Integer maxWorkerCount);

        /**
         * <p>
         * The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are
         * 1,2,4,8.
         * </p>
         * 
         * @param mcuCount
         *        The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values
         *        are 1,2,4,8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcuCount(Integer mcuCount);

        /**
         * <p>
         * The target minimum number of workers allocated to the connector.
         * </p>
         * 
         * @param minWorkerCount
         *        The target minimum number of workers allocated to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkerCount(Integer minWorkerCount);

        /**
         * <p>
         * The target sacle-in policy for the connector.
         * </p>
         * 
         * @param scaleInPolicy
         *        The target sacle-in policy for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInPolicy(ScaleInPolicyUpdate scaleInPolicy);

        /**
         * <p>
         * The target sacle-in policy for the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScaleInPolicyUpdate.Builder} avoiding the
         * need to create one manually via {@link ScaleInPolicyUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScaleInPolicyUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #scaleInPolicy(ScaleInPolicyUpdate)}.
         * 
         * @param scaleInPolicy
         *        a consumer that will call methods on {@link ScaleInPolicyUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scaleInPolicy(ScaleInPolicyUpdate)
         */
        default Builder scaleInPolicy(Consumer<ScaleInPolicyUpdate.Builder> scaleInPolicy) {
            return scaleInPolicy(ScaleInPolicyUpdate.builder().applyMutation(scaleInPolicy).build());
        }

        /**
         * <p>
         * The target sacle-out policy for the connector.
         * </p>
         * 
         * @param scaleOutPolicy
         *        The target sacle-out policy for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutPolicy(ScaleOutPolicyUpdate scaleOutPolicy);

        /**
         * <p>
         * The target sacle-out policy for the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScaleOutPolicyUpdate.Builder} avoiding
         * the need to create one manually via {@link ScaleOutPolicyUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScaleOutPolicyUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #scaleOutPolicy(ScaleOutPolicyUpdate)}.
         * 
         * @param scaleOutPolicy
         *        a consumer that will call methods on {@link ScaleOutPolicyUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scaleOutPolicy(ScaleOutPolicyUpdate)
         */
        default Builder scaleOutPolicy(Consumer<ScaleOutPolicyUpdate.Builder> scaleOutPolicy) {
            return scaleOutPolicy(ScaleOutPolicyUpdate.builder().applyMutation(scaleOutPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer maxWorkerCount;

        private Integer mcuCount;

        private Integer minWorkerCount;

        private ScaleInPolicyUpdate scaleInPolicy;

        private ScaleOutPolicyUpdate scaleOutPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingUpdate model) {
            maxWorkerCount(model.maxWorkerCount);
            mcuCount(model.mcuCount);
            minWorkerCount(model.minWorkerCount);
            scaleInPolicy(model.scaleInPolicy);
            scaleOutPolicy(model.scaleOutPolicy);
        }

        public final Integer getMaxWorkerCount() {
            return maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final Integer getMcuCount() {
            return mcuCount;
        }

        public final void setMcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
        }

        @Override
        public final Builder mcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final ScaleInPolicyUpdate.Builder getScaleInPolicy() {
            return scaleInPolicy != null ? scaleInPolicy.toBuilder() : null;
        }

        public final void setScaleInPolicy(ScaleInPolicyUpdate.BuilderImpl scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy != null ? scaleInPolicy.build() : null;
        }

        @Override
        public final Builder scaleInPolicy(ScaleInPolicyUpdate scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy;
            return this;
        }

        public final ScaleOutPolicyUpdate.Builder getScaleOutPolicy() {
            return scaleOutPolicy != null ? scaleOutPolicy.toBuilder() : null;
        }

        public final void setScaleOutPolicy(ScaleOutPolicyUpdate.BuilderImpl scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy != null ? scaleOutPolicy.build() : null;
        }

        @Override
        public final Builder scaleOutPolicy(ScaleOutPolicyUpdate scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy;
            return this;
        }

        @Override
        public AutoScalingUpdate build() {
            return new AutoScalingUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
