/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the capacity of the connector, whether it is auto scaled or provisioned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Capacity implements SdkPojo, Serializable, ToCopyableBuilder<Capacity.Builder, Capacity> {
    private static final SdkField<AutoScaling> AUTO_SCALING_FIELD = SdkField.<AutoScaling> builder(MarshallingType.SDK_POJO)
            .memberName("autoScaling").getter(getter(Capacity::autoScaling)).setter(setter(Builder::autoScaling))
            .constructor(AutoScaling::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScaling").build()).build();

    private static final SdkField<ProvisionedCapacity> PROVISIONED_CAPACITY_FIELD = SdkField
            .<ProvisionedCapacity> builder(MarshallingType.SDK_POJO).memberName("provisionedCapacity")
            .getter(getter(Capacity::provisionedCapacity)).setter(setter(Builder::provisionedCapacity))
            .constructor(ProvisionedCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedCapacity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_FIELD,
            PROVISIONED_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutoScaling autoScaling;

    private final ProvisionedCapacity provisionedCapacity;

    private Capacity(BuilderImpl builder) {
        this.autoScaling = builder.autoScaling;
        this.provisionedCapacity = builder.provisionedCapacity;
    }

    /**
     * <p>
     * Information about the auto scaling parameters for the connector.
     * </p>
     * 
     * @return Information about the auto scaling parameters for the connector.
     */
    public final AutoScaling autoScaling() {
        return autoScaling;
    }

    /**
     * <p>
     * Details about a fixed capacity allocated to a connector.
     * </p>
     * 
     * @return Details about a fixed capacity allocated to a connector.
     */
    public final ProvisionedCapacity provisionedCapacity() {
        return provisionedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScaling());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity) obj;
        return Objects.equals(autoScaling(), other.autoScaling())
                && Objects.equals(provisionedCapacity(), other.provisionedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Capacity").add("AutoScaling", autoScaling()).add("ProvisionedCapacity", provisionedCapacity())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoScaling":
            return Optional.ofNullable(clazz.cast(autoScaling()));
        case "provisionedCapacity":
            return Optional.ofNullable(clazz.cast(provisionedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("autoScaling", AUTO_SCALING_FIELD);
        map.put("provisionedCapacity", PROVISIONED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Capacity, T> g) {
        return obj -> g.apply((Capacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Capacity> {
        /**
         * <p>
         * Information about the auto scaling parameters for the connector.
         * </p>
         * 
         * @param autoScaling
         *        Information about the auto scaling parameters for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScaling(AutoScaling autoScaling);

        /**
         * <p>
         * Information about the auto scaling parameters for the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScaling.Builder} avoiding the need to
         * create one manually via {@link AutoScaling#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScaling.Builder#build()} is called immediately and its result
         * is passed to {@link #autoScaling(AutoScaling)}.
         * 
         * @param autoScaling
         *        a consumer that will call methods on {@link AutoScaling.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScaling(AutoScaling)
         */
        default Builder autoScaling(Consumer<AutoScaling.Builder> autoScaling) {
            return autoScaling(AutoScaling.builder().applyMutation(autoScaling).build());
        }

        /**
         * <p>
         * Details about a fixed capacity allocated to a connector.
         * </p>
         * 
         * @param provisionedCapacity
         *        Details about a fixed capacity allocated to a connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedCapacity(ProvisionedCapacity provisionedCapacity);

        /**
         * <p>
         * Details about a fixed capacity allocated to a connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedCapacity.Builder} avoiding the
         * need to create one manually via {@link ProvisionedCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedCapacity.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedCapacity(ProvisionedCapacity)}.
         * 
         * @param provisionedCapacity
         *        a consumer that will call methods on {@link ProvisionedCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedCapacity(ProvisionedCapacity)
         */
        default Builder provisionedCapacity(Consumer<ProvisionedCapacity.Builder> provisionedCapacity) {
            return provisionedCapacity(ProvisionedCapacity.builder().applyMutation(provisionedCapacity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoScaling autoScaling;

        private ProvisionedCapacity provisionedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(Capacity model) {
            autoScaling(model.autoScaling);
            provisionedCapacity(model.provisionedCapacity);
        }

        public final AutoScaling.Builder getAutoScaling() {
            return autoScaling != null ? autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(AutoScaling.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        public final Builder autoScaling(AutoScaling autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        public final ProvisionedCapacity.Builder getProvisionedCapacity() {
            return provisionedCapacity != null ? provisionedCapacity.toBuilder() : null;
        }

        public final void setProvisionedCapacity(ProvisionedCapacity.BuilderImpl provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity != null ? provisionedCapacity.build() : null;
        }

        @Override
        public final Builder provisionedCapacity(ProvisionedCapacity provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity;
            return this;
        }

        @Override
        public Capacity build() {
            return new Capacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
