/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectorRequest extends KafkaConnectRequest implements
        ToCopyableBuilder<CreateConnectorRequest.Builder, CreateConnectorRequest> {
    private static final SdkField<Capacity> CAPACITY_FIELD = SdkField.<Capacity> builder(MarshallingType.SDK_POJO)
            .memberName("capacity").getter(getter(CreateConnectorRequest::capacity)).setter(setter(Builder::capacity))
            .constructor(Capacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()).build();

    private static final SdkField<Map<String, String>> CONNECTOR_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("connectorConfiguration")
            .getter(getter(CreateConnectorRequest::connectorConfiguration))
            .setter(setter(Builder::connectorConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONNECTOR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorDescription").getter(getter(CreateConnectorRequest::connectorDescription))
            .setter(setter(Builder::connectorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorDescription").build())
            .build();

    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorName").getter(getter(CreateConnectorRequest::connectorName))
            .setter(setter(Builder::connectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()).build();

    private static final SdkField<KafkaCluster> KAFKA_CLUSTER_FIELD = SdkField.<KafkaCluster> builder(MarshallingType.SDK_POJO)
            .memberName("kafkaCluster").getter(getter(CreateConnectorRequest::kafkaCluster))
            .setter(setter(Builder::kafkaCluster)).constructor(KafkaCluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaCluster").build()).build();

    private static final SdkField<KafkaClusterClientAuthentication> KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD = SdkField
            .<KafkaClusterClientAuthentication> builder(MarshallingType.SDK_POJO)
            .memberName("kafkaClusterClientAuthentication")
            .getter(getter(CreateConnectorRequest::kafkaClusterClientAuthentication))
            .setter(setter(Builder::kafkaClusterClientAuthentication))
            .constructor(KafkaClusterClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterClientAuthentication")
                    .build()).build();

    private static final SdkField<KafkaClusterEncryptionInTransit> KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD = SdkField
            .<KafkaClusterEncryptionInTransit> builder(MarshallingType.SDK_POJO)
            .memberName("kafkaClusterEncryptionInTransit")
            .getter(getter(CreateConnectorRequest::kafkaClusterEncryptionInTransit))
            .setter(setter(Builder::kafkaClusterEncryptionInTransit))
            .constructor(KafkaClusterEncryptionInTransit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterEncryptionInTransit")
                    .build()).build();

    private static final SdkField<String> KAFKA_CONNECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kafkaConnectVersion").getter(getter(CreateConnectorRequest::kafkaConnectVersion))
            .setter(setter(Builder::kafkaConnectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaConnectVersion").build())
            .build();

    private static final SdkField<LogDelivery> LOG_DELIVERY_FIELD = SdkField.<LogDelivery> builder(MarshallingType.SDK_POJO)
            .memberName("logDelivery").getter(getter(CreateConnectorRequest::logDelivery)).setter(setter(Builder::logDelivery))
            .constructor(LogDelivery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDelivery").build()).build();

    private static final SdkField<List<Plugin>> PLUGINS_FIELD = SdkField
            .<List<Plugin>> builder(MarshallingType.LIST)
            .memberName("plugins")
            .getter(getter(CreateConnectorRequest::plugins))
            .setter(setter(Builder::plugins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plugins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Plugin> builder(MarshallingType.SDK_POJO)
                                            .constructor(Plugin::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceExecutionRoleArn").getter(getter(CreateConnectorRequest::serviceExecutionRoleArn))
            .setter(setter(Builder::serviceExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceExecutionRoleArn").build())
            .build();

    private static final SdkField<WorkerConfiguration> WORKER_CONFIGURATION_FIELD = SdkField
            .<WorkerConfiguration> builder(MarshallingType.SDK_POJO).memberName("workerConfiguration")
            .getter(getter(CreateConnectorRequest::workerConfiguration)).setter(setter(Builder::workerConfiguration))
            .constructor(WorkerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateConnectorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            CONNECTOR_CONFIGURATION_FIELD, CONNECTOR_DESCRIPTION_FIELD, CONNECTOR_NAME_FIELD, KAFKA_CLUSTER_FIELD,
            KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD, KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD, KAFKA_CONNECT_VERSION_FIELD,
            LOG_DELIVERY_FIELD, PLUGINS_FIELD, SERVICE_EXECUTION_ROLE_ARN_FIELD, WORKER_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Capacity capacity;

    private final Map<String, String> connectorConfiguration;

    private final String connectorDescription;

    private final String connectorName;

    private final KafkaCluster kafkaCluster;

    private final KafkaClusterClientAuthentication kafkaClusterClientAuthentication;

    private final KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit;

    private final String kafkaConnectVersion;

    private final LogDelivery logDelivery;

    private final List<Plugin> plugins;

    private final String serviceExecutionRoleArn;

    private final WorkerConfiguration workerConfiguration;

    private final Map<String, String> tags;

    private CreateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
        this.connectorConfiguration = builder.connectorConfiguration;
        this.connectorDescription = builder.connectorDescription;
        this.connectorName = builder.connectorName;
        this.kafkaCluster = builder.kafkaCluster;
        this.kafkaClusterClientAuthentication = builder.kafkaClusterClientAuthentication;
        this.kafkaClusterEncryptionInTransit = builder.kafkaClusterEncryptionInTransit;
        this.kafkaConnectVersion = builder.kafkaConnectVersion;
        this.logDelivery = builder.logDelivery;
        this.plugins = builder.plugins;
        this.serviceExecutionRoleArn = builder.serviceExecutionRoleArn;
        this.workerConfiguration = builder.workerConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.
     * </p>
     * 
     * @return Information about the capacity allocated to the connector. Exactly one of the two properties must be
     *         specified.
     */
    public final Capacity capacity() {
        return capacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectorConfiguration() {
        return connectorConfiguration != null && !(connectorConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of keys to values that represent the configuration for the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorConfiguration} method.
     * </p>
     * 
     * @return A map of keys to values that represent the configuration for the connector.
     */
    public final Map<String, String> connectorConfiguration() {
        return connectorConfiguration;
    }

    /**
     * <p>
     * A summary description of the connector.
     * </p>
     * 
     * @return A summary description of the connector.
     */
    public final String connectorDescription() {
        return connectorDescription;
    }

    /**
     * <p>
     * The name of the connector.
     * </p>
     * 
     * @return The name of the connector.
     */
    public final String connectorName() {
        return connectorName;
    }

    /**
     * <p>
     * Specifies which Apache Kafka cluster to connect to.
     * </p>
     * 
     * @return Specifies which Apache Kafka cluster to connect to.
     */
    public final KafkaCluster kafkaCluster() {
        return kafkaCluster;
    }

    /**
     * <p>
     * Details of the client authentication used by the Apache Kafka cluster.
     * </p>
     * 
     * @return Details of the client authentication used by the Apache Kafka cluster.
     */
    public final KafkaClusterClientAuthentication kafkaClusterClientAuthentication() {
        return kafkaClusterClientAuthentication;
    }

    /**
     * <p>
     * Details of encryption in transit to the Apache Kafka cluster.
     * </p>
     * 
     * @return Details of encryption in transit to the Apache Kafka cluster.
     */
    public final KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit() {
        return kafkaClusterEncryptionInTransit;
    }

    /**
     * <p>
     * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the
     * plugins.
     * </p>
     * 
     * @return The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and
     *         the plugins.
     */
    public final String kafkaConnectVersion() {
        return kafkaConnectVersion;
    }

    /**
     * <p>
     * Details about log delivery.
     * </p>
     * 
     * @return Details about log delivery.
     */
    public final LogDelivery logDelivery() {
        return logDelivery;
    }

    /**
     * For responses, this returns true if the service returned a value for the Plugins property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPlugins() {
        return plugins != null && !(plugins instanceof SdkAutoConstructList);
    }

    /**
     * <important>
     * <p>
     * Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than one plugin
     * for your connector, you can create a single custom plugin using a ZIP file that bundles multiple plugins
     * together.
     * </p>
     * </important>
     * <p>
     * Specifies which plugin to use for the connector. You must specify a single-element list containing one
     * <code>customPlugin</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlugins} method.
     * </p>
     * 
     * @return <p>
     *         Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than one
     *         plugin for your connector, you can create a single custom plugin using a ZIP file that bundles multiple
     *         plugins together.
     *         </p>
     *         </important>
     *         <p>
     *         Specifies which plugin to use for the connector. You must specify a single-element list containing one
     *         <code>customPlugin</code> object.
     */
    public final List<Plugin> plugins() {
        return plugins;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources
     * that it needs. The types of resources depends on the logic of the connector. For example, a connector that has
     * Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services
     *         resources that it needs. The types of resources depends on the logic of the connector. For example, a
     *         connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3
     *         destination bucket.
     */
    public final String serviceExecutionRoleArn() {
        return serviceExecutionRoleArn;
    }

    /**
     * <p>
     * Specifies which worker configuration to use with the connector.
     * </p>
     * 
     * @return Specifies which worker configuration to use with the connector.
     */
    public final WorkerConfiguration workerConfiguration() {
        return workerConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags you want to attach to the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags you want to attach to the connector.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorConfiguration() ? connectorConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaCluster());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaClusterClientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaClusterEncryptionInTransit());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaConnectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(logDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlugins() ? plugins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(workerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorRequest)) {
            return false;
        }
        CreateConnectorRequest other = (CreateConnectorRequest) obj;
        return Objects.equals(capacity(), other.capacity()) && hasConnectorConfiguration() == other.hasConnectorConfiguration()
                && Objects.equals(connectorConfiguration(), other.connectorConfiguration())
                && Objects.equals(connectorDescription(), other.connectorDescription())
                && Objects.equals(connectorName(), other.connectorName()) && Objects.equals(kafkaCluster(), other.kafkaCluster())
                && Objects.equals(kafkaClusterClientAuthentication(), other.kafkaClusterClientAuthentication())
                && Objects.equals(kafkaClusterEncryptionInTransit(), other.kafkaClusterEncryptionInTransit())
                && Objects.equals(kafkaConnectVersion(), other.kafkaConnectVersion())
                && Objects.equals(logDelivery(), other.logDelivery()) && hasPlugins() == other.hasPlugins()
                && Objects.equals(plugins(), other.plugins())
                && Objects.equals(serviceExecutionRoleArn(), other.serviceExecutionRoleArn())
                && Objects.equals(workerConfiguration(), other.workerConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectorRequest").add("Capacity", capacity())
                .add("ConnectorConfiguration", connectorConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectorDescription", connectorDescription()).add("ConnectorName", connectorName())
                .add("KafkaCluster", kafkaCluster()).add("KafkaClusterClientAuthentication", kafkaClusterClientAuthentication())
                .add("KafkaClusterEncryptionInTransit", kafkaClusterEncryptionInTransit())
                .add("KafkaConnectVersion", kafkaConnectVersion()).add("LogDelivery", logDelivery())
                .add("Plugins", hasPlugins() ? plugins() : null).add("ServiceExecutionRoleArn", serviceExecutionRoleArn())
                .add("WorkerConfiguration", workerConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "connectorConfiguration":
            return Optional.ofNullable(clazz.cast(connectorConfiguration()));
        case "connectorDescription":
            return Optional.ofNullable(clazz.cast(connectorDescription()));
        case "connectorName":
            return Optional.ofNullable(clazz.cast(connectorName()));
        case "kafkaCluster":
            return Optional.ofNullable(clazz.cast(kafkaCluster()));
        case "kafkaClusterClientAuthentication":
            return Optional.ofNullable(clazz.cast(kafkaClusterClientAuthentication()));
        case "kafkaClusterEncryptionInTransit":
            return Optional.ofNullable(clazz.cast(kafkaClusterEncryptionInTransit()));
        case "kafkaConnectVersion":
            return Optional.ofNullable(clazz.cast(kafkaConnectVersion()));
        case "logDelivery":
            return Optional.ofNullable(clazz.cast(logDelivery()));
        case "plugins":
            return Optional.ofNullable(clazz.cast(plugins()));
        case "serviceExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(serviceExecutionRoleArn()));
        case "workerConfiguration":
            return Optional.ofNullable(clazz.cast(workerConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capacity", CAPACITY_FIELD);
        map.put("connectorConfiguration", CONNECTOR_CONFIGURATION_FIELD);
        map.put("connectorDescription", CONNECTOR_DESCRIPTION_FIELD);
        map.put("connectorName", CONNECTOR_NAME_FIELD);
        map.put("kafkaCluster", KAFKA_CLUSTER_FIELD);
        map.put("kafkaClusterClientAuthentication", KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD);
        map.put("kafkaClusterEncryptionInTransit", KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD);
        map.put("kafkaConnectVersion", KAFKA_CONNECT_VERSION_FIELD);
        map.put("logDelivery", LOG_DELIVERY_FIELD);
        map.put("plugins", PLUGINS_FIELD);
        map.put("serviceExecutionRoleArn", SERVICE_EXECUTION_ROLE_ARN_FIELD);
        map.put("workerConfiguration", WORKER_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorRequest, T> g) {
        return obj -> g.apply((CreateConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectorRequest> {
        /**
         * <p>
         * Information about the capacity allocated to the connector. Exactly one of the two properties must be
         * specified.
         * </p>
         * 
         * @param capacity
         *        Information about the capacity allocated to the connector. Exactly one of the two properties must be
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Capacity capacity);

        /**
         * <p>
         * Information about the capacity allocated to the connector. Exactly one of the two properties must be
         * specified.
         * </p>
         * This is a convenience method that creates an instance of the {@link Capacity.Builder} avoiding the need to
         * create one manually via {@link Capacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Capacity.Builder#build()} is called immediately and its result is
         * passed to {@link #capacity(Capacity)}.
         * 
         * @param capacity
         *        a consumer that will call methods on {@link Capacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacity(Capacity)
         */
        default Builder capacity(Consumer<Capacity.Builder> capacity) {
            return capacity(Capacity.builder().applyMutation(capacity).build());
        }

        /**
         * <p>
         * A map of keys to values that represent the configuration for the connector.
         * </p>
         * 
         * @param connectorConfiguration
         *        A map of keys to values that represent the configuration for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorConfiguration(Map<String, String> connectorConfiguration);

        /**
         * <p>
         * A summary description of the connector.
         * </p>
         * 
         * @param connectorDescription
         *        A summary description of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDescription(String connectorDescription);

        /**
         * <p>
         * The name of the connector.
         * </p>
         * 
         * @param connectorName
         *        The name of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorName(String connectorName);

        /**
         * <p>
         * Specifies which Apache Kafka cluster to connect to.
         * </p>
         * 
         * @param kafkaCluster
         *        Specifies which Apache Kafka cluster to connect to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaCluster(KafkaCluster kafkaCluster);

        /**
         * <p>
         * Specifies which Apache Kafka cluster to connect to.
         * </p>
         * This is a convenience method that creates an instance of the {@link KafkaCluster.Builder} avoiding the need
         * to create one manually via {@link KafkaCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KafkaCluster.Builder#build()} is called immediately and its
         * result is passed to {@link #kafkaCluster(KafkaCluster)}.
         * 
         * @param kafkaCluster
         *        a consumer that will call methods on {@link KafkaCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaCluster(KafkaCluster)
         */
        default Builder kafkaCluster(Consumer<KafkaCluster.Builder> kafkaCluster) {
            return kafkaCluster(KafkaCluster.builder().applyMutation(kafkaCluster).build());
        }

        /**
         * <p>
         * Details of the client authentication used by the Apache Kafka cluster.
         * </p>
         * 
         * @param kafkaClusterClientAuthentication
         *        Details of the client authentication used by the Apache Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusterClientAuthentication(KafkaClusterClientAuthentication kafkaClusterClientAuthentication);

        /**
         * <p>
         * Details of the client authentication used by the Apache Kafka cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link KafkaClusterClientAuthentication.Builder}
         * avoiding the need to create one manually via {@link KafkaClusterClientAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KafkaClusterClientAuthentication.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kafkaClusterClientAuthentication(KafkaClusterClientAuthentication)}.
         * 
         * @param kafkaClusterClientAuthentication
         *        a consumer that will call methods on {@link KafkaClusterClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaClusterClientAuthentication(KafkaClusterClientAuthentication)
         */
        default Builder kafkaClusterClientAuthentication(
                Consumer<KafkaClusterClientAuthentication.Builder> kafkaClusterClientAuthentication) {
            return kafkaClusterClientAuthentication(KafkaClusterClientAuthentication.builder()
                    .applyMutation(kafkaClusterClientAuthentication).build());
        }

        /**
         * <p>
         * Details of encryption in transit to the Apache Kafka cluster.
         * </p>
         * 
         * @param kafkaClusterEncryptionInTransit
         *        Details of encryption in transit to the Apache Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit);

        /**
         * <p>
         * Details of encryption in transit to the Apache Kafka cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link KafkaClusterEncryptionInTransit.Builder}
         * avoiding the need to create one manually via {@link KafkaClusterEncryptionInTransit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KafkaClusterEncryptionInTransit.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransit)}.
         * 
         * @param kafkaClusterEncryptionInTransit
         *        a consumer that will call methods on {@link KafkaClusterEncryptionInTransit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransit)
         */
        default Builder kafkaClusterEncryptionInTransit(
                Consumer<KafkaClusterEncryptionInTransit.Builder> kafkaClusterEncryptionInTransit) {
            return kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransit.builder()
                    .applyMutation(kafkaClusterEncryptionInTransit).build());
        }

        /**
         * <p>
         * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the
         * plugins.
         * </p>
         * 
         * @param kafkaConnectVersion
         *        The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and
         *        the plugins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaConnectVersion(String kafkaConnectVersion);

        /**
         * <p>
         * Details about log delivery.
         * </p>
         * 
         * @param logDelivery
         *        Details about log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDelivery(LogDelivery logDelivery);

        /**
         * <p>
         * Details about log delivery.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDelivery.Builder} avoiding the need to
         * create one manually via {@link LogDelivery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDelivery.Builder#build()} is called immediately and its result
         * is passed to {@link #logDelivery(LogDelivery)}.
         * 
         * @param logDelivery
         *        a consumer that will call methods on {@link LogDelivery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDelivery(LogDelivery)
         */
        default Builder logDelivery(Consumer<LogDelivery.Builder> logDelivery) {
            return logDelivery(LogDelivery.builder().applyMutation(logDelivery).build());
        }

        /**
         * <important>
         * <p>
         * Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than one
         * plugin for your connector, you can create a single custom plugin using a ZIP file that bundles multiple
         * plugins together.
         * </p>
         * </important>
         * <p>
         * Specifies which plugin to use for the connector. You must specify a single-element list containing one
         * <code>customPlugin</code> object.
         * </p>
         * 
         * @param plugins
         *        <p>
         *        Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than
         *        one plugin for your connector, you can create a single custom plugin using a ZIP file that bundles
         *        multiple plugins together.
         *        </p>
         *        </important>
         *        <p>
         *        Specifies which plugin to use for the connector. You must specify a single-element list containing one
         *        <code>customPlugin</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plugins(Collection<Plugin> plugins);

        /**
         * <important>
         * <p>
         * Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than one
         * plugin for your connector, you can create a single custom plugin using a ZIP file that bundles multiple
         * plugins together.
         * </p>
         * </important>
         * <p>
         * Specifies which plugin to use for the connector. You must specify a single-element list containing one
         * <code>customPlugin</code> object.
         * </p>
         * 
         * @param plugins
         *        <p>
         *        Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than
         *        one plugin for your connector, you can create a single custom plugin using a ZIP file that bundles
         *        multiple plugins together.
         *        </p>
         *        </important>
         *        <p>
         *        Specifies which plugin to use for the connector. You must specify a single-element list containing one
         *        <code>customPlugin</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plugins(Plugin... plugins);

        /**
         * <important>
         * <p>
         * Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than one
         * plugin for your connector, you can create a single custom plugin using a ZIP file that bundles multiple
         * plugins together.
         * </p>
         * </important>
         * <p>
         * Specifies which plugin to use for the connector. You must specify a single-element list containing one
         * <code>customPlugin</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafkaconnect.model.Plugin.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kafkaconnect.model.Plugin#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafkaconnect.model.Plugin.Builder#build()} is called immediately and
         * its result is passed to {@link #plugins(List<Plugin>)}.
         * 
         * @param plugins
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafkaconnect.model.Plugin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plugins(java.util.Collection<Plugin>)
         */
        Builder plugins(Consumer<Plugin.Builder>... plugins);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services
         * resources that it needs. The types of resources depends on the logic of the connector. For example, a
         * connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3
         * destination bucket.
         * </p>
         * 
         * @param serviceExecutionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services
         *        resources that it needs. The types of resources depends on the logic of the connector. For example, a
         *        connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3
         *        destination bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceExecutionRoleArn(String serviceExecutionRoleArn);

        /**
         * <p>
         * Specifies which worker configuration to use with the connector.
         * </p>
         * 
         * @param workerConfiguration
         *        Specifies which worker configuration to use with the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfiguration(WorkerConfiguration workerConfiguration);

        /**
         * <p>
         * Specifies which worker configuration to use with the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkerConfiguration.Builder} avoiding the
         * need to create one manually via {@link WorkerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkerConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #workerConfiguration(WorkerConfiguration)}.
         * 
         * @param workerConfiguration
         *        a consumer that will call methods on {@link WorkerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerConfiguration(WorkerConfiguration)
         */
        default Builder workerConfiguration(Consumer<WorkerConfiguration.Builder> workerConfiguration) {
            return workerConfiguration(WorkerConfiguration.builder().applyMutation(workerConfiguration).build());
        }

        /**
         * <p>
         * The tags you want to attach to the connector.
         * </p>
         * 
         * @param tags
         *        The tags you want to attach to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaConnectRequest.BuilderImpl implements Builder {
        private Capacity capacity;

        private Map<String, String> connectorConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String connectorDescription;

        private String connectorName;

        private KafkaCluster kafkaCluster;

        private KafkaClusterClientAuthentication kafkaClusterClientAuthentication;

        private KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit;

        private String kafkaConnectVersion;

        private LogDelivery logDelivery;

        private List<Plugin> plugins = DefaultSdkAutoConstructList.getInstance();

        private String serviceExecutionRoleArn;

        private WorkerConfiguration workerConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorRequest model) {
            super(model);
            capacity(model.capacity);
            connectorConfiguration(model.connectorConfiguration);
            connectorDescription(model.connectorDescription);
            connectorName(model.connectorName);
            kafkaCluster(model.kafkaCluster);
            kafkaClusterClientAuthentication(model.kafkaClusterClientAuthentication);
            kafkaClusterEncryptionInTransit(model.kafkaClusterEncryptionInTransit);
            kafkaConnectVersion(model.kafkaConnectVersion);
            logDelivery(model.logDelivery);
            plugins(model.plugins);
            serviceExecutionRoleArn(model.serviceExecutionRoleArn);
            workerConfiguration(model.workerConfiguration);
            tags(model.tags);
        }

        public final Capacity.Builder getCapacity() {
            return capacity != null ? capacity.toBuilder() : null;
        }

        public final void setCapacity(Capacity.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            return this;
        }

        public final Map<String, String> getConnectorConfiguration() {
            if (connectorConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectorConfiguration;
        }

        public final void setConnectorConfiguration(Map<String, String> connectorConfiguration) {
            this.connectorConfiguration = ConnectorConfigurationCopier.copy(connectorConfiguration);
        }

        @Override
        public final Builder connectorConfiguration(Map<String, String> connectorConfiguration) {
            this.connectorConfiguration = ConnectorConfigurationCopier.copy(connectorConfiguration);
            return this;
        }

        public final String getConnectorDescription() {
            return connectorDescription;
        }

        public final void setConnectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
        }

        @Override
        public final Builder connectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        public final String getConnectorName() {
            return connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final KafkaCluster.Builder getKafkaCluster() {
            return kafkaCluster != null ? kafkaCluster.toBuilder() : null;
        }

        public final void setKafkaCluster(KafkaCluster.BuilderImpl kafkaCluster) {
            this.kafkaCluster = kafkaCluster != null ? kafkaCluster.build() : null;
        }

        @Override
        public final Builder kafkaCluster(KafkaCluster kafkaCluster) {
            this.kafkaCluster = kafkaCluster;
            return this;
        }

        public final KafkaClusterClientAuthentication.Builder getKafkaClusterClientAuthentication() {
            return kafkaClusterClientAuthentication != null ? kafkaClusterClientAuthentication.toBuilder() : null;
        }

        public final void setKafkaClusterClientAuthentication(
                KafkaClusterClientAuthentication.BuilderImpl kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication != null ? kafkaClusterClientAuthentication
                    .build() : null;
        }

        @Override
        public final Builder kafkaClusterClientAuthentication(KafkaClusterClientAuthentication kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication;
            return this;
        }

        public final KafkaClusterEncryptionInTransit.Builder getKafkaClusterEncryptionInTransit() {
            return kafkaClusterEncryptionInTransit != null ? kafkaClusterEncryptionInTransit.toBuilder() : null;
        }

        public final void setKafkaClusterEncryptionInTransit(
                KafkaClusterEncryptionInTransit.BuilderImpl kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit != null ? kafkaClusterEncryptionInTransit
                    .build() : null;
        }

        @Override
        public final Builder kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit;
            return this;
        }

        public final String getKafkaConnectVersion() {
            return kafkaConnectVersion;
        }

        public final void setKafkaConnectVersion(String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
        }

        @Override
        public final Builder kafkaConnectVersion(String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
            return this;
        }

        public final LogDelivery.Builder getLogDelivery() {
            return logDelivery != null ? logDelivery.toBuilder() : null;
        }

        public final void setLogDelivery(LogDelivery.BuilderImpl logDelivery) {
            this.logDelivery = logDelivery != null ? logDelivery.build() : null;
        }

        @Override
        public final Builder logDelivery(LogDelivery logDelivery) {
            this.logDelivery = logDelivery;
            return this;
        }

        public final List<Plugin.Builder> getPlugins() {
            List<Plugin.Builder> result = ___listOfPluginCopier.copyToBuilder(this.plugins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlugins(Collection<Plugin.BuilderImpl> plugins) {
            this.plugins = ___listOfPluginCopier.copyFromBuilder(plugins);
        }

        @Override
        public final Builder plugins(Collection<Plugin> plugins) {
            this.plugins = ___listOfPluginCopier.copy(plugins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(Plugin... plugins) {
            plugins(Arrays.asList(plugins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(Consumer<Plugin.Builder>... plugins) {
            plugins(Stream.of(plugins).map(c -> Plugin.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceExecutionRoleArn() {
            return serviceExecutionRoleArn;
        }

        public final void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
        }

        @Override
        public final Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public final WorkerConfiguration.Builder getWorkerConfiguration() {
            return workerConfiguration != null ? workerConfiguration.toBuilder() : null;
        }

        public final void setWorkerConfiguration(WorkerConfiguration.BuilderImpl workerConfiguration) {
            this.workerConfiguration = workerConfiguration != null ? workerConfiguration.build() : null;
        }

        @Override
        public final Builder workerConfiguration(WorkerConfiguration workerConfiguration) {
            this.workerConfiguration = workerConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorRequest build() {
            return new CreateConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
