/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkerConfigurationResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<CreateWorkerConfigurationResponse.Builder, CreateWorkerConfigurationResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(CreateWorkerConfigurationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<WorkerConfigurationRevisionSummary> LATEST_REVISION_FIELD = SdkField
            .<WorkerConfigurationRevisionSummary> builder(MarshallingType.SDK_POJO).memberName("latestRevision")
            .getter(getter(CreateWorkerConfigurationResponse::latestRevision)).setter(setter(Builder::latestRevision))
            .constructor(WorkerConfigurationRevisionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkerConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> WORKER_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerConfigurationArn").getter(getter(CreateWorkerConfigurationResponse::workerConfigurationArn))
            .setter(setter(Builder::workerConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationArn").build())
            .build();

    private static final SdkField<String> WORKER_CONFIGURATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerConfigurationState")
            .getter(getter(CreateWorkerConfigurationResponse::workerConfigurationStateAsString))
            .setter(setter(Builder::workerConfigurationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            LATEST_REVISION_FIELD, NAME_FIELD, WORKER_CONFIGURATION_ARN_FIELD, WORKER_CONFIGURATION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant creationTime;

    private final WorkerConfigurationRevisionSummary latestRevision;

    private final String name;

    private final String workerConfigurationArn;

    private final String workerConfigurationState;

    private CreateWorkerConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.workerConfigurationArn = builder.workerConfigurationArn;
        this.workerConfigurationState = builder.workerConfigurationState;
    }

    /**
     * <p>
     * The time that the worker configuration was created.
     * </p>
     * 
     * @return The time that the worker configuration was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The latest revision of the worker configuration.
     * </p>
     * 
     * @return The latest revision of the worker configuration.
     */
    public final WorkerConfigurationRevisionSummary latestRevision() {
        return latestRevision;
    }

    /**
     * <p>
     * The name of the worker configuration.
     * </p>
     * 
     * @return The name of the worker configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.
     */
    public final String workerConfigurationArn() {
        return workerConfigurationArn;
    }

    /**
     * <p>
     * The state of the worker configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #workerConfigurationState} will return {@link WorkerConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #workerConfigurationStateAsString}.
     * </p>
     * 
     * @return The state of the worker configuration.
     * @see WorkerConfigurationState
     */
    public final WorkerConfigurationState workerConfigurationState() {
        return WorkerConfigurationState.fromValue(workerConfigurationState);
    }

    /**
     * <p>
     * The state of the worker configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #workerConfigurationState} will return {@link WorkerConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #workerConfigurationStateAsString}.
     * </p>
     * 
     * @return The state of the worker configuration.
     * @see WorkerConfigurationState
     */
    public final String workerConfigurationStateAsString() {
        return workerConfigurationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(workerConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(workerConfigurationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkerConfigurationResponse)) {
            return false;
        }
        CreateWorkerConfigurationResponse other = (CreateWorkerConfigurationResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(latestRevision(), other.latestRevision())
                && Objects.equals(name(), other.name())
                && Objects.equals(workerConfigurationArn(), other.workerConfigurationArn())
                && Objects.equals(workerConfigurationStateAsString(), other.workerConfigurationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkerConfigurationResponse").add("CreationTime", creationTime())
                .add("LatestRevision", latestRevision()).add("Name", name())
                .add("WorkerConfigurationArn", workerConfigurationArn())
                .add("WorkerConfigurationState", workerConfigurationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "latestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "workerConfigurationArn":
            return Optional.ofNullable(clazz.cast(workerConfigurationArn()));
        case "workerConfigurationState":
            return Optional.ofNullable(clazz.cast(workerConfigurationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("latestRevision", LATEST_REVISION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("workerConfigurationArn", WORKER_CONFIGURATION_ARN_FIELD);
        map.put("workerConfigurationState", WORKER_CONFIGURATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkerConfigurationResponse, T> g) {
        return obj -> g.apply((CreateWorkerConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkerConfigurationResponse> {
        /**
         * <p>
         * The time that the worker configuration was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the worker configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The latest revision of the worker configuration.
         * </p>
         * 
         * @param latestRevision
         *        The latest revision of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(WorkerConfigurationRevisionSummary latestRevision);

        /**
         * <p>
         * The latest revision of the worker configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkerConfigurationRevisionSummary.Builder} avoiding the need to create one manually via
         * {@link WorkerConfigurationRevisionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkerConfigurationRevisionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #latestRevision(WorkerConfigurationRevisionSummary)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link WorkerConfigurationRevisionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(WorkerConfigurationRevisionSummary)
         */
        default Builder latestRevision(Consumer<WorkerConfigurationRevisionSummary.Builder> latestRevision) {
            return latestRevision(WorkerConfigurationRevisionSummary.builder().applyMutation(latestRevision).build());
        }

        /**
         * <p>
         * The name of the worker configuration.
         * </p>
         * 
         * @param name
         *        The name of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.
         * </p>
         * 
         * @param workerConfigurationArn
         *        The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfigurationArn(String workerConfigurationArn);

        /**
         * <p>
         * The state of the worker configuration.
         * </p>
         * 
         * @param workerConfigurationState
         *        The state of the worker configuration.
         * @see WorkerConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerConfigurationState
         */
        Builder workerConfigurationState(String workerConfigurationState);

        /**
         * <p>
         * The state of the worker configuration.
         * </p>
         * 
         * @param workerConfigurationState
         *        The state of the worker configuration.
         * @see WorkerConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerConfigurationState
         */
        Builder workerConfigurationState(WorkerConfigurationState workerConfigurationState);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private WorkerConfigurationRevisionSummary latestRevision;

        private String name;

        private String workerConfigurationArn;

        private String workerConfigurationState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkerConfigurationResponse model) {
            super(model);
            creationTime(model.creationTime);
            latestRevision(model.latestRevision);
            name(model.name);
            workerConfigurationArn(model.workerConfigurationArn);
            workerConfigurationState(model.workerConfigurationState);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final WorkerConfigurationRevisionSummary.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(WorkerConfigurationRevisionSummary.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        public final Builder latestRevision(WorkerConfigurationRevisionSummary latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkerConfigurationArn() {
            return workerConfigurationArn;
        }

        public final void setWorkerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
        }

        @Override
        public final Builder workerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        public final String getWorkerConfigurationState() {
            return workerConfigurationState;
        }

        public final void setWorkerConfigurationState(String workerConfigurationState) {
            this.workerConfigurationState = workerConfigurationState;
        }

        @Override
        public final Builder workerConfigurationState(String workerConfigurationState) {
            this.workerConfigurationState = workerConfigurationState;
            return this;
        }

        @Override
        public final Builder workerConfigurationState(WorkerConfigurationState workerConfigurationState) {
            this.workerConfigurationState(workerConfigurationState == null ? null : workerConfigurationState.toString());
            return this;
        }

        @Override
        public CreateWorkerConfigurationResponse build() {
            return new CreateWorkerConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
