/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a custom plugin file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomPluginFileDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomPluginFileDescription.Builder, CustomPluginFileDescription> {
    private static final SdkField<String> FILE_MD5_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileMd5").getter(getter(CustomPluginFileDescription::fileMd5)).setter(setter(Builder::fileMd5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMd5").build()).build();

    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("fileSize")
            .getter(getter(CustomPluginFileDescription::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_MD5_FIELD,
            FILE_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileMd5;

    private final Long fileSize;

    private CustomPluginFileDescription(BuilderImpl builder) {
        this.fileMd5 = builder.fileMd5;
        this.fileSize = builder.fileSize;
    }

    /**
     * <p>
     * The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.
     * </p>
     * 
     * @return The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.
     */
    public final String fileMd5() {
        return fileMd5;
    }

    /**
     * <p>
     * The size in bytes of the custom plugin file. You can use it to validate the file.
     * </p>
     * 
     * @return The size in bytes of the custom plugin file. You can use it to validate the file.
     */
    public final Long fileSize() {
        return fileSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileMd5());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPluginFileDescription)) {
            return false;
        }
        CustomPluginFileDescription other = (CustomPluginFileDescription) obj;
        return Objects.equals(fileMd5(), other.fileMd5()) && Objects.equals(fileSize(), other.fileSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomPluginFileDescription").add("FileMd5", fileMd5()).add("FileSize", fileSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileMd5":
            return Optional.ofNullable(clazz.cast(fileMd5()));
        case "fileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileMd5", FILE_MD5_FIELD);
        map.put("fileSize", FILE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomPluginFileDescription, T> g) {
        return obj -> g.apply((CustomPluginFileDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomPluginFileDescription> {
        /**
         * <p>
         * The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.
         * </p>
         * 
         * @param fileMd5
         *        The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileMd5(String fileMd5);

        /**
         * <p>
         * The size in bytes of the custom plugin file. You can use it to validate the file.
         * </p>
         * 
         * @param fileSize
         *        The size in bytes of the custom plugin file. You can use it to validate the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Long fileSize);
    }

    static final class BuilderImpl implements Builder {
        private String fileMd5;

        private Long fileSize;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPluginFileDescription model) {
            fileMd5(model.fileMd5);
            fileSize(model.fileSize);
        }

        public final String getFileMd5() {
            return fileMd5;
        }

        public final void setFileMd5(String fileMd5) {
            this.fileMd5 = fileMd5;
        }

        @Override
        public final Builder fileMd5(String fileMd5) {
            this.fileMd5 = fileMd5;
            return this;
        }

        public final Long getFileSize() {
            return fileSize;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        @Override
        public CustomPluginFileDescription build() {
            return new CustomPluginFileDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
