/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorOperationResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<DescribeConnectorOperationResponse.Builder, DescribeConnectorOperationResponse> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorArn").getter(getter(DescribeConnectorOperationResponse::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()).build();

    private static final SdkField<String> CONNECTOR_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorOperationArn").getter(getter(DescribeConnectorOperationResponse::connectorOperationArn))
            .setter(setter(Builder::connectorOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationArn").build())
            .build();

    private static final SdkField<String> CONNECTOR_OPERATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorOperationState")
            .getter(getter(DescribeConnectorOperationResponse::connectorOperationStateAsString))
            .setter(setter(Builder::connectorOperationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationState").build())
            .build();

    private static final SdkField<String> CONNECTOR_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorOperationType")
            .getter(getter(DescribeConnectorOperationResponse::connectorOperationTypeAsString))
            .setter(setter(Builder::connectorOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationType").build())
            .build();

    private static final SdkField<List<ConnectorOperationStep>> OPERATION_STEPS_FIELD = SdkField
            .<List<ConnectorOperationStep>> builder(MarshallingType.LIST)
            .memberName("operationSteps")
            .getter(getter(DescribeConnectorOperationResponse::operationSteps))
            .setter(setter(Builder::operationSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectorOperationStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorOperationStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WorkerSetting> ORIGIN_WORKER_SETTING_FIELD = SdkField
            .<WorkerSetting> builder(MarshallingType.SDK_POJO).memberName("originWorkerSetting")
            .getter(getter(DescribeConnectorOperationResponse::originWorkerSetting)).setter(setter(Builder::originWorkerSetting))
            .constructor(WorkerSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originWorkerSetting").build())
            .build();

    private static final SdkField<Map<String, String>> ORIGIN_CONNECTOR_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("originConnectorConfiguration")
            .getter(getter(DescribeConnectorOperationResponse::originConnectorConfiguration))
            .setter(setter(Builder::originConnectorConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originConnectorConfiguration")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<WorkerSetting> TARGET_WORKER_SETTING_FIELD = SdkField
            .<WorkerSetting> builder(MarshallingType.SDK_POJO).memberName("targetWorkerSetting")
            .getter(getter(DescribeConnectorOperationResponse::targetWorkerSetting)).setter(setter(Builder::targetWorkerSetting))
            .constructor(WorkerSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetWorkerSetting").build())
            .build();

    private static final SdkField<Map<String, String>> TARGET_CONNECTOR_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("targetConnectorConfiguration")
            .getter(getter(DescribeConnectorOperationResponse::targetConnectorConfiguration))
            .setter(setter(Builder::targetConnectorConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetConnectorConfiguration")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<StateDescription> ERROR_INFO_FIELD = SdkField
            .<StateDescription> builder(MarshallingType.SDK_POJO).memberName("errorInfo")
            .getter(getter(DescribeConnectorOperationResponse::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(StateDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(DescribeConnectorOperationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(DescribeConnectorOperationResponse::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD,
            CONNECTOR_OPERATION_ARN_FIELD, CONNECTOR_OPERATION_STATE_FIELD, CONNECTOR_OPERATION_TYPE_FIELD,
            OPERATION_STEPS_FIELD, ORIGIN_WORKER_SETTING_FIELD, ORIGIN_CONNECTOR_CONFIGURATION_FIELD,
            TARGET_WORKER_SETTING_FIELD, TARGET_CONNECTOR_CONFIGURATION_FIELD, ERROR_INFO_FIELD, CREATION_TIME_FIELD,
            END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorArn;

    private final String connectorOperationArn;

    private final String connectorOperationState;

    private final String connectorOperationType;

    private final List<ConnectorOperationStep> operationSteps;

    private final WorkerSetting originWorkerSetting;

    private final Map<String, String> originConnectorConfiguration;

    private final WorkerSetting targetWorkerSetting;

    private final Map<String, String> targetConnectorConfiguration;

    private final StateDescription errorInfo;

    private final Instant creationTime;

    private final Instant endTime;

    private DescribeConnectorOperationResponse(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorOperationArn = builder.connectorOperationArn;
        this.connectorOperationState = builder.connectorOperationState;
        this.connectorOperationType = builder.connectorOperationType;
        this.operationSteps = builder.operationSteps;
        this.originWorkerSetting = builder.originWorkerSetting;
        this.originConnectorConfiguration = builder.originConnectorConfiguration;
        this.targetWorkerSetting = builder.targetWorkerSetting;
        this.targetConnectorConfiguration = builder.targetConnectorConfiguration;
        this.errorInfo = builder.errorInfo;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector operation.
     */
    public final String connectorOperationArn() {
        return connectorOperationArn;
    }

    /**
     * <p>
     * The state of the connector operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorOperationState} will return {@link ConnectorOperationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorOperationStateAsString}.
     * </p>
     * 
     * @return The state of the connector operation.
     * @see ConnectorOperationState
     */
    public final ConnectorOperationState connectorOperationState() {
        return ConnectorOperationState.fromValue(connectorOperationState);
    }

    /**
     * <p>
     * The state of the connector operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorOperationState} will return {@link ConnectorOperationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorOperationStateAsString}.
     * </p>
     * 
     * @return The state of the connector operation.
     * @see ConnectorOperationState
     */
    public final String connectorOperationStateAsString() {
        return connectorOperationState;
    }

    /**
     * <p>
     * The type of connector operation performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorOperationType} will return {@link ConnectorOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #connectorOperationTypeAsString}.
     * </p>
     * 
     * @return The type of connector operation performed.
     * @see ConnectorOperationType
     */
    public final ConnectorOperationType connectorOperationType() {
        return ConnectorOperationType.fromValue(connectorOperationType);
    }

    /**
     * <p>
     * The type of connector operation performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorOperationType} will return {@link ConnectorOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #connectorOperationTypeAsString}.
     * </p>
     * 
     * @return The type of connector operation performed.
     * @see ConnectorOperationType
     */
    public final String connectorOperationTypeAsString() {
        return connectorOperationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperationSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperationSteps() {
        return operationSteps != null && !(operationSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of operation steps taken.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperationSteps} method.
     * </p>
     * 
     * @return The array of operation steps taken.
     */
    public final List<ConnectorOperationStep> operationSteps() {
        return operationSteps;
    }

    /**
     * <p>
     * The origin worker setting.
     * </p>
     * 
     * @return The origin worker setting.
     */
    public final WorkerSetting originWorkerSetting() {
        return originWorkerSetting;
    }

    /**
     * For responses, this returns true if the service returned a value for the OriginConnectorConfiguration property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOriginConnectorConfiguration() {
        return originConnectorConfiguration != null && !(originConnectorConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The origin connector configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOriginConnectorConfiguration} method.
     * </p>
     * 
     * @return The origin connector configuration.
     */
    public final Map<String, String> originConnectorConfiguration() {
        return originConnectorConfiguration;
    }

    /**
     * <p>
     * The target worker setting.
     * </p>
     * 
     * @return The target worker setting.
     */
    public final WorkerSetting targetWorkerSetting() {
        return targetWorkerSetting;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetConnectorConfiguration property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetConnectorConfiguration() {
        return targetConnectorConfiguration != null && !(targetConnectorConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The target connector configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetConnectorConfiguration} method.
     * </p>
     * 
     * @return The target connector configuration.
     */
    public final Map<String, String> targetConnectorConfiguration() {
        return targetConnectorConfiguration;
    }

    /**
     * Returns the value of the ErrorInfo property for this object.
     * 
     * @return The value of the ErrorInfo property for this object.
     */
    public final StateDescription errorInfo() {
        return errorInfo;
    }

    /**
     * <p>
     * The time when the operation was created.
     * </p>
     * 
     * @return The time when the operation was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the operation ended.
     * </p>
     * 
     * @return The time when the operation ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorOperationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperationSteps() ? operationSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(originWorkerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasOriginConnectorConfiguration() ? originConnectorConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetWorkerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetConnectorConfiguration() ? targetConnectorConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorOperationResponse)) {
            return false;
        }
        DescribeConnectorOperationResponse other = (DescribeConnectorOperationResponse) obj;
        return Objects.equals(connectorArn(), other.connectorArn())
                && Objects.equals(connectorOperationArn(), other.connectorOperationArn())
                && Objects.equals(connectorOperationStateAsString(), other.connectorOperationStateAsString())
                && Objects.equals(connectorOperationTypeAsString(), other.connectorOperationTypeAsString())
                && hasOperationSteps() == other.hasOperationSteps() && Objects.equals(operationSteps(), other.operationSteps())
                && Objects.equals(originWorkerSetting(), other.originWorkerSetting())
                && hasOriginConnectorConfiguration() == other.hasOriginConnectorConfiguration()
                && Objects.equals(originConnectorConfiguration(), other.originConnectorConfiguration())
                && Objects.equals(targetWorkerSetting(), other.targetWorkerSetting())
                && hasTargetConnectorConfiguration() == other.hasTargetConnectorConfiguration()
                && Objects.equals(targetConnectorConfiguration(), other.targetConnectorConfiguration())
                && Objects.equals(errorInfo(), other.errorInfo()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeConnectorOperationResponse")
                .add("ConnectorArn", connectorArn())
                .add("ConnectorOperationArn", connectorOperationArn())
                .add("ConnectorOperationState", connectorOperationStateAsString())
                .add("ConnectorOperationType", connectorOperationTypeAsString())
                .add("OperationSteps", hasOperationSteps() ? operationSteps() : null)
                .add("OriginWorkerSetting", originWorkerSetting())
                .add("OriginConnectorConfiguration",
                        originConnectorConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TargetWorkerSetting", targetWorkerSetting())
                .add("TargetConnectorConfiguration",
                        targetConnectorConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ErrorInfo", errorInfo()).add("CreationTime", creationTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "connectorOperationArn":
            return Optional.ofNullable(clazz.cast(connectorOperationArn()));
        case "connectorOperationState":
            return Optional.ofNullable(clazz.cast(connectorOperationStateAsString()));
        case "connectorOperationType":
            return Optional.ofNullable(clazz.cast(connectorOperationTypeAsString()));
        case "operationSteps":
            return Optional.ofNullable(clazz.cast(operationSteps()));
        case "originWorkerSetting":
            return Optional.ofNullable(clazz.cast(originWorkerSetting()));
        case "originConnectorConfiguration":
            return Optional.ofNullable(clazz.cast(originConnectorConfiguration()));
        case "targetWorkerSetting":
            return Optional.ofNullable(clazz.cast(targetWorkerSetting()));
        case "targetConnectorConfiguration":
            return Optional.ofNullable(clazz.cast(targetConnectorConfiguration()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorArn", CONNECTOR_ARN_FIELD);
        map.put("connectorOperationArn", CONNECTOR_OPERATION_ARN_FIELD);
        map.put("connectorOperationState", CONNECTOR_OPERATION_STATE_FIELD);
        map.put("connectorOperationType", CONNECTOR_OPERATION_TYPE_FIELD);
        map.put("operationSteps", OPERATION_STEPS_FIELD);
        map.put("originWorkerSetting", ORIGIN_WORKER_SETTING_FIELD);
        map.put("originConnectorConfiguration", ORIGIN_CONNECTOR_CONFIGURATION_FIELD);
        map.put("targetWorkerSetting", TARGET_WORKER_SETTING_FIELD);
        map.put("targetConnectorConfiguration", TARGET_CONNECTOR_CONFIGURATION_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorOperationResponse, T> g) {
        return obj -> g.apply((DescribeConnectorOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConnectorOperationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector operation.
         * </p>
         * 
         * @param connectorOperationArn
         *        The Amazon Resource Name (ARN) of the connector operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorOperationArn(String connectorOperationArn);

        /**
         * <p>
         * The state of the connector operation.
         * </p>
         * 
         * @param connectorOperationState
         *        The state of the connector operation.
         * @see ConnectorOperationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationState
         */
        Builder connectorOperationState(String connectorOperationState);

        /**
         * <p>
         * The state of the connector operation.
         * </p>
         * 
         * @param connectorOperationState
         *        The state of the connector operation.
         * @see ConnectorOperationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationState
         */
        Builder connectorOperationState(ConnectorOperationState connectorOperationState);

        /**
         * <p>
         * The type of connector operation performed.
         * </p>
         * 
         * @param connectorOperationType
         *        The type of connector operation performed.
         * @see ConnectorOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationType
         */
        Builder connectorOperationType(String connectorOperationType);

        /**
         * <p>
         * The type of connector operation performed.
         * </p>
         * 
         * @param connectorOperationType
         *        The type of connector operation performed.
         * @see ConnectorOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationType
         */
        Builder connectorOperationType(ConnectorOperationType connectorOperationType);

        /**
         * <p>
         * The array of operation steps taken.
         * </p>
         * 
         * @param operationSteps
         *        The array of operation steps taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationSteps(Collection<ConnectorOperationStep> operationSteps);

        /**
         * <p>
         * The array of operation steps taken.
         * </p>
         * 
         * @param operationSteps
         *        The array of operation steps taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationSteps(ConnectorOperationStep... operationSteps);

        /**
         * <p>
         * The array of operation steps taken.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationStep.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationStep.Builder#build()} is called
         * immediately and its result is passed to {@link #operationSteps(List<ConnectorOperationStep>)}.
         * 
         * @param operationSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationSteps(java.util.Collection<ConnectorOperationStep>)
         */
        Builder operationSteps(Consumer<ConnectorOperationStep.Builder>... operationSteps);

        /**
         * <p>
         * The origin worker setting.
         * </p>
         * 
         * @param originWorkerSetting
         *        The origin worker setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originWorkerSetting(WorkerSetting originWorkerSetting);

        /**
         * <p>
         * The origin worker setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkerSetting.Builder} avoiding the need
         * to create one manually via {@link WorkerSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkerSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #originWorkerSetting(WorkerSetting)}.
         * 
         * @param originWorkerSetting
         *        a consumer that will call methods on {@link WorkerSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originWorkerSetting(WorkerSetting)
         */
        default Builder originWorkerSetting(Consumer<WorkerSetting.Builder> originWorkerSetting) {
            return originWorkerSetting(WorkerSetting.builder().applyMutation(originWorkerSetting).build());
        }

        /**
         * <p>
         * The origin connector configuration.
         * </p>
         * 
         * @param originConnectorConfiguration
         *        The origin connector configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originConnectorConfiguration(Map<String, String> originConnectorConfiguration);

        /**
         * <p>
         * The target worker setting.
         * </p>
         * 
         * @param targetWorkerSetting
         *        The target worker setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetWorkerSetting(WorkerSetting targetWorkerSetting);

        /**
         * <p>
         * The target worker setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkerSetting.Builder} avoiding the need
         * to create one manually via {@link WorkerSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkerSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #targetWorkerSetting(WorkerSetting)}.
         * 
         * @param targetWorkerSetting
         *        a consumer that will call methods on {@link WorkerSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetWorkerSetting(WorkerSetting)
         */
        default Builder targetWorkerSetting(Consumer<WorkerSetting.Builder> targetWorkerSetting) {
            return targetWorkerSetting(WorkerSetting.builder().applyMutation(targetWorkerSetting).build());
        }

        /**
         * <p>
         * The target connector configuration.
         * </p>
         * 
         * @param targetConnectorConfiguration
         *        The target connector configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConnectorConfiguration(Map<String, String> targetConnectorConfiguration);

        /**
         * Sets the value of the ErrorInfo property for this object.
         *
         * @param errorInfo
         *        The new value for the ErrorInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(StateDescription errorInfo);

        /**
         * Sets the value of the ErrorInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StateDescription.Builder} avoiding the
         * need to create one manually via {@link StateDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StateDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #errorInfo(StateDescription)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link StateDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(StateDescription)
         */
        default Builder errorInfo(Consumer<StateDescription.Builder> errorInfo) {
            return errorInfo(StateDescription.builder().applyMutation(errorInfo).build());
        }

        /**
         * <p>
         * The time when the operation was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the operation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the operation ended.
         * </p>
         * 
         * @param endTime
         *        The time when the operation ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private String connectorArn;

        private String connectorOperationArn;

        private String connectorOperationState;

        private String connectorOperationType;

        private List<ConnectorOperationStep> operationSteps = DefaultSdkAutoConstructList.getInstance();

        private WorkerSetting originWorkerSetting;

        private Map<String, String> originConnectorConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private WorkerSetting targetWorkerSetting;

        private Map<String, String> targetConnectorConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private StateDescription errorInfo;

        private Instant creationTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorOperationResponse model) {
            super(model);
            connectorArn(model.connectorArn);
            connectorOperationArn(model.connectorOperationArn);
            connectorOperationState(model.connectorOperationState);
            connectorOperationType(model.connectorOperationType);
            operationSteps(model.operationSteps);
            originWorkerSetting(model.originWorkerSetting);
            originConnectorConfiguration(model.originConnectorConfiguration);
            targetWorkerSetting(model.targetWorkerSetting);
            targetConnectorConfiguration(model.targetConnectorConfiguration);
            errorInfo(model.errorInfo);
            creationTime(model.creationTime);
            endTime(model.endTime);
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorOperationArn() {
            return connectorOperationArn;
        }

        public final void setConnectorOperationArn(String connectorOperationArn) {
            this.connectorOperationArn = connectorOperationArn;
        }

        @Override
        public final Builder connectorOperationArn(String connectorOperationArn) {
            this.connectorOperationArn = connectorOperationArn;
            return this;
        }

        public final String getConnectorOperationState() {
            return connectorOperationState;
        }

        public final void setConnectorOperationState(String connectorOperationState) {
            this.connectorOperationState = connectorOperationState;
        }

        @Override
        public final Builder connectorOperationState(String connectorOperationState) {
            this.connectorOperationState = connectorOperationState;
            return this;
        }

        @Override
        public final Builder connectorOperationState(ConnectorOperationState connectorOperationState) {
            this.connectorOperationState(connectorOperationState == null ? null : connectorOperationState.toString());
            return this;
        }

        public final String getConnectorOperationType() {
            return connectorOperationType;
        }

        public final void setConnectorOperationType(String connectorOperationType) {
            this.connectorOperationType = connectorOperationType;
        }

        @Override
        public final Builder connectorOperationType(String connectorOperationType) {
            this.connectorOperationType = connectorOperationType;
            return this;
        }

        @Override
        public final Builder connectorOperationType(ConnectorOperationType connectorOperationType) {
            this.connectorOperationType(connectorOperationType == null ? null : connectorOperationType.toString());
            return this;
        }

        public final List<ConnectorOperationStep.Builder> getOperationSteps() {
            List<ConnectorOperationStep.Builder> result = ___listOfConnectorOperationStepCopier
                    .copyToBuilder(this.operationSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationSteps(Collection<ConnectorOperationStep.BuilderImpl> operationSteps) {
            this.operationSteps = ___listOfConnectorOperationStepCopier.copyFromBuilder(operationSteps);
        }

        @Override
        public final Builder operationSteps(Collection<ConnectorOperationStep> operationSteps) {
            this.operationSteps = ___listOfConnectorOperationStepCopier.copy(operationSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(ConnectorOperationStep... operationSteps) {
            operationSteps(Arrays.asList(operationSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(Consumer<ConnectorOperationStep.Builder>... operationSteps) {
            operationSteps(Stream.of(operationSteps).map(c -> ConnectorOperationStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final WorkerSetting.Builder getOriginWorkerSetting() {
            return originWorkerSetting != null ? originWorkerSetting.toBuilder() : null;
        }

        public final void setOriginWorkerSetting(WorkerSetting.BuilderImpl originWorkerSetting) {
            this.originWorkerSetting = originWorkerSetting != null ? originWorkerSetting.build() : null;
        }

        @Override
        public final Builder originWorkerSetting(WorkerSetting originWorkerSetting) {
            this.originWorkerSetting = originWorkerSetting;
            return this;
        }

        public final Map<String, String> getOriginConnectorConfiguration() {
            if (originConnectorConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return originConnectorConfiguration;
        }

        public final void setOriginConnectorConfiguration(Map<String, String> originConnectorConfiguration) {
            this.originConnectorConfiguration = ConnectorConfigurationCopier.copy(originConnectorConfiguration);
        }

        @Override
        public final Builder originConnectorConfiguration(Map<String, String> originConnectorConfiguration) {
            this.originConnectorConfiguration = ConnectorConfigurationCopier.copy(originConnectorConfiguration);
            return this;
        }

        public final WorkerSetting.Builder getTargetWorkerSetting() {
            return targetWorkerSetting != null ? targetWorkerSetting.toBuilder() : null;
        }

        public final void setTargetWorkerSetting(WorkerSetting.BuilderImpl targetWorkerSetting) {
            this.targetWorkerSetting = targetWorkerSetting != null ? targetWorkerSetting.build() : null;
        }

        @Override
        public final Builder targetWorkerSetting(WorkerSetting targetWorkerSetting) {
            this.targetWorkerSetting = targetWorkerSetting;
            return this;
        }

        public final Map<String, String> getTargetConnectorConfiguration() {
            if (targetConnectorConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return targetConnectorConfiguration;
        }

        public final void setTargetConnectorConfiguration(Map<String, String> targetConnectorConfiguration) {
            this.targetConnectorConfiguration = ConnectorConfigurationCopier.copy(targetConnectorConfiguration);
        }

        @Override
        public final Builder targetConnectorConfiguration(Map<String, String> targetConnectorConfiguration) {
            this.targetConnectorConfiguration = ConnectorConfigurationCopier.copy(targetConnectorConfiguration);
            return this;
        }

        public final StateDescription.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(StateDescription.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(StateDescription errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public DescribeConnectorOperationResponse build() {
            return new DescribeConnectorOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
